% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoimage.R
\name{autoimage}
\alias{autoimage}
\title{Automatic facetting of multiple projected images}
\usage{
autoimage(x, y, z, legend = "horizontal", proj = "none", parameters,
  orientation, common.legend = TRUE, map = "none", size, lratio,
  outer.title, ...)
}
\arguments{
\item{x}{Locations of grid points at which the values in \code{z}
are measured.  The values must be finite and non-missing.  These 
arguments can be either vectors or matrices depending on the type
of data to be displayed.  See Details.}

\item{y}{Locations of grid points at which the values in \code{z}
are measured.  The values must be finite and non-missing.  These 
arguments can be either vectors or matrices depending on the type
of data to be displayed.  See Details.}

\item{z}{A numeric or logical vector or matrix containing the 
values to be plotted (NAs are allowed).}

\item{legend}{A character string indicating where the color scale 
should be placed.  The default is \code{"horizontal"}.  The other
valid options are \code{"none"} and \code{"vertical"}.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{parameters}{A numeric vector specifying the values of the 
\code{parameters} argument in the 
\code{\link[mapproj]{mapproject}}.  This may be necessary when
\code{proj != "none"}.}

\item{orientation}{A vector \code{c(latitude,longitude,rotation)} 
which describes where the "North Pole" should be when computing 
the projection.  See \code{\link[mapproj]{mapproject}} for more
details.}

\item{common.legend}{A logical value indicating whether a common 
legend scale should be used for all images provided in the
\code{z} array.  Default is \code{TRUE}.  If \code{FALSE}, a
separate legend is used for each image.}

\item{map}{The name of the map to draw on the image. Default is 
\code{"none"}.  Other options include \code{"world"}, 
\code{"usa"}, \code{"state"}, \code{"county"}, \code{"france"}, 
\code{"nz"} (New Zealand), \code{"italy"}, \code{"lakes"}, and
\code{"world2"}, all from the \code{maps} package.}

\item{size}{A vector of length two indicating the number of rows 
and columns that should be used for the series of image data in 
\code{z}.  Note that \code{prod(size)} must match the length of 
the third dimension of \code{z} (if it is an array), or 
\code{c(1, 1)} if \code{z} is a matrix.}

\item{lratio}{A numeric value indicating the ratio of the smaller 
dimension of the legend scale to the width of the image.  Default
is 0.1 + 0.1 \code{* k}, where \code{k} is the number of image rows 
if \code{legend == "horizontal"} or the number of image 
columns if \code{legend == "vertical"}.}

\item{outer.title}{A title related to all of the images that is plotted in the outer margin of the figure.}

\item{...}{Additional arguments passed to the \code{\link[graphics]{image}} or 
\code{\link[fields]{poly.image}} functions.  e.g., \code{xlab}, \code{ylab}, 
\code{xlim}, \code{ylim}, \code{zlim}, etc.}
}
\description{
\code{autoimage} plots a sequence of images (with possibly 
projected coordinates) while also automatically plotting a 
color scale matching the image colors to the values of \code{z}.  
Many options are available for legend customization.  The coordinates
can be irregularly spaced, on a regular grid, or on an irregular 
grid.  \code{z} can be a numeric vector, matrix, or array, depending
on the context.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used to project 
the \code{x} and \code{y} coordinates when \code{proj != "none"}.

If multiple images are to be plotted (i.e., if \code{z} is an array), 
then the \code{main} argument can be a vector with length matching 
\code{dim(z)[3]}, and each successive element of the vector will 
be used to add a title to each successive image plotted.  
See the Examples.

Additionally, if \code{common.legend = FALSE}, then separate limits 
for the z-axis of each image can be provided as a list.  
Specifically, if \code{dim(z)[3] == k}, then \code{zlim} should 
be a list of length \code{k}, and each element of the list should 
be a 2-dimensional vector providing the lower and upper limit, 
respectively, of the legend for each image.  Alternatively, if 
\code{zlim} is a list of length \code{k}, then \code{common.legend}
is set to \code{FALSE}.

The range of \code{zlim} is cut into \eqn{n} partitions, 
where \code{n} is the length of \code{col}.

It is generally desirable to increase \code{lratio} when
more images are plotted simultaneously.

The multiple plots are constructed using the 
\code{\link[autoimage]{autolayout}} function, which 
is incompatible with the \code{mfrow} and \code{mfcol} arguments 
in the \code{\link[graphics]{par}} function and is also 
incompatible with the \code{\link[graphics]{split.screen}} function.

The \code{mtext.args} argument can be passed through \code{...} 
in order to customize the outer title.  This should be a named
list with components matching the arguments of 
\code{\link[graphics]{mtext}}.

Lines can be added to each image by passing the \code{lines} 
argument through \code{...}.  In that case, \code{lines} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the lines.  The appearance of the plotted lines
can be customized by passing a named list called \code{lines.args}
through \code{...}. The components of \code{lines.args} should match
the arguments of \code{\link[graphics]{lines}}.  See Examples.

Points can be added to each image by passing the \code{points} 
argument through \code{...}.  In that case, \code{points} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the points.  The appearance of the plotted points
can be customized by passing a named list called \code{points.args}
through \code{...}. The components of \code{points.args} should match
the components of \code{\link[graphics]{points}}.  See Examples.

Text can be added to each image by passing the \code{text} 
argument through \code{...}.  In that case, \code{text} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the text, and \code{labels}, a component
specifying the actual text to write.  The appearance of the plotted text
can be customized by passing a named list called \code{text.args}
through \code{...}. The components of \code{text.args} should match
the components of \code{\link[graphics]{text}}.  See Examples.
 
The legend scale can be modified by passing \code{legend.axis.args}
through \code{...}.  The argument should be a named list
corresponding to the arguments of the \code{\link[graphics]{axis}}
function.  See Examples.

The image axes can be modified by passing \code{axis.args}
through \code{...}.  The argument should be a named list
corresponding to the arguments of the \code{\link[graphics]{axis}}
function.  The exception to this is that arguments \code{xat} 
and \code{yat} can be specified (instead of \code{at}) to specify
the location of the x and y ticks.  If \code{xat} or \code{yat}
are specified, then this overrides the \code{xaxt} and \code{yaxt}
arguments, respectively.  See the \code{\link[autoimage]{paxes}}
function to see how \code{axis.args can be used.}

The legend margin can be customized by passing \code{legend.mar}
to \code{pimage} through \code{...}.  This should be a numeric
vector indicating the margins of the legend, identical to how 
\code{par("mar")} is specified.

The various options of the labeling, axes, and legend are largely
independent.  e.g., passing \code{col.axis} through \code{...} 
will not affect the axis unless it is passed as part of the 
named list \code{axis.args}.  However, one can set the various
\code{par} options prior to plotting to simultaneously
affect the appearance of multiple aspects of the plot.  See 
Examples for \code{\link[autoimage]{pimage}}.  After plotting, 
\code{reset.par()} can be used to reset 
the graphics device options to their default values.
}
\examples{
data(narccap)
# restructure data for 2 images
tasmax2 <- tasmax[,,1:2]

# plot irregularly gridded images with separate legends
# and usa border
autoimage(lon, lat, tasmax2, common.legend = FALSE, map = "usa")

# plot irregularly gridded images with common legend and world lines
# customize world lines
# add and customize title
autoimage(lon, lat, tasmax2, map = "world", 
          lines.args = list(col = "white", lwd = 2),
          outer.title = "Maximum Daily Surface Air Temperature (K)",
          mtext.args = list(col = "blue", cex = 2))

# plot irregularly-spaced responsed as images with separate legends
# and county borders.  Add observed data locations with custom point
# options.  Add text at locations of Denver and Colorado Springs.
data(co, package = "gear")
autoimage(co$lon, co$lat, co[,c("Al", "Ca")], common.legend = FALSE, 
          map = "county", main = c("Aluminum", "Cadmium"),
          points = list(x = co$lon, y = co$lat),
          points.args = list(pch = 20, col = "white"),
          text = list(x = c(-104.98, -104.80), y = c(39.74, 38.85), 
                      labels = c("Denver", "Colorado Springs")),
          text.args = list(col = "red"))

# customize margins and lratio for large plot
# also use projection
# specify manual lines (though in this case it is the same as using 
# map = "world")
data(worldMapEnv, package = "maps")
worldpoly <- maps::map("world", plot = FALSE)
par(mar = c(1.1, 4.1, 2.1, 1.1))
autoimage(lon, lat, tasmax, lines = worldpoly, 
          proj = "bonne", parameters = 40,
          main = c("day 1", "day 2", "day 3", "day 4", "day 5"),
          ylab = "",
          axes = FALSE,
          lratio = 0.5)
}
\seealso{
\code{\link[autoimage]{pimage}}
}
