% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze_sub.R
\name{gaze_sub}
\alias{gaze_sub}
\title{Summary function for categorical/continuous variable}
\usage{
gaze_sub(data, xname, y = NULL, max.ylev = 5, autoCat = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{xname}{A name of categorical/continuous vector}

\item{y}{A name of vector, either continuous or categorical}

\item{max.ylev}{max.ylev An integer indicating the maximum number of levels of grouping variable ('y').
If a column have unique values less than max.ylev it is treated as a categorical variable. Default value is 5.}

\item{autoCat}{logical Whether or not use is.mynumeric() to determine whether a variable is numeric or not}

\item{...}{Further arguments to be passed to gazeCont() or gazeCat()}
}
\value{
An object of class "data.frame" or "tibble"
}
\description{
Summary function for categorical/continuous variable
}
\examples{
require(moonBook)
gaze_sub(acs,"age")
gaze_sub(acs,"log(age)")
gaze_sub(acs,"I(age^2)")
gaze_sub(acs,"sex")
gaze_sub(acs,"age","EF")
gaze_sub(acs,"sex","EF")
gaze_sub(acs,"age","Dx")
gaze_sub(acs,"sex","Dx")
gaze_sub(iris,"Species","Sepal.Length")
gaze_sub(mtcars,"am")
gaze_sub(mtcars,"am",autoCat=TRUE)
}
