% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_residual.R
\name{model_residual}
\alias{model_residual}
\alias{modelResiduals}
\title{Create Model Residuals Explanation}
\usage{
model_residual(object, ...)

modelResiduals(object, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{...}{other parameters}
}
\value{
An object of the class \code{auditor_model_residual}.
}
\description{
Creates \code{auditor_model_residual} that contains sorted residuals.
 An object can be further used to generate plots.
For the list of possible plots see see also section.
}
\examples{
library(DALEX)

# fit a model
model_glm <- glm(m2.price ~ ., data = apartments)

glm_audit <- explain(model_glm,
                   data = apartments,
                   y = apartments$m2.price)

# validate a model with auditor
mr <- model_residual(glm_audit)
mr

plot(mr)

}
\seealso{
\code{\link{plot_acf}, \link{plot_autocorrelation}, \link{plot_residual}, \link{plot_residual_boxplot},
\link{plot_pca}, \link{plot_correlation}, \link{plot_prediction}, \link{plot_rec}, \link{plot_residual_density},
\link{plot_residual}, \link{plot_rroc}, \link{plot_scalelocation}, \link{plot_tsecdf}}
}
