% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\alias{modelPerformance}
\title{Create Model Performance Explaination}
\usage{
model_performance(object, score = c("mae", "mse", "rec", "rroc"),
  new_score = NULL)

modelPerformance(object, score = c("mae", "mse", "rec", "rroc"),
  new_score = NULL)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{score}{Vector of score names to be plotted. Possible values are 'auc' 'cookdistance', 'dw', 'peak', 'halfnormal', 'mae', 'mse', 'rec', 'rmse', 'rroc', 'runs'
(for detailed description see functions in see also section). Pass NULL if you want to use only custom scores by 'new_score' parameter.}

\item{new_score}{A named list of functions that take one argument: object of class 'explainer' and return a numeric value. The measure calculated by the function should have the property that lower score value indicates better model.}
}
\value{
An object of the class 'auditor_model_performance'.
}
\description{
Creates 'modelPerformance'auditor_model_performance' object that can be used to plot radar with ranking of models.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_performance(exp_glm)

}
\seealso{
\code{\link{score_auc}}, \code{\link{score_cooksdistance}, \link{score_dw}, \link{score_peak}, \link{score_halfnormal}, \link{score_mae},
\link{score_mse}, \link{score_rec}, \link{score_rroc}, \link{score_runs}}
}
