% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelPCA.R
\name{plotModelPCA}
\alias{plotModelPCA}
\title{Principal Component Analysis of models}
\usage{
plotModelPCA(object, ..., scale = TRUE, invisible = "none")
}
\arguments{
\item{object}{An object of class ModelAudit,}

\item{...}{Other modelAudit objects to be plotted together.}

\item{scale}{A logical value indicating whether the models residuals should be scaled before the analysis.}

\item{invisible}{A text specifying the elements to be hidden on the plot. Default value is "none". Allowed values are "model", "observ".}
}
\value{
ggplot object
}
\description{
Principal Component Analysis of models residuals.
PCA can be used to assess the similarity of the models.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotModelPCA(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
