% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if.R
\name{if_all}
\alias{if_all}
\alias{if_any}
\alias{if_none}
\title{Test for all, any or none}
\usage{
if_all(.l, .p = isTRUE, .f)

if_any(.l, .p = isTRUE, .f)

if_none(.l, .p = isTRUE, .f)
}
\arguments{
\item{.l}{the list to test.}

\item{.p}{the predicate for testing. Defaut is \code{isTRUE}.}

\item{.f}{a mapper or a function run if .p(.x) is TRUE.}
}
\value{
If .p(.x) is TRUE, .f() is run.
}
\description{
Test for all, any or none
}
\examples{
if_all(1:10, ~ .x < 11, ~ return(letters[1:10]))
if_any(1:10, is.numeric, ~ return(letters[1:10]))
if_none(1:10, is.numeric, ~ return(letters[1:10]))
}
