% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_to_desc_from_is}
\alias{att_to_desc_from_is}
\title{Amend DESCRIPTION with dependencies from imports and suggests package list}
\usage{
att_to_desc_from_is(
  path.d = "DESCRIPTION",
  imports = NULL,
  suggests = NULL,
  normalize = TRUE,
  add_remotes = FALSE
)
}
\arguments{
\item{path.d}{path to description file.}

\item{imports}{character vector of package names to add in Imports section}

\item{suggests}{character vector of package names to add in Suggests section}

\item{normalize}{Logical. Whether to normalize the DESCRIPTION file. See \code{\link[desc]{desc_normalize}}}

\item{add_remotes}{Logical. Whether to add Remotes in DESCRIPTION when packages installed are from non-CRAN.}
}
\value{
Fill in Description file
}
\description{
Amend DESCRIPTION with dependencies from imports and suggests package list
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_to_desc_from_is(path.d = file.path(dummypackage, "DESCRIPTION"),
imports = c("fcuk", "attachment"), suggests = c("knitr"))
# In combination with other functions
att_to_desc_from_is(path.d = file.path(dummypackage, "DESCRIPTION"),
imports = att_from_rscripts(file.path(dummypackage, ".R")),
suggests = att_from_rmds(file.path(dummypackage, "vignettes")))
}
