% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-add-box.R
\name{plot_add_box}
\alias{plot_add_box}
\title{Low level plotting function to add sudo confidence range to calibration plots.}
\usage{
plot_add_box(plot, range = c(0.5, 0.2))
}
\arguments{
\item{plot}{ggplot2 object.}

\item{range}{max and min relative change of data. Default is \code{c(0.5, 0.2)}.}
}
\value{
ggplot2 plot.
}
\description{
Low level plotting function to add sudo confidence range to calibration plots.
}
\examples{
# Make sure to use a relative timeseries generated with \\code{\\link{convert_relative_initial}}.
df <- convert_relative_initial(preprocess$structn_age)

# Create the plot with \\code{\\link{plot_line}}.
plot <- plot_line(df, col = "agecl")

# Add lower and upper range.
plot_add_box(plot)

# You can set the upper and lower range as you like!
plot_add_box(plot, range = c(0.8, 0.4))
}
\seealso{
Other low-level-plot functions: \code{\link{plot_add_range}}
}
