% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-growth-fishbase.R
\name{get_growth_fishbase}
\alias{get_growth_fishbase}
\title{Extract growth parameters from http:://www.fishbase.se.}
\usage{
get_growth_fishbase(fish, mirror = "se")
}
\arguments{
\item{fish}{Vector of fish species with genus and species information.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe with species, country, locality, linf and k.
}
\description{
This function extracts values for Linf, k  and t0 from http:://www.fishbase.se
}
\details{
Before the actual extraction takes place fishbaseh IDs for every species are extracted using \code{\link{get_ids_fishbase}}.
The IDs are needed to generate the urls lateron.
}
\examples{
\dontrun{
# For some reason the examples break with appveyor.
fish <- c("Gadus morhua", "Merlangius merlangus")
df <- get_growth_fishbase(fish)
head(df)

df <- get_growth_fishbase(fish, mirror = "de")
head(df)

fish <- c("Sprattus sprattus")
df <- get_growth_fishbase(fish)
head(df)
# Only use for debugging purposes.
fish <- read.csv("Z:/my_data_alex/fish_species_names_from_ibts.csv", stringsAsFactors = FALSE)[, 1]
url <- get_growth_fishbase(fish)
url <- urls$ref_url
}
}
