% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coroutine.R, R/gen.R, R/async.R, R/stream.R
\name{getNode}
\alias{getNode}
\alias{getState}
\alias{getOrig}
\alias{getEnv}
\alias{getNode.coroutine}
\alias{format.coroutine}
\alias{getState.generator}
\alias{getState.async}
\alias{getState.stream}
\title{Query / display coroutine properties and state.}
\usage{
getNode(x, ...)

getState(x, ...)

getOrig(x, ...)

getEnv(x, ...)

\method{getNode}{coroutine}(x, ...)

\method{format}{coroutine}(x, ...)

\method{getState}{generator}(x, ...)

\method{getState}{async}(x, ...)

\method{getState}{stream}(x, ...)
}
\arguments{
\item{x}{a coroutine (\link{async}, \link{gen}, or \link{stream}) object.}

\item{...}{Undocumented.}
}
\value{
\code{getNode()} returns a character naming the last known execution node.

\code{getOrig()} returns the original expression given to the coroutine's
constructor.

\code{getEnv()} returns the coroutine's effective environment.

For a \link{gen}erator \code{g}, \code{getState(g)} might return "yielded",
"running" (if nextElem is \emph{currently} being called), "stopped" (for
generators that have stopped with an error) or "finished" (for
generators that have finished normally.)

\code{getState(a)} on an \link{async} might return "pending", "resolved" or
"rejected".

\code{getState(s)} on a \link{stream} might return "resolved",
"rejected", "running", "woken", "yielding", or "yielded".
}
\description{
A coroutine's \code{format} method displays its pre-compiled source
code, its effective environment, whether it is running or
finished, and a label indicating its last known state. The
methods \code{getState}, \code{getNode} and \code{getOrig} also expose this
information.
}
\details{
The state displayed by \code{format()} or \code{getNode()} can be read like an
adsress pointing to a spot in the source code; for example, a state
string like \verb{.\{1.<-2.await__then} can be read like
"in the first argument of \verb{\{}, in the second argument of \verb{<-}, in a
call to \code{await()}, at internal node \code{then}."
}
