% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async-package.R
\docType{package}
\name{async-package}
\alias{async-package}
\alias{_PACKAGE}
\title{The async package.}
\description{
The \code{async} package allows you to write sequential-looking code
that can pause, return control to R, then pick up where it left
off.  Async constructs include generators, async/await blocks, and
streams (experimental as of async 0.3).
}
\details{
A generator runs until it yields a value and then stops, returning
control to R until another value is requested. An async block can
pause and return control to R until some data is available, then
resume. Generators implement the \link{iteror} interface (which is
back-compatible with \link[iterators:iterators-package]{iterator}
package.) Async blocks implement the \link[promises:promise]{promise}
interface. The new \link{stream} construct implements the \link{channel}
interface, which is defined in this package.
\itemize{
\item \code{\link[=gen]{gen(...)}} creates a generator (an iterator); within a generator use
\code{\link[=yield]{yield(x)}} to return a value.
\item \code{\link[=async]{async(...)}} creates an async block (a promise); within the \code{async}
write \code{\link[=await]{await(x)}} to pause on \code{x} (another promise).
\item \code{\link[=stream]{stream(...)}} creates a stream (an asynchronous iterator or
\link{channel}); in writing a \code{stream} you can use both \code{await} and \code{yield}.)
}

Theare are some global package \link{options}:

\code{async.verbose}: (default FALSE) if TRUE, coroutines will print an extremely
chatty play-by-play of what they are doing.
\code{async.compileLevel}: (0) Default compile level for new coroutines. See
description of levels under \link{gen}.
\code{async.paranoid}: (FALSE) If true, perform various time-consuming integrity
checks on the results of compilation. Meant to be enabled during certain
package tests.
\code{async.destructive}: (TRUE) If true, tear down interpreted coroutines
while building compiled replacements.
\code{async.sendLater}: (TRUE) If true, channels will send messages to listeners
in the event loop. If false, messages are sent immediately, which may be
faster but may have a higher risk of stack overflow, as well as expose
different sorts of bugs in your code.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://crowding.github.io/async/}
  \item \url{https://github.com/crowding/async/}
  \item Report bugs at \url{https://github.com/crowding/async/issues}
}

}
\author{
Peter Meilstrup
}
\keyword{internal}
