#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5271
#define LARGE_STATE_COUNT 3028
#define SYMBOL_COUNT 134
#define ALIAS_COUNT 1
#define TOKEN_COUNT 79
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 56

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_BSLASH = 2,
  anon_sym_function = 3,
  anon_sym_EQ = 4,
  anon_sym_if = 5,
  anon_sym_for = 6,
  anon_sym_in = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_QMARK = 10,
  anon_sym_TILDE = 11,
  anon_sym_BANG = 12,
  anon_sym_PLUS = 13,
  anon_sym_DASH = 14,
  anon_sym_LT_DASH = 15,
  anon_sym_LT_LT_DASH = 16,
  anon_sym_COLON_EQ = 17,
  anon_sym_DASH_GT = 18,
  anon_sym_DASH_GT_GT = 19,
  anon_sym_PIPE = 20,
  anon_sym_AMP = 21,
  anon_sym_PIPE_PIPE = 22,
  anon_sym_AMP_AMP = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_GT = 26,
  anon_sym_GT_EQ = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_BANG_EQ = 29,
  anon_sym_STAR = 30,
  anon_sym_SLASH = 31,
  anon_sym_STAR_STAR = 32,
  anon_sym_CARET = 33,
  aux_sym_binary_operator_token1 = 34,
  anon_sym_PIPE_GT = 35,
  anon_sym_COLON = 36,
  anon_sym_DOLLAR = 37,
  anon_sym_AT = 38,
  anon_sym_COLON_COLON = 39,
  anon_sym_COLON_COLON_COLON = 40,
  anon_sym_L = 41,
  anon_sym_i = 42,
  aux_sym__hex_literal_token1 = 43,
  sym__number_literal = 44,
  anon_sym_SQUOTE = 45,
  anon_sym_DQUOTE = 46,
  aux_sym__single_quoted_string_content_token1 = 47,
  aux_sym__double_quoted_string_content_token1 = 48,
  sym_escape_sequence = 49,
  sym_return = 50,
  sym_next = 51,
  sym_break = 52,
  sym_true = 53,
  sym_false = 54,
  sym_null = 55,
  sym_inf = 56,
  sym_nan = 57,
  anon_sym_NA = 58,
  anon_sym_NA_integer_ = 59,
  anon_sym_NA_real_ = 60,
  anon_sym_NA_complex_ = 61,
  anon_sym_NA_character_ = 62,
  sym_dots = 63,
  sym_dot_dot_i = 64,
  sym_comment = 65,
  sym_comma = 66,
  sym__newline = 67,
  sym__semicolon = 68,
  sym__raw_string_literal = 69,
  sym__external_else = 70,
  sym__external_open_parenthesis = 71,
  sym__external_close_parenthesis = 72,
  sym__external_open_brace = 73,
  sym__external_close_brace = 74,
  sym__external_open_bracket = 75,
  sym__external_close_bracket = 76,
  sym__external_open_bracket2 = 77,
  sym__external_close_bracket2 = 78,
  sym_program = 79,
  sym_function_definition = 80,
  sym_parameters = 81,
  sym_parameter = 82,
  sym__parameter_with_default = 83,
  sym__parameter_without_default = 84,
  sym_if_statement = 85,
  sym_for_statement = 86,
  sym_while_statement = 87,
  sym_repeat_statement = 88,
  sym_braced_expression = 89,
  sym_parenthesized_expression = 90,
  sym_call = 91,
  sym_subset = 92,
  sym_subset2 = 93,
  sym_call_arguments = 94,
  sym_subset_arguments = 95,
  sym_subset2_arguments = 96,
  sym__argument = 97,
  sym_argument = 98,
  sym__argument_named = 99,
  sym__argument_unnamed = 100,
  sym__argument_value = 101,
  sym_unary_operator = 102,
  sym_binary_operator = 103,
  sym_extract_operator = 104,
  sym_namespace_operator = 105,
  sym_integer = 106,
  sym_complex = 107,
  sym_float = 108,
  sym__hex_literal = 109,
  sym__float_literal = 110,
  sym_string = 111,
  sym__single_quoted_string = 112,
  sym__double_quoted_string = 113,
  aux_sym__single_quoted_string_content = 114,
  aux_sym__double_quoted_string_content = 115,
  sym_na = 116,
  sym__expression = 117,
  sym__string_or_identifier = 118,
  sym__else = 119,
  sym__open_parenthesis = 120,
  sym__close_parenthesis = 121,
  sym__open_brace = 122,
  sym__close_brace = 123,
  sym__open_bracket = 124,
  sym__close_bracket = 125,
  sym__open_bracket2 = 126,
  sym__close_bracket2 = 127,
  aux_sym_program_repeat1 = 128,
  aux_sym_function_definition_repeat1 = 129,
  aux_sym_parameters_repeat1 = 130,
  aux_sym_braced_expression_repeat1 = 131,
  aux_sym_parenthesized_expression_repeat1 = 132,
  aux_sym_call_arguments_repeat1 = 133,
  alias_sym_string_content = 134,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_QMARK] = "\?",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_CARET] = "^",
  [aux_sym_binary_operator_token1] = "special",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_COLON] = ":",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_L] = "L",
  [anon_sym_i] = "i",
  [aux_sym__hex_literal_token1] = "_hex_literal_token1",
  [sym__number_literal] = "_number_literal",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__single_quoted_string_content_token1] = "_single_quoted_string_content_token1",
  [aux_sym__double_quoted_string_content_token1] = "_double_quoted_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_return] = "return",
  [sym_next] = "next",
  [sym_break] = "break",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_character_] = "NA_character_",
  [sym_dots] = "dots",
  [sym_dot_dot_i] = "dot_dot_i",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [sym__newline] = "_newline",
  [sym__semicolon] = "_semicolon",
  [sym__raw_string_literal] = "_raw_string_literal",
  [sym__external_else] = "else",
  [sym__external_open_parenthesis] = "(",
  [sym__external_close_parenthesis] = ")",
  [sym__external_open_brace] = "{",
  [sym__external_close_brace] = "}",
  [sym__external_open_bracket] = "[",
  [sym__external_close_bracket] = "]",
  [sym__external_open_bracket2] = "[[",
  [sym__external_close_bracket2] = "]]",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__parameter_with_default] = "_parameter_with_default",
  [sym__parameter_without_default] = "_parameter_without_default",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_braced_expression] = "braced_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call] = "call",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_call_arguments] = "arguments",
  [sym_subset_arguments] = "arguments",
  [sym_subset2_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_argument] = "argument",
  [sym__argument_named] = "_argument_named",
  [sym__argument_unnamed] = "_argument_unnamed",
  [sym__argument_value] = "_argument_value",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_extract_operator] = "extract_operator",
  [sym_namespace_operator] = "namespace_operator",
  [sym_integer] = "integer",
  [sym_complex] = "complex",
  [sym_float] = "float",
  [sym__hex_literal] = "_hex_literal",
  [sym__float_literal] = "_float_literal",
  [sym_string] = "string",
  [sym__single_quoted_string] = "_single_quoted_string",
  [sym__double_quoted_string] = "_double_quoted_string",
  [aux_sym__single_quoted_string_content] = "_single_quoted_string_content",
  [aux_sym__double_quoted_string_content] = "_double_quoted_string_content",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym__string_or_identifier] = "_string_or_identifier",
  [sym__else] = "_else",
  [sym__open_parenthesis] = "_open_parenthesis",
  [sym__close_parenthesis] = "_close_parenthesis",
  [sym__open_brace] = "_open_brace",
  [sym__close_brace] = "_close_brace",
  [sym__open_bracket] = "_open_bracket",
  [sym__close_bracket] = "_close_bracket",
  [sym__open_bracket2] = "_open_bracket2",
  [sym__close_bracket2] = "_close_bracket2",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_braced_expression_repeat1] = "braced_expression_repeat1",
  [aux_sym_parenthesized_expression_repeat1] = "parenthesized_expression_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [alias_sym_string_content] = "string_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [aux_sym_binary_operator_token1] = aux_sym_binary_operator_token1,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_L] = anon_sym_L,
  [anon_sym_i] = anon_sym_i,
  [aux_sym__hex_literal_token1] = aux_sym__hex_literal_token1,
  [sym__number_literal] = sym__number_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__single_quoted_string_content_token1] = aux_sym__single_quoted_string_content_token1,
  [aux_sym__double_quoted_string_content_token1] = aux_sym__double_quoted_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_return] = sym_return,
  [sym_next] = sym_next,
  [sym_break] = sym_break,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [sym_dots] = sym_dots,
  [sym_dot_dot_i] = sym_dot_dot_i,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [sym__newline] = sym__newline,
  [sym__semicolon] = sym__semicolon,
  [sym__raw_string_literal] = sym__raw_string_literal,
  [sym__external_else] = sym__external_else,
  [sym__external_open_parenthesis] = sym__external_open_parenthesis,
  [sym__external_close_parenthesis] = sym__external_close_parenthesis,
  [sym__external_open_brace] = sym__external_open_brace,
  [sym__external_close_brace] = sym__external_close_brace,
  [sym__external_open_bracket] = sym__external_open_bracket,
  [sym__external_close_bracket] = sym__external_close_bracket,
  [sym__external_open_bracket2] = sym__external_open_bracket2,
  [sym__external_close_bracket2] = sym__external_close_bracket2,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__parameter_with_default] = sym__parameter_with_default,
  [sym__parameter_without_default] = sym__parameter_without_default,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_braced_expression] = sym_braced_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call] = sym_call,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_call_arguments] = sym_call_arguments,
  [sym_subset_arguments] = sym_call_arguments,
  [sym_subset2_arguments] = sym_call_arguments,
  [sym__argument] = sym__argument,
  [sym_argument] = sym_argument,
  [sym__argument_named] = sym__argument_named,
  [sym__argument_unnamed] = sym__argument_unnamed,
  [sym__argument_value] = sym__argument_value,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_extract_operator] = sym_extract_operator,
  [sym_namespace_operator] = sym_namespace_operator,
  [sym_integer] = sym_integer,
  [sym_complex] = sym_complex,
  [sym_float] = sym_float,
  [sym__hex_literal] = sym__hex_literal,
  [sym__float_literal] = sym__float_literal,
  [sym_string] = sym_string,
  [sym__single_quoted_string] = sym__single_quoted_string,
  [sym__double_quoted_string] = sym__double_quoted_string,
  [aux_sym__single_quoted_string_content] = aux_sym__single_quoted_string_content,
  [aux_sym__double_quoted_string_content] = aux_sym__double_quoted_string_content,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym__string_or_identifier] = sym__string_or_identifier,
  [sym__else] = sym__else,
  [sym__open_parenthesis] = sym__open_parenthesis,
  [sym__close_parenthesis] = sym__close_parenthesis,
  [sym__open_brace] = sym__open_brace,
  [sym__close_brace] = sym__close_brace,
  [sym__open_bracket] = sym__open_bracket,
  [sym__close_bracket] = sym__close_bracket,
  [sym__open_bracket2] = sym__open_bracket2,
  [sym__close_bracket2] = sym__close_bracket2,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_braced_expression_repeat1] = aux_sym_braced_expression_repeat1,
  [aux_sym_parenthesized_expression_repeat1] = aux_sym_parenthesized_expression_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [alias_sym_string_content] = alias_sym_string_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_binary_operator_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_L] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__hex_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__number_literal] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_dot_i] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__external_else] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_with_default] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_without_default] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_named] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_unnamed] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_value] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_extract_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__string_or_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym__open_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__close_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__open_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__close_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket2] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_braced_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_close = 5,
  field_condition = 6,
  field_consequence = 7,
  field_content = 8,
  field_default = 9,
  field_function = 10,
  field_lhs = 11,
  field_name = 12,
  field_open = 13,
  field_operator = 14,
  field_parameter = 15,
  field_parameters = 16,
  field_rhs = 17,
  field_sequence = 18,
  field_value = 19,
  field_variable = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close] = "close",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_default] = "default",
  [field_function] = "function",
  [field_lhs] = "lhs",
  [field_name] = "name",
  [field_open] = "open",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_rhs] = "rhs",
  [field_sequence] = "sequence",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 1},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 3},
  [12] = {.index = 19, .length = 1},
  [13] = {.index = 20, .length = 2},
  [14] = {.index = 22, .length = 1},
  [15] = {.index = 23, .length = 1},
  [16] = {.index = 24, .length = 2},
  [17] = {.index = 26, .length = 1},
  [18] = {.index = 27, .length = 3},
  [19] = {.index = 30, .length = 1},
  [20] = {.index = 31, .length = 1},
  [21] = {.index = 32, .length = 1},
  [22] = {.index = 33, .length = 2},
  [23] = {.index = 35, .length = 1},
  [24] = {.index = 36, .length = 3},
  [25] = {.index = 39, .length = 2},
  [26] = {.index = 41, .length = 3},
  [27] = {.index = 44, .length = 3},
  [28] = {.index = 47, .length = 3},
  [29] = {.index = 50, .length = 3},
  [30] = {.index = 53, .length = 3},
  [31] = {.index = 56, .length = 2},
  [32] = {.index = 58, .length = 2},
  [33] = {.index = 60, .length = 1},
  [34] = {.index = 61, .length = 4},
  [35] = {.index = 65, .length = 2},
  [36] = {.index = 67, .length = 4},
  [37] = {.index = 71, .length = 4},
  [38] = {.index = 75, .length = 3},
  [39] = {.index = 78, .length = 2},
  [40] = {.index = 80, .length = 4},
  [41] = {.index = 84, .length = 4},
  [42] = {.index = 88, .length = 4},
  [43] = {.index = 92, .length = 4},
  [44] = {.index = 96, .length = 4},
  [45] = {.index = 100, .length = 5},
  [46] = {.index = 105, .length = 4},
  [47] = {.index = 109, .length = 5},
  [48] = {.index = 114, .length = 4},
  [49] = {.index = 118, .length = 4},
  [50] = {.index = 122, .length = 5},
  [51] = {.index = 127, .length = 5},
  [52] = {.index = 132, .length = 5},
  [53] = {.index = 137, .length = 5},
  [54] = {.index = 142, .length = 5},
  [55] = {.index = 147, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_content, 0, .inherited = true},
  [1] =
    {field_open, 0},
  [2] =
    {field_name, 0},
    {field_parameters, 1},
  [4] =
    {field_body, 1},
  [5] =
    {field_operator, 0},
    {field_rhs, 1},
  [7] =
    {field_lhs, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_body, 0},
  [12] =
    {field_close, 1},
    {field_open, 0},
  [14] =
    {field_body, 1, .inherited = true},
    {field_open, 0},
  [16] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [19] =
    {field_name, 0},
  [20] =
    {field_default, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [22] =
    {field_name, 0, .inherited = true},
  [23] =
    {field_body, 2},
  [24] =
    {field_operator, 0},
    {field_rhs, 2},
  [26] =
    {field_content, 1},
  [27] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [30] =
    {field_value, 0},
  [31] =
    {field_argument, 0, .inherited = true},
  [32] =
    {field_argument, 0},
  [33] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [35] =
    {field_value, 0, .inherited = true},
  [36] =
    {field_body, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [39] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [41] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 1},
  [44] =
    {field_close, 2},
    {field_open, 0},
    {field_parameter, 1},
  [47] =
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [50] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 3},
  [53] =
    {field_argument, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [56] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [58] =
    {field_default, 2},
    {field_name, 0},
  [60] =
    {field_parameter, 1},
  [61] =
    {field_close, 3},
    {field_open, 0},
    {field_parameter, 1},
    {field_parameter, 2, .inherited = true},
  [65] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [67] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [71] =
    {field_body, 4},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [75] =
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [78] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [80] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [84] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [88] =
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [92] =
    {field_body, 5},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [96] =
    {field_body, 5},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [100] =
    {field_alternative, 6},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [105] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [109] =
    {field_body, 6},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [114] =
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [118] =
    {field_body, 6},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [122] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [127] =
    {field_alternative, 7},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [132] =
    {field_body, 7},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [137] =
    {field_body, 7},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [142] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [147] =
    {field_body, 8},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [17] = {
    [1] = alias_sym_string_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__single_quoted_string_content, 2,
    aux_sym__single_quoted_string_content,
    alias_sym_string_content,
  aux_sym__double_quoted_string_content, 2,
    aux_sym__double_quoted_string_content,
    alias_sym_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 3,
  [6] = 6,
  [7] = 6,
  [8] = 6,
  [9] = 6,
  [10] = 4,
  [11] = 4,
  [12] = 2,
  [13] = 2,
  [14] = 3,
  [15] = 2,
  [16] = 4,
  [17] = 2,
  [18] = 4,
  [19] = 3,
  [20] = 3,
  [21] = 6,
  [22] = 22,
  [23] = 3,
  [24] = 4,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 4,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 2,
  [34] = 2,
  [35] = 2,
  [36] = 36,
  [37] = 6,
  [38] = 38,
  [39] = 39,
  [40] = 2,
  [41] = 2,
  [42] = 4,
  [43] = 39,
  [44] = 6,
  [45] = 4,
  [46] = 46,
  [47] = 47,
  [48] = 2,
  [49] = 38,
  [50] = 6,
  [51] = 4,
  [52] = 2,
  [53] = 22,
  [54] = 3,
  [55] = 47,
  [56] = 4,
  [57] = 3,
  [58] = 58,
  [59] = 4,
  [60] = 46,
  [61] = 2,
  [62] = 6,
  [63] = 4,
  [64] = 3,
  [65] = 36,
  [66] = 39,
  [67] = 3,
  [68] = 2,
  [69] = 6,
  [70] = 4,
  [71] = 25,
  [72] = 32,
  [73] = 26,
  [74] = 4,
  [75] = 2,
  [76] = 3,
  [77] = 38,
  [78] = 36,
  [79] = 31,
  [80] = 22,
  [81] = 30,
  [82] = 31,
  [83] = 58,
  [84] = 6,
  [85] = 28,
  [86] = 30,
  [87] = 46,
  [88] = 27,
  [89] = 26,
  [90] = 25,
  [91] = 32,
  [92] = 27,
  [93] = 2,
  [94] = 4,
  [95] = 58,
  [96] = 28,
  [97] = 4,
  [98] = 2,
  [99] = 47,
  [100] = 46,
  [101] = 47,
  [102] = 6,
  [103] = 2,
  [104] = 6,
  [105] = 2,
  [106] = 2,
  [107] = 2,
  [108] = 22,
  [109] = 38,
  [110] = 39,
  [111] = 47,
  [112] = 6,
  [113] = 46,
  [114] = 36,
  [115] = 25,
  [116] = 26,
  [117] = 27,
  [118] = 28,
  [119] = 3,
  [120] = 3,
  [121] = 2,
  [122] = 30,
  [123] = 58,
  [124] = 39,
  [125] = 31,
  [126] = 6,
  [127] = 32,
  [128] = 22,
  [129] = 38,
  [130] = 47,
  [131] = 46,
  [132] = 36,
  [133] = 4,
  [134] = 25,
  [135] = 26,
  [136] = 2,
  [137] = 27,
  [138] = 58,
  [139] = 58,
  [140] = 28,
  [141] = 30,
  [142] = 2,
  [143] = 31,
  [144] = 32,
  [145] = 39,
  [146] = 2,
  [147] = 3,
  [148] = 6,
  [149] = 22,
  [150] = 3,
  [151] = 22,
  [152] = 38,
  [153] = 4,
  [154] = 4,
  [155] = 38,
  [156] = 47,
  [157] = 46,
  [158] = 36,
  [159] = 39,
  [160] = 25,
  [161] = 26,
  [162] = 27,
  [163] = 36,
  [164] = 28,
  [165] = 25,
  [166] = 26,
  [167] = 30,
  [168] = 31,
  [169] = 32,
  [170] = 6,
  [171] = 27,
  [172] = 28,
  [173] = 4,
  [174] = 30,
  [175] = 31,
  [176] = 6,
  [177] = 32,
  [178] = 3,
  [179] = 22,
  [180] = 4,
  [181] = 38,
  [182] = 47,
  [183] = 46,
  [184] = 2,
  [185] = 4,
  [186] = 36,
  [187] = 25,
  [188] = 4,
  [189] = 26,
  [190] = 3,
  [191] = 3,
  [192] = 4,
  [193] = 27,
  [194] = 28,
  [195] = 39,
  [196] = 30,
  [197] = 31,
  [198] = 32,
  [199] = 4,
  [200] = 3,
  [201] = 22,
  [202] = 32,
  [203] = 6,
  [204] = 6,
  [205] = 28,
  [206] = 27,
  [207] = 26,
  [208] = 25,
  [209] = 36,
  [210] = 3,
  [211] = 30,
  [212] = 46,
  [213] = 3,
  [214] = 3,
  [215] = 47,
  [216] = 28,
  [217] = 38,
  [218] = 3,
  [219] = 46,
  [220] = 31,
  [221] = 32,
  [222] = 27,
  [223] = 31,
  [224] = 30,
  [225] = 28,
  [226] = 27,
  [227] = 26,
  [228] = 25,
  [229] = 36,
  [230] = 46,
  [231] = 26,
  [232] = 22,
  [233] = 32,
  [234] = 30,
  [235] = 47,
  [236] = 58,
  [237] = 38,
  [238] = 22,
  [239] = 31,
  [240] = 30,
  [241] = 28,
  [242] = 27,
  [243] = 26,
  [244] = 4,
  [245] = 58,
  [246] = 3,
  [247] = 32,
  [248] = 25,
  [249] = 31,
  [250] = 38,
  [251] = 36,
  [252] = 32,
  [253] = 31,
  [254] = 30,
  [255] = 28,
  [256] = 27,
  [257] = 26,
  [258] = 25,
  [259] = 36,
  [260] = 46,
  [261] = 36,
  [262] = 39,
  [263] = 38,
  [264] = 22,
  [265] = 47,
  [266] = 32,
  [267] = 31,
  [268] = 30,
  [269] = 28,
  [270] = 6,
  [271] = 58,
  [272] = 27,
  [273] = 26,
  [274] = 25,
  [275] = 25,
  [276] = 22,
  [277] = 46,
  [278] = 36,
  [279] = 39,
  [280] = 6,
  [281] = 47,
  [282] = 2,
  [283] = 6,
  [284] = 22,
  [285] = 2,
  [286] = 6,
  [287] = 3,
  [288] = 47,
  [289] = 38,
  [290] = 38,
  [291] = 47,
  [292] = 4,
  [293] = 3,
  [294] = 39,
  [295] = 6,
  [296] = 6,
  [297] = 46,
  [298] = 30,
  [299] = 25,
  [300] = 25,
  [301] = 36,
  [302] = 46,
  [303] = 31,
  [304] = 47,
  [305] = 38,
  [306] = 22,
  [307] = 58,
  [308] = 28,
  [309] = 30,
  [310] = 30,
  [311] = 31,
  [312] = 32,
  [313] = 32,
  [314] = 28,
  [315] = 27,
  [316] = 26,
  [317] = 25,
  [318] = 36,
  [319] = 46,
  [320] = 22,
  [321] = 47,
  [322] = 38,
  [323] = 32,
  [324] = 32,
  [325] = 31,
  [326] = 30,
  [327] = 31,
  [328] = 30,
  [329] = 28,
  [330] = 58,
  [331] = 27,
  [332] = 28,
  [333] = 6,
  [334] = 38,
  [335] = 47,
  [336] = 46,
  [337] = 27,
  [338] = 46,
  [339] = 36,
  [340] = 36,
  [341] = 26,
  [342] = 25,
  [343] = 25,
  [344] = 26,
  [345] = 27,
  [346] = 28,
  [347] = 30,
  [348] = 22,
  [349] = 31,
  [350] = 3,
  [351] = 38,
  [352] = 47,
  [353] = 32,
  [354] = 22,
  [355] = 46,
  [356] = 38,
  [357] = 47,
  [358] = 36,
  [359] = 25,
  [360] = 26,
  [361] = 27,
  [362] = 38,
  [363] = 28,
  [364] = 25,
  [365] = 26,
  [366] = 22,
  [367] = 30,
  [368] = 31,
  [369] = 32,
  [370] = 27,
  [371] = 36,
  [372] = 39,
  [373] = 22,
  [374] = 28,
  [375] = 38,
  [376] = 47,
  [377] = 32,
  [378] = 31,
  [379] = 30,
  [380] = 46,
  [381] = 31,
  [382] = 28,
  [383] = 27,
  [384] = 26,
  [385] = 25,
  [386] = 36,
  [387] = 46,
  [388] = 32,
  [389] = 36,
  [390] = 47,
  [391] = 38,
  [392] = 22,
  [393] = 22,
  [394] = 25,
  [395] = 26,
  [396] = 27,
  [397] = 27,
  [398] = 26,
  [399] = 26,
  [400] = 36,
  [401] = 28,
  [402] = 3,
  [403] = 30,
  [404] = 38,
  [405] = 31,
  [406] = 47,
  [407] = 46,
  [408] = 32,
  [409] = 58,
  [410] = 47,
  [411] = 22,
  [412] = 46,
  [413] = 6,
  [414] = 58,
  [415] = 26,
  [416] = 32,
  [417] = 36,
  [418] = 30,
  [419] = 27,
  [420] = 32,
  [421] = 31,
  [422] = 30,
  [423] = 28,
  [424] = 36,
  [425] = 27,
  [426] = 26,
  [427] = 25,
  [428] = 36,
  [429] = 46,
  [430] = 46,
  [431] = 47,
  [432] = 38,
  [433] = 22,
  [434] = 32,
  [435] = 38,
  [436] = 31,
  [437] = 30,
  [438] = 28,
  [439] = 27,
  [440] = 26,
  [441] = 25,
  [442] = 36,
  [443] = 58,
  [444] = 46,
  [445] = 47,
  [446] = 32,
  [447] = 38,
  [448] = 36,
  [449] = 38,
  [450] = 22,
  [451] = 32,
  [452] = 47,
  [453] = 31,
  [454] = 30,
  [455] = 28,
  [456] = 27,
  [457] = 26,
  [458] = 25,
  [459] = 25,
  [460] = 22,
  [461] = 47,
  [462] = 38,
  [463] = 22,
  [464] = 25,
  [465] = 22,
  [466] = 26,
  [467] = 27,
  [468] = 28,
  [469] = 47,
  [470] = 31,
  [471] = 28,
  [472] = 31,
  [473] = 30,
  [474] = 46,
  [475] = 46,
  [476] = 476,
  [477] = 477,
  [478] = 477,
  [479] = 479,
  [480] = 479,
  [481] = 479,
  [482] = 479,
  [483] = 476,
  [484] = 484,
  [485] = 476,
  [486] = 484,
  [487] = 484,
  [488] = 484,
  [489] = 479,
  [490] = 477,
  [491] = 477,
  [492] = 476,
  [493] = 484,
  [494] = 479,
  [495] = 476,
  [496] = 477,
  [497] = 476,
  [498] = 477,
  [499] = 484,
  [500] = 500,
  [501] = 484,
  [502] = 502,
  [503] = 477,
  [504] = 479,
  [505] = 476,
  [506] = 502,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 507,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 476,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 477,
  [538] = 479,
  [539] = 500,
  [540] = 540,
  [541] = 541,
  [542] = 484,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 553,
  [564] = 509,
  [565] = 510,
  [566] = 511,
  [567] = 512,
  [568] = 513,
  [569] = 514,
  [570] = 515,
  [571] = 516,
  [572] = 517,
  [573] = 518,
  [574] = 519,
  [575] = 502,
  [576] = 520,
  [577] = 521,
  [578] = 523,
  [579] = 524,
  [580] = 525,
  [581] = 526,
  [582] = 527,
  [583] = 528,
  [584] = 529,
  [585] = 530,
  [586] = 531,
  [587] = 533,
  [588] = 534,
  [589] = 535,
  [590] = 536,
  [591] = 540,
  [592] = 541,
  [593] = 543,
  [594] = 508,
  [595] = 545,
  [596] = 546,
  [597] = 547,
  [598] = 548,
  [599] = 507,
  [600] = 549,
  [601] = 550,
  [602] = 551,
  [603] = 552,
  [604] = 476,
  [605] = 554,
  [606] = 555,
  [607] = 556,
  [608] = 557,
  [609] = 558,
  [610] = 559,
  [611] = 560,
  [612] = 561,
  [613] = 562,
  [614] = 544,
  [615] = 509,
  [616] = 510,
  [617] = 511,
  [618] = 512,
  [619] = 513,
  [620] = 514,
  [621] = 515,
  [622] = 516,
  [623] = 517,
  [624] = 518,
  [625] = 519,
  [626] = 520,
  [627] = 521,
  [628] = 523,
  [629] = 524,
  [630] = 525,
  [631] = 526,
  [632] = 527,
  [633] = 528,
  [634] = 529,
  [635] = 530,
  [636] = 531,
  [637] = 533,
  [638] = 534,
  [639] = 535,
  [640] = 536,
  [641] = 500,
  [642] = 540,
  [643] = 541,
  [644] = 543,
  [645] = 508,
  [646] = 545,
  [647] = 546,
  [648] = 547,
  [649] = 548,
  [650] = 549,
  [651] = 550,
  [652] = 551,
  [653] = 552,
  [654] = 553,
  [655] = 554,
  [656] = 555,
  [657] = 556,
  [658] = 557,
  [659] = 558,
  [660] = 559,
  [661] = 560,
  [662] = 561,
  [663] = 562,
  [664] = 544,
  [665] = 484,
  [666] = 479,
  [667] = 477,
  [668] = 476,
  [669] = 484,
  [670] = 479,
  [671] = 477,
  [672] = 560,
  [673] = 546,
  [674] = 513,
  [675] = 512,
  [676] = 511,
  [677] = 510,
  [678] = 509,
  [679] = 544,
  [680] = 562,
  [681] = 561,
  [682] = 560,
  [683] = 559,
  [684] = 558,
  [685] = 557,
  [686] = 556,
  [687] = 555,
  [688] = 514,
  [689] = 554,
  [690] = 553,
  [691] = 515,
  [692] = 516,
  [693] = 517,
  [694] = 518,
  [695] = 552,
  [696] = 519,
  [697] = 520,
  [698] = 521,
  [699] = 551,
  [700] = 550,
  [701] = 549,
  [702] = 548,
  [703] = 547,
  [704] = 546,
  [705] = 545,
  [706] = 508,
  [707] = 543,
  [708] = 541,
  [709] = 540,
  [710] = 500,
  [711] = 536,
  [712] = 523,
  [713] = 535,
  [714] = 524,
  [715] = 525,
  [716] = 526,
  [717] = 527,
  [718] = 528,
  [719] = 529,
  [720] = 530,
  [721] = 531,
  [722] = 533,
  [723] = 534,
  [724] = 534,
  [725] = 533,
  [726] = 531,
  [727] = 530,
  [728] = 529,
  [729] = 535,
  [730] = 528,
  [731] = 536,
  [732] = 527,
  [733] = 500,
  [734] = 526,
  [735] = 540,
  [736] = 525,
  [737] = 541,
  [738] = 524,
  [739] = 543,
  [740] = 523,
  [741] = 508,
  [742] = 521,
  [743] = 545,
  [744] = 520,
  [745] = 519,
  [746] = 518,
  [747] = 517,
  [748] = 516,
  [749] = 515,
  [750] = 546,
  [751] = 547,
  [752] = 548,
  [753] = 514,
  [754] = 549,
  [755] = 550,
  [756] = 551,
  [757] = 552,
  [758] = 553,
  [759] = 554,
  [760] = 555,
  [761] = 556,
  [762] = 557,
  [763] = 558,
  [764] = 559,
  [765] = 560,
  [766] = 561,
  [767] = 562,
  [768] = 544,
  [769] = 513,
  [770] = 507,
  [771] = 512,
  [772] = 511,
  [773] = 510,
  [774] = 509,
  [775] = 476,
  [776] = 477,
  [777] = 479,
  [778] = 778,
  [779] = 484,
  [780] = 780,
  [781] = 476,
  [782] = 477,
  [783] = 479,
  [784] = 484,
  [785] = 484,
  [786] = 479,
  [787] = 477,
  [788] = 476,
  [789] = 507,
  [790] = 507,
  [791] = 502,
  [792] = 476,
  [793] = 477,
  [794] = 479,
  [795] = 484,
  [796] = 507,
  [797] = 509,
  [798] = 510,
  [799] = 511,
  [800] = 512,
  [801] = 513,
  [802] = 514,
  [803] = 476,
  [804] = 515,
  [805] = 477,
  [806] = 516,
  [807] = 479,
  [808] = 517,
  [809] = 484,
  [810] = 518,
  [811] = 519,
  [812] = 544,
  [813] = 562,
  [814] = 520,
  [815] = 561,
  [816] = 521,
  [817] = 523,
  [818] = 476,
  [819] = 477,
  [820] = 479,
  [821] = 484,
  [822] = 559,
  [823] = 558,
  [824] = 557,
  [825] = 524,
  [826] = 525,
  [827] = 556,
  [828] = 526,
  [829] = 527,
  [830] = 528,
  [831] = 555,
  [832] = 529,
  [833] = 554,
  [834] = 553,
  [835] = 530,
  [836] = 531,
  [837] = 533,
  [838] = 534,
  [839] = 552,
  [840] = 535,
  [841] = 536,
  [842] = 500,
  [843] = 540,
  [844] = 541,
  [845] = 551,
  [846] = 550,
  [847] = 549,
  [848] = 548,
  [849] = 547,
  [850] = 546,
  [851] = 545,
  [852] = 508,
  [853] = 543,
  [854] = 541,
  [855] = 540,
  [856] = 476,
  [857] = 500,
  [858] = 536,
  [859] = 477,
  [860] = 479,
  [861] = 543,
  [862] = 508,
  [863] = 535,
  [864] = 484,
  [865] = 545,
  [866] = 546,
  [867] = 547,
  [868] = 548,
  [869] = 549,
  [870] = 476,
  [871] = 477,
  [872] = 479,
  [873] = 484,
  [874] = 550,
  [875] = 551,
  [876] = 552,
  [877] = 553,
  [878] = 554,
  [879] = 534,
  [880] = 533,
  [881] = 555,
  [882] = 531,
  [883] = 556,
  [884] = 530,
  [885] = 529,
  [886] = 557,
  [887] = 528,
  [888] = 558,
  [889] = 527,
  [890] = 559,
  [891] = 526,
  [892] = 560,
  [893] = 525,
  [894] = 561,
  [895] = 524,
  [896] = 562,
  [897] = 523,
  [898] = 544,
  [899] = 521,
  [900] = 520,
  [901] = 519,
  [902] = 518,
  [903] = 780,
  [904] = 517,
  [905] = 516,
  [906] = 515,
  [907] = 514,
  [908] = 513,
  [909] = 512,
  [910] = 511,
  [911] = 510,
  [912] = 509,
  [913] = 509,
  [914] = 510,
  [915] = 511,
  [916] = 512,
  [917] = 502,
  [918] = 513,
  [919] = 514,
  [920] = 778,
  [921] = 507,
  [922] = 515,
  [923] = 516,
  [924] = 517,
  [925] = 518,
  [926] = 519,
  [927] = 520,
  [928] = 521,
  [929] = 523,
  [930] = 524,
  [931] = 525,
  [932] = 526,
  [933] = 527,
  [934] = 528,
  [935] = 502,
  [936] = 529,
  [937] = 530,
  [938] = 531,
  [939] = 533,
  [940] = 534,
  [941] = 535,
  [942] = 536,
  [943] = 500,
  [944] = 540,
  [945] = 541,
  [946] = 543,
  [947] = 508,
  [948] = 545,
  [949] = 780,
  [950] = 778,
  [951] = 544,
  [952] = 562,
  [953] = 561,
  [954] = 560,
  [955] = 559,
  [956] = 558,
  [957] = 557,
  [958] = 556,
  [959] = 555,
  [960] = 554,
  [961] = 553,
  [962] = 552,
  [963] = 551,
  [964] = 550,
  [965] = 549,
  [966] = 548,
  [967] = 547,
  [968] = 968,
  [969] = 544,
  [970] = 507,
  [971] = 778,
  [972] = 780,
  [973] = 780,
  [974] = 778,
  [975] = 509,
  [976] = 510,
  [977] = 511,
  [978] = 512,
  [979] = 513,
  [980] = 514,
  [981] = 515,
  [982] = 516,
  [983] = 517,
  [984] = 518,
  [985] = 519,
  [986] = 520,
  [987] = 521,
  [988] = 523,
  [989] = 524,
  [990] = 525,
  [991] = 484,
  [992] = 526,
  [993] = 968,
  [994] = 484,
  [995] = 527,
  [996] = 528,
  [997] = 529,
  [998] = 530,
  [999] = 479,
  [1000] = 477,
  [1001] = 479,
  [1002] = 531,
  [1003] = 533,
  [1004] = 477,
  [1005] = 534,
  [1006] = 535,
  [1007] = 536,
  [1008] = 476,
  [1009] = 500,
  [1010] = 540,
  [1011] = 541,
  [1012] = 543,
  [1013] = 508,
  [1014] = 545,
  [1015] = 546,
  [1016] = 547,
  [1017] = 548,
  [1018] = 549,
  [1019] = 550,
  [1020] = 551,
  [1021] = 552,
  [1022] = 553,
  [1023] = 554,
  [1024] = 555,
  [1025] = 556,
  [1026] = 557,
  [1027] = 558,
  [1028] = 559,
  [1029] = 560,
  [1030] = 476,
  [1031] = 561,
  [1032] = 562,
  [1033] = 544,
  [1034] = 509,
  [1035] = 510,
  [1036] = 511,
  [1037] = 512,
  [1038] = 513,
  [1039] = 514,
  [1040] = 515,
  [1041] = 516,
  [1042] = 517,
  [1043] = 518,
  [1044] = 519,
  [1045] = 520,
  [1046] = 521,
  [1047] = 523,
  [1048] = 524,
  [1049] = 525,
  [1050] = 526,
  [1051] = 527,
  [1052] = 528,
  [1053] = 529,
  [1054] = 530,
  [1055] = 531,
  [1056] = 533,
  [1057] = 534,
  [1058] = 535,
  [1059] = 536,
  [1060] = 500,
  [1061] = 780,
  [1062] = 540,
  [1063] = 541,
  [1064] = 543,
  [1065] = 508,
  [1066] = 545,
  [1067] = 546,
  [1068] = 544,
  [1069] = 562,
  [1070] = 561,
  [1071] = 560,
  [1072] = 507,
  [1073] = 547,
  [1074] = 559,
  [1075] = 558,
  [1076] = 557,
  [1077] = 548,
  [1078] = 549,
  [1079] = 556,
  [1080] = 550,
  [1081] = 551,
  [1082] = 552,
  [1083] = 555,
  [1084] = 553,
  [1085] = 554,
  [1086] = 553,
  [1087] = 554,
  [1088] = 555,
  [1089] = 556,
  [1090] = 557,
  [1091] = 558,
  [1092] = 552,
  [1093] = 559,
  [1094] = 560,
  [1095] = 561,
  [1096] = 562,
  [1097] = 544,
  [1098] = 551,
  [1099] = 550,
  [1100] = 549,
  [1101] = 548,
  [1102] = 547,
  [1103] = 546,
  [1104] = 545,
  [1105] = 778,
  [1106] = 508,
  [1107] = 543,
  [1108] = 541,
  [1109] = 540,
  [1110] = 500,
  [1111] = 968,
  [1112] = 536,
  [1113] = 535,
  [1114] = 534,
  [1115] = 533,
  [1116] = 531,
  [1117] = 530,
  [1118] = 529,
  [1119] = 528,
  [1120] = 527,
  [1121] = 526,
  [1122] = 525,
  [1123] = 524,
  [1124] = 523,
  [1125] = 521,
  [1126] = 520,
  [1127] = 519,
  [1128] = 518,
  [1129] = 517,
  [1130] = 516,
  [1131] = 515,
  [1132] = 514,
  [1133] = 502,
  [1134] = 513,
  [1135] = 512,
  [1136] = 511,
  [1137] = 510,
  [1138] = 509,
  [1139] = 502,
  [1140] = 544,
  [1141] = 562,
  [1142] = 561,
  [1143] = 560,
  [1144] = 559,
  [1145] = 484,
  [1146] = 544,
  [1147] = 558,
  [1148] = 557,
  [1149] = 556,
  [1150] = 479,
  [1151] = 477,
  [1152] = 507,
  [1153] = 562,
  [1154] = 561,
  [1155] = 555,
  [1156] = 560,
  [1157] = 554,
  [1158] = 553,
  [1159] = 476,
  [1160] = 559,
  [1161] = 552,
  [1162] = 558,
  [1163] = 557,
  [1164] = 556,
  [1165] = 555,
  [1166] = 551,
  [1167] = 554,
  [1168] = 553,
  [1169] = 550,
  [1170] = 552,
  [1171] = 551,
  [1172] = 550,
  [1173] = 549,
  [1174] = 548,
  [1175] = 547,
  [1176] = 546,
  [1177] = 545,
  [1178] = 508,
  [1179] = 543,
  [1180] = 549,
  [1181] = 548,
  [1182] = 547,
  [1183] = 541,
  [1184] = 540,
  [1185] = 500,
  [1186] = 546,
  [1187] = 536,
  [1188] = 545,
  [1189] = 535,
  [1190] = 508,
  [1191] = 543,
  [1192] = 541,
  [1193] = 540,
  [1194] = 500,
  [1195] = 536,
  [1196] = 535,
  [1197] = 534,
  [1198] = 534,
  [1199] = 533,
  [1200] = 531,
  [1201] = 530,
  [1202] = 529,
  [1203] = 528,
  [1204] = 527,
  [1205] = 526,
  [1206] = 525,
  [1207] = 524,
  [1208] = 523,
  [1209] = 521,
  [1210] = 520,
  [1211] = 519,
  [1212] = 518,
  [1213] = 778,
  [1214] = 517,
  [1215] = 516,
  [1216] = 515,
  [1217] = 533,
  [1218] = 514,
  [1219] = 502,
  [1220] = 531,
  [1221] = 530,
  [1222] = 529,
  [1223] = 513,
  [1224] = 512,
  [1225] = 511,
  [1226] = 528,
  [1227] = 510,
  [1228] = 527,
  [1229] = 509,
  [1230] = 526,
  [1231] = 525,
  [1232] = 524,
  [1233] = 523,
  [1234] = 521,
  [1235] = 520,
  [1236] = 519,
  [1237] = 518,
  [1238] = 517,
  [1239] = 516,
  [1240] = 515,
  [1241] = 514,
  [1242] = 513,
  [1243] = 512,
  [1244] = 511,
  [1245] = 510,
  [1246] = 509,
  [1247] = 509,
  [1248] = 510,
  [1249] = 511,
  [1250] = 512,
  [1251] = 513,
  [1252] = 514,
  [1253] = 515,
  [1254] = 516,
  [1255] = 517,
  [1256] = 518,
  [1257] = 519,
  [1258] = 520,
  [1259] = 521,
  [1260] = 523,
  [1261] = 524,
  [1262] = 525,
  [1263] = 526,
  [1264] = 780,
  [1265] = 484,
  [1266] = 479,
  [1267] = 527,
  [1268] = 477,
  [1269] = 528,
  [1270] = 476,
  [1271] = 529,
  [1272] = 530,
  [1273] = 531,
  [1274] = 533,
  [1275] = 534,
  [1276] = 535,
  [1277] = 536,
  [1278] = 500,
  [1279] = 540,
  [1280] = 476,
  [1281] = 541,
  [1282] = 543,
  [1283] = 484,
  [1284] = 508,
  [1285] = 545,
  [1286] = 479,
  [1287] = 477,
  [1288] = 479,
  [1289] = 477,
  [1290] = 476,
  [1291] = 484,
  [1292] = 546,
  [1293] = 484,
  [1294] = 479,
  [1295] = 477,
  [1296] = 547,
  [1297] = 476,
  [1298] = 548,
  [1299] = 780,
  [1300] = 484,
  [1301] = 479,
  [1302] = 549,
  [1303] = 550,
  [1304] = 551,
  [1305] = 552,
  [1306] = 553,
  [1307] = 554,
  [1308] = 555,
  [1309] = 556,
  [1310] = 557,
  [1311] = 558,
  [1312] = 559,
  [1313] = 562,
  [1314] = 561,
  [1315] = 477,
  [1316] = 476,
  [1317] = 778,
  [1318] = 560,
  [1319] = 554,
  [1320] = 562,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1323,
  [1325] = 1325,
  [1326] = 1321,
  [1327] = 1327,
  [1328] = 1322,
  [1329] = 1325,
  [1330] = 1327,
  [1331] = 1322,
  [1332] = 1325,
  [1333] = 1333,
  [1334] = 1327,
  [1335] = 1322,
  [1336] = 968,
  [1337] = 514,
  [1338] = 968,
  [1339] = 1333,
  [1340] = 1325,
  [1341] = 509,
  [1342] = 1333,
  [1343] = 510,
  [1344] = 1325,
  [1345] = 511,
  [1346] = 1327,
  [1347] = 512,
  [1348] = 1322,
  [1349] = 513,
  [1350] = 1325,
  [1351] = 1333,
  [1352] = 1327,
  [1353] = 1322,
  [1354] = 502,
  [1355] = 515,
  [1356] = 516,
  [1357] = 1325,
  [1358] = 517,
  [1359] = 1333,
  [1360] = 1327,
  [1361] = 1322,
  [1362] = 1325,
  [1363] = 1333,
  [1364] = 1327,
  [1365] = 1322,
  [1366] = 1325,
  [1367] = 1321,
  [1368] = 1333,
  [1369] = 1323,
  [1370] = 1327,
  [1371] = 1322,
  [1372] = 1325,
  [1373] = 1333,
  [1374] = 1322,
  [1375] = 1333,
  [1376] = 557,
  [1377] = 514,
  [1378] = 1327,
  [1379] = 1322,
  [1380] = 1325,
  [1381] = 515,
  [1382] = 516,
  [1383] = 517,
  [1384] = 518,
  [1385] = 519,
  [1386] = 1323,
  [1387] = 1321,
  [1388] = 520,
  [1389] = 780,
  [1390] = 521,
  [1391] = 518,
  [1392] = 523,
  [1393] = 1333,
  [1394] = 524,
  [1395] = 1327,
  [1396] = 525,
  [1397] = 1322,
  [1398] = 526,
  [1399] = 1325,
  [1400] = 527,
  [1401] = 1333,
  [1402] = 528,
  [1403] = 1323,
  [1404] = 529,
  [1405] = 1321,
  [1406] = 530,
  [1407] = 1327,
  [1408] = 531,
  [1409] = 1322,
  [1410] = 533,
  [1411] = 1325,
  [1412] = 534,
  [1413] = 513,
  [1414] = 1325,
  [1415] = 1327,
  [1416] = 1322,
  [1417] = 1323,
  [1418] = 1321,
  [1419] = 1322,
  [1420] = 1323,
  [1421] = 1321,
  [1422] = 512,
  [1423] = 1325,
  [1424] = 1333,
  [1425] = 1327,
  [1426] = 535,
  [1427] = 778,
  [1428] = 1327,
  [1429] = 536,
  [1430] = 500,
  [1431] = 540,
  [1432] = 541,
  [1433] = 543,
  [1434] = 508,
  [1435] = 545,
  [1436] = 546,
  [1437] = 547,
  [1438] = 548,
  [1439] = 549,
  [1440] = 550,
  [1441] = 551,
  [1442] = 1322,
  [1443] = 1325,
  [1444] = 1333,
  [1445] = 507,
  [1446] = 544,
  [1447] = 1327,
  [1448] = 552,
  [1449] = 562,
  [1450] = 1322,
  [1451] = 561,
  [1452] = 1327,
  [1453] = 1321,
  [1454] = 560,
  [1455] = 553,
  [1456] = 554,
  [1457] = 559,
  [1458] = 555,
  [1459] = 558,
  [1460] = 557,
  [1461] = 1325,
  [1462] = 556,
  [1463] = 1323,
  [1464] = 544,
  [1465] = 557,
  [1466] = 558,
  [1467] = 559,
  [1468] = 556,
  [1469] = 560,
  [1470] = 561,
  [1471] = 562,
  [1472] = 562,
  [1473] = 544,
  [1474] = 555,
  [1475] = 561,
  [1476] = 554,
  [1477] = 553,
  [1478] = 1325,
  [1479] = 552,
  [1480] = 551,
  [1481] = 550,
  [1482] = 549,
  [1483] = 548,
  [1484] = 547,
  [1485] = 560,
  [1486] = 546,
  [1487] = 559,
  [1488] = 1333,
  [1489] = 558,
  [1490] = 1327,
  [1491] = 545,
  [1492] = 1333,
  [1493] = 508,
  [1494] = 1322,
  [1495] = 543,
  [1496] = 1325,
  [1497] = 541,
  [1498] = 540,
  [1499] = 500,
  [1500] = 536,
  [1501] = 514,
  [1502] = 535,
  [1503] = 1323,
  [1504] = 1321,
  [1505] = 1333,
  [1506] = 534,
  [1507] = 533,
  [1508] = 531,
  [1509] = 530,
  [1510] = 529,
  [1511] = 528,
  [1512] = 527,
  [1513] = 526,
  [1514] = 525,
  [1515] = 778,
  [1516] = 524,
  [1517] = 523,
  [1518] = 521,
  [1519] = 1327,
  [1520] = 520,
  [1521] = 502,
  [1522] = 519,
  [1523] = 518,
  [1524] = 517,
  [1525] = 1322,
  [1526] = 516,
  [1527] = 556,
  [1528] = 1325,
  [1529] = 1322,
  [1530] = 515,
  [1531] = 514,
  [1532] = 1333,
  [1533] = 1327,
  [1534] = 1322,
  [1535] = 511,
  [1536] = 1323,
  [1537] = 1325,
  [1538] = 1333,
  [1539] = 1327,
  [1540] = 513,
  [1541] = 1322,
  [1542] = 512,
  [1543] = 1321,
  [1544] = 511,
  [1545] = 1325,
  [1546] = 510,
  [1547] = 1333,
  [1548] = 509,
  [1549] = 1327,
  [1550] = 515,
  [1551] = 1322,
  [1552] = 544,
  [1553] = 510,
  [1554] = 562,
  [1555] = 1325,
  [1556] = 516,
  [1557] = 778,
  [1558] = 561,
  [1559] = 1333,
  [1560] = 560,
  [1561] = 509,
  [1562] = 559,
  [1563] = 968,
  [1564] = 558,
  [1565] = 557,
  [1566] = 780,
  [1567] = 517,
  [1568] = 518,
  [1569] = 1321,
  [1570] = 556,
  [1571] = 1323,
  [1572] = 555,
  [1573] = 554,
  [1574] = 553,
  [1575] = 520,
  [1576] = 552,
  [1577] = 1327,
  [1578] = 551,
  [1579] = 555,
  [1580] = 520,
  [1581] = 780,
  [1582] = 1322,
  [1583] = 1321,
  [1584] = 1325,
  [1585] = 1323,
  [1586] = 968,
  [1587] = 1333,
  [1588] = 1327,
  [1589] = 1322,
  [1590] = 1325,
  [1591] = 1333,
  [1592] = 1327,
  [1593] = 550,
  [1594] = 549,
  [1595] = 548,
  [1596] = 547,
  [1597] = 546,
  [1598] = 1322,
  [1599] = 502,
  [1600] = 553,
  [1601] = 545,
  [1602] = 508,
  [1603] = 1333,
  [1604] = 1327,
  [1605] = 543,
  [1606] = 1325,
  [1607] = 1327,
  [1608] = 541,
  [1609] = 778,
  [1610] = 540,
  [1611] = 500,
  [1612] = 552,
  [1613] = 1327,
  [1614] = 536,
  [1615] = 1322,
  [1616] = 1325,
  [1617] = 521,
  [1618] = 502,
  [1619] = 535,
  [1620] = 1333,
  [1621] = 523,
  [1622] = 1323,
  [1623] = 544,
  [1624] = 562,
  [1625] = 1321,
  [1626] = 524,
  [1627] = 534,
  [1628] = 533,
  [1629] = 531,
  [1630] = 530,
  [1631] = 529,
  [1632] = 528,
  [1633] = 527,
  [1634] = 526,
  [1635] = 525,
  [1636] = 541,
  [1637] = 561,
  [1638] = 524,
  [1639] = 509,
  [1640] = 523,
  [1641] = 510,
  [1642] = 521,
  [1643] = 511,
  [1644] = 520,
  [1645] = 512,
  [1646] = 519,
  [1647] = 513,
  [1648] = 518,
  [1649] = 517,
  [1650] = 516,
  [1651] = 515,
  [1652] = 560,
  [1653] = 521,
  [1654] = 514,
  [1655] = 559,
  [1656] = 558,
  [1657] = 513,
  [1658] = 512,
  [1659] = 511,
  [1660] = 510,
  [1661] = 523,
  [1662] = 509,
  [1663] = 524,
  [1664] = 544,
  [1665] = 562,
  [1666] = 557,
  [1667] = 519,
  [1668] = 561,
  [1669] = 560,
  [1670] = 525,
  [1671] = 559,
  [1672] = 556,
  [1673] = 558,
  [1674] = 557,
  [1675] = 525,
  [1676] = 551,
  [1677] = 556,
  [1678] = 550,
  [1679] = 514,
  [1680] = 549,
  [1681] = 555,
  [1682] = 526,
  [1683] = 515,
  [1684] = 516,
  [1685] = 517,
  [1686] = 518,
  [1687] = 519,
  [1688] = 554,
  [1689] = 553,
  [1690] = 520,
  [1691] = 527,
  [1692] = 521,
  [1693] = 552,
  [1694] = 523,
  [1695] = 551,
  [1696] = 524,
  [1697] = 550,
  [1698] = 525,
  [1699] = 549,
  [1700] = 526,
  [1701] = 548,
  [1702] = 527,
  [1703] = 547,
  [1704] = 528,
  [1705] = 546,
  [1706] = 529,
  [1707] = 545,
  [1708] = 530,
  [1709] = 508,
  [1710] = 531,
  [1711] = 543,
  [1712] = 533,
  [1713] = 541,
  [1714] = 534,
  [1715] = 540,
  [1716] = 500,
  [1717] = 555,
  [1718] = 536,
  [1719] = 528,
  [1720] = 1321,
  [1721] = 535,
  [1722] = 1323,
  [1723] = 1323,
  [1724] = 1321,
  [1725] = 548,
  [1726] = 526,
  [1727] = 547,
  [1728] = 535,
  [1729] = 534,
  [1730] = 546,
  [1731] = 536,
  [1732] = 500,
  [1733] = 540,
  [1734] = 541,
  [1735] = 543,
  [1736] = 508,
  [1737] = 545,
  [1738] = 546,
  [1739] = 547,
  [1740] = 548,
  [1741] = 549,
  [1742] = 550,
  [1743] = 551,
  [1744] = 533,
  [1745] = 531,
  [1746] = 530,
  [1747] = 529,
  [1748] = 528,
  [1749] = 554,
  [1750] = 552,
  [1751] = 545,
  [1752] = 508,
  [1753] = 527,
  [1754] = 553,
  [1755] = 1325,
  [1756] = 543,
  [1757] = 553,
  [1758] = 554,
  [1759] = 540,
  [1760] = 555,
  [1761] = 526,
  [1762] = 525,
  [1763] = 1322,
  [1764] = 556,
  [1765] = 524,
  [1766] = 500,
  [1767] = 557,
  [1768] = 558,
  [1769] = 559,
  [1770] = 523,
  [1771] = 560,
  [1772] = 561,
  [1773] = 536,
  [1774] = 527,
  [1775] = 544,
  [1776] = 521,
  [1777] = 520,
  [1778] = 519,
  [1779] = 518,
  [1780] = 517,
  [1781] = 516,
  [1782] = 515,
  [1783] = 514,
  [1784] = 529,
  [1785] = 528,
  [1786] = 780,
  [1787] = 513,
  [1788] = 512,
  [1789] = 535,
  [1790] = 552,
  [1791] = 511,
  [1792] = 529,
  [1793] = 510,
  [1794] = 1321,
  [1795] = 509,
  [1796] = 1323,
  [1797] = 530,
  [1798] = 551,
  [1799] = 531,
  [1800] = 533,
  [1801] = 534,
  [1802] = 550,
  [1803] = 549,
  [1804] = 1333,
  [1805] = 1321,
  [1806] = 1323,
  [1807] = 535,
  [1808] = 536,
  [1809] = 500,
  [1810] = 540,
  [1811] = 541,
  [1812] = 1323,
  [1813] = 1321,
  [1814] = 548,
  [1815] = 543,
  [1816] = 508,
  [1817] = 778,
  [1818] = 545,
  [1819] = 546,
  [1820] = 547,
  [1821] = 547,
  [1822] = 548,
  [1823] = 546,
  [1824] = 549,
  [1825] = 550,
  [1826] = 551,
  [1827] = 545,
  [1828] = 508,
  [1829] = 1323,
  [1830] = 543,
  [1831] = 541,
  [1832] = 540,
  [1833] = 552,
  [1834] = 500,
  [1835] = 536,
  [1836] = 535,
  [1837] = 519,
  [1838] = 1323,
  [1839] = 1321,
  [1840] = 534,
  [1841] = 533,
  [1842] = 531,
  [1843] = 530,
  [1844] = 529,
  [1845] = 528,
  [1846] = 1333,
  [1847] = 527,
  [1848] = 513,
  [1849] = 526,
  [1850] = 553,
  [1851] = 525,
  [1852] = 554,
  [1853] = 524,
  [1854] = 555,
  [1855] = 523,
  [1856] = 521,
  [1857] = 520,
  [1858] = 519,
  [1859] = 1323,
  [1860] = 518,
  [1861] = 517,
  [1862] = 516,
  [1863] = 1321,
  [1864] = 515,
  [1865] = 512,
  [1866] = 1327,
  [1867] = 556,
  [1868] = 780,
  [1869] = 557,
  [1870] = 558,
  [1871] = 1321,
  [1872] = 559,
  [1873] = 1323,
  [1874] = 561,
  [1875] = 1323,
  [1876] = 1321,
  [1877] = 1321,
  [1878] = 562,
  [1879] = 511,
  [1880] = 560,
  [1881] = 1333,
  [1882] = 514,
  [1883] = 531,
  [1884] = 533,
  [1885] = 778,
  [1886] = 544,
  [1887] = 510,
  [1888] = 1321,
  [1889] = 1323,
  [1890] = 968,
  [1891] = 1321,
  [1892] = 1323,
  [1893] = 513,
  [1894] = 1321,
  [1895] = 1323,
  [1896] = 512,
  [1897] = 511,
  [1898] = 1333,
  [1899] = 510,
  [1900] = 530,
  [1901] = 780,
  [1902] = 509,
  [1903] = 534,
  [1904] = 1321,
  [1905] = 1323,
  [1906] = 1323,
  [1907] = 509,
  [1908] = 1321,
  [1909] = 780,
  [1910] = 525,
  [1911] = 536,
  [1912] = 1912,
  [1913] = 518,
  [1914] = 517,
  [1915] = 516,
  [1916] = 515,
  [1917] = 515,
  [1918] = 526,
  [1919] = 516,
  [1920] = 514,
  [1921] = 518,
  [1922] = 519,
  [1923] = 1923,
  [1924] = 780,
  [1925] = 1925,
  [1926] = 520,
  [1927] = 1927,
  [1928] = 553,
  [1929] = 1929,
  [1930] = 523,
  [1931] = 1931,
  [1932] = 524,
  [1933] = 535,
  [1934] = 1934,
  [1935] = 521,
  [1936] = 513,
  [1937] = 523,
  [1938] = 534,
  [1939] = 524,
  [1940] = 1931,
  [1941] = 514,
  [1942] = 520,
  [1943] = 1943,
  [1944] = 526,
  [1945] = 525,
  [1946] = 560,
  [1947] = 1947,
  [1948] = 528,
  [1949] = 526,
  [1950] = 561,
  [1951] = 527,
  [1952] = 535,
  [1953] = 517,
  [1954] = 529,
  [1955] = 548,
  [1956] = 530,
  [1957] = 531,
  [1958] = 547,
  [1959] = 546,
  [1960] = 512,
  [1961] = 513,
  [1962] = 559,
  [1963] = 512,
  [1964] = 511,
  [1965] = 558,
  [1966] = 778,
  [1967] = 533,
  [1968] = 968,
  [1969] = 502,
  [1970] = 510,
  [1971] = 511,
  [1972] = 534,
  [1973] = 557,
  [1974] = 510,
  [1975] = 545,
  [1976] = 533,
  [1977] = 509,
  [1978] = 531,
  [1979] = 509,
  [1980] = 530,
  [1981] = 1929,
  [1982] = 1927,
  [1983] = 562,
  [1984] = 1925,
  [1985] = 1923,
  [1986] = 508,
  [1987] = 556,
  [1988] = 529,
  [1989] = 534,
  [1990] = 1934,
  [1991] = 543,
  [1992] = 544,
  [1993] = 533,
  [1994] = 534,
  [1995] = 541,
  [1996] = 533,
  [1997] = 531,
  [1998] = 549,
  [1999] = 515,
  [2000] = 535,
  [2001] = 540,
  [2002] = 550,
  [2003] = 530,
  [2004] = 1943,
  [2005] = 500,
  [2006] = 531,
  [2007] = 529,
  [2008] = 1947,
  [2009] = 1929,
  [2010] = 536,
  [2011] = 555,
  [2012] = 517,
  [2013] = 544,
  [2014] = 562,
  [2015] = 780,
  [2016] = 1927,
  [2017] = 561,
  [2018] = 2018,
  [2019] = 560,
  [2020] = 500,
  [2021] = 1925,
  [2022] = 559,
  [2023] = 540,
  [2024] = 558,
  [2025] = 541,
  [2026] = 557,
  [2027] = 1923,
  [2028] = 543,
  [2029] = 508,
  [2030] = 518,
  [2031] = 2031,
  [2032] = 527,
  [2033] = 2033,
  [2034] = 1912,
  [2035] = 546,
  [2036] = 968,
  [2037] = 519,
  [2038] = 1931,
  [2039] = 780,
  [2040] = 547,
  [2041] = 1934,
  [2042] = 556,
  [2043] = 554,
  [2044] = 548,
  [2045] = 549,
  [2046] = 550,
  [2047] = 545,
  [2048] = 778,
  [2049] = 529,
  [2050] = 553,
  [2051] = 555,
  [2052] = 500,
  [2053] = 554,
  [2054] = 520,
  [2055] = 516,
  [2056] = 780,
  [2057] = 780,
  [2058] = 553,
  [2059] = 1943,
  [2060] = 1947,
  [2061] = 552,
  [2062] = 528,
  [2063] = 536,
  [2064] = 778,
  [2065] = 778,
  [2066] = 540,
  [2067] = 552,
  [2068] = 541,
  [2069] = 519,
  [2070] = 543,
  [2071] = 521,
  [2072] = 554,
  [2073] = 508,
  [2074] = 552,
  [2075] = 2031,
  [2076] = 2033,
  [2077] = 551,
  [2078] = 550,
  [2079] = 545,
  [2080] = 549,
  [2081] = 546,
  [2082] = 547,
  [2083] = 548,
  [2084] = 555,
  [2085] = 548,
  [2086] = 556,
  [2087] = 557,
  [2088] = 558,
  [2089] = 547,
  [2090] = 514,
  [2091] = 546,
  [2092] = 521,
  [2093] = 545,
  [2094] = 559,
  [2095] = 508,
  [2096] = 549,
  [2097] = 778,
  [2098] = 968,
  [2099] = 560,
  [2100] = 543,
  [2101] = 541,
  [2102] = 540,
  [2103] = 500,
  [2104] = 536,
  [2105] = 561,
  [2106] = 562,
  [2107] = 544,
  [2108] = 528,
  [2109] = 550,
  [2110] = 551,
  [2111] = 552,
  [2112] = 553,
  [2113] = 1912,
  [2114] = 554,
  [2115] = 2031,
  [2116] = 2033,
  [2117] = 555,
  [2118] = 778,
  [2119] = 528,
  [2120] = 527,
  [2121] = 556,
  [2122] = 551,
  [2123] = 968,
  [2124] = 557,
  [2125] = 525,
  [2126] = 524,
  [2127] = 523,
  [2128] = 521,
  [2129] = 558,
  [2130] = 559,
  [2131] = 778,
  [2132] = 560,
  [2133] = 561,
  [2134] = 562,
  [2135] = 520,
  [2136] = 519,
  [2137] = 518,
  [2138] = 513,
  [2139] = 517,
  [2140] = 512,
  [2141] = 524,
  [2142] = 511,
  [2143] = 968,
  [2144] = 510,
  [2145] = 509,
  [2146] = 780,
  [2147] = 516,
  [2148] = 515,
  [2149] = 514,
  [2150] = 544,
  [2151] = 513,
  [2152] = 525,
  [2153] = 523,
  [2154] = 526,
  [2155] = 780,
  [2156] = 551,
  [2157] = 527,
  [2158] = 512,
  [2159] = 530,
  [2160] = 511,
  [2161] = 968,
  [2162] = 535,
  [2163] = 778,
  [2164] = 510,
  [2165] = 509,
  [2166] = 1927,
  [2167] = 1929,
  [2168] = 968,
  [2169] = 1927,
  [2170] = 2033,
  [2171] = 778,
  [2172] = 2031,
  [2173] = 968,
  [2174] = 2033,
  [2175] = 2031,
  [2176] = 1947,
  [2177] = 1943,
  [2178] = 778,
  [2179] = 778,
  [2180] = 1934,
  [2181] = 1923,
  [2182] = 968,
  [2183] = 1925,
  [2184] = 1929,
  [2185] = 1947,
  [2186] = 1943,
  [2187] = 1934,
  [2188] = 1923,
  [2189] = 1925,
  [2190] = 2033,
  [2191] = 2031,
  [2192] = 1927,
  [2193] = 1929,
  [2194] = 2031,
  [2195] = 2195,
  [2196] = 2195,
  [2197] = 968,
  [2198] = 1943,
  [2199] = 2195,
  [2200] = 1923,
  [2201] = 1934,
  [2202] = 968,
  [2203] = 968,
  [2204] = 1947,
  [2205] = 968,
  [2206] = 1925,
  [2207] = 1947,
  [2208] = 1929,
  [2209] = 1927,
  [2210] = 1925,
  [2211] = 1923,
  [2212] = 1934,
  [2213] = 780,
  [2214] = 780,
  [2215] = 968,
  [2216] = 2031,
  [2217] = 2033,
  [2218] = 1929,
  [2219] = 1927,
  [2220] = 1925,
  [2221] = 1923,
  [2222] = 1934,
  [2223] = 1943,
  [2224] = 1947,
  [2225] = 780,
  [2226] = 780,
  [2227] = 778,
  [2228] = 2033,
  [2229] = 1943,
  [2230] = 2230,
  [2231] = 1927,
  [2232] = 2232,
  [2233] = 1929,
  [2234] = 1927,
  [2235] = 1925,
  [2236] = 1923,
  [2237] = 1934,
  [2238] = 1943,
  [2239] = 1947,
  [2240] = 2240,
  [2241] = 2230,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2033,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 968,
  [2252] = 2252,
  [2253] = 2031,
  [2254] = 2232,
  [2255] = 2031,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2033,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 1947,
  [2263] = 1943,
  [2264] = 1934,
  [2265] = 1923,
  [2266] = 1925,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 1929,
  [2270] = 1929,
  [2271] = 1927,
  [2272] = 1925,
  [2273] = 1923,
  [2274] = 1934,
  [2275] = 2275,
  [2276] = 1943,
  [2277] = 1947,
  [2278] = 2031,
  [2279] = 2033,
  [2280] = 2280,
  [2281] = 2195,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 1927,
  [2285] = 2285,
  [2286] = 1929,
  [2287] = 1927,
  [2288] = 1925,
  [2289] = 1923,
  [2290] = 1934,
  [2291] = 1943,
  [2292] = 1947,
  [2293] = 2232,
  [2294] = 2285,
  [2295] = 2031,
  [2296] = 2033,
  [2297] = 2282,
  [2298] = 2280,
  [2299] = 2033,
  [2300] = 2031,
  [2301] = 2285,
  [2302] = 2195,
  [2303] = 2195,
  [2304] = 2283,
  [2305] = 968,
  [2306] = 1947,
  [2307] = 1943,
  [2308] = 2282,
  [2309] = 1934,
  [2310] = 1923,
  [2311] = 1925,
  [2312] = 1927,
  [2313] = 1929,
  [2314] = 2280,
  [2315] = 2275,
  [2316] = 2268,
  [2317] = 2267,
  [2318] = 2261,
  [2319] = 2260,
  [2320] = 2259,
  [2321] = 2257,
  [2322] = 2256,
  [2323] = 2252,
  [2324] = 2250,
  [2325] = 2249,
  [2326] = 2248,
  [2327] = 2246,
  [2328] = 2245,
  [2329] = 2244,
  [2330] = 2243,
  [2331] = 2242,
  [2332] = 2230,
  [2333] = 2240,
  [2334] = 2033,
  [2335] = 2031,
  [2336] = 2195,
  [2337] = 2275,
  [2338] = 968,
  [2339] = 2268,
  [2340] = 2267,
  [2341] = 2283,
  [2342] = 2261,
  [2343] = 2260,
  [2344] = 1947,
  [2345] = 1943,
  [2346] = 2259,
  [2347] = 2257,
  [2348] = 2256,
  [2349] = 2195,
  [2350] = 2240,
  [2351] = 2242,
  [2352] = 2243,
  [2353] = 968,
  [2354] = 1934,
  [2355] = 1923,
  [2356] = 1925,
  [2357] = 2244,
  [2358] = 2245,
  [2359] = 1929,
  [2360] = 2246,
  [2361] = 2248,
  [2362] = 2249,
  [2363] = 2250,
  [2364] = 2252,
  [2365] = 2267,
  [2366] = 1943,
  [2367] = 1947,
  [2368] = 1943,
  [2369] = 1934,
  [2370] = 1923,
  [2371] = 1925,
  [2372] = 1927,
  [2373] = 1929,
  [2374] = 2283,
  [2375] = 2033,
  [2376] = 2031,
  [2377] = 1929,
  [2378] = 1927,
  [2379] = 2232,
  [2380] = 2261,
  [2381] = 1925,
  [2382] = 1923,
  [2383] = 1934,
  [2384] = 2268,
  [2385] = 2260,
  [2386] = 1943,
  [2387] = 2031,
  [2388] = 2259,
  [2389] = 2033,
  [2390] = 1947,
  [2391] = 2267,
  [2392] = 1929,
  [2393] = 2285,
  [2394] = 2232,
  [2395] = 2031,
  [2396] = 2033,
  [2397] = 1927,
  [2398] = 2195,
  [2399] = 2195,
  [2400] = 2195,
  [2401] = 2261,
  [2402] = 2267,
  [2403] = 2260,
  [2404] = 2259,
  [2405] = 2282,
  [2406] = 2257,
  [2407] = 2268,
  [2408] = 2256,
  [2409] = 2280,
  [2410] = 2232,
  [2411] = 2283,
  [2412] = 1925,
  [2413] = 2280,
  [2414] = 2230,
  [2415] = 2232,
  [2416] = 2257,
  [2417] = 2242,
  [2418] = 2275,
  [2419] = 2240,
  [2420] = 2230,
  [2421] = 2242,
  [2422] = 2243,
  [2423] = 2033,
  [2424] = 2031,
  [2425] = 2232,
  [2426] = 2243,
  [2427] = 2256,
  [2428] = 2033,
  [2429] = 2031,
  [2430] = 1923,
  [2431] = 2285,
  [2432] = 2275,
  [2433] = 1947,
  [2434] = 1943,
  [2435] = 2268,
  [2436] = 2267,
  [2437] = 1934,
  [2438] = 2261,
  [2439] = 2260,
  [2440] = 2259,
  [2441] = 1927,
  [2442] = 1923,
  [2443] = 2257,
  [2444] = 2256,
  [2445] = 1925,
  [2446] = 2285,
  [2447] = 2282,
  [2448] = 1925,
  [2449] = 1929,
  [2450] = 2280,
  [2451] = 2252,
  [2452] = 2250,
  [2453] = 2249,
  [2454] = 2248,
  [2455] = 2246,
  [2456] = 1923,
  [2457] = 2245,
  [2458] = 2244,
  [2459] = 2282,
  [2460] = 2195,
  [2461] = 2282,
  [2462] = 1923,
  [2463] = 2240,
  [2464] = 2230,
  [2465] = 2195,
  [2466] = 1934,
  [2467] = 2242,
  [2468] = 2243,
  [2469] = 2244,
  [2470] = 2245,
  [2471] = 2246,
  [2472] = 2248,
  [2473] = 2243,
  [2474] = 2242,
  [2475] = 2230,
  [2476] = 2240,
  [2477] = 2280,
  [2478] = 1934,
  [2479] = 1947,
  [2480] = 2249,
  [2481] = 1947,
  [2482] = 1943,
  [2483] = 1943,
  [2484] = 1943,
  [2485] = 2250,
  [2486] = 1947,
  [2487] = 2252,
  [2488] = 2244,
  [2489] = 2245,
  [2490] = 2256,
  [2491] = 2246,
  [2492] = 1929,
  [2493] = 2257,
  [2494] = 1934,
  [2495] = 2240,
  [2496] = 2240,
  [2497] = 2033,
  [2498] = 2244,
  [2499] = 2031,
  [2500] = 2230,
  [2501] = 2242,
  [2502] = 2243,
  [2503] = 2195,
  [2504] = 2245,
  [2505] = 2259,
  [2506] = 2246,
  [2507] = 2260,
  [2508] = 2248,
  [2509] = 2261,
  [2510] = 2275,
  [2511] = 2285,
  [2512] = 2249,
  [2513] = 2248,
  [2514] = 1929,
  [2515] = 2244,
  [2516] = 2245,
  [2517] = 2246,
  [2518] = 2268,
  [2519] = 2248,
  [2520] = 2249,
  [2521] = 2250,
  [2522] = 1927,
  [2523] = 1925,
  [2524] = 2249,
  [2525] = 2250,
  [2526] = 2275,
  [2527] = 2252,
  [2528] = 1923,
  [2529] = 1934,
  [2530] = 1927,
  [2531] = 2283,
  [2532] = 1929,
  [2533] = 2250,
  [2534] = 1927,
  [2535] = 2285,
  [2536] = 1925,
  [2537] = 2252,
  [2538] = 1923,
  [2539] = 1934,
  [2540] = 1925,
  [2541] = 1927,
  [2542] = 2280,
  [2543] = 1929,
  [2544] = 1943,
  [2545] = 2275,
  [2546] = 1947,
  [2547] = 2282,
  [2548] = 2033,
  [2549] = 2031,
  [2550] = 2256,
  [2551] = 2257,
  [2552] = 2252,
  [2553] = 2259,
  [2554] = 2260,
  [2555] = 2261,
  [2556] = 2267,
  [2557] = 2268,
  [2558] = 1947,
  [2559] = 2033,
  [2560] = 2031,
  [2561] = 2260,
  [2562] = 1927,
  [2563] = 2033,
  [2564] = 1943,
  [2565] = 2031,
  [2566] = 2033,
  [2567] = 1929,
  [2568] = 2282,
  [2569] = 2275,
  [2570] = 2240,
  [2571] = 2230,
  [2572] = 2242,
  [2573] = 2031,
  [2574] = 2243,
  [2575] = 2283,
  [2576] = 2195,
  [2577] = 2280,
  [2578] = 1925,
  [2579] = 2256,
  [2580] = 2232,
  [2581] = 2257,
  [2582] = 2252,
  [2583] = 2285,
  [2584] = 2250,
  [2585] = 2249,
  [2586] = 2268,
  [2587] = 2248,
  [2588] = 2244,
  [2589] = 2246,
  [2590] = 2245,
  [2591] = 2244,
  [2592] = 2259,
  [2593] = 2267,
  [2594] = 2260,
  [2595] = 2261,
  [2596] = 2245,
  [2597] = 2597,
  [2598] = 2285,
  [2599] = 2240,
  [2600] = 2230,
  [2601] = 2242,
  [2602] = 2246,
  [2603] = 2232,
  [2604] = 2243,
  [2605] = 2249,
  [2606] = 2597,
  [2607] = 2232,
  [2608] = 2243,
  [2609] = 2242,
  [2610] = 2230,
  [2611] = 2240,
  [2612] = 2250,
  [2613] = 2248,
  [2614] = 2275,
  [2615] = 2252,
  [2616] = 1943,
  [2617] = 2195,
  [2618] = 2268,
  [2619] = 2267,
  [2620] = 1934,
  [2621] = 2244,
  [2622] = 2245,
  [2623] = 2246,
  [2624] = 2248,
  [2625] = 2267,
  [2626] = 2249,
  [2627] = 2250,
  [2628] = 2268,
  [2629] = 2252,
  [2630] = 1943,
  [2631] = 1947,
  [2632] = 2240,
  [2633] = 2597,
  [2634] = 2230,
  [2635] = 2242,
  [2636] = 1947,
  [2637] = 2195,
  [2638] = 2261,
  [2639] = 2195,
  [2640] = 2283,
  [2641] = 2275,
  [2642] = 1947,
  [2643] = 2243,
  [2644] = 1943,
  [2645] = 2256,
  [2646] = 2257,
  [2647] = 2260,
  [2648] = 2259,
  [2649] = 1934,
  [2650] = 2259,
  [2651] = 2261,
  [2652] = 2267,
  [2653] = 2268,
  [2654] = 1923,
  [2655] = 2256,
  [2656] = 1925,
  [2657] = 2283,
  [2658] = 2033,
  [2659] = 2257,
  [2660] = 2257,
  [2661] = 2259,
  [2662] = 2275,
  [2663] = 2260,
  [2664] = 1927,
  [2665] = 1929,
  [2666] = 2282,
  [2667] = 1929,
  [2668] = 1929,
  [2669] = 2280,
  [2670] = 2195,
  [2671] = 2261,
  [2672] = 2256,
  [2673] = 1927,
  [2674] = 2280,
  [2675] = 2240,
  [2676] = 2230,
  [2677] = 2242,
  [2678] = 2261,
  [2679] = 2260,
  [2680] = 2195,
  [2681] = 2243,
  [2682] = 2031,
  [2683] = 2259,
  [2684] = 2257,
  [2685] = 2256,
  [2686] = 2267,
  [2687] = 2268,
  [2688] = 2033,
  [2689] = 2285,
  [2690] = 2275,
  [2691] = 2282,
  [2692] = 2244,
  [2693] = 2245,
  [2694] = 2246,
  [2695] = 2248,
  [2696] = 2249,
  [2697] = 2250,
  [2698] = 2252,
  [2699] = 2282,
  [2700] = 1925,
  [2701] = 1923,
  [2702] = 2280,
  [2703] = 2240,
  [2704] = 2230,
  [2705] = 2242,
  [2706] = 2243,
  [2707] = 2244,
  [2708] = 2245,
  [2709] = 2285,
  [2710] = 2282,
  [2711] = 2244,
  [2712] = 2245,
  [2713] = 2246,
  [2714] = 2248,
  [2715] = 2249,
  [2716] = 2250,
  [2717] = 2252,
  [2718] = 1947,
  [2719] = 2280,
  [2720] = 2246,
  [2721] = 2248,
  [2722] = 2195,
  [2723] = 2285,
  [2724] = 2256,
  [2725] = 2249,
  [2726] = 2250,
  [2727] = 2257,
  [2728] = 2282,
  [2729] = 2259,
  [2730] = 2260,
  [2731] = 2261,
  [2732] = 2267,
  [2733] = 2252,
  [2734] = 2268,
  [2735] = 1923,
  [2736] = 2280,
  [2737] = 1934,
  [2738] = 1923,
  [2739] = 1925,
  [2740] = 2275,
  [2741] = 2031,
  [2742] = 2195,
  [2743] = 2285,
  [2744] = 1927,
  [2745] = 1934,
  [2746] = 2250,
  [2747] = 2230,
  [2748] = 2268,
  [2749] = 2246,
  [2750] = 2267,
  [2751] = 2240,
  [2752] = 2249,
  [2753] = 2248,
  [2754] = 2230,
  [2755] = 2246,
  [2756] = 2245,
  [2757] = 2242,
  [2758] = 2243,
  [2759] = 2246,
  [2760] = 2244,
  [2761] = 2275,
  [2762] = 2243,
  [2763] = 2261,
  [2764] = 2260,
  [2765] = 2259,
  [2766] = 2248,
  [2767] = 2245,
  [2768] = 2252,
  [2769] = 2257,
  [2770] = 2246,
  [2771] = 2256,
  [2772] = 2772,
  [2773] = 2282,
  [2774] = 2242,
  [2775] = 2230,
  [2776] = 2240,
  [2777] = 2261,
  [2778] = 2778,
  [2779] = 2260,
  [2780] = 2230,
  [2781] = 2245,
  [2782] = 2250,
  [2783] = 2285,
  [2784] = 2249,
  [2785] = 2244,
  [2786] = 2259,
  [2787] = 2244,
  [2788] = 2248,
  [2789] = 2275,
  [2790] = 2257,
  [2791] = 2249,
  [2792] = 2242,
  [2793] = 2268,
  [2794] = 2240,
  [2795] = 2230,
  [2796] = 2242,
  [2797] = 2260,
  [2798] = 2267,
  [2799] = 2243,
  [2800] = 2280,
  [2801] = 2259,
  [2802] = 2244,
  [2803] = 2245,
  [2804] = 2250,
  [2805] = 2256,
  [2806] = 2268,
  [2807] = 2246,
  [2808] = 2261,
  [2809] = 2244,
  [2810] = 2245,
  [2811] = 2246,
  [2812] = 2248,
  [2813] = 2248,
  [2814] = 2243,
  [2815] = 2249,
  [2816] = 2250,
  [2817] = 2282,
  [2818] = 2252,
  [2819] = 2249,
  [2820] = 2250,
  [2821] = 2275,
  [2822] = 2285,
  [2823] = 2240,
  [2824] = 2252,
  [2825] = 2282,
  [2826] = 2280,
  [2827] = 2240,
  [2828] = 2230,
  [2829] = 2285,
  [2830] = 2248,
  [2831] = 2252,
  [2832] = 2267,
  [2833] = 2242,
  [2834] = 2268,
  [2835] = 2772,
  [2836] = 2242,
  [2837] = 2243,
  [2838] = 2283,
  [2839] = 2242,
  [2840] = 2261,
  [2841] = 2252,
  [2842] = 2283,
  [2843] = 2245,
  [2844] = 2230,
  [2845] = 2261,
  [2846] = 2268,
  [2847] = 2195,
  [2848] = 2285,
  [2849] = 2260,
  [2850] = 2285,
  [2851] = 2245,
  [2852] = 2259,
  [2853] = 2261,
  [2854] = 2260,
  [2855] = 2252,
  [2856] = 2285,
  [2857] = 2250,
  [2858] = 2256,
  [2859] = 2283,
  [2860] = 2249,
  [2861] = 2257,
  [2862] = 2240,
  [2863] = 2248,
  [2864] = 2259,
  [2865] = 2256,
  [2866] = 2195,
  [2867] = 2259,
  [2868] = 2282,
  [2869] = 2260,
  [2870] = 2261,
  [2871] = 2243,
  [2872] = 2267,
  [2873] = 2268,
  [2874] = 2282,
  [2875] = 2240,
  [2876] = 2244,
  [2877] = 2245,
  [2878] = 2246,
  [2879] = 2280,
  [2880] = 2248,
  [2881] = 2195,
  [2882] = 2249,
  [2883] = 2232,
  [2884] = 2280,
  [2885] = 2257,
  [2886] = 2257,
  [2887] = 2280,
  [2888] = 2275,
  [2889] = 2250,
  [2890] = 2257,
  [2891] = 2256,
  [2892] = 2275,
  [2893] = 2893,
  [2894] = 2250,
  [2895] = 2257,
  [2896] = 2256,
  [2897] = 2280,
  [2898] = 2283,
  [2899] = 2246,
  [2900] = 2252,
  [2901] = 2195,
  [2902] = 2275,
  [2903] = 2252,
  [2904] = 2256,
  [2905] = 2282,
  [2906] = 2259,
  [2907] = 2275,
  [2908] = 2256,
  [2909] = 2249,
  [2910] = 2243,
  [2911] = 2282,
  [2912] = 2772,
  [2913] = 2240,
  [2914] = 2230,
  [2915] = 2242,
  [2916] = 2257,
  [2917] = 2275,
  [2918] = 2285,
  [2919] = 2259,
  [2920] = 2260,
  [2921] = 2243,
  [2922] = 2260,
  [2923] = 2261,
  [2924] = 2285,
  [2925] = 2267,
  [2926] = 2280,
  [2927] = 2268,
  [2928] = 2244,
  [2929] = 2280,
  [2930] = 2282,
  [2931] = 2244,
  [2932] = 2267,
  [2933] = 2267,
  [2934] = 2268,
  [2935] = 2267,
  [2936] = 2243,
  [2937] = 2282,
  [2938] = 2938,
  [2939] = 2275,
  [2940] = 2268,
  [2941] = 2261,
  [2942] = 2260,
  [2943] = 2259,
  [2944] = 2257,
  [2945] = 2267,
  [2946] = 2256,
  [2947] = 2285,
  [2948] = 2244,
  [2949] = 2252,
  [2950] = 2250,
  [2951] = 2249,
  [2952] = 2248,
  [2953] = 2246,
  [2954] = 2245,
  [2955] = 2240,
  [2956] = 2282,
  [2957] = 2275,
  [2958] = 2230,
  [2959] = 2938,
  [2960] = 2240,
  [2961] = 2242,
  [2962] = 2243,
  [2963] = 2285,
  [2964] = 2244,
  [2965] = 2245,
  [2966] = 2246,
  [2967] = 2248,
  [2968] = 2249,
  [2969] = 2250,
  [2970] = 2252,
  [2971] = 2268,
  [2972] = 2267,
  [2973] = 2280,
  [2974] = 2256,
  [2975] = 2257,
  [2976] = 2259,
  [2977] = 2260,
  [2978] = 2261,
  [2979] = 2267,
  [2980] = 2268,
  [2981] = 2230,
  [2982] = 2256,
  [2983] = 2275,
  [2984] = 2280,
  [2985] = 2261,
  [2986] = 2260,
  [2987] = 2259,
  [2988] = 2280,
  [2989] = 2240,
  [2990] = 2230,
  [2991] = 2242,
  [2992] = 2280,
  [2993] = 2240,
  [2994] = 2230,
  [2995] = 2243,
  [2996] = 2242,
  [2997] = 2243,
  [2998] = 2282,
  [2999] = 2244,
  [3000] = 2275,
  [3001] = 2245,
  [3002] = 2246,
  [3003] = 2248,
  [3004] = 2249,
  [3005] = 2250,
  [3006] = 2252,
  [3007] = 2282,
  [3008] = 2244,
  [3009] = 2245,
  [3010] = 2246,
  [3011] = 2248,
  [3012] = 2249,
  [3013] = 2250,
  [3014] = 2938,
  [3015] = 2252,
  [3016] = 2285,
  [3017] = 2257,
  [3018] = 2256,
  [3019] = 2242,
  [3020] = 2285,
  [3021] = 2283,
  [3022] = 2257,
  [3023] = 2268,
  [3024] = 2267,
  [3025] = 2259,
  [3026] = 2260,
  [3027] = 2261,
  [3028] = 3028,
  [3029] = 3029,
  [3030] = 3030,
  [3031] = 3031,
  [3032] = 3032,
  [3033] = 3033,
  [3034] = 3030,
  [3035] = 3035,
  [3036] = 3029,
  [3037] = 3037,
  [3038] = 3038,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 3041,
  [3042] = 3028,
  [3043] = 3043,
  [3044] = 3044,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 3033,
  [3048] = 3048,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 3052,
  [3053] = 3053,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 3040,
  [3057] = 3041,
  [3058] = 3052,
  [3059] = 3044,
  [3060] = 3046,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3063,
  [3064] = 3064,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 3067,
  [3068] = 3068,
  [3069] = 3069,
  [3070] = 3070,
  [3071] = 3045,
  [3072] = 3032,
  [3073] = 3035,
  [3074] = 3033,
  [3075] = 3075,
  [3076] = 3037,
  [3077] = 3077,
  [3078] = 3078,
  [3079] = 3069,
  [3080] = 3067,
  [3081] = 3065,
  [3082] = 3063,
  [3083] = 3062,
  [3084] = 3061,
  [3085] = 3050,
  [3086] = 3048,
  [3087] = 3078,
  [3088] = 3037,
  [3089] = 3030,
  [3090] = 3029,
  [3091] = 3077,
  [3092] = 3038,
  [3093] = 3039,
  [3094] = 3049,
  [3095] = 3043,
  [3096] = 3096,
  [3097] = 3046,
  [3098] = 3075,
  [3099] = 3049,
  [3100] = 3055,
  [3101] = 3031,
  [3102] = 3051,
  [3103] = 3070,
  [3104] = 3038,
  [3105] = 3053,
  [3106] = 3068,
  [3107] = 3031,
  [3108] = 3066,
  [3109] = 3049,
  [3110] = 3064,
  [3111] = 3046,
  [3112] = 3054,
  [3113] = 3039,
  [3114] = 3032,
  [3115] = 3038,
  [3116] = 3054,
  [3117] = 3030,
  [3118] = 3048,
  [3119] = 3033,
  [3120] = 3050,
  [3121] = 3032,
  [3122] = 3061,
  [3123] = 3045,
  [3124] = 3062,
  [3125] = 3044,
  [3126] = 3054,
  [3127] = 3028,
  [3128] = 3053,
  [3129] = 3041,
  [3130] = 3052,
  [3131] = 3040,
  [3132] = 3063,
  [3133] = 3051,
  [3134] = 3065,
  [3135] = 3067,
  [3136] = 3069,
  [3137] = 3078,
  [3138] = 3077,
  [3139] = 3037,
  [3140] = 3096,
  [3141] = 3075,
  [3142] = 3070,
  [3143] = 3068,
  [3144] = 3031,
  [3145] = 3035,
  [3146] = 3029,
  [3147] = 3043,
  [3148] = 3055,
  [3149] = 3035,
  [3150] = 3029,
  [3151] = 3043,
  [3152] = 3055,
  [3153] = 3066,
  [3154] = 3064,
  [3155] = 3064,
  [3156] = 3066,
  [3157] = 3045,
  [3158] = 3068,
  [3159] = 3070,
  [3160] = 3054,
  [3161] = 3053,
  [3162] = 3052,
  [3163] = 3051,
  [3164] = 3035,
  [3165] = 3039,
  [3166] = 3029,
  [3167] = 3028,
  [3168] = 3041,
  [3169] = 3043,
  [3170] = 3055,
  [3171] = 3040,
  [3172] = 3035,
  [3173] = 3029,
  [3174] = 3043,
  [3175] = 3031,
  [3176] = 3055,
  [3177] = 3035,
  [3178] = 3029,
  [3179] = 3040,
  [3180] = 3043,
  [3181] = 3041,
  [3182] = 3028,
  [3183] = 3044,
  [3184] = 3045,
  [3185] = 3032,
  [3186] = 3055,
  [3187] = 3033,
  [3188] = 3051,
  [3189] = 3052,
  [3190] = 3053,
  [3191] = 3054,
  [3192] = 3053,
  [3193] = 3035,
  [3194] = 3029,
  [3195] = 3043,
  [3196] = 3075,
  [3197] = 3055,
  [3198] = 3030,
  [3199] = 3096,
  [3200] = 3038,
  [3201] = 3064,
  [3202] = 3039,
  [3203] = 3066,
  [3204] = 3046,
  [3205] = 3068,
  [3206] = 3049,
  [3207] = 3070,
  [3208] = 3035,
  [3209] = 3077,
  [3210] = 3078,
  [3211] = 3043,
  [3212] = 3075,
  [3213] = 3037,
  [3214] = 3077,
  [3215] = 3078,
  [3216] = 3069,
  [3217] = 3067,
  [3218] = 3065,
  [3219] = 3063,
  [3220] = 3062,
  [3221] = 3061,
  [3222] = 3050,
  [3223] = 3048,
  [3224] = 3044,
  [3225] = 3069,
  [3226] = 3067,
  [3227] = 3065,
  [3228] = 3063,
  [3229] = 3062,
  [3230] = 3061,
  [3231] = 3050,
  [3232] = 3040,
  [3233] = 3055,
  [3234] = 3048,
  [3235] = 3041,
  [3236] = 3035,
  [3237] = 3028,
  [3238] = 3044,
  [3239] = 3045,
  [3240] = 3032,
  [3241] = 3033,
  [3242] = 3030,
  [3243] = 3052,
  [3244] = 3031,
  [3245] = 3038,
  [3246] = 3049,
  [3247] = 3039,
  [3248] = 3046,
  [3249] = 3046,
  [3250] = 3039,
  [3251] = 3049,
  [3252] = 3038,
  [3253] = 3048,
  [3254] = 3030,
  [3255] = 3050,
  [3256] = 3033,
  [3257] = 3061,
  [3258] = 3032,
  [3259] = 3062,
  [3260] = 3045,
  [3261] = 3063,
  [3262] = 3044,
  [3263] = 3065,
  [3264] = 3028,
  [3265] = 3067,
  [3266] = 3041,
  [3267] = 3069,
  [3268] = 3040,
  [3269] = 3031,
  [3270] = 3078,
  [3271] = 3029,
  [3272] = 3043,
  [3273] = 3077,
  [3274] = 3055,
  [3275] = 3037,
  [3276] = 3031,
  [3277] = 3048,
  [3278] = 3050,
  [3279] = 3096,
  [3280] = 3061,
  [3281] = 3075,
  [3282] = 3062,
  [3283] = 3063,
  [3284] = 3065,
  [3285] = 3067,
  [3286] = 3070,
  [3287] = 3068,
  [3288] = 3066,
  [3289] = 3064,
  [3290] = 3035,
  [3291] = 3069,
  [3292] = 3078,
  [3293] = 3077,
  [3294] = 3037,
  [3295] = 3096,
  [3296] = 3075,
  [3297] = 3049,
  [3298] = 3046,
  [3299] = 3070,
  [3300] = 3039,
  [3301] = 3061,
  [3302] = 3054,
  [3303] = 3029,
  [3304] = 3068,
  [3305] = 3053,
  [3306] = 3052,
  [3307] = 3038,
  [3308] = 3051,
  [3309] = 3043,
  [3310] = 3055,
  [3311] = 3066,
  [3312] = 3035,
  [3313] = 3029,
  [3314] = 3043,
  [3315] = 3055,
  [3316] = 3035,
  [3317] = 3029,
  [3318] = 3051,
  [3319] = 3052,
  [3320] = 3043,
  [3321] = 3053,
  [3322] = 3054,
  [3323] = 3064,
  [3324] = 3030,
  [3325] = 3051,
  [3326] = 3052,
  [3327] = 3053,
  [3328] = 3054,
  [3329] = 3033,
  [3330] = 3032,
  [3331] = 3055,
  [3332] = 3045,
  [3333] = 3044,
  [3334] = 3028,
  [3335] = 3041,
  [3336] = 3054,
  [3337] = 3053,
  [3338] = 3064,
  [3339] = 3052,
  [3340] = 3066,
  [3341] = 3051,
  [3342] = 3068,
  [3343] = 3066,
  [3344] = 3070,
  [3345] = 3051,
  [3346] = 3040,
  [3347] = 3035,
  [3348] = 3029,
  [3349] = 3075,
  [3350] = 3096,
  [3351] = 3037,
  [3352] = 3077,
  [3353] = 3078,
  [3354] = 3069,
  [3355] = 3067,
  [3356] = 3065,
  [3357] = 3063,
  [3358] = 3062,
  [3359] = 3061,
  [3360] = 3050,
  [3361] = 3048,
  [3362] = 3064,
  [3363] = 3043,
  [3364] = 3055,
  [3365] = 3052,
  [3366] = 3053,
  [3367] = 3054,
  [3368] = 3068,
  [3369] = 3035,
  [3370] = 3029,
  [3371] = 3048,
  [3372] = 3043,
  [3373] = 3055,
  [3374] = 3070,
  [3375] = 3051,
  [3376] = 3064,
  [3377] = 3035,
  [3378] = 3029,
  [3379] = 3043,
  [3380] = 3055,
  [3381] = 3066,
  [3382] = 3031,
  [3383] = 3068,
  [3384] = 3049,
  [3385] = 3040,
  [3386] = 3046,
  [3387] = 3041,
  [3388] = 3039,
  [3389] = 3028,
  [3390] = 3038,
  [3391] = 3044,
  [3392] = 3030,
  [3393] = 3045,
  [3394] = 3033,
  [3395] = 3032,
  [3396] = 3032,
  [3397] = 3033,
  [3398] = 3045,
  [3399] = 3030,
  [3400] = 3044,
  [3401] = 3038,
  [3402] = 3028,
  [3403] = 3039,
  [3404] = 3041,
  [3405] = 3046,
  [3406] = 3040,
  [3407] = 3070,
  [3408] = 3049,
  [3409] = 3075,
  [3410] = 3035,
  [3411] = 3031,
  [3412] = 3040,
  [3413] = 3029,
  [3414] = 3043,
  [3415] = 3055,
  [3416] = 3096,
  [3417] = 3064,
  [3418] = 3075,
  [3419] = 3050,
  [3420] = 3035,
  [3421] = 3029,
  [3422] = 3043,
  [3423] = 3055,
  [3424] = 3096,
  [3425] = 3037,
  [3426] = 3077,
  [3427] = 3078,
  [3428] = 3035,
  [3429] = 3029,
  [3430] = 3043,
  [3431] = 3055,
  [3432] = 3048,
  [3433] = 3069,
  [3434] = 3067,
  [3435] = 3065,
  [3436] = 3063,
  [3437] = 3035,
  [3438] = 3050,
  [3439] = 3062,
  [3440] = 3029,
  [3441] = 3043,
  [3442] = 3063,
  [3443] = 3061,
  [3444] = 3062,
  [3445] = 3065,
  [3446] = 3063,
  [3447] = 3055,
  [3448] = 3062,
  [3449] = 3065,
  [3450] = 3067,
  [3451] = 3069,
  [3452] = 3067,
  [3453] = 3069,
  [3454] = 3078,
  [3455] = 3061,
  [3456] = 3077,
  [3457] = 3037,
  [3458] = 3078,
  [3459] = 3096,
  [3460] = 3075,
  [3461] = 3078,
  [3462] = 3077,
  [3463] = 3051,
  [3464] = 3052,
  [3465] = 3053,
  [3466] = 3054,
  [3467] = 3050,
  [3468] = 3041,
  [3469] = 3048,
  [3470] = 3028,
  [3471] = 3070,
  [3472] = 3037,
  [3473] = 3068,
  [3474] = 3096,
  [3475] = 3066,
  [3476] = 3064,
  [3477] = 3064,
  [3478] = 3066,
  [3479] = 3035,
  [3480] = 3068,
  [3481] = 3029,
  [3482] = 3070,
  [3483] = 3066,
  [3484] = 3043,
  [3485] = 3055,
  [3486] = 3044,
  [3487] = 3075,
  [3488] = 3096,
  [3489] = 3037,
  [3490] = 3077,
  [3491] = 3078,
  [3492] = 3069,
  [3493] = 3067,
  [3494] = 3065,
  [3495] = 3063,
  [3496] = 3062,
  [3497] = 3061,
  [3498] = 3050,
  [3499] = 3048,
  [3500] = 3077,
  [3501] = 3045,
  [3502] = 3078,
  [3503] = 3032,
  [3504] = 3069,
  [3505] = 3033,
  [3506] = 3067,
  [3507] = 3075,
  [3508] = 3030,
  [3509] = 3035,
  [3510] = 3038,
  [3511] = 3029,
  [3512] = 3043,
  [3513] = 3039,
  [3514] = 3054,
  [3515] = 3053,
  [3516] = 3052,
  [3517] = 3051,
  [3518] = 3068,
  [3519] = 3055,
  [3520] = 3031,
  [3521] = 3065,
  [3522] = 3049,
  [3523] = 3070,
  [3524] = 3046,
  [3525] = 3031,
  [3526] = 3039,
  [3527] = 3063,
  [3528] = 3038,
  [3529] = 3062,
  [3530] = 3030,
  [3531] = 3037,
  [3532] = 3033,
  [3533] = 3035,
  [3534] = 3032,
  [3535] = 3029,
  [3536] = 3045,
  [3537] = 3043,
  [3538] = 3044,
  [3539] = 3075,
  [3540] = 3028,
  [3541] = 3096,
  [3542] = 3041,
  [3543] = 3037,
  [3544] = 3040,
  [3545] = 3046,
  [3546] = 3055,
  [3547] = 3050,
  [3548] = 3049,
  [3549] = 3077,
  [3550] = 3048,
  [3551] = 3078,
  [3552] = 3031,
  [3553] = 3035,
  [3554] = 3029,
  [3555] = 3069,
  [3556] = 3043,
  [3557] = 3055,
  [3558] = 3031,
  [3559] = 3049,
  [3560] = 3035,
  [3561] = 3029,
  [3562] = 3043,
  [3563] = 3067,
  [3564] = 3055,
  [3565] = 3065,
  [3566] = 3046,
  [3567] = 3039,
  [3568] = 3038,
  [3569] = 3030,
  [3570] = 3035,
  [3571] = 3029,
  [3572] = 3043,
  [3573] = 3048,
  [3574] = 3050,
  [3575] = 3061,
  [3576] = 3062,
  [3577] = 3063,
  [3578] = 3065,
  [3579] = 3055,
  [3580] = 3070,
  [3581] = 3067,
  [3582] = 3069,
  [3583] = 3040,
  [3584] = 3041,
  [3585] = 3033,
  [3586] = 3032,
  [3587] = 3028,
  [3588] = 3068,
  [3589] = 3044,
  [3590] = 3045,
  [3591] = 3032,
  [3592] = 3033,
  [3593] = 3045,
  [3594] = 3030,
  [3595] = 3038,
  [3596] = 3066,
  [3597] = 3039,
  [3598] = 3046,
  [3599] = 3051,
  [3600] = 3049,
  [3601] = 3051,
  [3602] = 3052,
  [3603] = 3053,
  [3604] = 3054,
  [3605] = 3077,
  [3606] = 3037,
  [3607] = 3075,
  [3608] = 3052,
  [3609] = 3053,
  [3610] = 3064,
  [3611] = 3054,
  [3612] = 3031,
  [3613] = 3049,
  [3614] = 3064,
  [3615] = 3062,
  [3616] = 3066,
  [3617] = 3061,
  [3618] = 3068,
  [3619] = 3070,
  [3620] = 3070,
  [3621] = 3046,
  [3622] = 3068,
  [3623] = 3028,
  [3624] = 3066,
  [3625] = 3075,
  [3626] = 3096,
  [3627] = 3037,
  [3628] = 3077,
  [3629] = 3078,
  [3630] = 3069,
  [3631] = 3067,
  [3632] = 3065,
  [3633] = 3063,
  [3634] = 3062,
  [3635] = 3061,
  [3636] = 3050,
  [3637] = 3048,
  [3638] = 3050,
  [3639] = 3041,
  [3640] = 3064,
  [3641] = 3040,
  [3642] = 3039,
  [3643] = 3051,
  [3644] = 3038,
  [3645] = 3048,
  [3646] = 3030,
  [3647] = 3064,
  [3648] = 3033,
  [3649] = 3066,
  [3650] = 3054,
  [3651] = 3053,
  [3652] = 3052,
  [3653] = 3051,
  [3654] = 3048,
  [3655] = 3052,
  [3656] = 3032,
  [3657] = 3050,
  [3658] = 3031,
  [3659] = 3061,
  [3660] = 3049,
  [3661] = 3062,
  [3662] = 3046,
  [3663] = 3063,
  [3664] = 3039,
  [3665] = 3065,
  [3666] = 3038,
  [3667] = 3067,
  [3668] = 3030,
  [3669] = 3069,
  [3670] = 3033,
  [3671] = 3078,
  [3672] = 3032,
  [3673] = 3077,
  [3674] = 3045,
  [3675] = 3037,
  [3676] = 3044,
  [3677] = 3096,
  [3678] = 3028,
  [3679] = 3075,
  [3680] = 3041,
  [3681] = 3053,
  [3682] = 3040,
  [3683] = 3068,
  [3684] = 3045,
  [3685] = 3070,
  [3686] = 3044,
  [3687] = 3070,
  [3688] = 3054,
  [3689] = 3068,
  [3690] = 3061,
  [3691] = 3041,
  [3692] = 3040,
  [3693] = 3066,
  [3694] = 3040,
  [3695] = 3041,
  [3696] = 3064,
  [3697] = 3075,
  [3698] = 3096,
  [3699] = 3040,
  [3700] = 3028,
  [3701] = 3044,
  [3702] = 3054,
  [3703] = 3054,
  [3704] = 3053,
  [3705] = 3052,
  [3706] = 3051,
  [3707] = 3045,
  [3708] = 3037,
  [3709] = 3077,
  [3710] = 3077,
  [3711] = 3051,
  [3712] = 3052,
  [3713] = 3053,
  [3714] = 3032,
  [3715] = 3064,
  [3716] = 3040,
  [3717] = 3041,
  [3718] = 3041,
  [3719] = 3078,
  [3720] = 3069,
  [3721] = 3054,
  [3722] = 3067,
  [3723] = 3028,
  [3724] = 3065,
  [3725] = 3040,
  [3726] = 3053,
  [3727] = 3052,
  [3728] = 3063,
  [3729] = 3033,
  [3730] = 3061,
  [3731] = 3050,
  [3732] = 3066,
  [3733] = 3041,
  [3734] = 3051,
  [3735] = 3062,
  [3736] = 3068,
  [3737] = 3028,
  [3738] = 3070,
  [3739] = 3051,
  [3740] = 3052,
  [3741] = 3053,
  [3742] = 3054,
  [3743] = 3048,
  [3744] = 3044,
  [3745] = 3045,
  [3746] = 3032,
  [3747] = 3033,
  [3748] = 3063,
  [3749] = 3030,
  [3750] = 3064,
  [3751] = 3038,
  [3752] = 3064,
  [3753] = 3037,
  [3754] = 3066,
  [3755] = 3039,
  [3756] = 3068,
  [3757] = 3077,
  [3758] = 3070,
  [3759] = 3040,
  [3760] = 3041,
  [3761] = 3046,
  [3762] = 3078,
  [3763] = 3075,
  [3764] = 3096,
  [3765] = 3037,
  [3766] = 3077,
  [3767] = 3078,
  [3768] = 3069,
  [3769] = 3067,
  [3770] = 3065,
  [3771] = 3063,
  [3772] = 3062,
  [3773] = 3061,
  [3774] = 3050,
  [3775] = 3048,
  [3776] = 3028,
  [3777] = 3049,
  [3778] = 3069,
  [3779] = 3031,
  [3780] = 3044,
  [3781] = 3067,
  [3782] = 3065,
  [3783] = 3045,
  [3784] = 3032,
  [3785] = 3033,
  [3786] = 3063,
  [3787] = 3062,
  [3788] = 3030,
  [3789] = 3038,
  [3790] = 3039,
  [3791] = 3046,
  [3792] = 3049,
  [3793] = 3031,
  [3794] = 3061,
  [3795] = 3050,
  [3796] = 3031,
  [3797] = 3048,
  [3798] = 3049,
  [3799] = 3048,
  [3800] = 3046,
  [3801] = 3044,
  [3802] = 3039,
  [3803] = 3030,
  [3804] = 3038,
  [3805] = 3050,
  [3806] = 3030,
  [3807] = 3061,
  [3808] = 3033,
  [3809] = 3038,
  [3810] = 3032,
  [3811] = 3062,
  [3812] = 3045,
  [3813] = 3063,
  [3814] = 3044,
  [3815] = 3065,
  [3816] = 3028,
  [3817] = 3067,
  [3818] = 3041,
  [3819] = 3069,
  [3820] = 3040,
  [3821] = 3078,
  [3822] = 3077,
  [3823] = 3037,
  [3824] = 3096,
  [3825] = 3048,
  [3826] = 3075,
  [3827] = 3050,
  [3828] = 3070,
  [3829] = 3068,
  [3830] = 3028,
  [3831] = 3061,
  [3832] = 3066,
  [3833] = 3045,
  [3834] = 3051,
  [3835] = 3063,
  [3836] = 3065,
  [3837] = 3067,
  [3838] = 3069,
  [3839] = 3078,
  [3840] = 3077,
  [3841] = 3037,
  [3842] = 3096,
  [3843] = 3075,
  [3844] = 3033,
  [3845] = 3044,
  [3846] = 3066,
  [3847] = 3054,
  [3848] = 3053,
  [3849] = 3052,
  [3850] = 3051,
  [3851] = 3031,
  [3852] = 3068,
  [3853] = 3070,
  [3854] = 3068,
  [3855] = 3052,
  [3856] = 3066,
  [3857] = 3064,
  [3858] = 3053,
  [3859] = 3039,
  [3860] = 3046,
  [3861] = 3054,
  [3862] = 3035,
  [3863] = 3032,
  [3864] = 3049,
  [3865] = 3049,
  [3866] = 3046,
  [3867] = 3031,
  [3868] = 3039,
  [3869] = 3029,
  [3870] = 3038,
  [3871] = 3054,
  [3872] = 3043,
  [3873] = 3053,
  [3874] = 3052,
  [3875] = 3051,
  [3876] = 3049,
  [3877] = 3051,
  [3878] = 3052,
  [3879] = 3053,
  [3880] = 3054,
  [3881] = 3030,
  [3882] = 3052,
  [3883] = 3055,
  [3884] = 3031,
  [3885] = 3031,
  [3886] = 3048,
  [3887] = 3032,
  [3888] = 3033,
  [3889] = 3035,
  [3890] = 3064,
  [3891] = 3064,
  [3892] = 3066,
  [3893] = 3049,
  [3894] = 3068,
  [3895] = 3066,
  [3896] = 3070,
  [3897] = 3050,
  [3898] = 3068,
  [3899] = 3070,
  [3900] = 3032,
  [3901] = 3075,
  [3902] = 3096,
  [3903] = 3037,
  [3904] = 3077,
  [3905] = 3078,
  [3906] = 3069,
  [3907] = 3067,
  [3908] = 3065,
  [3909] = 3063,
  [3910] = 3062,
  [3911] = 3061,
  [3912] = 3050,
  [3913] = 3048,
  [3914] = 3046,
  [3915] = 3061,
  [3916] = 3070,
  [3917] = 3045,
  [3918] = 3044,
  [3919] = 3028,
  [3920] = 3062,
  [3921] = 3063,
  [3922] = 3041,
  [3923] = 3048,
  [3924] = 3040,
  [3925] = 3050,
  [3926] = 3029,
  [3927] = 3043,
  [3928] = 3045,
  [3929] = 3044,
  [3930] = 3075,
  [3931] = 3075,
  [3932] = 3032,
  [3933] = 3031,
  [3934] = 3061,
  [3935] = 3049,
  [3936] = 3040,
  [3937] = 3046,
  [3938] = 3062,
  [3939] = 3039,
  [3940] = 3040,
  [3941] = 3038,
  [3942] = 3033,
  [3943] = 3030,
  [3944] = 3041,
  [3945] = 3033,
  [3946] = 3030,
  [3947] = 3032,
  [3948] = 3028,
  [3949] = 3045,
  [3950] = 3039,
  [3951] = 3044,
  [3952] = 3063,
  [3953] = 3028,
  [3954] = 3075,
  [3955] = 3041,
  [3956] = 3044,
  [3957] = 3040,
  [3958] = 3096,
  [3959] = 3038,
  [3960] = 3045,
  [3961] = 3038,
  [3962] = 3032,
  [3963] = 3039,
  [3964] = 3033,
  [3965] = 3037,
  [3966] = 3030,
  [3967] = 3046,
  [3968] = 3038,
  [3969] = 3051,
  [3970] = 3039,
  [3971] = 3051,
  [3972] = 3040,
  [3973] = 3041,
  [3974] = 3028,
  [3975] = 3044,
  [3976] = 3045,
  [3977] = 3065,
  [3978] = 3065,
  [3979] = 3077,
  [3980] = 3031,
  [3981] = 3055,
  [3982] = 3067,
  [3983] = 3046,
  [3984] = 3053,
  [3985] = 3049,
  [3986] = 3054,
  [3987] = 3031,
  [3988] = 3028,
  [3989] = 3989,
  [3990] = 3067,
  [3991] = 3064,
  [3992] = 3066,
  [3993] = 3068,
  [3994] = 3070,
  [3995] = 3033,
  [3996] = 3078,
  [3997] = 3052,
  [3998] = 3096,
  [3999] = 3030,
  [4000] = 3037,
  [4001] = 3038,
  [4002] = 3064,
  [4003] = 3039,
  [4004] = 3069,
  [4005] = 3053,
  [4006] = 3054,
  [4007] = 3067,
  [4008] = 3069,
  [4009] = 3040,
  [4010] = 3046,
  [4011] = 3075,
  [4012] = 3051,
  [4013] = 3052,
  [4014] = 3053,
  [4015] = 3054,
  [4016] = 3049,
  [4017] = 3048,
  [4018] = 3031,
  [4019] = 3050,
  [4020] = 3061,
  [4021] = 3062,
  [4022] = 3065,
  [4023] = 3063,
  [4024] = 3065,
  [4025] = 3064,
  [4026] = 3032,
  [4027] = 3066,
  [4028] = 3067,
  [4029] = 3068,
  [4030] = 3041,
  [4031] = 3070,
  [4032] = 3041,
  [4033] = 3030,
  [4034] = 3069,
  [4035] = 3078,
  [4036] = 3075,
  [4037] = 3096,
  [4038] = 3037,
  [4039] = 3077,
  [4040] = 3078,
  [4041] = 3069,
  [4042] = 3067,
  [4043] = 3065,
  [4044] = 3063,
  [4045] = 3062,
  [4046] = 3061,
  [4047] = 3050,
  [4048] = 3048,
  [4049] = 3077,
  [4050] = 3037,
  [4051] = 3096,
  [4052] = 3075,
  [4053] = 3070,
  [4054] = 3096,
  [4055] = 3068,
  [4056] = 3049,
  [4057] = 3028,
  [4058] = 3037,
  [4059] = 3066,
  [4060] = 3044,
  [4061] = 3077,
  [4062] = 3045,
  [4063] = 3064,
  [4064] = 3062,
  [4065] = 3078,
  [4066] = 3078,
  [4067] = 3069,
  [4068] = 3031,
  [4069] = 3033,
  [4070] = 3049,
  [4071] = 3048,
  [4072] = 3046,
  [4073] = 3030,
  [4074] = 3039,
  [4075] = 3050,
  [4076] = 3038,
  [4077] = 3038,
  [4078] = 3030,
  [4079] = 3061,
  [4080] = 3033,
  [4081] = 3039,
  [4082] = 3032,
  [4083] = 3062,
  [4084] = 3045,
  [4085] = 3046,
  [4086] = 3044,
  [4087] = 3063,
  [4088] = 3028,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4091,
  [4094] = 4094,
  [4095] = 4091,
  [4096] = 4094,
  [4097] = 4090,
  [4098] = 4098,
  [4099] = 4099,
  [4100] = 4092,
  [4101] = 4091,
  [4102] = 4094,
  [4103] = 4091,
  [4104] = 4104,
  [4105] = 4094,
  [4106] = 4091,
  [4107] = 4094,
  [4108] = 4091,
  [4109] = 4090,
  [4110] = 4098,
  [4111] = 4094,
  [4112] = 4099,
  [4113] = 4092,
  [4114] = 4114,
  [4115] = 4091,
  [4116] = 4094,
  [4117] = 4091,
  [4118] = 4104,
  [4119] = 4094,
  [4120] = 4091,
  [4121] = 4094,
  [4122] = 4091,
  [4123] = 4094,
  [4124] = 4094,
  [4125] = 4092,
  [4126] = 4089,
  [4127] = 4091,
  [4128] = 4094,
  [4129] = 4091,
  [4130] = 4094,
  [4131] = 4099,
  [4132] = 4098,
  [4133] = 4091,
  [4134] = 4094,
  [4135] = 4092,
  [4136] = 4098,
  [4137] = 4099,
  [4138] = 4099,
  [4139] = 4090,
  [4140] = 4090,
  [4141] = 4092,
  [4142] = 4091,
  [4143] = 4092,
  [4144] = 4092,
  [4145] = 4099,
  [4146] = 4094,
  [4147] = 4091,
  [4148] = 4094,
  [4149] = 4091,
  [4150] = 4094,
  [4151] = 4091,
  [4152] = 4098,
  [4153] = 4094,
  [4154] = 4154,
  [4155] = 4091,
  [4156] = 4094,
  [4157] = 4091,
  [4158] = 4094,
  [4159] = 4090,
  [4160] = 4114,
  [4161] = 4091,
  [4162] = 4104,
  [4163] = 4094,
  [4164] = 4099,
  [4165] = 4090,
  [4166] = 4089,
  [4167] = 4090,
  [4168] = 4098,
  [4169] = 4098,
  [4170] = 4099,
  [4171] = 4091,
  [4172] = 4094,
  [4173] = 4091,
  [4174] = 4092,
  [4175] = 4094,
  [4176] = 4091,
  [4177] = 4094,
  [4178] = 4091,
  [4179] = 4094,
  [4180] = 4090,
  [4181] = 4091,
  [4182] = 4094,
  [4183] = 4091,
  [4184] = 4090,
  [4185] = 4099,
  [4186] = 4098,
  [4187] = 4090,
  [4188] = 4098,
  [4189] = 4099,
  [4190] = 4089,
  [4191] = 4099,
  [4192] = 4104,
  [4193] = 4114,
  [4194] = 4098,
  [4195] = 4114,
  [4196] = 4090,
  [4197] = 4154,
  [4198] = 4092,
  [4199] = 4098,
  [4200] = 4099,
  [4201] = 4099,
  [4202] = 4092,
  [4203] = 4092,
  [4204] = 4099,
  [4205] = 4098,
  [4206] = 4089,
  [4207] = 4092,
  [4208] = 4098,
  [4209] = 4090,
  [4210] = 4090,
  [4211] = 4090,
  [4212] = 4098,
  [4213] = 4104,
  [4214] = 4099,
  [4215] = 4104,
  [4216] = 4114,
  [4217] = 4154,
  [4218] = 4090,
  [4219] = 4090,
  [4220] = 4089,
  [4221] = 4098,
  [4222] = 4104,
  [4223] = 4099,
  [4224] = 4099,
  [4225] = 4114,
  [4226] = 4098,
  [4227] = 4154,
  [4228] = 4089,
  [4229] = 4092,
  [4230] = 4154,
  [4231] = 4092,
  [4232] = 4092,
  [4233] = 4090,
  [4234] = 4104,
  [4235] = 4114,
  [4236] = 4154,
  [4237] = 4099,
  [4238] = 4089,
  [4239] = 4092,
  [4240] = 4098,
  [4241] = 4089,
  [4242] = 4114,
  [4243] = 4154,
  [4244] = 4089,
  [4245] = 4154,
  [4246] = 4104,
  [4247] = 4090,
  [4248] = 4114,
  [4249] = 4091,
  [4250] = 4154,
  [4251] = 4154,
  [4252] = 4099,
  [4253] = 4089,
  [4254] = 4098,
  [4255] = 4092,
  [4256] = 4104,
  [4257] = 4098,
  [4258] = 4114,
  [4259] = 4154,
  [4260] = 4099,
  [4261] = 4094,
  [4262] = 4094,
  [4263] = 4098,
  [4264] = 4104,
  [4265] = 4092,
  [4266] = 4114,
  [4267] = 4154,
  [4268] = 4089,
  [4269] = 4092,
  [4270] = 4104,
  [4271] = 4154,
  [4272] = 4114,
  [4273] = 4114,
  [4274] = 4090,
  [4275] = 4098,
  [4276] = 4099,
  [4277] = 4114,
  [4278] = 4092,
  [4279] = 4104,
  [4280] = 4090,
  [4281] = 4154,
  [4282] = 4089,
  [4283] = 4092,
  [4284] = 4089,
  [4285] = 4092,
  [4286] = 4104,
  [4287] = 4114,
  [4288] = 4089,
  [4289] = 4104,
  [4290] = 4154,
  [4291] = 4089,
  [4292] = 4104,
  [4293] = 4092,
  [4294] = 4114,
  [4295] = 4099,
  [4296] = 4154,
  [4297] = 4098,
  [4298] = 4154,
  [4299] = 4090,
  [4300] = 4089,
  [4301] = 4104,
  [4302] = 4092,
  [4303] = 4099,
  [4304] = 4114,
  [4305] = 4104,
  [4306] = 4104,
  [4307] = 4114,
  [4308] = 4089,
  [4309] = 4089,
  [4310] = 4154,
  [4311] = 4098,
  [4312] = 4114,
  [4313] = 4154,
  [4314] = 4114,
  [4315] = 4154,
  [4316] = 4090,
  [4317] = 4089,
  [4318] = 4104,
  [4319] = 4098,
  [4320] = 4114,
  [4321] = 4090,
  [4322] = 4154,
  [4323] = 4099,
  [4324] = 4089,
  [4325] = 4154,
  [4326] = 4090,
  [4327] = 4092,
  [4328] = 4104,
  [4329] = 4099,
  [4330] = 4098,
  [4331] = 4114,
  [4332] = 4089,
  [4333] = 4104,
  [4334] = 4104,
  [4335] = 4154,
  [4336] = 4089,
  [4337] = 4089,
  [4338] = 4114,
  [4339] = 4154,
  [4340] = 4104,
  [4341] = 4098,
  [4342] = 4114,
  [4343] = 4089,
  [4344] = 4114,
  [4345] = 4099,
  [4346] = 4104,
  [4347] = 4104,
  [4348] = 4114,
  [4349] = 4090,
  [4350] = 4154,
  [4351] = 4090,
  [4352] = 4154,
  [4353] = 4092,
  [4354] = 4154,
  [4355] = 4089,
  [4356] = 4114,
  [4357] = 4092,
  [4358] = 4104,
  [4359] = 4089,
  [4360] = 4099,
  [4361] = 4089,
  [4362] = 4098,
  [4363] = 4154,
  [4364] = 4098,
  [4365] = 4104,
  [4366] = 4099,
  [4367] = 4114,
  [4368] = 4090,
  [4369] = 780,
  [4370] = 778,
  [4371] = 778,
  [4372] = 780,
  [4373] = 968,
  [4374] = 476,
  [4375] = 484,
  [4376] = 479,
  [4377] = 477,
  [4378] = 476,
  [4379] = 968,
  [4380] = 484,
  [4381] = 479,
  [4382] = 477,
  [4383] = 515,
  [4384] = 516,
  [4385] = 525,
  [4386] = 2195,
  [4387] = 520,
  [4388] = 526,
  [4389] = 551,
  [4390] = 519,
  [4391] = 527,
  [4392] = 550,
  [4393] = 549,
  [4394] = 518,
  [4395] = 548,
  [4396] = 517,
  [4397] = 547,
  [4398] = 546,
  [4399] = 545,
  [4400] = 556,
  [4401] = 555,
  [4402] = 543,
  [4403] = 528,
  [4404] = 529,
  [4405] = 530,
  [4406] = 514,
  [4407] = 531,
  [4408] = 521,
  [4409] = 508,
  [4410] = 524,
  [4411] = 544,
  [4412] = 552,
  [4413] = 541,
  [4414] = 562,
  [4415] = 533,
  [4416] = 540,
  [4417] = 500,
  [4418] = 513,
  [4419] = 535,
  [4420] = 512,
  [4421] = 561,
  [4422] = 511,
  [4423] = 510,
  [4424] = 509,
  [4425] = 560,
  [4426] = 559,
  [4427] = 536,
  [4428] = 534,
  [4429] = 558,
  [4430] = 523,
  [4431] = 557,
  [4432] = 553,
  [4433] = 554,
  [4434] = 555,
  [4435] = 528,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 525,
  [4439] = 4439,
  [4440] = 4440,
  [4441] = 4441,
  [4442] = 523,
  [4443] = 4443,
  [4444] = 524,
  [4445] = 4439,
  [4446] = 529,
  [4447] = 521,
  [4448] = 4437,
  [4449] = 4440,
  [4450] = 4443,
  [4451] = 520,
  [4452] = 519,
  [4453] = 518,
  [4454] = 517,
  [4455] = 4455,
  [4456] = 516,
  [4457] = 515,
  [4458] = 4443,
  [4459] = 4439,
  [4460] = 531,
  [4461] = 4436,
  [4462] = 4441,
  [4463] = 526,
  [4464] = 4439,
  [4465] = 510,
  [4466] = 4436,
  [4467] = 4437,
  [4468] = 4440,
  [4469] = 4443,
  [4470] = 4441,
  [4471] = 4436,
  [4472] = 4441,
  [4473] = 4436,
  [4474] = 4441,
  [4475] = 4436,
  [4476] = 4441,
  [4477] = 4436,
  [4478] = 4440,
  [4479] = 509,
  [4480] = 4437,
  [4481] = 4441,
  [4482] = 4439,
  [4483] = 4436,
  [4484] = 4441,
  [4485] = 511,
  [4486] = 512,
  [4487] = 4436,
  [4488] = 4441,
  [4489] = 4439,
  [4490] = 4436,
  [4491] = 4441,
  [4492] = 4437,
  [4493] = 4440,
  [4494] = 4443,
  [4495] = 4436,
  [4496] = 4441,
  [4497] = 4436,
  [4498] = 4441,
  [4499] = 4436,
  [4500] = 4441,
  [4501] = 4436,
  [4502] = 4441,
  [4503] = 559,
  [4504] = 4436,
  [4505] = 4441,
  [4506] = 4436,
  [4507] = 4441,
  [4508] = 4443,
  [4509] = 4440,
  [4510] = 4437,
  [4511] = 4436,
  [4512] = 4441,
  [4513] = 4436,
  [4514] = 4439,
  [4515] = 4441,
  [4516] = 4436,
  [4517] = 4437,
  [4518] = 4440,
  [4519] = 4443,
  [4520] = 4441,
  [4521] = 4436,
  [4522] = 4441,
  [4523] = 4436,
  [4524] = 4441,
  [4525] = 4439,
  [4526] = 4436,
  [4527] = 4441,
  [4528] = 4436,
  [4529] = 4441,
  [4530] = 4436,
  [4531] = 513,
  [4532] = 4441,
  [4533] = 4436,
  [4534] = 4441,
  [4535] = 4436,
  [4536] = 4441,
  [4537] = 4436,
  [4538] = 4441,
  [4539] = 4439,
  [4540] = 4439,
  [4541] = 4436,
  [4542] = 4437,
  [4543] = 4440,
  [4544] = 4443,
  [4545] = 4437,
  [4546] = 4441,
  [4547] = 4440,
  [4548] = 4443,
  [4549] = 533,
  [4550] = 534,
  [4551] = 4437,
  [4552] = 535,
  [4553] = 514,
  [4554] = 4440,
  [4555] = 4443,
  [4556] = 4440,
  [4557] = 4437,
  [4558] = 4437,
  [4559] = 536,
  [4560] = 4439,
  [4561] = 4443,
  [4562] = 4440,
  [4563] = 4437,
  [4564] = 4439,
  [4565] = 500,
  [4566] = 4439,
  [4567] = 4437,
  [4568] = 4440,
  [4569] = 4443,
  [4570] = 4443,
  [4571] = 540,
  [4572] = 541,
  [4573] = 543,
  [4574] = 4443,
  [4575] = 530,
  [4576] = 4440,
  [4577] = 4437,
  [4578] = 508,
  [4579] = 4439,
  [4580] = 545,
  [4581] = 546,
  [4582] = 547,
  [4583] = 4443,
  [4584] = 4440,
  [4585] = 4437,
  [4586] = 4443,
  [4587] = 4440,
  [4588] = 548,
  [4589] = 4439,
  [4590] = 4437,
  [4591] = 4439,
  [4592] = 4437,
  [4593] = 4440,
  [4594] = 4443,
  [4595] = 4439,
  [4596] = 549,
  [4597] = 550,
  [4598] = 551,
  [4599] = 4443,
  [4600] = 4440,
  [4601] = 4437,
  [4602] = 4439,
  [4603] = 4443,
  [4604] = 544,
  [4605] = 562,
  [4606] = 4439,
  [4607] = 4440,
  [4608] = 4437,
  [4609] = 4439,
  [4610] = 4439,
  [4611] = 4440,
  [4612] = 552,
  [4613] = 4443,
  [4614] = 4439,
  [4615] = 561,
  [4616] = 4440,
  [4617] = 4437,
  [4618] = 4440,
  [4619] = 4443,
  [4620] = 4437,
  [4621] = 4439,
  [4622] = 4437,
  [4623] = 4439,
  [4624] = 4437,
  [4625] = 4440,
  [4626] = 4443,
  [4627] = 4443,
  [4628] = 560,
  [4629] = 4443,
  [4630] = 4440,
  [4631] = 4437,
  [4632] = 553,
  [4633] = 4439,
  [4634] = 2195,
  [4635] = 4443,
  [4636] = 4443,
  [4637] = 4440,
  [4638] = 4440,
  [4639] = 4439,
  [4640] = 558,
  [4641] = 554,
  [4642] = 4437,
  [4643] = 4440,
  [4644] = 4443,
  [4645] = 527,
  [4646] = 4443,
  [4647] = 4440,
  [4648] = 4437,
  [4649] = 4439,
  [4650] = 4437,
  [4651] = 4439,
  [4652] = 556,
  [4653] = 557,
  [4654] = 4654,
  [4655] = 1947,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4654,
  [4659] = 4657,
  [4660] = 4660,
  [4661] = 4657,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4656,
  [4665] = 4656,
  [4666] = 4660,
  [4667] = 4667,
  [4668] = 2033,
  [4669] = 4654,
  [4670] = 1943,
  [4671] = 4667,
  [4672] = 4660,
  [4673] = 4662,
  [4674] = 1923,
  [4675] = 2031,
  [4676] = 4662,
  [4677] = 4663,
  [4678] = 1934,
  [4679] = 4663,
  [4680] = 1925,
  [4681] = 1927,
  [4682] = 4667,
  [4683] = 1929,
  [4684] = 1923,
  [4685] = 1947,
  [4686] = 2031,
  [4687] = 1929,
  [4688] = 2033,
  [4689] = 1927,
  [4690] = 1925,
  [4691] = 1934,
  [4692] = 1943,
  [4693] = 2195,
  [4694] = 2244,
  [4695] = 2268,
  [4696] = 2245,
  [4697] = 2267,
  [4698] = 2261,
  [4699] = 2248,
  [4700] = 2257,
  [4701] = 2260,
  [4702] = 2249,
  [4703] = 2275,
  [4704] = 2246,
  [4705] = 2250,
  [4706] = 2252,
  [4707] = 2243,
  [4708] = 2259,
  [4709] = 2242,
  [4710] = 2256,
  [4711] = 2240,
  [4712] = 2230,
  [4713] = 2259,
  [4714] = 2252,
  [4715] = 2240,
  [4716] = 2275,
  [4717] = 2267,
  [4718] = 2249,
  [4719] = 2268,
  [4720] = 2244,
  [4721] = 2261,
  [4722] = 2260,
  [4723] = 2230,
  [4724] = 2257,
  [4725] = 2242,
  [4726] = 2245,
  [4727] = 2243,
  [4728] = 2246,
  [4729] = 2250,
  [4730] = 2248,
  [4731] = 2256,
  [4732] = 4732,
  [4733] = 4732,
  [4734] = 4732,
  [4735] = 4732,
  [4736] = 4732,
  [4737] = 4732,
  [4738] = 4732,
  [4739] = 4732,
  [4740] = 4732,
  [4741] = 4732,
  [4742] = 4732,
  [4743] = 4732,
  [4744] = 4732,
  [4745] = 4732,
  [4746] = 4732,
  [4747] = 4732,
  [4748] = 4732,
  [4749] = 4732,
  [4750] = 4732,
  [4751] = 4732,
  [4752] = 4732,
  [4753] = 4732,
  [4754] = 4732,
  [4755] = 4732,
  [4756] = 4732,
  [4757] = 4732,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4764,
  [4767] = 4767,
  [4768] = 4763,
  [4769] = 4759,
  [4770] = 4762,
  [4771] = 4759,
  [4772] = 4772,
  [4773] = 4764,
  [4774] = 4761,
  [4775] = 4775,
  [4776] = 4761,
  [4777] = 4762,
  [4778] = 4763,
  [4779] = 4779,
  [4780] = 4761,
  [4781] = 4764,
  [4782] = 4767,
  [4783] = 4775,
  [4784] = 4761,
  [4785] = 4765,
  [4786] = 4764,
  [4787] = 4779,
  [4788] = 4767,
  [4789] = 4759,
  [4790] = 4767,
  [4791] = 4759,
  [4792] = 4772,
  [4793] = 4759,
  [4794] = 4761,
  [4795] = 4775,
  [4796] = 4764,
  [4797] = 4761,
  [4798] = 4765,
  [4799] = 4767,
  [4800] = 4779,
  [4801] = 4762,
  [4802] = 4763,
  [4803] = 4772,
  [4804] = 4759,
  [4805] = 4762,
  [4806] = 4767,
  [4807] = 4765,
  [4808] = 4775,
  [4809] = 4775,
  [4810] = 4760,
  [4811] = 4765,
  [4812] = 4762,
  [4813] = 4763,
  [4814] = 4763,
  [4815] = 4763,
  [4816] = 4762,
  [4817] = 4763,
  [4818] = 4779,
  [4819] = 4764,
  [4820] = 4761,
  [4821] = 4772,
  [4822] = 4762,
  [4823] = 4763,
  [4824] = 4762,
  [4825] = 4763,
  [4826] = 4775,
  [4827] = 4761,
  [4828] = 4764,
  [4829] = 4762,
  [4830] = 4765,
  [4831] = 4779,
  [4832] = 4761,
  [4833] = 4764,
  [4834] = 4772,
  [4835] = 4767,
  [4836] = 4759,
  [4837] = 4759,
  [4838] = 4767,
  [4839] = 4775,
  [4840] = 4767,
  [4841] = 4765,
  [4842] = 4764,
  [4843] = 4761,
  [4844] = 4779,
  [4845] = 4759,
  [4846] = 4846,
  [4847] = 4762,
  [4848] = 4763,
  [4849] = 4764,
  [4850] = 4759,
  [4851] = 4759,
  [4852] = 4767,
  [4853] = 4772,
  [4854] = 4762,
  [4855] = 4775,
  [4856] = 4761,
  [4857] = 4763,
  [4858] = 4767,
  [4859] = 4765,
  [4860] = 4764,
  [4861] = 4761,
  [4862] = 4779,
  [4863] = 4772,
  [4864] = 4762,
  [4865] = 4763,
  [4866] = 4759,
  [4867] = 4763,
  [4868] = 4775,
  [4869] = 4759,
  [4870] = 4762,
  [4871] = 4767,
  [4872] = 4759,
  [4873] = 4765,
  [4874] = 4764,
  [4875] = 4762,
  [4876] = 4779,
  [4877] = 4764,
  [4878] = 4761,
  [4879] = 4772,
  [4880] = 4763,
  [4881] = 4762,
  [4882] = 4763,
  [4883] = 4762,
  [4884] = 4763,
  [4885] = 4775,
  [4886] = 4761,
  [4887] = 4765,
  [4888] = 4761,
  [4889] = 4846,
  [4890] = 4760,
  [4891] = 4764,
  [4892] = 4779,
  [4893] = 4772,
  [4894] = 4759,
  [4895] = 4775,
  [4896] = 4759,
  [4897] = 4761,
  [4898] = 4767,
  [4899] = 4846,
  [4900] = 4760,
  [4901] = 4767,
  [4902] = 4765,
  [4903] = 4779,
  [4904] = 4772,
  [4905] = 4846,
  [4906] = 4760,
  [4907] = 4764,
  [4908] = 4775,
  [4909] = 4762,
  [4910] = 4765,
  [4911] = 4846,
  [4912] = 4760,
  [4913] = 4763,
  [4914] = 4779,
  [4915] = 4761,
  [4916] = 4772,
  [4917] = 4846,
  [4918] = 4760,
  [4919] = 4761,
  [4920] = 4775,
  [4921] = 4764,
  [4922] = 4765,
  [4923] = 4846,
  [4924] = 4760,
  [4925] = 4764,
  [4926] = 4779,
  [4927] = 4759,
  [4928] = 4772,
  [4929] = 4846,
  [4930] = 4760,
  [4931] = 4763,
  [4932] = 4775,
  [4933] = 4762,
  [4934] = 4765,
  [4935] = 4846,
  [4936] = 4760,
  [4937] = 4779,
  [4938] = 4772,
  [4939] = 4775,
  [4940] = 4765,
  [4941] = 4846,
  [4942] = 4760,
  [4943] = 4761,
  [4944] = 4779,
  [4945] = 4764,
  [4946] = 4772,
  [4947] = 4846,
  [4948] = 4760,
  [4949] = 4775,
  [4950] = 4765,
  [4951] = 4759,
  [4952] = 4779,
  [4953] = 4846,
  [4954] = 4760,
  [4955] = 4772,
  [4956] = 4775,
  [4957] = 4767,
  [4958] = 4765,
  [4959] = 4846,
  [4960] = 4760,
  [4961] = 4767,
  [4962] = 4779,
  [4963] = 4763,
  [4964] = 4772,
  [4965] = 4846,
  [4966] = 4760,
  [4967] = 4775,
  [4968] = 4765,
  [4969] = 4764,
  [4970] = 4779,
  [4971] = 4846,
  [4972] = 4760,
  [4973] = 4761,
  [4974] = 4772,
  [4975] = 4775,
  [4976] = 4765,
  [4977] = 4846,
  [4978] = 4760,
  [4979] = 4763,
  [4980] = 4779,
  [4981] = 4762,
  [4982] = 4772,
  [4983] = 4846,
  [4984] = 4760,
  [4985] = 4779,
  [4986] = 4775,
  [4987] = 4767,
  [4988] = 4765,
  [4989] = 4846,
  [4990] = 4760,
  [4991] = 4779,
  [4992] = 4772,
  [4993] = 4761,
  [4994] = 4775,
  [4995] = 4846,
  [4996] = 4760,
  [4997] = 4764,
  [4998] = 4765,
  [4999] = 4779,
  [5000] = 4772,
  [5001] = 4846,
  [5002] = 4760,
  [5003] = 4759,
  [5004] = 4775,
  [5005] = 4762,
  [5006] = 4765,
  [5007] = 4846,
  [5008] = 4760,
  [5009] = 4767,
  [5010] = 4779,
  [5011] = 4763,
  [5012] = 4772,
  [5013] = 4846,
  [5014] = 4775,
  [5015] = 4765,
  [5016] = 4779,
  [5017] = 4767,
  [5018] = 4772,
  [5019] = 4846,
  [5020] = 4760,
  [5021] = 4759,
  [5022] = 4775,
  [5023] = 4763,
  [5024] = 4765,
  [5025] = 4846,
  [5026] = 4760,
  [5027] = 4762,
  [5028] = 4779,
  [5029] = 4767,
  [5030] = 4772,
  [5031] = 4846,
  [5032] = 4760,
  [5033] = 4764,
  [5034] = 4775,
  [5035] = 4765,
  [5036] = 4779,
  [5037] = 4846,
  [5038] = 4760,
  [5039] = 4761,
  [5040] = 4772,
  [5041] = 4764,
  [5042] = 4775,
  [5043] = 4846,
  [5044] = 4760,
  [5045] = 4765,
  [5046] = 4779,
  [5047] = 4759,
  [5048] = 4772,
  [5049] = 4846,
  [5050] = 4760,
  [5051] = 4775,
  [5052] = 4765,
  [5053] = 4767,
  [5054] = 4779,
  [5055] = 4772,
  [5056] = 4767,
  [5057] = 4762,
  [5058] = 4759,
  [5059] = 4775,
  [5060] = 4765,
  [5061] = 4767,
  [5062] = 4779,
  [5063] = 4763,
  [5064] = 4772,
  [5065] = 4763,
  [5066] = 4772,
  [5067] = 4762,
  [5068] = 4763,
  [5069] = 4762,
  [5070] = 4767,
  [5071] = 4762,
  [5072] = 4759,
  [5073] = 4759,
  [5074] = 5074,
  [5075] = 4761,
  [5076] = 5076,
  [5077] = 4764,
  [5078] = 4764,
  [5079] = 4761,
  [5080] = 4761,
  [5081] = 4762,
  [5082] = 4767,
  [5083] = 4759,
  [5084] = 4761,
  [5085] = 4764,
  [5086] = 4763,
  [5087] = 4763,
  [5088] = 4764,
  [5089] = 4762,
  [5090] = 4764,
  [5091] = 4761,
  [5092] = 4767,
  [5093] = 5093,
  [5094] = 5093,
  [5095] = 5093,
  [5096] = 5093,
  [5097] = 5093,
  [5098] = 5093,
  [5099] = 5093,
  [5100] = 5093,
  [5101] = 5093,
  [5102] = 5093,
  [5103] = 5093,
  [5104] = 5093,
  [5105] = 5093,
  [5106] = 5093,
  [5107] = 5093,
  [5108] = 5093,
  [5109] = 5109,
  [5110] = 5110,
  [5111] = 5093,
  [5112] = 5093,
  [5113] = 5093,
  [5114] = 5093,
  [5115] = 5093,
  [5116] = 5093,
  [5117] = 5093,
  [5118] = 5118,
  [5119] = 5093,
  [5120] = 5093,
  [5121] = 2195,
  [5122] = 5093,
  [5123] = 5123,
  [5124] = 5093,
  [5125] = 5093,
  [5126] = 5126,
  [5127] = 5126,
  [5128] = 5126,
  [5129] = 5126,
  [5130] = 5126,
  [5131] = 5126,
  [5132] = 5132,
  [5133] = 5126,
  [5134] = 5126,
  [5135] = 5126,
  [5136] = 5136,
  [5137] = 5126,
  [5138] = 5126,
  [5139] = 5126,
  [5140] = 5126,
  [5141] = 5126,
  [5142] = 5126,
  [5143] = 5126,
  [5144] = 5126,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 5126,
  [5148] = 5126,
  [5149] = 5126,
  [5150] = 5126,
  [5151] = 5126,
  [5152] = 5126,
  [5153] = 5126,
  [5154] = 5126,
  [5155] = 5126,
  [5156] = 5126,
  [5157] = 5126,
  [5158] = 5158,
  [5159] = 5158,
  [5160] = 5160,
  [5161] = 5161,
  [5162] = 5161,
  [5163] = 5160,
  [5164] = 5161,
  [5165] = 5160,
  [5166] = 5161,
  [5167] = 5160,
  [5168] = 5161,
  [5169] = 5169,
  [5170] = 5160,
  [5171] = 5158,
  [5172] = 5172,
  [5173] = 5158,
  [5174] = 5172,
  [5175] = 5158,
  [5176] = 5172,
  [5177] = 5158,
  [5178] = 5172,
  [5179] = 5158,
  [5180] = 5172,
  [5181] = 5160,
  [5182] = 5172,
  [5183] = 5158,
  [5184] = 5172,
  [5185] = 5161,
  [5186] = 5161,
  [5187] = 5158,
  [5188] = 5172,
  [5189] = 5158,
  [5190] = 5172,
  [5191] = 5158,
  [5192] = 5161,
  [5193] = 5172,
  [5194] = 5158,
  [5195] = 5172,
  [5196] = 5160,
  [5197] = 5158,
  [5198] = 5172,
  [5199] = 5158,
  [5200] = 5172,
  [5201] = 5158,
  [5202] = 5161,
  [5203] = 5172,
  [5204] = 5158,
  [5205] = 5172,
  [5206] = 5160,
  [5207] = 5158,
  [5208] = 5172,
  [5209] = 5158,
  [5210] = 5172,
  [5211] = 5160,
  [5212] = 5158,
  [5213] = 5172,
  [5214] = 5161,
  [5215] = 5160,
  [5216] = 5172,
  [5217] = 5158,
  [5218] = 5160,
  [5219] = 5172,
  [5220] = 5161,
  [5221] = 5158,
  [5222] = 5172,
  [5223] = 5158,
  [5224] = 5172,
  [5225] = 5158,
  [5226] = 5172,
  [5227] = 5158,
  [5228] = 5172,
  [5229] = 5158,
  [5230] = 5172,
  [5231] = 5158,
  [5232] = 5161,
  [5233] = 5172,
  [5234] = 5158,
  [5235] = 5158,
  [5236] = 5172,
  [5237] = 5160,
  [5238] = 5160,
  [5239] = 5161,
  [5240] = 5161,
  [5241] = 5160,
  [5242] = 5160,
  [5243] = 5161,
  [5244] = 5160,
  [5245] = 5161,
  [5246] = 5161,
  [5247] = 5172,
  [5248] = 5160,
  [5249] = 5161,
  [5250] = 5160,
  [5251] = 5161,
  [5252] = 5160,
  [5253] = 5161,
  [5254] = 5160,
  [5255] = 5161,
  [5256] = 5161,
  [5257] = 5160,
  [5258] = 5160,
  [5259] = 5161,
  [5260] = 5160,
  [5261] = 5160,
  [5262] = 5161,
  [5263] = 5161,
  [5264] = 5160,
  [5265] = 5160,
  [5266] = 5161,
  [5267] = 5160,
  [5268] = 5161,
  [5269] = 5161,
  [5270] = 5160,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'.', '.'}, {'A', 'Z'}, {'_', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d},
  {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339},
  {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5},
  {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8}, {0x11700, 0x1171a},
  {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f},
  {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00}, {0x11a0b, 0x11a32},
  {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40},
  {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89},
  {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e},
  {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77},
  {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167},
  {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
  {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a},
  {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5},
  {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788},
  {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad},
  {0x1e2c0, 0x1e2eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b},
  {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39},
  {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54},
  {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a},
  {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9},
  {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'.', '.'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7},
  {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee},
  {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf},
  {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3},
  {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa},
  {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963},
  {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc},
  {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36},
  {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03},
  {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48},
  {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10},
  {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9},
  {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf2},
  {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f},
  {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca},
  {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6},
  {0xec8, 0xecd}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37},
  {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049},
  {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715},
  {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd},
  {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b},
  {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e},
  {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59},
  {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf},
  {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff},
  {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1},
  {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c},
  {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c},
  {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2},
  {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e},
  {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
  {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
  {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9},
  {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79},
  {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff66, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0},
  {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d},
  {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592},
  {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767},
  {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c},
  {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7},
  {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1},
  {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075},
  {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173},
  {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x1123e},
  {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303},
  {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348},
  {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459},
  {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640},
  {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746},
  {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938},
  {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47},
  {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f},
  {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47},
  {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6},
  {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38},
  {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43},
  {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1},
  {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe},
  {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99},
  {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad},
  {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9},
  {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
  {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714},
  {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
  {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1e000, 0x1e006},
  {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6},
  {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1},
  {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      ADVANCE_MAP(
        '!', 30,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '.', 90,
        '/', 49,
        '0', 61,
        ':', 54,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '\\', 26,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(92);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 7,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '/', 49,
        ':', 55,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(92);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(70);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '`') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(92);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 5:
      if (lookahead == '%') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\') ADVANCE(5);
      END_STATE();
    case 6:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 8:
      if (lookahead == 'U') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(79);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(77);
      END_STATE();
    case 9:
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(87);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '{') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 11:
      if (lookahead == '{') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(77);
      END_STATE();
    case 13:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 18:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(36);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(37);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '|') ADVANCE(40);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '<') ADVANCE(6);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(50);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_binary_operator_token1);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym__hex_literal_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(71);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(74);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(77);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(89);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_dots);
      if (set_contains(sym_identifier_character_set_2, 764, lookahead)) ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_dot_dot_i);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'F', 1,
        'I', 2,
        'L', 3,
        'N', 4,
        'T', 5,
        'b', 6,
        'f', 7,
        'i', 8,
        'n', 9,
        'r', 10,
        'w', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_L);
      END_STATE();
    case 4:
      if (lookahead == 'A') ADVANCE(14);
      if (lookahead == 'U') ADVANCE(15);
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'R') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'L') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'L') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'N') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'U') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 23:
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'S') ADVANCE(39);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_inf);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'L') ADVANCE(43);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_nan);
      END_STATE();
    case 31:
      if (lookahead == 'E') ADVANCE(44);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'E') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 45:
      if (lookahead == 'k') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(75);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(76);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'x') ADVANCE(82);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 82:
      if (lookahead == '_') ADVANCE(85);
      END_STATE();
    case 83:
      if (lookahead == '_') ADVANCE(86);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      END_STATE();
    case 87:
      if (lookahead == '_') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 3},
  [3] = {.lex_state = 0, .external_lex_state = 4},
  [4] = {.lex_state = 0, .external_lex_state = 3},
  [5] = {.lex_state = 0, .external_lex_state = 5},
  [6] = {.lex_state = 0, .external_lex_state = 5},
  [7] = {.lex_state = 0, .external_lex_state = 4},
  [8] = {.lex_state = 0, .external_lex_state = 4},
  [9] = {.lex_state = 0, .external_lex_state = 5},
  [10] = {.lex_state = 0, .external_lex_state = 4},
  [11] = {.lex_state = 0, .external_lex_state = 4},
  [12] = {.lex_state = 0, .external_lex_state = 4},
  [13] = {.lex_state = 0, .external_lex_state = 5},
  [14] = {.lex_state = 0, .external_lex_state = 5},
  [15] = {.lex_state = 0, .external_lex_state = 4},
  [16] = {.lex_state = 0, .external_lex_state = 5},
  [17] = {.lex_state = 0, .external_lex_state = 5},
  [18] = {.lex_state = 0, .external_lex_state = 5},
  [19] = {.lex_state = 0, .external_lex_state = 3},
  [20] = {.lex_state = 0, .external_lex_state = 4},
  [21] = {.lex_state = 0, .external_lex_state = 3},
  [22] = {.lex_state = 0, .external_lex_state = 3},
  [23] = {.lex_state = 0, .external_lex_state = 6},
  [24] = {.lex_state = 0, .external_lex_state = 7},
  [25] = {.lex_state = 0, .external_lex_state = 3},
  [26] = {.lex_state = 0, .external_lex_state = 3},
  [27] = {.lex_state = 0, .external_lex_state = 3},
  [28] = {.lex_state = 0, .external_lex_state = 3},
  [29] = {.lex_state = 0, .external_lex_state = 8},
  [30] = {.lex_state = 0, .external_lex_state = 3},
  [31] = {.lex_state = 0, .external_lex_state = 3},
  [32] = {.lex_state = 0, .external_lex_state = 3},
  [33] = {.lex_state = 0, .external_lex_state = 3},
  [34] = {.lex_state = 0, .external_lex_state = 9},
  [35] = {.lex_state = 0, .external_lex_state = 8},
  [36] = {.lex_state = 0, .external_lex_state = 3},
  [37] = {.lex_state = 0, .external_lex_state = 3},
  [38] = {.lex_state = 0, .external_lex_state = 4},
  [39] = {.lex_state = 0, .external_lex_state = 5},
  [40] = {.lex_state = 0, .external_lex_state = 10},
  [41] = {.lex_state = 0, .external_lex_state = 9},
  [42] = {.lex_state = 0, .external_lex_state = 8},
  [43] = {.lex_state = 0, .external_lex_state = 4},
  [44] = {.lex_state = 0, .external_lex_state = 10},
  [45] = {.lex_state = 0, .external_lex_state = 9},
  [46] = {.lex_state = 0, .external_lex_state = 3},
  [47] = {.lex_state = 0, .external_lex_state = 3},
  [48] = {.lex_state = 0, .external_lex_state = 8},
  [49] = {.lex_state = 0, .external_lex_state = 3},
  [50] = {.lex_state = 0, .external_lex_state = 6},
  [51] = {.lex_state = 0, .external_lex_state = 3},
  [52] = {.lex_state = 0, .external_lex_state = 3},
  [53] = {.lex_state = 0, .external_lex_state = 4},
  [54] = {.lex_state = 0, .external_lex_state = 10},
  [55] = {.lex_state = 0, .external_lex_state = 4},
  [56] = {.lex_state = 0, .external_lex_state = 10},
  [57] = {.lex_state = 0, .external_lex_state = 6},
  [58] = {.lex_state = 0, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 6},
  [60] = {.lex_state = 0, .external_lex_state = 4},
  [61] = {.lex_state = 0, .external_lex_state = 6},
  [62] = {.lex_state = 0, .external_lex_state = 10},
  [63] = {.lex_state = 0, .external_lex_state = 9},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 4},
  [66] = {.lex_state = 0, .external_lex_state = 3},
  [67] = {.lex_state = 0, .external_lex_state = 7},
  [68] = {.lex_state = 0, .external_lex_state = 7},
  [69] = {.lex_state = 0, .external_lex_state = 6},
  [70] = {.lex_state = 0, .external_lex_state = 6},
  [71] = {.lex_state = 0, .external_lex_state = 4},
  [72] = {.lex_state = 0, .external_lex_state = 5},
  [73] = {.lex_state = 0, .external_lex_state = 4},
  [74] = {.lex_state = 0, .external_lex_state = 10},
  [75] = {.lex_state = 0, .external_lex_state = 3},
  [76] = {.lex_state = 0, .external_lex_state = 10},
  [77] = {.lex_state = 0, .external_lex_state = 5},
  [78] = {.lex_state = 0, .external_lex_state = 5},
  [79] = {.lex_state = 0, .external_lex_state = 5},
  [80] = {.lex_state = 0, .external_lex_state = 5},
  [81] = {.lex_state = 0, .external_lex_state = 5},
  [82] = {.lex_state = 0, .external_lex_state = 4},
  [83] = {.lex_state = 0, .external_lex_state = 4},
  [84] = {.lex_state = 0, .external_lex_state = 7},
  [85] = {.lex_state = 0, .external_lex_state = 5},
  [86] = {.lex_state = 0, .external_lex_state = 4},
  [87] = {.lex_state = 0, .external_lex_state = 5},
  [88] = {.lex_state = 0, .external_lex_state = 5},
  [89] = {.lex_state = 0, .external_lex_state = 5},
  [90] = {.lex_state = 0, .external_lex_state = 5},
  [91] = {.lex_state = 0, .external_lex_state = 4},
  [92] = {.lex_state = 0, .external_lex_state = 4},
  [93] = {.lex_state = 0, .external_lex_state = 6},
  [94] = {.lex_state = 0, .external_lex_state = 3},
  [95] = {.lex_state = 0, .external_lex_state = 5},
  [96] = {.lex_state = 0, .external_lex_state = 4},
  [97] = {.lex_state = 0, .external_lex_state = 3},
  [98] = {.lex_state = 0, .external_lex_state = 10},
  [99] = {.lex_state = 0, .external_lex_state = 5},
  [100] = {.lex_state = 0, .external_lex_state = 7},
  [101] = {.lex_state = 0, .external_lex_state = 9},
  [102] = {.lex_state = 0, .external_lex_state = 11},
  [103] = {.lex_state = 0, .external_lex_state = 12},
  [104] = {.lex_state = 0, .external_lex_state = 13},
  [105] = {.lex_state = 0, .external_lex_state = 14},
  [106] = {.lex_state = 0, .external_lex_state = 15},
  [107] = {.lex_state = 0, .external_lex_state = 7},
  [108] = {.lex_state = 0, .external_lex_state = 6},
  [109] = {.lex_state = 0, .external_lex_state = 6},
  [110] = {.lex_state = 0, .external_lex_state = 6},
  [111] = {.lex_state = 0, .external_lex_state = 6},
  [112] = {.lex_state = 0, .external_lex_state = 16},
  [113] = {.lex_state = 0, .external_lex_state = 6},
  [114] = {.lex_state = 0, .external_lex_state = 6},
  [115] = {.lex_state = 0, .external_lex_state = 6},
  [116] = {.lex_state = 0, .external_lex_state = 6},
  [117] = {.lex_state = 0, .external_lex_state = 6},
  [118] = {.lex_state = 0, .external_lex_state = 6},
  [119] = {.lex_state = 0, .external_lex_state = 16},
  [120] = {.lex_state = 0, .external_lex_state = 11},
  [121] = {.lex_state = 0, .external_lex_state = 12},
  [122] = {.lex_state = 0, .external_lex_state = 6},
  [123] = {.lex_state = 0, .external_lex_state = 6},
  [124] = {.lex_state = 0, .external_lex_state = 10},
  [125] = {.lex_state = 0, .external_lex_state = 6},
  [126] = {.lex_state = 0, .external_lex_state = 7},
  [127] = {.lex_state = 0, .external_lex_state = 6},
  [128] = {.lex_state = 0, .external_lex_state = 10},
  [129] = {.lex_state = 0, .external_lex_state = 10},
  [130] = {.lex_state = 0, .external_lex_state = 10},
  [131] = {.lex_state = 0, .external_lex_state = 10},
  [132] = {.lex_state = 0, .external_lex_state = 10},
  [133] = {.lex_state = 0, .external_lex_state = 14},
  [134] = {.lex_state = 0, .external_lex_state = 10},
  [135] = {.lex_state = 0, .external_lex_state = 10},
  [136] = {.lex_state = 0, .external_lex_state = 15},
  [137] = {.lex_state = 0, .external_lex_state = 10},
  [138] = {.lex_state = 0, .external_lex_state = 10},
  [139] = {.lex_state = 0, .external_lex_state = 7},
  [140] = {.lex_state = 0, .external_lex_state = 10},
  [141] = {.lex_state = 0, .external_lex_state = 10},
  [142] = {.lex_state = 0, .external_lex_state = 7},
  [143] = {.lex_state = 0, .external_lex_state = 10},
  [144] = {.lex_state = 0, .external_lex_state = 10},
  [145] = {.lex_state = 0, .external_lex_state = 7},
  [146] = {.lex_state = 0, .external_lex_state = 7},
  [147] = {.lex_state = 0, .external_lex_state = 11},
  [148] = {.lex_state = 0, .external_lex_state = 13},
  [149] = {.lex_state = 0, .external_lex_state = 7},
  [150] = {.lex_state = 0, .external_lex_state = 13},
  [151] = {.lex_state = 0, .external_lex_state = 9},
  [152] = {.lex_state = 0, .external_lex_state = 9},
  [153] = {.lex_state = 0, .external_lex_state = 7},
  [154] = {.lex_state = 0, .external_lex_state = 7},
  [155] = {.lex_state = 0, .external_lex_state = 7},
  [156] = {.lex_state = 0, .external_lex_state = 7},
  [157] = {.lex_state = 0, .external_lex_state = 9},
  [158] = {.lex_state = 0, .external_lex_state = 9},
  [159] = {.lex_state = 0, .external_lex_state = 8},
  [160] = {.lex_state = 0, .external_lex_state = 9},
  [161] = {.lex_state = 0, .external_lex_state = 9},
  [162] = {.lex_state = 0, .external_lex_state = 9},
  [163] = {.lex_state = 0, .external_lex_state = 7},
  [164] = {.lex_state = 0, .external_lex_state = 9},
  [165] = {.lex_state = 0, .external_lex_state = 7},
  [166] = {.lex_state = 0, .external_lex_state = 7},
  [167] = {.lex_state = 0, .external_lex_state = 9},
  [168] = {.lex_state = 0, .external_lex_state = 9},
  [169] = {.lex_state = 0, .external_lex_state = 9},
  [170] = {.lex_state = 0, .external_lex_state = 11},
  [171] = {.lex_state = 0, .external_lex_state = 7},
  [172] = {.lex_state = 0, .external_lex_state = 7},
  [173] = {.lex_state = 0, .external_lex_state = 7},
  [174] = {.lex_state = 0, .external_lex_state = 7},
  [175] = {.lex_state = 0, .external_lex_state = 7},
  [176] = {.lex_state = 0, .external_lex_state = 16},
  [177] = {.lex_state = 0, .external_lex_state = 7},
  [178] = {.lex_state = 0, .external_lex_state = 7},
  [179] = {.lex_state = 0, .external_lex_state = 8},
  [180] = {.lex_state = 0, .external_lex_state = 12},
  [181] = {.lex_state = 0, .external_lex_state = 8},
  [182] = {.lex_state = 0, .external_lex_state = 8},
  [183] = {.lex_state = 0, .external_lex_state = 8},
  [184] = {.lex_state = 0, .external_lex_state = 14},
  [185] = {.lex_state = 0, .external_lex_state = 15},
  [186] = {.lex_state = 0, .external_lex_state = 8},
  [187] = {.lex_state = 0, .external_lex_state = 8},
  [188] = {.lex_state = 0, .external_lex_state = 15},
  [189] = {.lex_state = 0, .external_lex_state = 8},
  [190] = {.lex_state = 0, .external_lex_state = 13},
  [191] = {.lex_state = 0, .external_lex_state = 16},
  [192] = {.lex_state = 0, .external_lex_state = 12},
  [193] = {.lex_state = 0, .external_lex_state = 8},
  [194] = {.lex_state = 0, .external_lex_state = 8},
  [195] = {.lex_state = 0, .external_lex_state = 9},
  [196] = {.lex_state = 0, .external_lex_state = 8},
  [197] = {.lex_state = 0, .external_lex_state = 8},
  [198] = {.lex_state = 0, .external_lex_state = 8},
  [199] = {.lex_state = 0, .external_lex_state = 14},
  [200] = {.lex_state = 0, .external_lex_state = 17},
  [201] = {.lex_state = 0, .external_lex_state = 15},
  [202] = {.lex_state = 0, .external_lex_state = 14},
  [203] = {.lex_state = 0, .external_lex_state = 18},
  [204] = {.lex_state = 0, .external_lex_state = 19},
  [205] = {.lex_state = 0, .external_lex_state = 14},
  [206] = {.lex_state = 0, .external_lex_state = 14},
  [207] = {.lex_state = 0, .external_lex_state = 14},
  [208] = {.lex_state = 0, .external_lex_state = 14},
  [209] = {.lex_state = 0, .external_lex_state = 14},
  [210] = {.lex_state = 0, .external_lex_state = 18},
  [211] = {.lex_state = 0, .external_lex_state = 15},
  [212] = {.lex_state = 0, .external_lex_state = 14},
  [213] = {.lex_state = 0, .external_lex_state = 19},
  [214] = {.lex_state = 0, .external_lex_state = 19},
  [215] = {.lex_state = 0, .external_lex_state = 14},
  [216] = {.lex_state = 0, .external_lex_state = 15},
  [217] = {.lex_state = 0, .external_lex_state = 14},
  [218] = {.lex_state = 0, .external_lex_state = 18},
  [219] = {.lex_state = 0, .external_lex_state = 11},
  [220] = {.lex_state = 0, .external_lex_state = 15},
  [221] = {.lex_state = 0, .external_lex_state = 16},
  [222] = {.lex_state = 0, .external_lex_state = 15},
  [223] = {.lex_state = 0, .external_lex_state = 16},
  [224] = {.lex_state = 0, .external_lex_state = 16},
  [225] = {.lex_state = 0, .external_lex_state = 16},
  [226] = {.lex_state = 0, .external_lex_state = 16},
  [227] = {.lex_state = 0, .external_lex_state = 16},
  [228] = {.lex_state = 0, .external_lex_state = 16},
  [229] = {.lex_state = 0, .external_lex_state = 16},
  [230] = {.lex_state = 0, .external_lex_state = 16},
  [231] = {.lex_state = 0, .external_lex_state = 15},
  [232] = {.lex_state = 0, .external_lex_state = 14},
  [233] = {.lex_state = 0, .external_lex_state = 13},
  [234] = {.lex_state = 0, .external_lex_state = 14},
  [235] = {.lex_state = 0, .external_lex_state = 16},
  [236] = {.lex_state = 0, .external_lex_state = 11},
  [237] = {.lex_state = 0, .external_lex_state = 16},
  [238] = {.lex_state = 0, .external_lex_state = 16},
  [239] = {.lex_state = 0, .external_lex_state = 13},
  [240] = {.lex_state = 0, .external_lex_state = 13},
  [241] = {.lex_state = 0, .external_lex_state = 13},
  [242] = {.lex_state = 0, .external_lex_state = 13},
  [243] = {.lex_state = 0, .external_lex_state = 13},
  [244] = {.lex_state = 0, .external_lex_state = 20},
  [245] = {.lex_state = 0, .external_lex_state = 13},
  [246] = {.lex_state = 0, .external_lex_state = 21},
  [247] = {.lex_state = 0, .external_lex_state = 15},
  [248] = {.lex_state = 0, .external_lex_state = 15},
  [249] = {.lex_state = 0, .external_lex_state = 14},
  [250] = {.lex_state = 0, .external_lex_state = 13},
  [251] = {.lex_state = 0, .external_lex_state = 13},
  [252] = {.lex_state = 0, .external_lex_state = 11},
  [253] = {.lex_state = 0, .external_lex_state = 11},
  [254] = {.lex_state = 0, .external_lex_state = 11},
  [255] = {.lex_state = 0, .external_lex_state = 11},
  [256] = {.lex_state = 0, .external_lex_state = 11},
  [257] = {.lex_state = 0, .external_lex_state = 11},
  [258] = {.lex_state = 0, .external_lex_state = 11},
  [259] = {.lex_state = 0, .external_lex_state = 11},
  [260] = {.lex_state = 0, .external_lex_state = 13},
  [261] = {.lex_state = 0, .external_lex_state = 15},
  [262] = {.lex_state = 0, .external_lex_state = 15},
  [263] = {.lex_state = 0, .external_lex_state = 11},
  [264] = {.lex_state = 0, .external_lex_state = 11},
  [265] = {.lex_state = 0, .external_lex_state = 13},
  [266] = {.lex_state = 0, .external_lex_state = 12},
  [267] = {.lex_state = 0, .external_lex_state = 12},
  [268] = {.lex_state = 0, .external_lex_state = 12},
  [269] = {.lex_state = 0, .external_lex_state = 12},
  [270] = {.lex_state = 0, .external_lex_state = 21},
  [271] = {.lex_state = 0, .external_lex_state = 16},
  [272] = {.lex_state = 0, .external_lex_state = 12},
  [273] = {.lex_state = 0, .external_lex_state = 12},
  [274] = {.lex_state = 0, .external_lex_state = 13},
  [275] = {.lex_state = 0, .external_lex_state = 12},
  [276] = {.lex_state = 0, .external_lex_state = 13},
  [277] = {.lex_state = 0, .external_lex_state = 15},
  [278] = {.lex_state = 0, .external_lex_state = 12},
  [279] = {.lex_state = 0, .external_lex_state = 14},
  [280] = {.lex_state = 0, .external_lex_state = 18},
  [281] = {.lex_state = 0, .external_lex_state = 11},
  [282] = {.lex_state = 0, .external_lex_state = 20},
  [283] = {.lex_state = 0, .external_lex_state = 17},
  [284] = {.lex_state = 0, .external_lex_state = 12},
  [285] = {.lex_state = 0, .external_lex_state = 20},
  [286] = {.lex_state = 0, .external_lex_state = 17},
  [287] = {.lex_state = 0, .external_lex_state = 17},
  [288] = {.lex_state = 0, .external_lex_state = 15},
  [289] = {.lex_state = 0, .external_lex_state = 15},
  [290] = {.lex_state = 0, .external_lex_state = 12},
  [291] = {.lex_state = 0, .external_lex_state = 12},
  [292] = {.lex_state = 0, .external_lex_state = 20},
  [293] = {.lex_state = 0, .external_lex_state = 21},
  [294] = {.lex_state = 0, .external_lex_state = 12},
  [295] = {.lex_state = 0, .external_lex_state = 19},
  [296] = {.lex_state = 0, .external_lex_state = 21},
  [297] = {.lex_state = 0, .external_lex_state = 12},
  [298] = {.lex_state = 0, .external_lex_state = 21},
  [299] = {.lex_state = 0, .external_lex_state = 19},
  [300] = {.lex_state = 0, .external_lex_state = 17},
  [301] = {.lex_state = 0, .external_lex_state = 17},
  [302] = {.lex_state = 0, .external_lex_state = 17},
  [303] = {.lex_state = 0, .external_lex_state = 22},
  [304] = {.lex_state = 0, .external_lex_state = 17},
  [305] = {.lex_state = 0, .external_lex_state = 17},
  [306] = {.lex_state = 0, .external_lex_state = 17},
  [307] = {.lex_state = 0, .external_lex_state = 19},
  [308] = {.lex_state = 0, .external_lex_state = 19},
  [309] = {.lex_state = 0, .external_lex_state = 22},
  [310] = {.lex_state = 0, .external_lex_state = 19},
  [311] = {.lex_state = 0, .external_lex_state = 19},
  [312] = {.lex_state = 0, .external_lex_state = 20},
  [313] = {.lex_state = 0, .external_lex_state = 19},
  [314] = {.lex_state = 0, .external_lex_state = 22},
  [315] = {.lex_state = 0, .external_lex_state = 22},
  [316] = {.lex_state = 0, .external_lex_state = 22},
  [317] = {.lex_state = 0, .external_lex_state = 22},
  [318] = {.lex_state = 0, .external_lex_state = 22},
  [319] = {.lex_state = 0, .external_lex_state = 22},
  [320] = {.lex_state = 0, .external_lex_state = 23},
  [321] = {.lex_state = 0, .external_lex_state = 22},
  [322] = {.lex_state = 0, .external_lex_state = 22},
  [323] = {.lex_state = 0, .external_lex_state = 22},
  [324] = {.lex_state = 0, .external_lex_state = 17},
  [325] = {.lex_state = 0, .external_lex_state = 20},
  [326] = {.lex_state = 0, .external_lex_state = 20},
  [327] = {.lex_state = 0, .external_lex_state = 17},
  [328] = {.lex_state = 0, .external_lex_state = 17},
  [329] = {.lex_state = 0, .external_lex_state = 17},
  [330] = {.lex_state = 0, .external_lex_state = 17},
  [331] = {.lex_state = 0, .external_lex_state = 17},
  [332] = {.lex_state = 0, .external_lex_state = 20},
  [333] = {.lex_state = 0, .external_lex_state = 24},
  [334] = {.lex_state = 0, .external_lex_state = 23},
  [335] = {.lex_state = 0, .external_lex_state = 23},
  [336] = {.lex_state = 0, .external_lex_state = 21},
  [337] = {.lex_state = 0, .external_lex_state = 20},
  [338] = {.lex_state = 0, .external_lex_state = 23},
  [339] = {.lex_state = 0, .external_lex_state = 21},
  [340] = {.lex_state = 0, .external_lex_state = 23},
  [341] = {.lex_state = 0, .external_lex_state = 20},
  [342] = {.lex_state = 0, .external_lex_state = 23},
  [343] = {.lex_state = 0, .external_lex_state = 20},
  [344] = {.lex_state = 0, .external_lex_state = 23},
  [345] = {.lex_state = 0, .external_lex_state = 23},
  [346] = {.lex_state = 0, .external_lex_state = 23},
  [347] = {.lex_state = 0, .external_lex_state = 23},
  [348] = {.lex_state = 0, .external_lex_state = 18},
  [349] = {.lex_state = 0, .external_lex_state = 23},
  [350] = {.lex_state = 0, .external_lex_state = 24},
  [351] = {.lex_state = 0, .external_lex_state = 18},
  [352] = {.lex_state = 0, .external_lex_state = 18},
  [353] = {.lex_state = 0, .external_lex_state = 23},
  [354] = {.lex_state = 0, .external_lex_state = 22},
  [355] = {.lex_state = 0, .external_lex_state = 18},
  [356] = {.lex_state = 0, .external_lex_state = 19},
  [357] = {.lex_state = 0, .external_lex_state = 21},
  [358] = {.lex_state = 0, .external_lex_state = 18},
  [359] = {.lex_state = 0, .external_lex_state = 18},
  [360] = {.lex_state = 0, .external_lex_state = 18},
  [361] = {.lex_state = 0, .external_lex_state = 18},
  [362] = {.lex_state = 0, .external_lex_state = 21},
  [363] = {.lex_state = 0, .external_lex_state = 18},
  [364] = {.lex_state = 0, .external_lex_state = 21},
  [365] = {.lex_state = 0, .external_lex_state = 21},
  [366] = {.lex_state = 0, .external_lex_state = 25},
  [367] = {.lex_state = 0, .external_lex_state = 18},
  [368] = {.lex_state = 0, .external_lex_state = 18},
  [369] = {.lex_state = 0, .external_lex_state = 18},
  [370] = {.lex_state = 0, .external_lex_state = 21},
  [371] = {.lex_state = 0, .external_lex_state = 20},
  [372] = {.lex_state = 0, .external_lex_state = 20},
  [373] = {.lex_state = 0, .external_lex_state = 21},
  [374] = {.lex_state = 0, .external_lex_state = 21},
  [375] = {.lex_state = 0, .external_lex_state = 25},
  [376] = {.lex_state = 0, .external_lex_state = 25},
  [377] = {.lex_state = 0, .external_lex_state = 17},
  [378] = {.lex_state = 0, .external_lex_state = 17},
  [379] = {.lex_state = 0, .external_lex_state = 17},
  [380] = {.lex_state = 0, .external_lex_state = 25},
  [381] = {.lex_state = 0, .external_lex_state = 21},
  [382] = {.lex_state = 0, .external_lex_state = 17},
  [383] = {.lex_state = 0, .external_lex_state = 17},
  [384] = {.lex_state = 0, .external_lex_state = 17},
  [385] = {.lex_state = 0, .external_lex_state = 17},
  [386] = {.lex_state = 0, .external_lex_state = 17},
  [387] = {.lex_state = 0, .external_lex_state = 17},
  [388] = {.lex_state = 0, .external_lex_state = 21},
  [389] = {.lex_state = 0, .external_lex_state = 25},
  [390] = {.lex_state = 0, .external_lex_state = 17},
  [391] = {.lex_state = 0, .external_lex_state = 17},
  [392] = {.lex_state = 0, .external_lex_state = 20},
  [393] = {.lex_state = 0, .external_lex_state = 17},
  [394] = {.lex_state = 0, .external_lex_state = 25},
  [395] = {.lex_state = 0, .external_lex_state = 25},
  [396] = {.lex_state = 0, .external_lex_state = 19},
  [397] = {.lex_state = 0, .external_lex_state = 25},
  [398] = {.lex_state = 0, .external_lex_state = 19},
  [399] = {.lex_state = 0, .external_lex_state = 17},
  [400] = {.lex_state = 0, .external_lex_state = 19},
  [401] = {.lex_state = 0, .external_lex_state = 25},
  [402] = {.lex_state = 0, .external_lex_state = 24},
  [403] = {.lex_state = 0, .external_lex_state = 25},
  [404] = {.lex_state = 0, .external_lex_state = 20},
  [405] = {.lex_state = 0, .external_lex_state = 25},
  [406] = {.lex_state = 0, .external_lex_state = 20},
  [407] = {.lex_state = 0, .external_lex_state = 19},
  [408] = {.lex_state = 0, .external_lex_state = 25},
  [409] = {.lex_state = 0, .external_lex_state = 18},
  [410] = {.lex_state = 0, .external_lex_state = 19},
  [411] = {.lex_state = 0, .external_lex_state = 19},
  [412] = {.lex_state = 0, .external_lex_state = 20},
  [413] = {.lex_state = 0, .external_lex_state = 24},
  [414] = {.lex_state = 0, .external_lex_state = 21},
  [415] = {.lex_state = 0, .external_lex_state = 24},
  [416] = {.lex_state = 0, .external_lex_state = 26},
  [417] = {.lex_state = 0, .external_lex_state = 26},
  [418] = {.lex_state = 0, .external_lex_state = 24},
  [419] = {.lex_state = 0, .external_lex_state = 24},
  [420] = {.lex_state = 0, .external_lex_state = 27},
  [421] = {.lex_state = 0, .external_lex_state = 27},
  [422] = {.lex_state = 0, .external_lex_state = 27},
  [423] = {.lex_state = 0, .external_lex_state = 27},
  [424] = {.lex_state = 0, .external_lex_state = 24},
  [425] = {.lex_state = 0, .external_lex_state = 27},
  [426] = {.lex_state = 0, .external_lex_state = 27},
  [427] = {.lex_state = 0, .external_lex_state = 27},
  [428] = {.lex_state = 0, .external_lex_state = 27},
  [429] = {.lex_state = 0, .external_lex_state = 24},
  [430] = {.lex_state = 0, .external_lex_state = 27},
  [431] = {.lex_state = 0, .external_lex_state = 27},
  [432] = {.lex_state = 0, .external_lex_state = 27},
  [433] = {.lex_state = 0, .external_lex_state = 27},
  [434] = {.lex_state = 0, .external_lex_state = 28},
  [435] = {.lex_state = 0, .external_lex_state = 26},
  [436] = {.lex_state = 0, .external_lex_state = 28},
  [437] = {.lex_state = 0, .external_lex_state = 28},
  [438] = {.lex_state = 0, .external_lex_state = 28},
  [439] = {.lex_state = 0, .external_lex_state = 28},
  [440] = {.lex_state = 0, .external_lex_state = 28},
  [441] = {.lex_state = 0, .external_lex_state = 28},
  [442] = {.lex_state = 0, .external_lex_state = 28},
  [443] = {.lex_state = 0, .external_lex_state = 24},
  [444] = {.lex_state = 0, .external_lex_state = 28},
  [445] = {.lex_state = 0, .external_lex_state = 28},
  [446] = {.lex_state = 0, .external_lex_state = 24},
  [447] = {.lex_state = 0, .external_lex_state = 28},
  [448] = {.lex_state = 0, .external_lex_state = 24},
  [449] = {.lex_state = 0, .external_lex_state = 24},
  [450] = {.lex_state = 0, .external_lex_state = 28},
  [451] = {.lex_state = 0, .external_lex_state = 24},
  [452] = {.lex_state = 0, .external_lex_state = 26},
  [453] = {.lex_state = 0, .external_lex_state = 24},
  [454] = {.lex_state = 0, .external_lex_state = 24},
  [455] = {.lex_state = 0, .external_lex_state = 24},
  [456] = {.lex_state = 0, .external_lex_state = 24},
  [457] = {.lex_state = 0, .external_lex_state = 24},
  [458] = {.lex_state = 0, .external_lex_state = 24},
  [459] = {.lex_state = 0, .external_lex_state = 24},
  [460] = {.lex_state = 0, .external_lex_state = 26},
  [461] = {.lex_state = 0, .external_lex_state = 24},
  [462] = {.lex_state = 0, .external_lex_state = 24},
  [463] = {.lex_state = 0, .external_lex_state = 24},
  [464] = {.lex_state = 0, .external_lex_state = 26},
  [465] = {.lex_state = 0, .external_lex_state = 24},
  [466] = {.lex_state = 0, .external_lex_state = 26},
  [467] = {.lex_state = 0, .external_lex_state = 26},
  [468] = {.lex_state = 0, .external_lex_state = 24},
  [469] = {.lex_state = 0, .external_lex_state = 24},
  [470] = {.lex_state = 0, .external_lex_state = 26},
  [471] = {.lex_state = 0, .external_lex_state = 26},
  [472] = {.lex_state = 0, .external_lex_state = 24},
  [473] = {.lex_state = 0, .external_lex_state = 26},
  [474] = {.lex_state = 0, .external_lex_state = 24},
  [475] = {.lex_state = 0, .external_lex_state = 26},
  [476] = {.lex_state = 0, .external_lex_state = 5},
  [477] = {.lex_state = 0, .external_lex_state = 4},
  [478] = {.lex_state = 0, .external_lex_state = 5},
  [479] = {.lex_state = 0, .external_lex_state = 3},
  [480] = {.lex_state = 0, .external_lex_state = 4},
  [481] = {.lex_state = 0, .external_lex_state = 5},
  [482] = {.lex_state = 0, .external_lex_state = 4},
  [483] = {.lex_state = 0, .external_lex_state = 4},
  [484] = {.lex_state = 0, .external_lex_state = 5},
  [485] = {.lex_state = 0, .external_lex_state = 4},
  [486] = {.lex_state = 0, .external_lex_state = 4},
  [487] = {.lex_state = 0, .external_lex_state = 3},
  [488] = {.lex_state = 0, .external_lex_state = 3},
  [489] = {.lex_state = 0, .external_lex_state = 3},
  [490] = {.lex_state = 0, .external_lex_state = 4},
  [491] = {.lex_state = 0, .external_lex_state = 5},
  [492] = {.lex_state = 0, .external_lex_state = 3},
  [493] = {.lex_state = 0, .external_lex_state = 5},
  [494] = {.lex_state = 0, .external_lex_state = 5},
  [495] = {.lex_state = 0, .external_lex_state = 3},
  [496] = {.lex_state = 0, .external_lex_state = 3},
  [497] = {.lex_state = 0, .external_lex_state = 5},
  [498] = {.lex_state = 0, .external_lex_state = 3},
  [499] = {.lex_state = 0, .external_lex_state = 4},
  [500] = {.lex_state = 0, .external_lex_state = 4},
  [501] = {.lex_state = 0, .external_lex_state = 8},
  [502] = {.lex_state = 0, .external_lex_state = 5},
  [503] = {.lex_state = 0, .external_lex_state = 8},
  [504] = {.lex_state = 0, .external_lex_state = 8},
  [505] = {.lex_state = 0, .external_lex_state = 8},
  [506] = {.lex_state = 0, .external_lex_state = 4},
  [507] = {.lex_state = 0, .external_lex_state = 5},
  [508] = {.lex_state = 0, .external_lex_state = 3},
  [509] = {.lex_state = 0, .external_lex_state = 3},
  [510] = {.lex_state = 0, .external_lex_state = 3},
  [511] = {.lex_state = 0, .external_lex_state = 3},
  [512] = {.lex_state = 0, .external_lex_state = 3},
  [513] = {.lex_state = 0, .external_lex_state = 3},
  [514] = {.lex_state = 0, .external_lex_state = 3},
  [515] = {.lex_state = 0, .external_lex_state = 3},
  [516] = {.lex_state = 0, .external_lex_state = 3},
  [517] = {.lex_state = 0, .external_lex_state = 3},
  [518] = {.lex_state = 0, .external_lex_state = 3},
  [519] = {.lex_state = 0, .external_lex_state = 3},
  [520] = {.lex_state = 0, .external_lex_state = 3},
  [521] = {.lex_state = 0, .external_lex_state = 3},
  [522] = {.lex_state = 0, .external_lex_state = 4},
  [523] = {.lex_state = 0, .external_lex_state = 3},
  [524] = {.lex_state = 0, .external_lex_state = 3},
  [525] = {.lex_state = 0, .external_lex_state = 3},
  [526] = {.lex_state = 0, .external_lex_state = 3},
  [527] = {.lex_state = 0, .external_lex_state = 3},
  [528] = {.lex_state = 0, .external_lex_state = 3},
  [529] = {.lex_state = 0, .external_lex_state = 3},
  [530] = {.lex_state = 0, .external_lex_state = 3},
  [531] = {.lex_state = 0, .external_lex_state = 3},
  [532] = {.lex_state = 0, .external_lex_state = 9},
  [533] = {.lex_state = 0, .external_lex_state = 3},
  [534] = {.lex_state = 0, .external_lex_state = 3},
  [535] = {.lex_state = 0, .external_lex_state = 3},
  [536] = {.lex_state = 0, .external_lex_state = 3},
  [537] = {.lex_state = 0, .external_lex_state = 9},
  [538] = {.lex_state = 0, .external_lex_state = 9},
  [539] = {.lex_state = 0, .external_lex_state = 3},
  [540] = {.lex_state = 0, .external_lex_state = 3},
  [541] = {.lex_state = 0, .external_lex_state = 3},
  [542] = {.lex_state = 0, .external_lex_state = 9},
  [543] = {.lex_state = 0, .external_lex_state = 3},
  [544] = {.lex_state = 0, .external_lex_state = 3},
  [545] = {.lex_state = 0, .external_lex_state = 3},
  [546] = {.lex_state = 0, .external_lex_state = 3},
  [547] = {.lex_state = 0, .external_lex_state = 3},
  [548] = {.lex_state = 0, .external_lex_state = 3},
  [549] = {.lex_state = 0, .external_lex_state = 3},
  [550] = {.lex_state = 0, .external_lex_state = 3},
  [551] = {.lex_state = 0, .external_lex_state = 3},
  [552] = {.lex_state = 0, .external_lex_state = 3},
  [553] = {.lex_state = 0, .external_lex_state = 3},
  [554] = {.lex_state = 0, .external_lex_state = 3},
  [555] = {.lex_state = 0, .external_lex_state = 3},
  [556] = {.lex_state = 0, .external_lex_state = 3},
  [557] = {.lex_state = 0, .external_lex_state = 3},
  [558] = {.lex_state = 0, .external_lex_state = 3},
  [559] = {.lex_state = 0, .external_lex_state = 3},
  [560] = {.lex_state = 0, .external_lex_state = 3},
  [561] = {.lex_state = 0, .external_lex_state = 3},
  [562] = {.lex_state = 0, .external_lex_state = 3},
  [563] = {.lex_state = 0, .external_lex_state = 4},
  [564] = {.lex_state = 0, .external_lex_state = 4},
  [565] = {.lex_state = 0, .external_lex_state = 4},
  [566] = {.lex_state = 0, .external_lex_state = 4},
  [567] = {.lex_state = 0, .external_lex_state = 4},
  [568] = {.lex_state = 0, .external_lex_state = 4},
  [569] = {.lex_state = 0, .external_lex_state = 4},
  [570] = {.lex_state = 0, .external_lex_state = 4},
  [571] = {.lex_state = 0, .external_lex_state = 4},
  [572] = {.lex_state = 0, .external_lex_state = 4},
  [573] = {.lex_state = 0, .external_lex_state = 4},
  [574] = {.lex_state = 0, .external_lex_state = 4},
  [575] = {.lex_state = 0, .external_lex_state = 3},
  [576] = {.lex_state = 0, .external_lex_state = 4},
  [577] = {.lex_state = 0, .external_lex_state = 4},
  [578] = {.lex_state = 0, .external_lex_state = 4},
  [579] = {.lex_state = 0, .external_lex_state = 4},
  [580] = {.lex_state = 0, .external_lex_state = 4},
  [581] = {.lex_state = 0, .external_lex_state = 4},
  [582] = {.lex_state = 0, .external_lex_state = 4},
  [583] = {.lex_state = 0, .external_lex_state = 4},
  [584] = {.lex_state = 0, .external_lex_state = 4},
  [585] = {.lex_state = 0, .external_lex_state = 4},
  [586] = {.lex_state = 0, .external_lex_state = 4},
  [587] = {.lex_state = 0, .external_lex_state = 4},
  [588] = {.lex_state = 0, .external_lex_state = 4},
  [589] = {.lex_state = 0, .external_lex_state = 4},
  [590] = {.lex_state = 0, .external_lex_state = 4},
  [591] = {.lex_state = 0, .external_lex_state = 4},
  [592] = {.lex_state = 0, .external_lex_state = 4},
  [593] = {.lex_state = 0, .external_lex_state = 4},
  [594] = {.lex_state = 0, .external_lex_state = 4},
  [595] = {.lex_state = 0, .external_lex_state = 4},
  [596] = {.lex_state = 0, .external_lex_state = 4},
  [597] = {.lex_state = 0, .external_lex_state = 4},
  [598] = {.lex_state = 0, .external_lex_state = 4},
  [599] = {.lex_state = 0, .external_lex_state = 3},
  [600] = {.lex_state = 0, .external_lex_state = 4},
  [601] = {.lex_state = 0, .external_lex_state = 4},
  [602] = {.lex_state = 0, .external_lex_state = 4},
  [603] = {.lex_state = 0, .external_lex_state = 4},
  [604] = {.lex_state = 0, .external_lex_state = 8},
  [605] = {.lex_state = 0, .external_lex_state = 4},
  [606] = {.lex_state = 0, .external_lex_state = 4},
  [607] = {.lex_state = 0, .external_lex_state = 4},
  [608] = {.lex_state = 0, .external_lex_state = 4},
  [609] = {.lex_state = 0, .external_lex_state = 4},
  [610] = {.lex_state = 0, .external_lex_state = 4},
  [611] = {.lex_state = 0, .external_lex_state = 4},
  [612] = {.lex_state = 0, .external_lex_state = 4},
  [613] = {.lex_state = 0, .external_lex_state = 4},
  [614] = {.lex_state = 0, .external_lex_state = 4},
  [615] = {.lex_state = 0, .external_lex_state = 5},
  [616] = {.lex_state = 0, .external_lex_state = 5},
  [617] = {.lex_state = 0, .external_lex_state = 5},
  [618] = {.lex_state = 0, .external_lex_state = 5},
  [619] = {.lex_state = 0, .external_lex_state = 5},
  [620] = {.lex_state = 0, .external_lex_state = 5},
  [621] = {.lex_state = 0, .external_lex_state = 5},
  [622] = {.lex_state = 0, .external_lex_state = 5},
  [623] = {.lex_state = 0, .external_lex_state = 5},
  [624] = {.lex_state = 0, .external_lex_state = 5},
  [625] = {.lex_state = 0, .external_lex_state = 5},
  [626] = {.lex_state = 0, .external_lex_state = 5},
  [627] = {.lex_state = 0, .external_lex_state = 5},
  [628] = {.lex_state = 0, .external_lex_state = 5},
  [629] = {.lex_state = 0, .external_lex_state = 5},
  [630] = {.lex_state = 0, .external_lex_state = 5},
  [631] = {.lex_state = 0, .external_lex_state = 5},
  [632] = {.lex_state = 0, .external_lex_state = 5},
  [633] = {.lex_state = 0, .external_lex_state = 5},
  [634] = {.lex_state = 0, .external_lex_state = 5},
  [635] = {.lex_state = 0, .external_lex_state = 5},
  [636] = {.lex_state = 0, .external_lex_state = 5},
  [637] = {.lex_state = 0, .external_lex_state = 5},
  [638] = {.lex_state = 0, .external_lex_state = 5},
  [639] = {.lex_state = 0, .external_lex_state = 5},
  [640] = {.lex_state = 0, .external_lex_state = 5},
  [641] = {.lex_state = 0, .external_lex_state = 5},
  [642] = {.lex_state = 0, .external_lex_state = 5},
  [643] = {.lex_state = 0, .external_lex_state = 5},
  [644] = {.lex_state = 0, .external_lex_state = 5},
  [645] = {.lex_state = 0, .external_lex_state = 5},
  [646] = {.lex_state = 0, .external_lex_state = 5},
  [647] = {.lex_state = 0, .external_lex_state = 5},
  [648] = {.lex_state = 0, .external_lex_state = 5},
  [649] = {.lex_state = 0, .external_lex_state = 5},
  [650] = {.lex_state = 0, .external_lex_state = 5},
  [651] = {.lex_state = 0, .external_lex_state = 5},
  [652] = {.lex_state = 0, .external_lex_state = 5},
  [653] = {.lex_state = 0, .external_lex_state = 5},
  [654] = {.lex_state = 0, .external_lex_state = 5},
  [655] = {.lex_state = 0, .external_lex_state = 5},
  [656] = {.lex_state = 0, .external_lex_state = 5},
  [657] = {.lex_state = 0, .external_lex_state = 5},
  [658] = {.lex_state = 0, .external_lex_state = 5},
  [659] = {.lex_state = 0, .external_lex_state = 5},
  [660] = {.lex_state = 0, .external_lex_state = 5},
  [661] = {.lex_state = 0, .external_lex_state = 5},
  [662] = {.lex_state = 0, .external_lex_state = 5},
  [663] = {.lex_state = 0, .external_lex_state = 5},
  [664] = {.lex_state = 0, .external_lex_state = 5},
  [665] = {.lex_state = 0, .external_lex_state = 9},
  [666] = {.lex_state = 0, .external_lex_state = 9},
  [667] = {.lex_state = 0, .external_lex_state = 9},
  [668] = {.lex_state = 0, .external_lex_state = 9},
  [669] = {.lex_state = 0, .external_lex_state = 8},
  [670] = {.lex_state = 0, .external_lex_state = 8},
  [671] = {.lex_state = 0, .external_lex_state = 8},
  [672] = {.lex_state = 0, .external_lex_state = 7},
  [673] = {.lex_state = 0, .external_lex_state = 8},
  [674] = {.lex_state = 0, .external_lex_state = 10},
  [675] = {.lex_state = 0, .external_lex_state = 10},
  [676] = {.lex_state = 0, .external_lex_state = 10},
  [677] = {.lex_state = 0, .external_lex_state = 10},
  [678] = {.lex_state = 0, .external_lex_state = 10},
  [679] = {.lex_state = 0, .external_lex_state = 6},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 0, .external_lex_state = 6},
  [682] = {.lex_state = 0, .external_lex_state = 6},
  [683] = {.lex_state = 0, .external_lex_state = 6},
  [684] = {.lex_state = 0, .external_lex_state = 6},
  [685] = {.lex_state = 0, .external_lex_state = 6},
  [686] = {.lex_state = 0, .external_lex_state = 6},
  [687] = {.lex_state = 0, .external_lex_state = 6},
  [688] = {.lex_state = 0, .external_lex_state = 10},
  [689] = {.lex_state = 0, .external_lex_state = 6},
  [690] = {.lex_state = 0, .external_lex_state = 6},
  [691] = {.lex_state = 0, .external_lex_state = 10},
  [692] = {.lex_state = 0, .external_lex_state = 10},
  [693] = {.lex_state = 0, .external_lex_state = 10},
  [694] = {.lex_state = 0, .external_lex_state = 10},
  [695] = {.lex_state = 0, .external_lex_state = 6},
  [696] = {.lex_state = 0, .external_lex_state = 10},
  [697] = {.lex_state = 0, .external_lex_state = 10},
  [698] = {.lex_state = 0, .external_lex_state = 10},
  [699] = {.lex_state = 0, .external_lex_state = 6},
  [700] = {.lex_state = 0, .external_lex_state = 6},
  [701] = {.lex_state = 0, .external_lex_state = 6},
  [702] = {.lex_state = 0, .external_lex_state = 6},
  [703] = {.lex_state = 0, .external_lex_state = 6},
  [704] = {.lex_state = 0, .external_lex_state = 6},
  [705] = {.lex_state = 0, .external_lex_state = 6},
  [706] = {.lex_state = 0, .external_lex_state = 6},
  [707] = {.lex_state = 0, .external_lex_state = 6},
  [708] = {.lex_state = 0, .external_lex_state = 6},
  [709] = {.lex_state = 0, .external_lex_state = 6},
  [710] = {.lex_state = 0, .external_lex_state = 6},
  [711] = {.lex_state = 0, .external_lex_state = 6},
  [712] = {.lex_state = 0, .external_lex_state = 10},
  [713] = {.lex_state = 0, .external_lex_state = 6},
  [714] = {.lex_state = 0, .external_lex_state = 10},
  [715] = {.lex_state = 0, .external_lex_state = 10},
  [716] = {.lex_state = 0, .external_lex_state = 10},
  [717] = {.lex_state = 0, .external_lex_state = 10},
  [718] = {.lex_state = 0, .external_lex_state = 10},
  [719] = {.lex_state = 0, .external_lex_state = 10},
  [720] = {.lex_state = 0, .external_lex_state = 10},
  [721] = {.lex_state = 0, .external_lex_state = 10},
  [722] = {.lex_state = 0, .external_lex_state = 10},
  [723] = {.lex_state = 0, .external_lex_state = 6},
  [724] = {.lex_state = 0, .external_lex_state = 10},
  [725] = {.lex_state = 0, .external_lex_state = 6},
  [726] = {.lex_state = 0, .external_lex_state = 6},
  [727] = {.lex_state = 0, .external_lex_state = 6},
  [728] = {.lex_state = 0, .external_lex_state = 6},
  [729] = {.lex_state = 0, .external_lex_state = 10},
  [730] = {.lex_state = 0, .external_lex_state = 6},
  [731] = {.lex_state = 0, .external_lex_state = 10},
  [732] = {.lex_state = 0, .external_lex_state = 6},
  [733] = {.lex_state = 0, .external_lex_state = 10},
  [734] = {.lex_state = 0, .external_lex_state = 6},
  [735] = {.lex_state = 0, .external_lex_state = 10},
  [736] = {.lex_state = 0, .external_lex_state = 6},
  [737] = {.lex_state = 0, .external_lex_state = 10},
  [738] = {.lex_state = 0, .external_lex_state = 6},
  [739] = {.lex_state = 0, .external_lex_state = 10},
  [740] = {.lex_state = 0, .external_lex_state = 6},
  [741] = {.lex_state = 0, .external_lex_state = 10},
  [742] = {.lex_state = 0, .external_lex_state = 6},
  [743] = {.lex_state = 0, .external_lex_state = 10},
  [744] = {.lex_state = 0, .external_lex_state = 6},
  [745] = {.lex_state = 0, .external_lex_state = 6},
  [746] = {.lex_state = 0, .external_lex_state = 6},
  [747] = {.lex_state = 0, .external_lex_state = 6},
  [748] = {.lex_state = 0, .external_lex_state = 6},
  [749] = {.lex_state = 0, .external_lex_state = 6},
  [750] = {.lex_state = 0, .external_lex_state = 10},
  [751] = {.lex_state = 0, .external_lex_state = 10},
  [752] = {.lex_state = 0, .external_lex_state = 10},
  [753] = {.lex_state = 0, .external_lex_state = 6},
  [754] = {.lex_state = 0, .external_lex_state = 10},
  [755] = {.lex_state = 0, .external_lex_state = 10},
  [756] = {.lex_state = 0, .external_lex_state = 10},
  [757] = {.lex_state = 0, .external_lex_state = 10},
  [758] = {.lex_state = 0, .external_lex_state = 10},
  [759] = {.lex_state = 0, .external_lex_state = 10},
  [760] = {.lex_state = 0, .external_lex_state = 10},
  [761] = {.lex_state = 0, .external_lex_state = 10},
  [762] = {.lex_state = 0, .external_lex_state = 10},
  [763] = {.lex_state = 0, .external_lex_state = 10},
  [764] = {.lex_state = 0, .external_lex_state = 10},
  [765] = {.lex_state = 0, .external_lex_state = 10},
  [766] = {.lex_state = 0, .external_lex_state = 10},
  [767] = {.lex_state = 0, .external_lex_state = 10},
  [768] = {.lex_state = 0, .external_lex_state = 10},
  [769] = {.lex_state = 0, .external_lex_state = 6},
  [770] = {.lex_state = 0, .external_lex_state = 6},
  [771] = {.lex_state = 0, .external_lex_state = 6},
  [772] = {.lex_state = 0, .external_lex_state = 6},
  [773] = {.lex_state = 0, .external_lex_state = 6},
  [774] = {.lex_state = 0, .external_lex_state = 6},
  [775] = {.lex_state = 0, .external_lex_state = 13},
  [776] = {.lex_state = 0, .external_lex_state = 13},
  [777] = {.lex_state = 0, .external_lex_state = 13},
  [778] = {.lex_state = 0, .external_lex_state = 3},
  [779] = {.lex_state = 0, .external_lex_state = 13},
  [780] = {.lex_state = 0, .external_lex_state = 3},
  [781] = {.lex_state = 0, .external_lex_state = 16},
  [782] = {.lex_state = 0, .external_lex_state = 16},
  [783] = {.lex_state = 0, .external_lex_state = 16},
  [784] = {.lex_state = 0, .external_lex_state = 16},
  [785] = {.lex_state = 0, .external_lex_state = 14},
  [786] = {.lex_state = 0, .external_lex_state = 14},
  [787] = {.lex_state = 0, .external_lex_state = 14},
  [788] = {.lex_state = 0, .external_lex_state = 14},
  [789] = {.lex_state = 0, .external_lex_state = 8},
  [790] = {.lex_state = 0, .external_lex_state = 7},
  [791] = {.lex_state = 0, .external_lex_state = 7},
  [792] = {.lex_state = 0, .external_lex_state = 11},
  [793] = {.lex_state = 0, .external_lex_state = 11},
  [794] = {.lex_state = 0, .external_lex_state = 11},
  [795] = {.lex_state = 0, .external_lex_state = 11},
  [796] = {.lex_state = 0, .external_lex_state = 9},
  [797] = {.lex_state = 0, .external_lex_state = 9},
  [798] = {.lex_state = 0, .external_lex_state = 9},
  [799] = {.lex_state = 0, .external_lex_state = 9},
  [800] = {.lex_state = 0, .external_lex_state = 9},
  [801] = {.lex_state = 0, .external_lex_state = 9},
  [802] = {.lex_state = 0, .external_lex_state = 9},
  [803] = {.lex_state = 0, .external_lex_state = 16},
  [804] = {.lex_state = 0, .external_lex_state = 9},
  [805] = {.lex_state = 0, .external_lex_state = 16},
  [806] = {.lex_state = 0, .external_lex_state = 9},
  [807] = {.lex_state = 0, .external_lex_state = 16},
  [808] = {.lex_state = 0, .external_lex_state = 9},
  [809] = {.lex_state = 0, .external_lex_state = 16},
  [810] = {.lex_state = 0, .external_lex_state = 9},
  [811] = {.lex_state = 0, .external_lex_state = 9},
  [812] = {.lex_state = 0, .external_lex_state = 7},
  [813] = {.lex_state = 0, .external_lex_state = 7},
  [814] = {.lex_state = 0, .external_lex_state = 9},
  [815] = {.lex_state = 0, .external_lex_state = 7},
  [816] = {.lex_state = 0, .external_lex_state = 9},
  [817] = {.lex_state = 0, .external_lex_state = 9},
  [818] = {.lex_state = 0, .external_lex_state = 11},
  [819] = {.lex_state = 0, .external_lex_state = 11},
  [820] = {.lex_state = 0, .external_lex_state = 11},
  [821] = {.lex_state = 0, .external_lex_state = 11},
  [822] = {.lex_state = 0, .external_lex_state = 7},
  [823] = {.lex_state = 0, .external_lex_state = 7},
  [824] = {.lex_state = 0, .external_lex_state = 7},
  [825] = {.lex_state = 0, .external_lex_state = 9},
  [826] = {.lex_state = 0, .external_lex_state = 9},
  [827] = {.lex_state = 0, .external_lex_state = 7},
  [828] = {.lex_state = 0, .external_lex_state = 9},
  [829] = {.lex_state = 0, .external_lex_state = 9},
  [830] = {.lex_state = 0, .external_lex_state = 9},
  [831] = {.lex_state = 0, .external_lex_state = 7},
  [832] = {.lex_state = 0, .external_lex_state = 9},
  [833] = {.lex_state = 0, .external_lex_state = 7},
  [834] = {.lex_state = 0, .external_lex_state = 7},
  [835] = {.lex_state = 0, .external_lex_state = 9},
  [836] = {.lex_state = 0, .external_lex_state = 9},
  [837] = {.lex_state = 0, .external_lex_state = 9},
  [838] = {.lex_state = 0, .external_lex_state = 9},
  [839] = {.lex_state = 0, .external_lex_state = 7},
  [840] = {.lex_state = 0, .external_lex_state = 9},
  [841] = {.lex_state = 0, .external_lex_state = 9},
  [842] = {.lex_state = 0, .external_lex_state = 9},
  [843] = {.lex_state = 0, .external_lex_state = 9},
  [844] = {.lex_state = 0, .external_lex_state = 9},
  [845] = {.lex_state = 0, .external_lex_state = 7},
  [846] = {.lex_state = 0, .external_lex_state = 7},
  [847] = {.lex_state = 0, .external_lex_state = 7},
  [848] = {.lex_state = 0, .external_lex_state = 7},
  [849] = {.lex_state = 0, .external_lex_state = 7},
  [850] = {.lex_state = 0, .external_lex_state = 7},
  [851] = {.lex_state = 0, .external_lex_state = 7},
  [852] = {.lex_state = 0, .external_lex_state = 7},
  [853] = {.lex_state = 0, .external_lex_state = 7},
  [854] = {.lex_state = 0, .external_lex_state = 7},
  [855] = {.lex_state = 0, .external_lex_state = 7},
  [856] = {.lex_state = 0, .external_lex_state = 14},
  [857] = {.lex_state = 0, .external_lex_state = 7},
  [858] = {.lex_state = 0, .external_lex_state = 7},
  [859] = {.lex_state = 0, .external_lex_state = 14},
  [860] = {.lex_state = 0, .external_lex_state = 14},
  [861] = {.lex_state = 0, .external_lex_state = 9},
  [862] = {.lex_state = 0, .external_lex_state = 9},
  [863] = {.lex_state = 0, .external_lex_state = 7},
  [864] = {.lex_state = 0, .external_lex_state = 14},
  [865] = {.lex_state = 0, .external_lex_state = 9},
  [866] = {.lex_state = 0, .external_lex_state = 9},
  [867] = {.lex_state = 0, .external_lex_state = 9},
  [868] = {.lex_state = 0, .external_lex_state = 9},
  [869] = {.lex_state = 0, .external_lex_state = 9},
  [870] = {.lex_state = 0, .external_lex_state = 13},
  [871] = {.lex_state = 0, .external_lex_state = 13},
  [872] = {.lex_state = 0, .external_lex_state = 13},
  [873] = {.lex_state = 0, .external_lex_state = 13},
  [874] = {.lex_state = 0, .external_lex_state = 9},
  [875] = {.lex_state = 0, .external_lex_state = 9},
  [876] = {.lex_state = 0, .external_lex_state = 9},
  [877] = {.lex_state = 0, .external_lex_state = 9},
  [878] = {.lex_state = 0, .external_lex_state = 9},
  [879] = {.lex_state = 0, .external_lex_state = 7},
  [880] = {.lex_state = 0, .external_lex_state = 7},
  [881] = {.lex_state = 0, .external_lex_state = 9},
  [882] = {.lex_state = 0, .external_lex_state = 7},
  [883] = {.lex_state = 0, .external_lex_state = 9},
  [884] = {.lex_state = 0, .external_lex_state = 7},
  [885] = {.lex_state = 0, .external_lex_state = 7},
  [886] = {.lex_state = 0, .external_lex_state = 9},
  [887] = {.lex_state = 0, .external_lex_state = 7},
  [888] = {.lex_state = 0, .external_lex_state = 9},
  [889] = {.lex_state = 0, .external_lex_state = 7},
  [890] = {.lex_state = 0, .external_lex_state = 9},
  [891] = {.lex_state = 0, .external_lex_state = 7},
  [892] = {.lex_state = 0, .external_lex_state = 9},
  [893] = {.lex_state = 0, .external_lex_state = 7},
  [894] = {.lex_state = 0, .external_lex_state = 9},
  [895] = {.lex_state = 0, .external_lex_state = 7},
  [896] = {.lex_state = 0, .external_lex_state = 9},
  [897] = {.lex_state = 0, .external_lex_state = 7},
  [898] = {.lex_state = 0, .external_lex_state = 9},
  [899] = {.lex_state = 0, .external_lex_state = 7},
  [900] = {.lex_state = 0, .external_lex_state = 7},
  [901] = {.lex_state = 0, .external_lex_state = 7},
  [902] = {.lex_state = 0, .external_lex_state = 7},
  [903] = {.lex_state = 0, .external_lex_state = 5},
  [904] = {.lex_state = 0, .external_lex_state = 7},
  [905] = {.lex_state = 0, .external_lex_state = 7},
  [906] = {.lex_state = 0, .external_lex_state = 7},
  [907] = {.lex_state = 0, .external_lex_state = 7},
  [908] = {.lex_state = 0, .external_lex_state = 7},
  [909] = {.lex_state = 0, .external_lex_state = 7},
  [910] = {.lex_state = 0, .external_lex_state = 7},
  [911] = {.lex_state = 0, .external_lex_state = 7},
  [912] = {.lex_state = 0, .external_lex_state = 7},
  [913] = {.lex_state = 0, .external_lex_state = 8},
  [914] = {.lex_state = 0, .external_lex_state = 8},
  [915] = {.lex_state = 0, .external_lex_state = 8},
  [916] = {.lex_state = 0, .external_lex_state = 8},
  [917] = {.lex_state = 0, .external_lex_state = 6},
  [918] = {.lex_state = 0, .external_lex_state = 8},
  [919] = {.lex_state = 0, .external_lex_state = 8},
  [920] = {.lex_state = 0, .external_lex_state = 5},
  [921] = {.lex_state = 0, .external_lex_state = 10},
  [922] = {.lex_state = 0, .external_lex_state = 8},
  [923] = {.lex_state = 0, .external_lex_state = 8},
  [924] = {.lex_state = 0, .external_lex_state = 8},
  [925] = {.lex_state = 0, .external_lex_state = 8},
  [926] = {.lex_state = 0, .external_lex_state = 8},
  [927] = {.lex_state = 0, .external_lex_state = 8},
  [928] = {.lex_state = 0, .external_lex_state = 8},
  [929] = {.lex_state = 0, .external_lex_state = 8},
  [930] = {.lex_state = 0, .external_lex_state = 8},
  [931] = {.lex_state = 0, .external_lex_state = 8},
  [932] = {.lex_state = 0, .external_lex_state = 8},
  [933] = {.lex_state = 0, .external_lex_state = 8},
  [934] = {.lex_state = 0, .external_lex_state = 8},
  [935] = {.lex_state = 0, .external_lex_state = 10},
  [936] = {.lex_state = 0, .external_lex_state = 8},
  [937] = {.lex_state = 0, .external_lex_state = 8},
  [938] = {.lex_state = 0, .external_lex_state = 8},
  [939] = {.lex_state = 0, .external_lex_state = 8},
  [940] = {.lex_state = 0, .external_lex_state = 8},
  [941] = {.lex_state = 0, .external_lex_state = 8},
  [942] = {.lex_state = 0, .external_lex_state = 8},
  [943] = {.lex_state = 0, .external_lex_state = 8},
  [944] = {.lex_state = 0, .external_lex_state = 8},
  [945] = {.lex_state = 0, .external_lex_state = 8},
  [946] = {.lex_state = 0, .external_lex_state = 8},
  [947] = {.lex_state = 0, .external_lex_state = 8},
  [948] = {.lex_state = 0, .external_lex_state = 8},
  [949] = {.lex_state = 0, .external_lex_state = 4},
  [950] = {.lex_state = 0, .external_lex_state = 4},
  [951] = {.lex_state = 0, .external_lex_state = 8},
  [952] = {.lex_state = 0, .external_lex_state = 8},
  [953] = {.lex_state = 0, .external_lex_state = 8},
  [954] = {.lex_state = 0, .external_lex_state = 8},
  [955] = {.lex_state = 0, .external_lex_state = 8},
  [956] = {.lex_state = 0, .external_lex_state = 8},
  [957] = {.lex_state = 0, .external_lex_state = 8},
  [958] = {.lex_state = 0, .external_lex_state = 8},
  [959] = {.lex_state = 0, .external_lex_state = 8},
  [960] = {.lex_state = 0, .external_lex_state = 8},
  [961] = {.lex_state = 0, .external_lex_state = 8},
  [962] = {.lex_state = 0, .external_lex_state = 8},
  [963] = {.lex_state = 0, .external_lex_state = 8},
  [964] = {.lex_state = 0, .external_lex_state = 8},
  [965] = {.lex_state = 0, .external_lex_state = 8},
  [966] = {.lex_state = 0, .external_lex_state = 8},
  [967] = {.lex_state = 0, .external_lex_state = 8},
  [968] = {.lex_state = 0, .external_lex_state = 3},
  [969] = {.lex_state = 0, .external_lex_state = 11},
  [970] = {.lex_state = 0, .external_lex_state = 12},
  [971] = {.lex_state = 0, .external_lex_state = 10},
  [972] = {.lex_state = 0, .external_lex_state = 6},
  [973] = {.lex_state = 0, .external_lex_state = 10},
  [974] = {.lex_state = 0, .external_lex_state = 6},
  [975] = {.lex_state = 0, .external_lex_state = 13},
  [976] = {.lex_state = 0, .external_lex_state = 13},
  [977] = {.lex_state = 0, .external_lex_state = 13},
  [978] = {.lex_state = 0, .external_lex_state = 13},
  [979] = {.lex_state = 0, .external_lex_state = 13},
  [980] = {.lex_state = 0, .external_lex_state = 13},
  [981] = {.lex_state = 0, .external_lex_state = 13},
  [982] = {.lex_state = 0, .external_lex_state = 13},
  [983] = {.lex_state = 0, .external_lex_state = 13},
  [984] = {.lex_state = 0, .external_lex_state = 13},
  [985] = {.lex_state = 0, .external_lex_state = 13},
  [986] = {.lex_state = 0, .external_lex_state = 13},
  [987] = {.lex_state = 0, .external_lex_state = 13},
  [988] = {.lex_state = 0, .external_lex_state = 13},
  [989] = {.lex_state = 0, .external_lex_state = 13},
  [990] = {.lex_state = 0, .external_lex_state = 13},
  [991] = {.lex_state = 0, .external_lex_state = 25},
  [992] = {.lex_state = 0, .external_lex_state = 13},
  [993] = {.lex_state = 0, .external_lex_state = 4},
  [994] = {.lex_state = 0, .external_lex_state = 22},
  [995] = {.lex_state = 0, .external_lex_state = 13},
  [996] = {.lex_state = 0, .external_lex_state = 13},
  [997] = {.lex_state = 0, .external_lex_state = 13},
  [998] = {.lex_state = 0, .external_lex_state = 13},
  [999] = {.lex_state = 0, .external_lex_state = 22},
  [1000] = {.lex_state = 0, .external_lex_state = 22},
  [1001] = {.lex_state = 0, .external_lex_state = 25},
  [1002] = {.lex_state = 0, .external_lex_state = 13},
  [1003] = {.lex_state = 0, .external_lex_state = 13},
  [1004] = {.lex_state = 0, .external_lex_state = 25},
  [1005] = {.lex_state = 0, .external_lex_state = 13},
  [1006] = {.lex_state = 0, .external_lex_state = 13},
  [1007] = {.lex_state = 0, .external_lex_state = 13},
  [1008] = {.lex_state = 0, .external_lex_state = 22},
  [1009] = {.lex_state = 0, .external_lex_state = 13},
  [1010] = {.lex_state = 0, .external_lex_state = 13},
  [1011] = {.lex_state = 0, .external_lex_state = 13},
  [1012] = {.lex_state = 0, .external_lex_state = 13},
  [1013] = {.lex_state = 0, .external_lex_state = 13},
  [1014] = {.lex_state = 0, .external_lex_state = 13},
  [1015] = {.lex_state = 0, .external_lex_state = 13},
  [1016] = {.lex_state = 0, .external_lex_state = 13},
  [1017] = {.lex_state = 0, .external_lex_state = 13},
  [1018] = {.lex_state = 0, .external_lex_state = 13},
  [1019] = {.lex_state = 0, .external_lex_state = 13},
  [1020] = {.lex_state = 0, .external_lex_state = 13},
  [1021] = {.lex_state = 0, .external_lex_state = 13},
  [1022] = {.lex_state = 0, .external_lex_state = 13},
  [1023] = {.lex_state = 0, .external_lex_state = 13},
  [1024] = {.lex_state = 0, .external_lex_state = 13},
  [1025] = {.lex_state = 0, .external_lex_state = 13},
  [1026] = {.lex_state = 0, .external_lex_state = 13},
  [1027] = {.lex_state = 0, .external_lex_state = 13},
  [1028] = {.lex_state = 0, .external_lex_state = 13},
  [1029] = {.lex_state = 0, .external_lex_state = 13},
  [1030] = {.lex_state = 0, .external_lex_state = 25},
  [1031] = {.lex_state = 0, .external_lex_state = 13},
  [1032] = {.lex_state = 0, .external_lex_state = 13},
  [1033] = {.lex_state = 0, .external_lex_state = 13},
  [1034] = {.lex_state = 0, .external_lex_state = 14},
  [1035] = {.lex_state = 0, .external_lex_state = 14},
  [1036] = {.lex_state = 0, .external_lex_state = 14},
  [1037] = {.lex_state = 0, .external_lex_state = 14},
  [1038] = {.lex_state = 0, .external_lex_state = 14},
  [1039] = {.lex_state = 0, .external_lex_state = 14},
  [1040] = {.lex_state = 0, .external_lex_state = 14},
  [1041] = {.lex_state = 0, .external_lex_state = 14},
  [1042] = {.lex_state = 0, .external_lex_state = 14},
  [1043] = {.lex_state = 0, .external_lex_state = 14},
  [1044] = {.lex_state = 0, .external_lex_state = 14},
  [1045] = {.lex_state = 0, .external_lex_state = 14},
  [1046] = {.lex_state = 0, .external_lex_state = 14},
  [1047] = {.lex_state = 0, .external_lex_state = 14},
  [1048] = {.lex_state = 0, .external_lex_state = 14},
  [1049] = {.lex_state = 0, .external_lex_state = 14},
  [1050] = {.lex_state = 0, .external_lex_state = 14},
  [1051] = {.lex_state = 0, .external_lex_state = 14},
  [1052] = {.lex_state = 0, .external_lex_state = 14},
  [1053] = {.lex_state = 0, .external_lex_state = 14},
  [1054] = {.lex_state = 0, .external_lex_state = 14},
  [1055] = {.lex_state = 0, .external_lex_state = 14},
  [1056] = {.lex_state = 0, .external_lex_state = 14},
  [1057] = {.lex_state = 0, .external_lex_state = 14},
  [1058] = {.lex_state = 0, .external_lex_state = 14},
  [1059] = {.lex_state = 0, .external_lex_state = 14},
  [1060] = {.lex_state = 0, .external_lex_state = 14},
  [1061] = {.lex_state = 0, .external_lex_state = 8},
  [1062] = {.lex_state = 0, .external_lex_state = 14},
  [1063] = {.lex_state = 0, .external_lex_state = 14},
  [1064] = {.lex_state = 0, .external_lex_state = 14},
  [1065] = {.lex_state = 0, .external_lex_state = 14},
  [1066] = {.lex_state = 0, .external_lex_state = 14},
  [1067] = {.lex_state = 0, .external_lex_state = 14},
  [1068] = {.lex_state = 0, .external_lex_state = 15},
  [1069] = {.lex_state = 0, .external_lex_state = 15},
  [1070] = {.lex_state = 0, .external_lex_state = 15},
  [1071] = {.lex_state = 0, .external_lex_state = 15},
  [1072] = {.lex_state = 0, .external_lex_state = 14},
  [1073] = {.lex_state = 0, .external_lex_state = 14},
  [1074] = {.lex_state = 0, .external_lex_state = 15},
  [1075] = {.lex_state = 0, .external_lex_state = 15},
  [1076] = {.lex_state = 0, .external_lex_state = 15},
  [1077] = {.lex_state = 0, .external_lex_state = 14},
  [1078] = {.lex_state = 0, .external_lex_state = 14},
  [1079] = {.lex_state = 0, .external_lex_state = 15},
  [1080] = {.lex_state = 0, .external_lex_state = 14},
  [1081] = {.lex_state = 0, .external_lex_state = 14},
  [1082] = {.lex_state = 0, .external_lex_state = 14},
  [1083] = {.lex_state = 0, .external_lex_state = 15},
  [1084] = {.lex_state = 0, .external_lex_state = 14},
  [1085] = {.lex_state = 0, .external_lex_state = 15},
  [1086] = {.lex_state = 0, .external_lex_state = 15},
  [1087] = {.lex_state = 0, .external_lex_state = 14},
  [1088] = {.lex_state = 0, .external_lex_state = 14},
  [1089] = {.lex_state = 0, .external_lex_state = 14},
  [1090] = {.lex_state = 0, .external_lex_state = 14},
  [1091] = {.lex_state = 0, .external_lex_state = 14},
  [1092] = {.lex_state = 0, .external_lex_state = 15},
  [1093] = {.lex_state = 0, .external_lex_state = 14},
  [1094] = {.lex_state = 0, .external_lex_state = 14},
  [1095] = {.lex_state = 0, .external_lex_state = 14},
  [1096] = {.lex_state = 0, .external_lex_state = 14},
  [1097] = {.lex_state = 0, .external_lex_state = 14},
  [1098] = {.lex_state = 0, .external_lex_state = 15},
  [1099] = {.lex_state = 0, .external_lex_state = 15},
  [1100] = {.lex_state = 0, .external_lex_state = 15},
  [1101] = {.lex_state = 0, .external_lex_state = 15},
  [1102] = {.lex_state = 0, .external_lex_state = 15},
  [1103] = {.lex_state = 0, .external_lex_state = 15},
  [1104] = {.lex_state = 0, .external_lex_state = 15},
  [1105] = {.lex_state = 0, .external_lex_state = 8},
  [1106] = {.lex_state = 0, .external_lex_state = 15},
  [1107] = {.lex_state = 0, .external_lex_state = 15},
  [1108] = {.lex_state = 0, .external_lex_state = 15},
  [1109] = {.lex_state = 0, .external_lex_state = 15},
  [1110] = {.lex_state = 0, .external_lex_state = 15},
  [1111] = {.lex_state = 0, .external_lex_state = 5},
  [1112] = {.lex_state = 0, .external_lex_state = 15},
  [1113] = {.lex_state = 0, .external_lex_state = 15},
  [1114] = {.lex_state = 0, .external_lex_state = 15},
  [1115] = {.lex_state = 0, .external_lex_state = 15},
  [1116] = {.lex_state = 0, .external_lex_state = 15},
  [1117] = {.lex_state = 0, .external_lex_state = 15},
  [1118] = {.lex_state = 0, .external_lex_state = 15},
  [1119] = {.lex_state = 0, .external_lex_state = 15},
  [1120] = {.lex_state = 0, .external_lex_state = 15},
  [1121] = {.lex_state = 0, .external_lex_state = 15},
  [1122] = {.lex_state = 0, .external_lex_state = 15},
  [1123] = {.lex_state = 0, .external_lex_state = 15},
  [1124] = {.lex_state = 0, .external_lex_state = 15},
  [1125] = {.lex_state = 0, .external_lex_state = 15},
  [1126] = {.lex_state = 0, .external_lex_state = 15},
  [1127] = {.lex_state = 0, .external_lex_state = 15},
  [1128] = {.lex_state = 0, .external_lex_state = 15},
  [1129] = {.lex_state = 0, .external_lex_state = 15},
  [1130] = {.lex_state = 0, .external_lex_state = 15},
  [1131] = {.lex_state = 0, .external_lex_state = 15},
  [1132] = {.lex_state = 0, .external_lex_state = 15},
  [1133] = {.lex_state = 0, .external_lex_state = 16},
  [1134] = {.lex_state = 0, .external_lex_state = 15},
  [1135] = {.lex_state = 0, .external_lex_state = 15},
  [1136] = {.lex_state = 0, .external_lex_state = 15},
  [1137] = {.lex_state = 0, .external_lex_state = 15},
  [1138] = {.lex_state = 0, .external_lex_state = 15},
  [1139] = {.lex_state = 0, .external_lex_state = 11},
  [1140] = {.lex_state = 0, .external_lex_state = 16},
  [1141] = {.lex_state = 0, .external_lex_state = 16},
  [1142] = {.lex_state = 0, .external_lex_state = 16},
  [1143] = {.lex_state = 0, .external_lex_state = 16},
  [1144] = {.lex_state = 0, .external_lex_state = 16},
  [1145] = {.lex_state = 0, .external_lex_state = 23},
  [1146] = {.lex_state = 0, .external_lex_state = 12},
  [1147] = {.lex_state = 0, .external_lex_state = 16},
  [1148] = {.lex_state = 0, .external_lex_state = 16},
  [1149] = {.lex_state = 0, .external_lex_state = 16},
  [1150] = {.lex_state = 0, .external_lex_state = 23},
  [1151] = {.lex_state = 0, .external_lex_state = 23},
  [1152] = {.lex_state = 0, .external_lex_state = 15},
  [1153] = {.lex_state = 0, .external_lex_state = 12},
  [1154] = {.lex_state = 0, .external_lex_state = 12},
  [1155] = {.lex_state = 0, .external_lex_state = 16},
  [1156] = {.lex_state = 0, .external_lex_state = 12},
  [1157] = {.lex_state = 0, .external_lex_state = 16},
  [1158] = {.lex_state = 0, .external_lex_state = 16},
  [1159] = {.lex_state = 0, .external_lex_state = 23},
  [1160] = {.lex_state = 0, .external_lex_state = 12},
  [1161] = {.lex_state = 0, .external_lex_state = 16},
  [1162] = {.lex_state = 0, .external_lex_state = 12},
  [1163] = {.lex_state = 0, .external_lex_state = 12},
  [1164] = {.lex_state = 0, .external_lex_state = 12},
  [1165] = {.lex_state = 0, .external_lex_state = 12},
  [1166] = {.lex_state = 0, .external_lex_state = 16},
  [1167] = {.lex_state = 0, .external_lex_state = 12},
  [1168] = {.lex_state = 0, .external_lex_state = 12},
  [1169] = {.lex_state = 0, .external_lex_state = 16},
  [1170] = {.lex_state = 0, .external_lex_state = 12},
  [1171] = {.lex_state = 0, .external_lex_state = 12},
  [1172] = {.lex_state = 0, .external_lex_state = 12},
  [1173] = {.lex_state = 0, .external_lex_state = 16},
  [1174] = {.lex_state = 0, .external_lex_state = 16},
  [1175] = {.lex_state = 0, .external_lex_state = 16},
  [1176] = {.lex_state = 0, .external_lex_state = 16},
  [1177] = {.lex_state = 0, .external_lex_state = 16},
  [1178] = {.lex_state = 0, .external_lex_state = 16},
  [1179] = {.lex_state = 0, .external_lex_state = 16},
  [1180] = {.lex_state = 0, .external_lex_state = 12},
  [1181] = {.lex_state = 0, .external_lex_state = 12},
  [1182] = {.lex_state = 0, .external_lex_state = 12},
  [1183] = {.lex_state = 0, .external_lex_state = 16},
  [1184] = {.lex_state = 0, .external_lex_state = 16},
  [1185] = {.lex_state = 0, .external_lex_state = 16},
  [1186] = {.lex_state = 0, .external_lex_state = 12},
  [1187] = {.lex_state = 0, .external_lex_state = 16},
  [1188] = {.lex_state = 0, .external_lex_state = 12},
  [1189] = {.lex_state = 0, .external_lex_state = 16},
  [1190] = {.lex_state = 0, .external_lex_state = 12},
  [1191] = {.lex_state = 0, .external_lex_state = 12},
  [1192] = {.lex_state = 0, .external_lex_state = 12},
  [1193] = {.lex_state = 0, .external_lex_state = 12},
  [1194] = {.lex_state = 0, .external_lex_state = 12},
  [1195] = {.lex_state = 0, .external_lex_state = 12},
  [1196] = {.lex_state = 0, .external_lex_state = 12},
  [1197] = {.lex_state = 0, .external_lex_state = 12},
  [1198] = {.lex_state = 0, .external_lex_state = 16},
  [1199] = {.lex_state = 0, .external_lex_state = 16},
  [1200] = {.lex_state = 0, .external_lex_state = 16},
  [1201] = {.lex_state = 0, .external_lex_state = 16},
  [1202] = {.lex_state = 0, .external_lex_state = 16},
  [1203] = {.lex_state = 0, .external_lex_state = 16},
  [1204] = {.lex_state = 0, .external_lex_state = 16},
  [1205] = {.lex_state = 0, .external_lex_state = 16},
  [1206] = {.lex_state = 0, .external_lex_state = 16},
  [1207] = {.lex_state = 0, .external_lex_state = 16},
  [1208] = {.lex_state = 0, .external_lex_state = 16},
  [1209] = {.lex_state = 0, .external_lex_state = 16},
  [1210] = {.lex_state = 0, .external_lex_state = 16},
  [1211] = {.lex_state = 0, .external_lex_state = 16},
  [1212] = {.lex_state = 0, .external_lex_state = 16},
  [1213] = {.lex_state = 0, .external_lex_state = 7},
  [1214] = {.lex_state = 0, .external_lex_state = 16},
  [1215] = {.lex_state = 0, .external_lex_state = 16},
  [1216] = {.lex_state = 0, .external_lex_state = 16},
  [1217] = {.lex_state = 0, .external_lex_state = 12},
  [1218] = {.lex_state = 0, .external_lex_state = 16},
  [1219] = {.lex_state = 0, .external_lex_state = 13},
  [1220] = {.lex_state = 0, .external_lex_state = 12},
  [1221] = {.lex_state = 0, .external_lex_state = 12},
  [1222] = {.lex_state = 0, .external_lex_state = 12},
  [1223] = {.lex_state = 0, .external_lex_state = 16},
  [1224] = {.lex_state = 0, .external_lex_state = 16},
  [1225] = {.lex_state = 0, .external_lex_state = 16},
  [1226] = {.lex_state = 0, .external_lex_state = 12},
  [1227] = {.lex_state = 0, .external_lex_state = 16},
  [1228] = {.lex_state = 0, .external_lex_state = 12},
  [1229] = {.lex_state = 0, .external_lex_state = 16},
  [1230] = {.lex_state = 0, .external_lex_state = 12},
  [1231] = {.lex_state = 0, .external_lex_state = 12},
  [1232] = {.lex_state = 0, .external_lex_state = 12},
  [1233] = {.lex_state = 0, .external_lex_state = 12},
  [1234] = {.lex_state = 0, .external_lex_state = 12},
  [1235] = {.lex_state = 0, .external_lex_state = 12},
  [1236] = {.lex_state = 0, .external_lex_state = 12},
  [1237] = {.lex_state = 0, .external_lex_state = 12},
  [1238] = {.lex_state = 0, .external_lex_state = 12},
  [1239] = {.lex_state = 0, .external_lex_state = 12},
  [1240] = {.lex_state = 0, .external_lex_state = 12},
  [1241] = {.lex_state = 0, .external_lex_state = 12},
  [1242] = {.lex_state = 0, .external_lex_state = 12},
  [1243] = {.lex_state = 0, .external_lex_state = 12},
  [1244] = {.lex_state = 0, .external_lex_state = 12},
  [1245] = {.lex_state = 0, .external_lex_state = 12},
  [1246] = {.lex_state = 0, .external_lex_state = 12},
  [1247] = {.lex_state = 0, .external_lex_state = 11},
  [1248] = {.lex_state = 0, .external_lex_state = 11},
  [1249] = {.lex_state = 0, .external_lex_state = 11},
  [1250] = {.lex_state = 0, .external_lex_state = 11},
  [1251] = {.lex_state = 0, .external_lex_state = 11},
  [1252] = {.lex_state = 0, .external_lex_state = 11},
  [1253] = {.lex_state = 0, .external_lex_state = 11},
  [1254] = {.lex_state = 0, .external_lex_state = 11},
  [1255] = {.lex_state = 0, .external_lex_state = 11},
  [1256] = {.lex_state = 0, .external_lex_state = 11},
  [1257] = {.lex_state = 0, .external_lex_state = 11},
  [1258] = {.lex_state = 0, .external_lex_state = 11},
  [1259] = {.lex_state = 0, .external_lex_state = 11},
  [1260] = {.lex_state = 0, .external_lex_state = 11},
  [1261] = {.lex_state = 0, .external_lex_state = 11},
  [1262] = {.lex_state = 0, .external_lex_state = 11},
  [1263] = {.lex_state = 0, .external_lex_state = 11},
  [1264] = {.lex_state = 0, .external_lex_state = 7},
  [1265] = {.lex_state = 0, .external_lex_state = 25},
  [1266] = {.lex_state = 0, .external_lex_state = 25},
  [1267] = {.lex_state = 0, .external_lex_state = 11},
  [1268] = {.lex_state = 0, .external_lex_state = 25},
  [1269] = {.lex_state = 0, .external_lex_state = 11},
  [1270] = {.lex_state = 0, .external_lex_state = 25},
  [1271] = {.lex_state = 0, .external_lex_state = 11},
  [1272] = {.lex_state = 0, .external_lex_state = 11},
  [1273] = {.lex_state = 0, .external_lex_state = 11},
  [1274] = {.lex_state = 0, .external_lex_state = 11},
  [1275] = {.lex_state = 0, .external_lex_state = 11},
  [1276] = {.lex_state = 0, .external_lex_state = 11},
  [1277] = {.lex_state = 0, .external_lex_state = 11},
  [1278] = {.lex_state = 0, .external_lex_state = 11},
  [1279] = {.lex_state = 0, .external_lex_state = 11},
  [1280] = {.lex_state = 0, .external_lex_state = 17},
  [1281] = {.lex_state = 0, .external_lex_state = 11},
  [1282] = {.lex_state = 0, .external_lex_state = 11},
  [1283] = {.lex_state = 0, .external_lex_state = 17},
  [1284] = {.lex_state = 0, .external_lex_state = 11},
  [1285] = {.lex_state = 0, .external_lex_state = 11},
  [1286] = {.lex_state = 0, .external_lex_state = 17},
  [1287] = {.lex_state = 0, .external_lex_state = 17},
  [1288] = {.lex_state = 0, .external_lex_state = 17},
  [1289] = {.lex_state = 0, .external_lex_state = 17},
  [1290] = {.lex_state = 0, .external_lex_state = 17},
  [1291] = {.lex_state = 0, .external_lex_state = 22},
  [1292] = {.lex_state = 0, .external_lex_state = 11},
  [1293] = {.lex_state = 0, .external_lex_state = 17},
  [1294] = {.lex_state = 0, .external_lex_state = 22},
  [1295] = {.lex_state = 0, .external_lex_state = 22},
  [1296] = {.lex_state = 0, .external_lex_state = 11},
  [1297] = {.lex_state = 0, .external_lex_state = 22},
  [1298] = {.lex_state = 0, .external_lex_state = 11},
  [1299] = {.lex_state = 0, .external_lex_state = 9},
  [1300] = {.lex_state = 0, .external_lex_state = 23},
  [1301] = {.lex_state = 0, .external_lex_state = 23},
  [1302] = {.lex_state = 0, .external_lex_state = 11},
  [1303] = {.lex_state = 0, .external_lex_state = 11},
  [1304] = {.lex_state = 0, .external_lex_state = 11},
  [1305] = {.lex_state = 0, .external_lex_state = 11},
  [1306] = {.lex_state = 0, .external_lex_state = 11},
  [1307] = {.lex_state = 0, .external_lex_state = 11},
  [1308] = {.lex_state = 0, .external_lex_state = 11},
  [1309] = {.lex_state = 0, .external_lex_state = 11},
  [1310] = {.lex_state = 0, .external_lex_state = 11},
  [1311] = {.lex_state = 0, .external_lex_state = 11},
  [1312] = {.lex_state = 0, .external_lex_state = 11},
  [1313] = {.lex_state = 0, .external_lex_state = 11},
  [1314] = {.lex_state = 0, .external_lex_state = 11},
  [1315] = {.lex_state = 0, .external_lex_state = 23},
  [1316] = {.lex_state = 0, .external_lex_state = 23},
  [1317] = {.lex_state = 0, .external_lex_state = 9},
  [1318] = {.lex_state = 0, .external_lex_state = 11},
  [1319] = {.lex_state = 0, .external_lex_state = 20},
  [1320] = {.lex_state = 0, .external_lex_state = 18},
  [1321] = {.lex_state = 0, .external_lex_state = 29},
  [1322] = {.lex_state = 0, .external_lex_state = 29},
  [1323] = {.lex_state = 0, .external_lex_state = 30},
  [1324] = {.lex_state = 0, .external_lex_state = 30},
  [1325] = {.lex_state = 0, .external_lex_state = 31},
  [1326] = {.lex_state = 0, .external_lex_state = 29},
  [1327] = {.lex_state = 0, .external_lex_state = 30},
  [1328] = {.lex_state = 0, .external_lex_state = 29},
  [1329] = {.lex_state = 0, .external_lex_state = 31},
  [1330] = {.lex_state = 0, .external_lex_state = 30},
  [1331] = {.lex_state = 0, .external_lex_state = 29},
  [1332] = {.lex_state = 0, .external_lex_state = 31},
  [1333] = {.lex_state = 0, .external_lex_state = 31},
  [1334] = {.lex_state = 0, .external_lex_state = 30},
  [1335] = {.lex_state = 0, .external_lex_state = 29},
  [1336] = {.lex_state = 0, .external_lex_state = 9},
  [1337] = {.lex_state = 0, .external_lex_state = 20},
  [1338] = {.lex_state = 0, .external_lex_state = 10},
  [1339] = {.lex_state = 0, .external_lex_state = 31},
  [1340] = {.lex_state = 0, .external_lex_state = 31},
  [1341] = {.lex_state = 0, .external_lex_state = 19},
  [1342] = {.lex_state = 0, .external_lex_state = 31},
  [1343] = {.lex_state = 0, .external_lex_state = 19},
  [1344] = {.lex_state = 0, .external_lex_state = 31},
  [1345] = {.lex_state = 0, .external_lex_state = 19},
  [1346] = {.lex_state = 0, .external_lex_state = 30},
  [1347] = {.lex_state = 0, .external_lex_state = 19},
  [1348] = {.lex_state = 0, .external_lex_state = 29},
  [1349] = {.lex_state = 0, .external_lex_state = 19},
  [1350] = {.lex_state = 0, .external_lex_state = 31},
  [1351] = {.lex_state = 0, .external_lex_state = 31},
  [1352] = {.lex_state = 0, .external_lex_state = 30},
  [1353] = {.lex_state = 0, .external_lex_state = 29},
  [1354] = {.lex_state = 0, .external_lex_state = 21},
  [1355] = {.lex_state = 0, .external_lex_state = 20},
  [1356] = {.lex_state = 0, .external_lex_state = 20},
  [1357] = {.lex_state = 0, .external_lex_state = 31},
  [1358] = {.lex_state = 0, .external_lex_state = 20},
  [1359] = {.lex_state = 0, .external_lex_state = 31},
  [1360] = {.lex_state = 0, .external_lex_state = 30},
  [1361] = {.lex_state = 0, .external_lex_state = 29},
  [1362] = {.lex_state = 0, .external_lex_state = 31},
  [1363] = {.lex_state = 0, .external_lex_state = 31},
  [1364] = {.lex_state = 0, .external_lex_state = 30},
  [1365] = {.lex_state = 0, .external_lex_state = 29},
  [1366] = {.lex_state = 0, .external_lex_state = 31},
  [1367] = {.lex_state = 0, .external_lex_state = 29},
  [1368] = {.lex_state = 0, .external_lex_state = 31},
  [1369] = {.lex_state = 0, .external_lex_state = 30},
  [1370] = {.lex_state = 0, .external_lex_state = 30},
  [1371] = {.lex_state = 0, .external_lex_state = 29},
  [1372] = {.lex_state = 0, .external_lex_state = 31},
  [1373] = {.lex_state = 0, .external_lex_state = 31},
  [1374] = {.lex_state = 0, .external_lex_state = 29},
  [1375] = {.lex_state = 0, .external_lex_state = 31},
  [1376] = {.lex_state = 0, .external_lex_state = 20},
  [1377] = {.lex_state = 0, .external_lex_state = 19},
  [1378] = {.lex_state = 0, .external_lex_state = 30},
  [1379] = {.lex_state = 0, .external_lex_state = 29},
  [1380] = {.lex_state = 0, .external_lex_state = 31},
  [1381] = {.lex_state = 0, .external_lex_state = 19},
  [1382] = {.lex_state = 0, .external_lex_state = 19},
  [1383] = {.lex_state = 0, .external_lex_state = 19},
  [1384] = {.lex_state = 0, .external_lex_state = 19},
  [1385] = {.lex_state = 0, .external_lex_state = 19},
  [1386] = {.lex_state = 0, .external_lex_state = 30},
  [1387] = {.lex_state = 0, .external_lex_state = 29},
  [1388] = {.lex_state = 0, .external_lex_state = 19},
  [1389] = {.lex_state = 0, .external_lex_state = 11},
  [1390] = {.lex_state = 0, .external_lex_state = 19},
  [1391] = {.lex_state = 0, .external_lex_state = 20},
  [1392] = {.lex_state = 0, .external_lex_state = 19},
  [1393] = {.lex_state = 0, .external_lex_state = 31},
  [1394] = {.lex_state = 0, .external_lex_state = 19},
  [1395] = {.lex_state = 0, .external_lex_state = 30},
  [1396] = {.lex_state = 0, .external_lex_state = 19},
  [1397] = {.lex_state = 0, .external_lex_state = 29},
  [1398] = {.lex_state = 0, .external_lex_state = 19},
  [1399] = {.lex_state = 0, .external_lex_state = 31},
  [1400] = {.lex_state = 0, .external_lex_state = 19},
  [1401] = {.lex_state = 0, .external_lex_state = 31},
  [1402] = {.lex_state = 0, .external_lex_state = 19},
  [1403] = {.lex_state = 0, .external_lex_state = 30},
  [1404] = {.lex_state = 0, .external_lex_state = 19},
  [1405] = {.lex_state = 0, .external_lex_state = 29},
  [1406] = {.lex_state = 0, .external_lex_state = 19},
  [1407] = {.lex_state = 0, .external_lex_state = 30},
  [1408] = {.lex_state = 0, .external_lex_state = 19},
  [1409] = {.lex_state = 0, .external_lex_state = 29},
  [1410] = {.lex_state = 0, .external_lex_state = 19},
  [1411] = {.lex_state = 0, .external_lex_state = 31},
  [1412] = {.lex_state = 0, .external_lex_state = 19},
  [1413] = {.lex_state = 0, .external_lex_state = 21},
  [1414] = {.lex_state = 0, .external_lex_state = 31},
  [1415] = {.lex_state = 0, .external_lex_state = 30},
  [1416] = {.lex_state = 0, .external_lex_state = 29},
  [1417] = {.lex_state = 0, .external_lex_state = 30},
  [1418] = {.lex_state = 0, .external_lex_state = 29},
  [1419] = {.lex_state = 0, .external_lex_state = 29},
  [1420] = {.lex_state = 0, .external_lex_state = 30},
  [1421] = {.lex_state = 0, .external_lex_state = 29},
  [1422] = {.lex_state = 0, .external_lex_state = 21},
  [1423] = {.lex_state = 0, .external_lex_state = 31},
  [1424] = {.lex_state = 0, .external_lex_state = 31},
  [1425] = {.lex_state = 0, .external_lex_state = 30},
  [1426] = {.lex_state = 0, .external_lex_state = 19},
  [1427] = {.lex_state = 0, .external_lex_state = 11},
  [1428] = {.lex_state = 0, .external_lex_state = 30},
  [1429] = {.lex_state = 0, .external_lex_state = 19},
  [1430] = {.lex_state = 0, .external_lex_state = 19},
  [1431] = {.lex_state = 0, .external_lex_state = 19},
  [1432] = {.lex_state = 0, .external_lex_state = 19},
  [1433] = {.lex_state = 0, .external_lex_state = 19},
  [1434] = {.lex_state = 0, .external_lex_state = 19},
  [1435] = {.lex_state = 0, .external_lex_state = 19},
  [1436] = {.lex_state = 0, .external_lex_state = 19},
  [1437] = {.lex_state = 0, .external_lex_state = 19},
  [1438] = {.lex_state = 0, .external_lex_state = 19},
  [1439] = {.lex_state = 0, .external_lex_state = 19},
  [1440] = {.lex_state = 0, .external_lex_state = 19},
  [1441] = {.lex_state = 0, .external_lex_state = 19},
  [1442] = {.lex_state = 0, .external_lex_state = 29},
  [1443] = {.lex_state = 0, .external_lex_state = 31},
  [1444] = {.lex_state = 0, .external_lex_state = 31},
  [1445] = {.lex_state = 0, .external_lex_state = 20},
  [1446] = {.lex_state = 0, .external_lex_state = 23},
  [1447] = {.lex_state = 0, .external_lex_state = 30},
  [1448] = {.lex_state = 0, .external_lex_state = 19},
  [1449] = {.lex_state = 0, .external_lex_state = 23},
  [1450] = {.lex_state = 0, .external_lex_state = 29},
  [1451] = {.lex_state = 0, .external_lex_state = 23},
  [1452] = {.lex_state = 0, .external_lex_state = 30},
  [1453] = {.lex_state = 0, .external_lex_state = 29},
  [1454] = {.lex_state = 0, .external_lex_state = 23},
  [1455] = {.lex_state = 0, .external_lex_state = 19},
  [1456] = {.lex_state = 0, .external_lex_state = 19},
  [1457] = {.lex_state = 0, .external_lex_state = 23},
  [1458] = {.lex_state = 0, .external_lex_state = 19},
  [1459] = {.lex_state = 0, .external_lex_state = 23},
  [1460] = {.lex_state = 0, .external_lex_state = 23},
  [1461] = {.lex_state = 0, .external_lex_state = 31},
  [1462] = {.lex_state = 0, .external_lex_state = 19},
  [1463] = {.lex_state = 0, .external_lex_state = 30},
  [1464] = {.lex_state = 0, .external_lex_state = 20},
  [1465] = {.lex_state = 0, .external_lex_state = 19},
  [1466] = {.lex_state = 0, .external_lex_state = 19},
  [1467] = {.lex_state = 0, .external_lex_state = 19},
  [1468] = {.lex_state = 0, .external_lex_state = 23},
  [1469] = {.lex_state = 0, .external_lex_state = 19},
  [1470] = {.lex_state = 0, .external_lex_state = 19},
  [1471] = {.lex_state = 0, .external_lex_state = 20},
  [1472] = {.lex_state = 0, .external_lex_state = 19},
  [1473] = {.lex_state = 0, .external_lex_state = 19},
  [1474] = {.lex_state = 0, .external_lex_state = 23},
  [1475] = {.lex_state = 0, .external_lex_state = 20},
  [1476] = {.lex_state = 0, .external_lex_state = 23},
  [1477] = {.lex_state = 0, .external_lex_state = 23},
  [1478] = {.lex_state = 0, .external_lex_state = 31},
  [1479] = {.lex_state = 0, .external_lex_state = 23},
  [1480] = {.lex_state = 0, .external_lex_state = 23},
  [1481] = {.lex_state = 0, .external_lex_state = 23},
  [1482] = {.lex_state = 0, .external_lex_state = 23},
  [1483] = {.lex_state = 0, .external_lex_state = 23},
  [1484] = {.lex_state = 0, .external_lex_state = 23},
  [1485] = {.lex_state = 0, .external_lex_state = 20},
  [1486] = {.lex_state = 0, .external_lex_state = 23},
  [1487] = {.lex_state = 0, .external_lex_state = 20},
  [1488] = {.lex_state = 0, .external_lex_state = 31},
  [1489] = {.lex_state = 0, .external_lex_state = 20},
  [1490] = {.lex_state = 0, .external_lex_state = 30},
  [1491] = {.lex_state = 0, .external_lex_state = 23},
  [1492] = {.lex_state = 0, .external_lex_state = 31},
  [1493] = {.lex_state = 0, .external_lex_state = 23},
  [1494] = {.lex_state = 0, .external_lex_state = 29},
  [1495] = {.lex_state = 0, .external_lex_state = 23},
  [1496] = {.lex_state = 0, .external_lex_state = 31},
  [1497] = {.lex_state = 0, .external_lex_state = 23},
  [1498] = {.lex_state = 0, .external_lex_state = 23},
  [1499] = {.lex_state = 0, .external_lex_state = 23},
  [1500] = {.lex_state = 0, .external_lex_state = 23},
  [1501] = {.lex_state = 0, .external_lex_state = 21},
  [1502] = {.lex_state = 0, .external_lex_state = 23},
  [1503] = {.lex_state = 0, .external_lex_state = 30},
  [1504] = {.lex_state = 0, .external_lex_state = 29},
  [1505] = {.lex_state = 0, .external_lex_state = 31},
  [1506] = {.lex_state = 0, .external_lex_state = 23},
  [1507] = {.lex_state = 0, .external_lex_state = 23},
  [1508] = {.lex_state = 0, .external_lex_state = 23},
  [1509] = {.lex_state = 0, .external_lex_state = 23},
  [1510] = {.lex_state = 0, .external_lex_state = 23},
  [1511] = {.lex_state = 0, .external_lex_state = 23},
  [1512] = {.lex_state = 0, .external_lex_state = 23},
  [1513] = {.lex_state = 0, .external_lex_state = 23},
  [1514] = {.lex_state = 0, .external_lex_state = 23},
  [1515] = {.lex_state = 0, .external_lex_state = 12},
  [1516] = {.lex_state = 0, .external_lex_state = 23},
  [1517] = {.lex_state = 0, .external_lex_state = 23},
  [1518] = {.lex_state = 0, .external_lex_state = 23},
  [1519] = {.lex_state = 0, .external_lex_state = 30},
  [1520] = {.lex_state = 0, .external_lex_state = 23},
  [1521] = {.lex_state = 0, .external_lex_state = 17},
  [1522] = {.lex_state = 0, .external_lex_state = 23},
  [1523] = {.lex_state = 0, .external_lex_state = 23},
  [1524] = {.lex_state = 0, .external_lex_state = 23},
  [1525] = {.lex_state = 0, .external_lex_state = 29},
  [1526] = {.lex_state = 0, .external_lex_state = 23},
  [1527] = {.lex_state = 0, .external_lex_state = 20},
  [1528] = {.lex_state = 0, .external_lex_state = 31},
  [1529] = {.lex_state = 0, .external_lex_state = 29},
  [1530] = {.lex_state = 0, .external_lex_state = 23},
  [1531] = {.lex_state = 0, .external_lex_state = 23},
  [1532] = {.lex_state = 0, .external_lex_state = 31},
  [1533] = {.lex_state = 0, .external_lex_state = 30},
  [1534] = {.lex_state = 0, .external_lex_state = 29},
  [1535] = {.lex_state = 0, .external_lex_state = 21},
  [1536] = {.lex_state = 0, .external_lex_state = 30},
  [1537] = {.lex_state = 0, .external_lex_state = 31},
  [1538] = {.lex_state = 0, .external_lex_state = 31},
  [1539] = {.lex_state = 0, .external_lex_state = 30},
  [1540] = {.lex_state = 0, .external_lex_state = 23},
  [1541] = {.lex_state = 0, .external_lex_state = 29},
  [1542] = {.lex_state = 0, .external_lex_state = 23},
  [1543] = {.lex_state = 0, .external_lex_state = 29},
  [1544] = {.lex_state = 0, .external_lex_state = 23},
  [1545] = {.lex_state = 0, .external_lex_state = 31},
  [1546] = {.lex_state = 0, .external_lex_state = 23},
  [1547] = {.lex_state = 0, .external_lex_state = 31},
  [1548] = {.lex_state = 0, .external_lex_state = 23},
  [1549] = {.lex_state = 0, .external_lex_state = 30},
  [1550] = {.lex_state = 0, .external_lex_state = 21},
  [1551] = {.lex_state = 0, .external_lex_state = 29},
  [1552] = {.lex_state = 0, .external_lex_state = 22},
  [1553] = {.lex_state = 0, .external_lex_state = 21},
  [1554] = {.lex_state = 0, .external_lex_state = 22},
  [1555] = {.lex_state = 0, .external_lex_state = 31},
  [1556] = {.lex_state = 0, .external_lex_state = 21},
  [1557] = {.lex_state = 0, .external_lex_state = 16},
  [1558] = {.lex_state = 0, .external_lex_state = 22},
  [1559] = {.lex_state = 0, .external_lex_state = 31},
  [1560] = {.lex_state = 0, .external_lex_state = 22},
  [1561] = {.lex_state = 0, .external_lex_state = 21},
  [1562] = {.lex_state = 0, .external_lex_state = 22},
  [1563] = {.lex_state = 0, .external_lex_state = 7},
  [1564] = {.lex_state = 0, .external_lex_state = 22},
  [1565] = {.lex_state = 0, .external_lex_state = 22},
  [1566] = {.lex_state = 0, .external_lex_state = 12},
  [1567] = {.lex_state = 0, .external_lex_state = 21},
  [1568] = {.lex_state = 0, .external_lex_state = 21},
  [1569] = {.lex_state = 0, .external_lex_state = 29},
  [1570] = {.lex_state = 0, .external_lex_state = 22},
  [1571] = {.lex_state = 0, .external_lex_state = 30},
  [1572] = {.lex_state = 0, .external_lex_state = 22},
  [1573] = {.lex_state = 0, .external_lex_state = 22},
  [1574] = {.lex_state = 0, .external_lex_state = 22},
  [1575] = {.lex_state = 0, .external_lex_state = 21},
  [1576] = {.lex_state = 0, .external_lex_state = 22},
  [1577] = {.lex_state = 0, .external_lex_state = 30},
  [1578] = {.lex_state = 0, .external_lex_state = 22},
  [1579] = {.lex_state = 0, .external_lex_state = 20},
  [1580] = {.lex_state = 0, .external_lex_state = 20},
  [1581] = {.lex_state = 0, .external_lex_state = 16},
  [1582] = {.lex_state = 0, .external_lex_state = 29},
  [1583] = {.lex_state = 0, .external_lex_state = 29},
  [1584] = {.lex_state = 0, .external_lex_state = 31},
  [1585] = {.lex_state = 0, .external_lex_state = 30},
  [1586] = {.lex_state = 0, .external_lex_state = 6},
  [1587] = {.lex_state = 0, .external_lex_state = 31},
  [1588] = {.lex_state = 0, .external_lex_state = 30},
  [1589] = {.lex_state = 0, .external_lex_state = 29},
  [1590] = {.lex_state = 0, .external_lex_state = 31},
  [1591] = {.lex_state = 0, .external_lex_state = 31},
  [1592] = {.lex_state = 0, .external_lex_state = 30},
  [1593] = {.lex_state = 0, .external_lex_state = 22},
  [1594] = {.lex_state = 0, .external_lex_state = 22},
  [1595] = {.lex_state = 0, .external_lex_state = 22},
  [1596] = {.lex_state = 0, .external_lex_state = 22},
  [1597] = {.lex_state = 0, .external_lex_state = 22},
  [1598] = {.lex_state = 0, .external_lex_state = 29},
  [1599] = {.lex_state = 0, .external_lex_state = 18},
  [1600] = {.lex_state = 0, .external_lex_state = 20},
  [1601] = {.lex_state = 0, .external_lex_state = 22},
  [1602] = {.lex_state = 0, .external_lex_state = 22},
  [1603] = {.lex_state = 0, .external_lex_state = 31},
  [1604] = {.lex_state = 0, .external_lex_state = 30},
  [1605] = {.lex_state = 0, .external_lex_state = 22},
  [1606] = {.lex_state = 0, .external_lex_state = 31},
  [1607] = {.lex_state = 0, .external_lex_state = 30},
  [1608] = {.lex_state = 0, .external_lex_state = 22},
  [1609] = {.lex_state = 0, .external_lex_state = 13},
  [1610] = {.lex_state = 0, .external_lex_state = 22},
  [1611] = {.lex_state = 0, .external_lex_state = 22},
  [1612] = {.lex_state = 0, .external_lex_state = 20},
  [1613] = {.lex_state = 0, .external_lex_state = 30},
  [1614] = {.lex_state = 0, .external_lex_state = 22},
  [1615] = {.lex_state = 0, .external_lex_state = 29},
  [1616] = {.lex_state = 0, .external_lex_state = 31},
  [1617] = {.lex_state = 0, .external_lex_state = 20},
  [1618] = {.lex_state = 0, .external_lex_state = 19},
  [1619] = {.lex_state = 0, .external_lex_state = 22},
  [1620] = {.lex_state = 0, .external_lex_state = 31},
  [1621] = {.lex_state = 0, .external_lex_state = 20},
  [1622] = {.lex_state = 0, .external_lex_state = 30},
  [1623] = {.lex_state = 0, .external_lex_state = 25},
  [1624] = {.lex_state = 0, .external_lex_state = 25},
  [1625] = {.lex_state = 0, .external_lex_state = 29},
  [1626] = {.lex_state = 0, .external_lex_state = 20},
  [1627] = {.lex_state = 0, .external_lex_state = 22},
  [1628] = {.lex_state = 0, .external_lex_state = 22},
  [1629] = {.lex_state = 0, .external_lex_state = 22},
  [1630] = {.lex_state = 0, .external_lex_state = 22},
  [1631] = {.lex_state = 0, .external_lex_state = 22},
  [1632] = {.lex_state = 0, .external_lex_state = 22},
  [1633] = {.lex_state = 0, .external_lex_state = 22},
  [1634] = {.lex_state = 0, .external_lex_state = 22},
  [1635] = {.lex_state = 0, .external_lex_state = 22},
  [1636] = {.lex_state = 0, .external_lex_state = 20},
  [1637] = {.lex_state = 0, .external_lex_state = 25},
  [1638] = {.lex_state = 0, .external_lex_state = 22},
  [1639] = {.lex_state = 0, .external_lex_state = 18},
  [1640] = {.lex_state = 0, .external_lex_state = 22},
  [1641] = {.lex_state = 0, .external_lex_state = 18},
  [1642] = {.lex_state = 0, .external_lex_state = 22},
  [1643] = {.lex_state = 0, .external_lex_state = 18},
  [1644] = {.lex_state = 0, .external_lex_state = 22},
  [1645] = {.lex_state = 0, .external_lex_state = 18},
  [1646] = {.lex_state = 0, .external_lex_state = 22},
  [1647] = {.lex_state = 0, .external_lex_state = 18},
  [1648] = {.lex_state = 0, .external_lex_state = 22},
  [1649] = {.lex_state = 0, .external_lex_state = 22},
  [1650] = {.lex_state = 0, .external_lex_state = 22},
  [1651] = {.lex_state = 0, .external_lex_state = 22},
  [1652] = {.lex_state = 0, .external_lex_state = 25},
  [1653] = {.lex_state = 0, .external_lex_state = 21},
  [1654] = {.lex_state = 0, .external_lex_state = 22},
  [1655] = {.lex_state = 0, .external_lex_state = 25},
  [1656] = {.lex_state = 0, .external_lex_state = 25},
  [1657] = {.lex_state = 0, .external_lex_state = 22},
  [1658] = {.lex_state = 0, .external_lex_state = 22},
  [1659] = {.lex_state = 0, .external_lex_state = 22},
  [1660] = {.lex_state = 0, .external_lex_state = 22},
  [1661] = {.lex_state = 0, .external_lex_state = 21},
  [1662] = {.lex_state = 0, .external_lex_state = 22},
  [1663] = {.lex_state = 0, .external_lex_state = 21},
  [1664] = {.lex_state = 0, .external_lex_state = 17},
  [1665] = {.lex_state = 0, .external_lex_state = 17},
  [1666] = {.lex_state = 0, .external_lex_state = 25},
  [1667] = {.lex_state = 0, .external_lex_state = 21},
  [1668] = {.lex_state = 0, .external_lex_state = 17},
  [1669] = {.lex_state = 0, .external_lex_state = 17},
  [1670] = {.lex_state = 0, .external_lex_state = 20},
  [1671] = {.lex_state = 0, .external_lex_state = 17},
  [1672] = {.lex_state = 0, .external_lex_state = 25},
  [1673] = {.lex_state = 0, .external_lex_state = 17},
  [1674] = {.lex_state = 0, .external_lex_state = 17},
  [1675] = {.lex_state = 0, .external_lex_state = 21},
  [1676] = {.lex_state = 0, .external_lex_state = 20},
  [1677] = {.lex_state = 0, .external_lex_state = 17},
  [1678] = {.lex_state = 0, .external_lex_state = 20},
  [1679] = {.lex_state = 0, .external_lex_state = 18},
  [1680] = {.lex_state = 0, .external_lex_state = 20},
  [1681] = {.lex_state = 0, .external_lex_state = 17},
  [1682] = {.lex_state = 0, .external_lex_state = 21},
  [1683] = {.lex_state = 0, .external_lex_state = 18},
  [1684] = {.lex_state = 0, .external_lex_state = 18},
  [1685] = {.lex_state = 0, .external_lex_state = 18},
  [1686] = {.lex_state = 0, .external_lex_state = 18},
  [1687] = {.lex_state = 0, .external_lex_state = 18},
  [1688] = {.lex_state = 0, .external_lex_state = 17},
  [1689] = {.lex_state = 0, .external_lex_state = 17},
  [1690] = {.lex_state = 0, .external_lex_state = 18},
  [1691] = {.lex_state = 0, .external_lex_state = 21},
  [1692] = {.lex_state = 0, .external_lex_state = 18},
  [1693] = {.lex_state = 0, .external_lex_state = 17},
  [1694] = {.lex_state = 0, .external_lex_state = 18},
  [1695] = {.lex_state = 0, .external_lex_state = 17},
  [1696] = {.lex_state = 0, .external_lex_state = 18},
  [1697] = {.lex_state = 0, .external_lex_state = 17},
  [1698] = {.lex_state = 0, .external_lex_state = 18},
  [1699] = {.lex_state = 0, .external_lex_state = 17},
  [1700] = {.lex_state = 0, .external_lex_state = 18},
  [1701] = {.lex_state = 0, .external_lex_state = 17},
  [1702] = {.lex_state = 0, .external_lex_state = 18},
  [1703] = {.lex_state = 0, .external_lex_state = 17},
  [1704] = {.lex_state = 0, .external_lex_state = 18},
  [1705] = {.lex_state = 0, .external_lex_state = 17},
  [1706] = {.lex_state = 0, .external_lex_state = 18},
  [1707] = {.lex_state = 0, .external_lex_state = 17},
  [1708] = {.lex_state = 0, .external_lex_state = 18},
  [1709] = {.lex_state = 0, .external_lex_state = 17},
  [1710] = {.lex_state = 0, .external_lex_state = 18},
  [1711] = {.lex_state = 0, .external_lex_state = 17},
  [1712] = {.lex_state = 0, .external_lex_state = 18},
  [1713] = {.lex_state = 0, .external_lex_state = 17},
  [1714] = {.lex_state = 0, .external_lex_state = 18},
  [1715] = {.lex_state = 0, .external_lex_state = 17},
  [1716] = {.lex_state = 0, .external_lex_state = 17},
  [1717] = {.lex_state = 0, .external_lex_state = 25},
  [1718] = {.lex_state = 0, .external_lex_state = 17},
  [1719] = {.lex_state = 0, .external_lex_state = 21},
  [1720] = {.lex_state = 0, .external_lex_state = 29},
  [1721] = {.lex_state = 0, .external_lex_state = 17},
  [1722] = {.lex_state = 0, .external_lex_state = 30},
  [1723] = {.lex_state = 0, .external_lex_state = 30},
  [1724] = {.lex_state = 0, .external_lex_state = 29},
  [1725] = {.lex_state = 0, .external_lex_state = 20},
  [1726] = {.lex_state = 0, .external_lex_state = 20},
  [1727] = {.lex_state = 0, .external_lex_state = 20},
  [1728] = {.lex_state = 0, .external_lex_state = 18},
  [1729] = {.lex_state = 0, .external_lex_state = 17},
  [1730] = {.lex_state = 0, .external_lex_state = 20},
  [1731] = {.lex_state = 0, .external_lex_state = 18},
  [1732] = {.lex_state = 0, .external_lex_state = 18},
  [1733] = {.lex_state = 0, .external_lex_state = 18},
  [1734] = {.lex_state = 0, .external_lex_state = 18},
  [1735] = {.lex_state = 0, .external_lex_state = 18},
  [1736] = {.lex_state = 0, .external_lex_state = 18},
  [1737] = {.lex_state = 0, .external_lex_state = 18},
  [1738] = {.lex_state = 0, .external_lex_state = 18},
  [1739] = {.lex_state = 0, .external_lex_state = 18},
  [1740] = {.lex_state = 0, .external_lex_state = 18},
  [1741] = {.lex_state = 0, .external_lex_state = 18},
  [1742] = {.lex_state = 0, .external_lex_state = 18},
  [1743] = {.lex_state = 0, .external_lex_state = 18},
  [1744] = {.lex_state = 0, .external_lex_state = 17},
  [1745] = {.lex_state = 0, .external_lex_state = 17},
  [1746] = {.lex_state = 0, .external_lex_state = 17},
  [1747] = {.lex_state = 0, .external_lex_state = 17},
  [1748] = {.lex_state = 0, .external_lex_state = 17},
  [1749] = {.lex_state = 0, .external_lex_state = 25},
  [1750] = {.lex_state = 0, .external_lex_state = 18},
  [1751] = {.lex_state = 0, .external_lex_state = 20},
  [1752] = {.lex_state = 0, .external_lex_state = 20},
  [1753] = {.lex_state = 0, .external_lex_state = 17},
  [1754] = {.lex_state = 0, .external_lex_state = 25},
  [1755] = {.lex_state = 0, .external_lex_state = 31},
  [1756] = {.lex_state = 0, .external_lex_state = 20},
  [1757] = {.lex_state = 0, .external_lex_state = 18},
  [1758] = {.lex_state = 0, .external_lex_state = 18},
  [1759] = {.lex_state = 0, .external_lex_state = 20},
  [1760] = {.lex_state = 0, .external_lex_state = 18},
  [1761] = {.lex_state = 0, .external_lex_state = 17},
  [1762] = {.lex_state = 0, .external_lex_state = 17},
  [1763] = {.lex_state = 0, .external_lex_state = 29},
  [1764] = {.lex_state = 0, .external_lex_state = 18},
  [1765] = {.lex_state = 0, .external_lex_state = 17},
  [1766] = {.lex_state = 0, .external_lex_state = 20},
  [1767] = {.lex_state = 0, .external_lex_state = 18},
  [1768] = {.lex_state = 0, .external_lex_state = 18},
  [1769] = {.lex_state = 0, .external_lex_state = 18},
  [1770] = {.lex_state = 0, .external_lex_state = 17},
  [1771] = {.lex_state = 0, .external_lex_state = 18},
  [1772] = {.lex_state = 0, .external_lex_state = 18},
  [1773] = {.lex_state = 0, .external_lex_state = 20},
  [1774] = {.lex_state = 0, .external_lex_state = 20},
  [1775] = {.lex_state = 0, .external_lex_state = 18},
  [1776] = {.lex_state = 0, .external_lex_state = 17},
  [1777] = {.lex_state = 0, .external_lex_state = 17},
  [1778] = {.lex_state = 0, .external_lex_state = 17},
  [1779] = {.lex_state = 0, .external_lex_state = 17},
  [1780] = {.lex_state = 0, .external_lex_state = 17},
  [1781] = {.lex_state = 0, .external_lex_state = 17},
  [1782] = {.lex_state = 0, .external_lex_state = 17},
  [1783] = {.lex_state = 0, .external_lex_state = 17},
  [1784] = {.lex_state = 0, .external_lex_state = 21},
  [1785] = {.lex_state = 0, .external_lex_state = 20},
  [1786] = {.lex_state = 0, .external_lex_state = 13},
  [1787] = {.lex_state = 0, .external_lex_state = 17},
  [1788] = {.lex_state = 0, .external_lex_state = 17},
  [1789] = {.lex_state = 0, .external_lex_state = 20},
  [1790] = {.lex_state = 0, .external_lex_state = 25},
  [1791] = {.lex_state = 0, .external_lex_state = 17},
  [1792] = {.lex_state = 0, .external_lex_state = 20},
  [1793] = {.lex_state = 0, .external_lex_state = 17},
  [1794] = {.lex_state = 0, .external_lex_state = 29},
  [1795] = {.lex_state = 0, .external_lex_state = 17},
  [1796] = {.lex_state = 0, .external_lex_state = 30},
  [1797] = {.lex_state = 0, .external_lex_state = 21},
  [1798] = {.lex_state = 0, .external_lex_state = 25},
  [1799] = {.lex_state = 0, .external_lex_state = 21},
  [1800] = {.lex_state = 0, .external_lex_state = 21},
  [1801] = {.lex_state = 0, .external_lex_state = 21},
  [1802] = {.lex_state = 0, .external_lex_state = 25},
  [1803] = {.lex_state = 0, .external_lex_state = 25},
  [1804] = {.lex_state = 0, .external_lex_state = 31},
  [1805] = {.lex_state = 0, .external_lex_state = 29},
  [1806] = {.lex_state = 0, .external_lex_state = 30},
  [1807] = {.lex_state = 0, .external_lex_state = 21},
  [1808] = {.lex_state = 0, .external_lex_state = 21},
  [1809] = {.lex_state = 0, .external_lex_state = 21},
  [1810] = {.lex_state = 0, .external_lex_state = 21},
  [1811] = {.lex_state = 0, .external_lex_state = 21},
  [1812] = {.lex_state = 0, .external_lex_state = 30},
  [1813] = {.lex_state = 0, .external_lex_state = 29},
  [1814] = {.lex_state = 0, .external_lex_state = 25},
  [1815] = {.lex_state = 0, .external_lex_state = 21},
  [1816] = {.lex_state = 0, .external_lex_state = 21},
  [1817] = {.lex_state = 0, .external_lex_state = 15},
  [1818] = {.lex_state = 0, .external_lex_state = 21},
  [1819] = {.lex_state = 0, .external_lex_state = 21},
  [1820] = {.lex_state = 0, .external_lex_state = 21},
  [1821] = {.lex_state = 0, .external_lex_state = 25},
  [1822] = {.lex_state = 0, .external_lex_state = 21},
  [1823] = {.lex_state = 0, .external_lex_state = 25},
  [1824] = {.lex_state = 0, .external_lex_state = 21},
  [1825] = {.lex_state = 0, .external_lex_state = 21},
  [1826] = {.lex_state = 0, .external_lex_state = 21},
  [1827] = {.lex_state = 0, .external_lex_state = 25},
  [1828] = {.lex_state = 0, .external_lex_state = 25},
  [1829] = {.lex_state = 0, .external_lex_state = 30},
  [1830] = {.lex_state = 0, .external_lex_state = 25},
  [1831] = {.lex_state = 0, .external_lex_state = 25},
  [1832] = {.lex_state = 0, .external_lex_state = 25},
  [1833] = {.lex_state = 0, .external_lex_state = 21},
  [1834] = {.lex_state = 0, .external_lex_state = 25},
  [1835] = {.lex_state = 0, .external_lex_state = 25},
  [1836] = {.lex_state = 0, .external_lex_state = 25},
  [1837] = {.lex_state = 0, .external_lex_state = 20},
  [1838] = {.lex_state = 0, .external_lex_state = 30},
  [1839] = {.lex_state = 0, .external_lex_state = 29},
  [1840] = {.lex_state = 0, .external_lex_state = 25},
  [1841] = {.lex_state = 0, .external_lex_state = 25},
  [1842] = {.lex_state = 0, .external_lex_state = 25},
  [1843] = {.lex_state = 0, .external_lex_state = 25},
  [1844] = {.lex_state = 0, .external_lex_state = 25},
  [1845] = {.lex_state = 0, .external_lex_state = 25},
  [1846] = {.lex_state = 0, .external_lex_state = 31},
  [1847] = {.lex_state = 0, .external_lex_state = 25},
  [1848] = {.lex_state = 0, .external_lex_state = 20},
  [1849] = {.lex_state = 0, .external_lex_state = 25},
  [1850] = {.lex_state = 0, .external_lex_state = 21},
  [1851] = {.lex_state = 0, .external_lex_state = 25},
  [1852] = {.lex_state = 0, .external_lex_state = 21},
  [1853] = {.lex_state = 0, .external_lex_state = 25},
  [1854] = {.lex_state = 0, .external_lex_state = 21},
  [1855] = {.lex_state = 0, .external_lex_state = 25},
  [1856] = {.lex_state = 0, .external_lex_state = 25},
  [1857] = {.lex_state = 0, .external_lex_state = 25},
  [1858] = {.lex_state = 0, .external_lex_state = 25},
  [1859] = {.lex_state = 0, .external_lex_state = 30},
  [1860] = {.lex_state = 0, .external_lex_state = 25},
  [1861] = {.lex_state = 0, .external_lex_state = 25},
  [1862] = {.lex_state = 0, .external_lex_state = 25},
  [1863] = {.lex_state = 0, .external_lex_state = 29},
  [1864] = {.lex_state = 0, .external_lex_state = 25},
  [1865] = {.lex_state = 0, .external_lex_state = 20},
  [1866] = {.lex_state = 0, .external_lex_state = 30},
  [1867] = {.lex_state = 0, .external_lex_state = 21},
  [1868] = {.lex_state = 0, .external_lex_state = 15},
  [1869] = {.lex_state = 0, .external_lex_state = 21},
  [1870] = {.lex_state = 0, .external_lex_state = 21},
  [1871] = {.lex_state = 0, .external_lex_state = 29},
  [1872] = {.lex_state = 0, .external_lex_state = 21},
  [1873] = {.lex_state = 0, .external_lex_state = 30},
  [1874] = {.lex_state = 0, .external_lex_state = 21},
  [1875] = {.lex_state = 0, .external_lex_state = 30},
  [1876] = {.lex_state = 0, .external_lex_state = 29},
  [1877] = {.lex_state = 0, .external_lex_state = 29},
  [1878] = {.lex_state = 0, .external_lex_state = 21},
  [1879] = {.lex_state = 0, .external_lex_state = 20},
  [1880] = {.lex_state = 0, .external_lex_state = 21},
  [1881] = {.lex_state = 0, .external_lex_state = 31},
  [1882] = {.lex_state = 0, .external_lex_state = 25},
  [1883] = {.lex_state = 0, .external_lex_state = 20},
  [1884] = {.lex_state = 0, .external_lex_state = 20},
  [1885] = {.lex_state = 0, .external_lex_state = 14},
  [1886] = {.lex_state = 0, .external_lex_state = 21},
  [1887] = {.lex_state = 0, .external_lex_state = 20},
  [1888] = {.lex_state = 0, .external_lex_state = 29},
  [1889] = {.lex_state = 0, .external_lex_state = 30},
  [1890] = {.lex_state = 0, .external_lex_state = 8},
  [1891] = {.lex_state = 0, .external_lex_state = 29},
  [1892] = {.lex_state = 0, .external_lex_state = 30},
  [1893] = {.lex_state = 0, .external_lex_state = 25},
  [1894] = {.lex_state = 0, .external_lex_state = 29},
  [1895] = {.lex_state = 0, .external_lex_state = 30},
  [1896] = {.lex_state = 0, .external_lex_state = 25},
  [1897] = {.lex_state = 0, .external_lex_state = 25},
  [1898] = {.lex_state = 0, .external_lex_state = 31},
  [1899] = {.lex_state = 0, .external_lex_state = 25},
  [1900] = {.lex_state = 0, .external_lex_state = 20},
  [1901] = {.lex_state = 0, .external_lex_state = 14},
  [1902] = {.lex_state = 0, .external_lex_state = 25},
  [1903] = {.lex_state = 0, .external_lex_state = 20},
  [1904] = {.lex_state = 0, .external_lex_state = 29},
  [1905] = {.lex_state = 0, .external_lex_state = 30},
  [1906] = {.lex_state = 0, .external_lex_state = 30},
  [1907] = {.lex_state = 0, .external_lex_state = 20},
  [1908] = {.lex_state = 0, .external_lex_state = 29},
  [1909] = {.lex_state = 0, .external_lex_state = 22},
  [1910] = {.lex_state = 0, .external_lex_state = 27},
  [1911] = {.lex_state = 0, .external_lex_state = 24},
  [1912] = {.lex_state = 0, .external_lex_state = 30},
  [1913] = {.lex_state = 0, .external_lex_state = 27},
  [1914] = {.lex_state = 0, .external_lex_state = 27},
  [1915] = {.lex_state = 0, .external_lex_state = 27},
  [1916] = {.lex_state = 0, .external_lex_state = 27},
  [1917] = {.lex_state = 0, .external_lex_state = 28},
  [1918] = {.lex_state = 0, .external_lex_state = 26},
  [1919] = {.lex_state = 0, .external_lex_state = 28},
  [1920] = {.lex_state = 0, .external_lex_state = 27},
  [1921] = {.lex_state = 0, .external_lex_state = 28},
  [1922] = {.lex_state = 0, .external_lex_state = 28},
  [1923] = {.lex_state = 0, .external_lex_state = 5},
  [1924] = {.lex_state = 0, .external_lex_state = 20},
  [1925] = {.lex_state = 0, .external_lex_state = 5},
  [1926] = {.lex_state = 0, .external_lex_state = 28},
  [1927] = {.lex_state = 0, .external_lex_state = 5},
  [1928] = {.lex_state = 0, .external_lex_state = 27},
  [1929] = {.lex_state = 0, .external_lex_state = 5},
  [1930] = {.lex_state = 0, .external_lex_state = 28},
  [1931] = {.lex_state = 0, .external_lex_state = 24},
  [1932] = {.lex_state = 0, .external_lex_state = 28},
  [1933] = {.lex_state = 0, .external_lex_state = 24},
  [1934] = {.lex_state = 0, .external_lex_state = 5},
  [1935] = {.lex_state = 0, .external_lex_state = 27},
  [1936] = {.lex_state = 0, .external_lex_state = 26},
  [1937] = {.lex_state = 0, .external_lex_state = 27},
  [1938] = {.lex_state = 0, .external_lex_state = 26},
  [1939] = {.lex_state = 0, .external_lex_state = 27},
  [1940] = {.lex_state = 0, .external_lex_state = 27},
  [1941] = {.lex_state = 0, .external_lex_state = 28},
  [1942] = {.lex_state = 0, .external_lex_state = 27},
  [1943] = {.lex_state = 0, .external_lex_state = 5},
  [1944] = {.lex_state = 0, .external_lex_state = 27},
  [1945] = {.lex_state = 0, .external_lex_state = 28},
  [1946] = {.lex_state = 0, .external_lex_state = 26},
  [1947] = {.lex_state = 0, .external_lex_state = 5},
  [1948] = {.lex_state = 0, .external_lex_state = 27},
  [1949] = {.lex_state = 0, .external_lex_state = 28},
  [1950] = {.lex_state = 0, .external_lex_state = 26},
  [1951] = {.lex_state = 0, .external_lex_state = 28},
  [1952] = {.lex_state = 0, .external_lex_state = 26},
  [1953] = {.lex_state = 0, .external_lex_state = 28},
  [1954] = {.lex_state = 0, .external_lex_state = 27},
  [1955] = {.lex_state = 0, .external_lex_state = 28},
  [1956] = {.lex_state = 0, .external_lex_state = 27},
  [1957] = {.lex_state = 0, .external_lex_state = 27},
  [1958] = {.lex_state = 0, .external_lex_state = 26},
  [1959] = {.lex_state = 0, .external_lex_state = 26},
  [1960] = {.lex_state = 0, .external_lex_state = 26},
  [1961] = {.lex_state = 0, .external_lex_state = 27},
  [1962] = {.lex_state = 0, .external_lex_state = 26},
  [1963] = {.lex_state = 0, .external_lex_state = 27},
  [1964] = {.lex_state = 0, .external_lex_state = 26},
  [1965] = {.lex_state = 0, .external_lex_state = 26},
  [1966] = {.lex_state = 0, .external_lex_state = 25},
  [1967] = {.lex_state = 0, .external_lex_state = 27},
  [1968] = {.lex_state = 0, .external_lex_state = 14},
  [1969] = {.lex_state = 0, .external_lex_state = 24},
  [1970] = {.lex_state = 0, .external_lex_state = 26},
  [1971] = {.lex_state = 0, .external_lex_state = 27},
  [1972] = {.lex_state = 0, .external_lex_state = 27},
  [1973] = {.lex_state = 0, .external_lex_state = 26},
  [1974] = {.lex_state = 0, .external_lex_state = 27},
  [1975] = {.lex_state = 0, .external_lex_state = 26},
  [1976] = {.lex_state = 0, .external_lex_state = 26},
  [1977] = {.lex_state = 0, .external_lex_state = 26},
  [1978] = {.lex_state = 0, .external_lex_state = 26},
  [1979] = {.lex_state = 0, .external_lex_state = 27},
  [1980] = {.lex_state = 0, .external_lex_state = 26},
  [1981] = {.lex_state = 0, .external_lex_state = 3},
  [1982] = {.lex_state = 0, .external_lex_state = 3},
  [1983] = {.lex_state = 0, .external_lex_state = 26},
  [1984] = {.lex_state = 0, .external_lex_state = 3},
  [1985] = {.lex_state = 0, .external_lex_state = 3},
  [1986] = {.lex_state = 0, .external_lex_state = 26},
  [1987] = {.lex_state = 0, .external_lex_state = 26},
  [1988] = {.lex_state = 0, .external_lex_state = 26},
  [1989] = {.lex_state = 0, .external_lex_state = 28},
  [1990] = {.lex_state = 0, .external_lex_state = 3},
  [1991] = {.lex_state = 0, .external_lex_state = 26},
  [1992] = {.lex_state = 0, .external_lex_state = 26},
  [1993] = {.lex_state = 0, .external_lex_state = 28},
  [1994] = {.lex_state = 0, .external_lex_state = 24},
  [1995] = {.lex_state = 0, .external_lex_state = 26},
  [1996] = {.lex_state = 0, .external_lex_state = 24},
  [1997] = {.lex_state = 0, .external_lex_state = 28},
  [1998] = {.lex_state = 0, .external_lex_state = 26},
  [1999] = {.lex_state = 0, .external_lex_state = 24},
  [2000] = {.lex_state = 0, .external_lex_state = 27},
  [2001] = {.lex_state = 0, .external_lex_state = 26},
  [2002] = {.lex_state = 0, .external_lex_state = 26},
  [2003] = {.lex_state = 0, .external_lex_state = 28},
  [2004] = {.lex_state = 0, .external_lex_state = 3},
  [2005] = {.lex_state = 0, .external_lex_state = 26},
  [2006] = {.lex_state = 0, .external_lex_state = 24},
  [2007] = {.lex_state = 0, .external_lex_state = 28},
  [2008] = {.lex_state = 0, .external_lex_state = 3},
  [2009] = {.lex_state = 0, .external_lex_state = 4},
  [2010] = {.lex_state = 0, .external_lex_state = 27},
  [2011] = {.lex_state = 0, .external_lex_state = 26},
  [2012] = {.lex_state = 0, .external_lex_state = 24},
  [2013] = {.lex_state = 0, .external_lex_state = 28},
  [2014] = {.lex_state = 0, .external_lex_state = 28},
  [2015] = {.lex_state = 0, .external_lex_state = 25},
  [2016] = {.lex_state = 0, .external_lex_state = 4},
  [2017] = {.lex_state = 0, .external_lex_state = 28},
  [2018] = {.lex_state = 0, .external_lex_state = 26},
  [2019] = {.lex_state = 0, .external_lex_state = 28},
  [2020] = {.lex_state = 0, .external_lex_state = 27},
  [2021] = {.lex_state = 0, .external_lex_state = 4},
  [2022] = {.lex_state = 0, .external_lex_state = 28},
  [2023] = {.lex_state = 0, .external_lex_state = 27},
  [2024] = {.lex_state = 0, .external_lex_state = 28},
  [2025] = {.lex_state = 0, .external_lex_state = 27},
  [2026] = {.lex_state = 0, .external_lex_state = 28},
  [2027] = {.lex_state = 0, .external_lex_state = 4},
  [2028] = {.lex_state = 0, .external_lex_state = 27},
  [2029] = {.lex_state = 0, .external_lex_state = 27},
  [2030] = {.lex_state = 0, .external_lex_state = 24},
  [2031] = {.lex_state = 0, .external_lex_state = 3},
  [2032] = {.lex_state = 0, .external_lex_state = 27},
  [2033] = {.lex_state = 0, .external_lex_state = 3},
  [2034] = {.lex_state = 0, .external_lex_state = 29},
  [2035] = {.lex_state = 0, .external_lex_state = 27},
  [2036] = {.lex_state = 0, .external_lex_state = 15},
  [2037] = {.lex_state = 0, .external_lex_state = 24},
  [2038] = {.lex_state = 0, .external_lex_state = 28},
  [2039] = {.lex_state = 0, .external_lex_state = 21},
  [2040] = {.lex_state = 0, .external_lex_state = 27},
  [2041] = {.lex_state = 0, .external_lex_state = 4},
  [2042] = {.lex_state = 0, .external_lex_state = 28},
  [2043] = {.lex_state = 0, .external_lex_state = 26},
  [2044] = {.lex_state = 0, .external_lex_state = 27},
  [2045] = {.lex_state = 0, .external_lex_state = 27},
  [2046] = {.lex_state = 0, .external_lex_state = 27},
  [2047] = {.lex_state = 0, .external_lex_state = 27},
  [2048] = {.lex_state = 0, .external_lex_state = 17},
  [2049] = {.lex_state = 0, .external_lex_state = 24},
  [2050] = {.lex_state = 0, .external_lex_state = 26},
  [2051] = {.lex_state = 0, .external_lex_state = 28},
  [2052] = {.lex_state = 0, .external_lex_state = 24},
  [2053] = {.lex_state = 0, .external_lex_state = 28},
  [2054] = {.lex_state = 0, .external_lex_state = 24},
  [2055] = {.lex_state = 0, .external_lex_state = 24},
  [2056] = {.lex_state = 0, .external_lex_state = 17},
  [2057] = {.lex_state = 0, .external_lex_state = 18},
  [2058] = {.lex_state = 0, .external_lex_state = 28},
  [2059] = {.lex_state = 0, .external_lex_state = 4},
  [2060] = {.lex_state = 0, .external_lex_state = 4},
  [2061] = {.lex_state = 0, .external_lex_state = 27},
  [2062] = {.lex_state = 0, .external_lex_state = 24},
  [2063] = {.lex_state = 0, .external_lex_state = 26},
  [2064] = {.lex_state = 0, .external_lex_state = 18},
  [2065] = {.lex_state = 0, .external_lex_state = 22},
  [2066] = {.lex_state = 0, .external_lex_state = 24},
  [2067] = {.lex_state = 0, .external_lex_state = 28},
  [2068] = {.lex_state = 0, .external_lex_state = 24},
  [2069] = {.lex_state = 0, .external_lex_state = 27},
  [2070] = {.lex_state = 0, .external_lex_state = 24},
  [2071] = {.lex_state = 0, .external_lex_state = 28},
  [2072] = {.lex_state = 0, .external_lex_state = 27},
  [2073] = {.lex_state = 0, .external_lex_state = 24},
  [2074] = {.lex_state = 0, .external_lex_state = 26},
  [2075] = {.lex_state = 0, .external_lex_state = 4},
  [2076] = {.lex_state = 0, .external_lex_state = 4},
  [2077] = {.lex_state = 0, .external_lex_state = 28},
  [2078] = {.lex_state = 0, .external_lex_state = 28},
  [2079] = {.lex_state = 0, .external_lex_state = 24},
  [2080] = {.lex_state = 0, .external_lex_state = 28},
  [2081] = {.lex_state = 0, .external_lex_state = 24},
  [2082] = {.lex_state = 0, .external_lex_state = 24},
  [2083] = {.lex_state = 0, .external_lex_state = 24},
  [2084] = {.lex_state = 0, .external_lex_state = 27},
  [2085] = {.lex_state = 0, .external_lex_state = 26},
  [2086] = {.lex_state = 0, .external_lex_state = 27},
  [2087] = {.lex_state = 0, .external_lex_state = 27},
  [2088] = {.lex_state = 0, .external_lex_state = 27},
  [2089] = {.lex_state = 0, .external_lex_state = 28},
  [2090] = {.lex_state = 0, .external_lex_state = 24},
  [2091] = {.lex_state = 0, .external_lex_state = 28},
  [2092] = {.lex_state = 0, .external_lex_state = 24},
  [2093] = {.lex_state = 0, .external_lex_state = 28},
  [2094] = {.lex_state = 0, .external_lex_state = 27},
  [2095] = {.lex_state = 0, .external_lex_state = 28},
  [2096] = {.lex_state = 0, .external_lex_state = 24},
  [2097] = {.lex_state = 0, .external_lex_state = 19},
  [2098] = {.lex_state = 0, .external_lex_state = 13},
  [2099] = {.lex_state = 0, .external_lex_state = 27},
  [2100] = {.lex_state = 0, .external_lex_state = 28},
  [2101] = {.lex_state = 0, .external_lex_state = 28},
  [2102] = {.lex_state = 0, .external_lex_state = 28},
  [2103] = {.lex_state = 0, .external_lex_state = 28},
  [2104] = {.lex_state = 0, .external_lex_state = 28},
  [2105] = {.lex_state = 0, .external_lex_state = 27},
  [2106] = {.lex_state = 0, .external_lex_state = 27},
  [2107] = {.lex_state = 0, .external_lex_state = 27},
  [2108] = {.lex_state = 0, .external_lex_state = 28},
  [2109] = {.lex_state = 0, .external_lex_state = 24},
  [2110] = {.lex_state = 0, .external_lex_state = 24},
  [2111] = {.lex_state = 0, .external_lex_state = 24},
  [2112] = {.lex_state = 0, .external_lex_state = 24},
  [2113] = {.lex_state = 0, .external_lex_state = 31},
  [2114] = {.lex_state = 0, .external_lex_state = 24},
  [2115] = {.lex_state = 0, .external_lex_state = 5},
  [2116] = {.lex_state = 0, .external_lex_state = 5},
  [2117] = {.lex_state = 0, .external_lex_state = 24},
  [2118] = {.lex_state = 0, .external_lex_state = 20},
  [2119] = {.lex_state = 0, .external_lex_state = 26},
  [2120] = {.lex_state = 0, .external_lex_state = 26},
  [2121] = {.lex_state = 0, .external_lex_state = 24},
  [2122] = {.lex_state = 0, .external_lex_state = 27},
  [2123] = {.lex_state = 0, .external_lex_state = 16},
  [2124] = {.lex_state = 0, .external_lex_state = 24},
  [2125] = {.lex_state = 0, .external_lex_state = 26},
  [2126] = {.lex_state = 0, .external_lex_state = 26},
  [2127] = {.lex_state = 0, .external_lex_state = 26},
  [2128] = {.lex_state = 0, .external_lex_state = 26},
  [2129] = {.lex_state = 0, .external_lex_state = 24},
  [2130] = {.lex_state = 0, .external_lex_state = 24},
  [2131] = {.lex_state = 0, .external_lex_state = 23},
  [2132] = {.lex_state = 0, .external_lex_state = 24},
  [2133] = {.lex_state = 0, .external_lex_state = 24},
  [2134] = {.lex_state = 0, .external_lex_state = 24},
  [2135] = {.lex_state = 0, .external_lex_state = 26},
  [2136] = {.lex_state = 0, .external_lex_state = 26},
  [2137] = {.lex_state = 0, .external_lex_state = 26},
  [2138] = {.lex_state = 0, .external_lex_state = 24},
  [2139] = {.lex_state = 0, .external_lex_state = 26},
  [2140] = {.lex_state = 0, .external_lex_state = 24},
  [2141] = {.lex_state = 0, .external_lex_state = 24},
  [2142] = {.lex_state = 0, .external_lex_state = 24},
  [2143] = {.lex_state = 0, .external_lex_state = 12},
  [2144] = {.lex_state = 0, .external_lex_state = 24},
  [2145] = {.lex_state = 0, .external_lex_state = 24},
  [2146] = {.lex_state = 0, .external_lex_state = 23},
  [2147] = {.lex_state = 0, .external_lex_state = 26},
  [2148] = {.lex_state = 0, .external_lex_state = 26},
  [2149] = {.lex_state = 0, .external_lex_state = 26},
  [2150] = {.lex_state = 0, .external_lex_state = 24},
  [2151] = {.lex_state = 0, .external_lex_state = 28},
  [2152] = {.lex_state = 0, .external_lex_state = 24},
  [2153] = {.lex_state = 0, .external_lex_state = 24},
  [2154] = {.lex_state = 0, .external_lex_state = 24},
  [2155] = {.lex_state = 0, .external_lex_state = 19},
  [2156] = {.lex_state = 0, .external_lex_state = 26},
  [2157] = {.lex_state = 0, .external_lex_state = 24},
  [2158] = {.lex_state = 0, .external_lex_state = 28},
  [2159] = {.lex_state = 0, .external_lex_state = 24},
  [2160] = {.lex_state = 0, .external_lex_state = 28},
  [2161] = {.lex_state = 0, .external_lex_state = 11},
  [2162] = {.lex_state = 0, .external_lex_state = 28},
  [2163] = {.lex_state = 0, .external_lex_state = 21},
  [2164] = {.lex_state = 0, .external_lex_state = 28},
  [2165] = {.lex_state = 0, .external_lex_state = 28},
  [2166] = {.lex_state = 0, .external_lex_state = 9},
  [2167] = {.lex_state = 0, .external_lex_state = 9},
  [2168] = {.lex_state = 0, .external_lex_state = 21},
  [2169] = {.lex_state = 0, .external_lex_state = 7},
  [2170] = {.lex_state = 0, .external_lex_state = 6},
  [2171] = {.lex_state = 0, .external_lex_state = 26},
  [2172] = {.lex_state = 0, .external_lex_state = 6},
  [2173] = {.lex_state = 0, .external_lex_state = 23},
  [2174] = {.lex_state = 0, .external_lex_state = 7},
  [2175] = {.lex_state = 0, .external_lex_state = 7},
  [2176] = {.lex_state = 0, .external_lex_state = 7},
  [2177] = {.lex_state = 0, .external_lex_state = 7},
  [2178] = {.lex_state = 0, .external_lex_state = 28},
  [2179] = {.lex_state = 0, .external_lex_state = 24},
  [2180] = {.lex_state = 0, .external_lex_state = 7},
  [2181] = {.lex_state = 0, .external_lex_state = 7},
  [2182] = {.lex_state = 0, .external_lex_state = 19},
  [2183] = {.lex_state = 0, .external_lex_state = 7},
  [2184] = {.lex_state = 0, .external_lex_state = 7},
  [2185] = {.lex_state = 0, .external_lex_state = 6},
  [2186] = {.lex_state = 0, .external_lex_state = 6},
  [2187] = {.lex_state = 0, .external_lex_state = 6},
  [2188] = {.lex_state = 0, .external_lex_state = 6},
  [2189] = {.lex_state = 0, .external_lex_state = 6},
  [2190] = {.lex_state = 0, .external_lex_state = 10},
  [2191] = {.lex_state = 0, .external_lex_state = 10},
  [2192] = {.lex_state = 0, .external_lex_state = 6},
  [2193] = {.lex_state = 0, .external_lex_state = 6},
  [2194] = {.lex_state = 0, .external_lex_state = 8},
  [2195] = {.lex_state = 0, .external_lex_state = 3},
  [2196] = {.lex_state = 0, .external_lex_state = 5},
  [2197] = {.lex_state = 0, .external_lex_state = 22},
  [2198] = {.lex_state = 0, .external_lex_state = 9},
  [2199] = {.lex_state = 0, .external_lex_state = 4},
  [2200] = {.lex_state = 0, .external_lex_state = 9},
  [2201] = {.lex_state = 0, .external_lex_state = 9},
  [2202] = {.lex_state = 0, .external_lex_state = 18},
  [2203] = {.lex_state = 0, .external_lex_state = 17},
  [2204] = {.lex_state = 0, .external_lex_state = 10},
  [2205] = {.lex_state = 0, .external_lex_state = 20},
  [2206] = {.lex_state = 0, .external_lex_state = 9},
  [2207] = {.lex_state = 0, .external_lex_state = 9},
  [2208] = {.lex_state = 0, .external_lex_state = 8},
  [2209] = {.lex_state = 0, .external_lex_state = 8},
  [2210] = {.lex_state = 0, .external_lex_state = 8},
  [2211] = {.lex_state = 0, .external_lex_state = 8},
  [2212] = {.lex_state = 0, .external_lex_state = 8},
  [2213] = {.lex_state = 0, .external_lex_state = 27},
  [2214] = {.lex_state = 0, .external_lex_state = 24},
  [2215] = {.lex_state = 0, .external_lex_state = 25},
  [2216] = {.lex_state = 0, .external_lex_state = 9},
  [2217] = {.lex_state = 0, .external_lex_state = 9},
  [2218] = {.lex_state = 0, .external_lex_state = 10},
  [2219] = {.lex_state = 0, .external_lex_state = 10},
  [2220] = {.lex_state = 0, .external_lex_state = 10},
  [2221] = {.lex_state = 0, .external_lex_state = 10},
  [2222] = {.lex_state = 0, .external_lex_state = 10},
  [2223] = {.lex_state = 0, .external_lex_state = 8},
  [2224] = {.lex_state = 0, .external_lex_state = 8},
  [2225] = {.lex_state = 0, .external_lex_state = 28},
  [2226] = {.lex_state = 0, .external_lex_state = 26},
  [2227] = {.lex_state = 0, .external_lex_state = 27},
  [2228] = {.lex_state = 0, .external_lex_state = 8},
  [2229] = {.lex_state = 0, .external_lex_state = 10},
  [2230] = {.lex_state = 0, .external_lex_state = 5},
  [2231] = {.lex_state = 0, .external_lex_state = 13},
  [2232] = {.lex_state = 0, .external_lex_state = 4},
  [2233] = {.lex_state = 0, .external_lex_state = 15},
  [2234] = {.lex_state = 0, .external_lex_state = 15},
  [2235] = {.lex_state = 0, .external_lex_state = 15},
  [2236] = {.lex_state = 0, .external_lex_state = 15},
  [2237] = {.lex_state = 0, .external_lex_state = 15},
  [2238] = {.lex_state = 0, .external_lex_state = 15},
  [2239] = {.lex_state = 0, .external_lex_state = 15},
  [2240] = {.lex_state = 0, .external_lex_state = 3},
  [2241] = {.lex_state = 0, .external_lex_state = 3},
  [2242] = {.lex_state = 0, .external_lex_state = 3},
  [2243] = {.lex_state = 0, .external_lex_state = 3},
  [2244] = {.lex_state = 0, .external_lex_state = 3},
  [2245] = {.lex_state = 0, .external_lex_state = 3},
  [2246] = {.lex_state = 0, .external_lex_state = 3},
  [2247] = {.lex_state = 0, .external_lex_state = 12},
  [2248] = {.lex_state = 0, .external_lex_state = 3},
  [2249] = {.lex_state = 0, .external_lex_state = 3},
  [2250] = {.lex_state = 0, .external_lex_state = 3},
  [2251] = {.lex_state = 0, .external_lex_state = 24},
  [2252] = {.lex_state = 0, .external_lex_state = 3},
  [2253] = {.lex_state = 0, .external_lex_state = 12},
  [2254] = {.lex_state = 0, .external_lex_state = 5},
  [2255] = {.lex_state = 0, .external_lex_state = 15},
  [2256] = {.lex_state = 0, .external_lex_state = 3},
  [2257] = {.lex_state = 0, .external_lex_state = 3},
  [2258] = {.lex_state = 0, .external_lex_state = 15},
  [2259] = {.lex_state = 0, .external_lex_state = 3},
  [2260] = {.lex_state = 0, .external_lex_state = 3},
  [2261] = {.lex_state = 0, .external_lex_state = 3},
  [2262] = {.lex_state = 0, .external_lex_state = 12},
  [2263] = {.lex_state = 0, .external_lex_state = 12},
  [2264] = {.lex_state = 0, .external_lex_state = 12},
  [2265] = {.lex_state = 0, .external_lex_state = 12},
  [2266] = {.lex_state = 0, .external_lex_state = 12},
  [2267] = {.lex_state = 0, .external_lex_state = 3},
  [2268] = {.lex_state = 0, .external_lex_state = 3},
  [2269] = {.lex_state = 0, .external_lex_state = 12},
  [2270] = {.lex_state = 0, .external_lex_state = 11},
  [2271] = {.lex_state = 0, .external_lex_state = 11},
  [2272] = {.lex_state = 0, .external_lex_state = 11},
  [2273] = {.lex_state = 0, .external_lex_state = 11},
  [2274] = {.lex_state = 0, .external_lex_state = 11},
  [2275] = {.lex_state = 0, .external_lex_state = 3},
  [2276] = {.lex_state = 0, .external_lex_state = 11},
  [2277] = {.lex_state = 0, .external_lex_state = 11},
  [2278] = {.lex_state = 0, .external_lex_state = 11},
  [2279] = {.lex_state = 0, .external_lex_state = 11},
  [2280] = {.lex_state = 0, .external_lex_state = 3},
  [2281] = {.lex_state = 0, .external_lex_state = 7},
  [2282] = {.lex_state = 0, .external_lex_state = 3},
  [2283] = {.lex_state = 0, .external_lex_state = 3},
  [2284] = {.lex_state = 0, .external_lex_state = 12},
  [2285] = {.lex_state = 0, .external_lex_state = 3},
  [2286] = {.lex_state = 0, .external_lex_state = 16},
  [2287] = {.lex_state = 0, .external_lex_state = 16},
  [2288] = {.lex_state = 0, .external_lex_state = 16},
  [2289] = {.lex_state = 0, .external_lex_state = 16},
  [2290] = {.lex_state = 0, .external_lex_state = 16},
  [2291] = {.lex_state = 0, .external_lex_state = 16},
  [2292] = {.lex_state = 0, .external_lex_state = 16},
  [2293] = {.lex_state = 0, .external_lex_state = 3},
  [2294] = {.lex_state = 0, .external_lex_state = 4},
  [2295] = {.lex_state = 0, .external_lex_state = 16},
  [2296] = {.lex_state = 0, .external_lex_state = 16},
  [2297] = {.lex_state = 0, .external_lex_state = 4},
  [2298] = {.lex_state = 0, .external_lex_state = 4},
  [2299] = {.lex_state = 0, .external_lex_state = 14},
  [2300] = {.lex_state = 0, .external_lex_state = 14},
  [2301] = {.lex_state = 0, .external_lex_state = 5},
  [2302] = {.lex_state = 0, .external_lex_state = 9},
  [2303] = {.lex_state = 0, .external_lex_state = 10},
  [2304] = {.lex_state = 0, .external_lex_state = 4},
  [2305] = {.lex_state = 0, .external_lex_state = 27},
  [2306] = {.lex_state = 0, .external_lex_state = 14},
  [2307] = {.lex_state = 0, .external_lex_state = 14},
  [2308] = {.lex_state = 0, .external_lex_state = 5},
  [2309] = {.lex_state = 0, .external_lex_state = 14},
  [2310] = {.lex_state = 0, .external_lex_state = 14},
  [2311] = {.lex_state = 0, .external_lex_state = 14},
  [2312] = {.lex_state = 0, .external_lex_state = 14},
  [2313] = {.lex_state = 0, .external_lex_state = 14},
  [2314] = {.lex_state = 0, .external_lex_state = 5},
  [2315] = {.lex_state = 0, .external_lex_state = 4},
  [2316] = {.lex_state = 0, .external_lex_state = 4},
  [2317] = {.lex_state = 0, .external_lex_state = 4},
  [2318] = {.lex_state = 0, .external_lex_state = 4},
  [2319] = {.lex_state = 0, .external_lex_state = 4},
  [2320] = {.lex_state = 0, .external_lex_state = 4},
  [2321] = {.lex_state = 0, .external_lex_state = 4},
  [2322] = {.lex_state = 0, .external_lex_state = 4},
  [2323] = {.lex_state = 0, .external_lex_state = 4},
  [2324] = {.lex_state = 0, .external_lex_state = 4},
  [2325] = {.lex_state = 0, .external_lex_state = 4},
  [2326] = {.lex_state = 0, .external_lex_state = 4},
  [2327] = {.lex_state = 0, .external_lex_state = 4},
  [2328] = {.lex_state = 0, .external_lex_state = 4},
  [2329] = {.lex_state = 0, .external_lex_state = 4},
  [2330] = {.lex_state = 0, .external_lex_state = 4},
  [2331] = {.lex_state = 0, .external_lex_state = 4},
  [2332] = {.lex_state = 0, .external_lex_state = 4},
  [2333] = {.lex_state = 0, .external_lex_state = 4},
  [2334] = {.lex_state = 0, .external_lex_state = 13},
  [2335] = {.lex_state = 0, .external_lex_state = 13},
  [2336] = {.lex_state = 0, .external_lex_state = 6},
  [2337] = {.lex_state = 0, .external_lex_state = 5},
  [2338] = {.lex_state = 0, .external_lex_state = 26},
  [2339] = {.lex_state = 0, .external_lex_state = 5},
  [2340] = {.lex_state = 0, .external_lex_state = 5},
  [2341] = {.lex_state = 0, .external_lex_state = 5},
  [2342] = {.lex_state = 0, .external_lex_state = 5},
  [2343] = {.lex_state = 0, .external_lex_state = 5},
  [2344] = {.lex_state = 0, .external_lex_state = 13},
  [2345] = {.lex_state = 0, .external_lex_state = 13},
  [2346] = {.lex_state = 0, .external_lex_state = 5},
  [2347] = {.lex_state = 0, .external_lex_state = 5},
  [2348] = {.lex_state = 0, .external_lex_state = 5},
  [2349] = {.lex_state = 0, .external_lex_state = 8},
  [2350] = {.lex_state = 0, .external_lex_state = 5},
  [2351] = {.lex_state = 0, .external_lex_state = 5},
  [2352] = {.lex_state = 0, .external_lex_state = 5},
  [2353] = {.lex_state = 0, .external_lex_state = 28},
  [2354] = {.lex_state = 0, .external_lex_state = 13},
  [2355] = {.lex_state = 0, .external_lex_state = 13},
  [2356] = {.lex_state = 0, .external_lex_state = 13},
  [2357] = {.lex_state = 0, .external_lex_state = 5},
  [2358] = {.lex_state = 0, .external_lex_state = 5},
  [2359] = {.lex_state = 0, .external_lex_state = 13},
  [2360] = {.lex_state = 0, .external_lex_state = 5},
  [2361] = {.lex_state = 0, .external_lex_state = 5},
  [2362] = {.lex_state = 0, .external_lex_state = 5},
  [2363] = {.lex_state = 0, .external_lex_state = 5},
  [2364] = {.lex_state = 0, .external_lex_state = 5},
  [2365] = {.lex_state = 0, .external_lex_state = 7},
  [2366] = {.lex_state = 0, .external_lex_state = 18},
  [2367] = {.lex_state = 0, .external_lex_state = 17},
  [2368] = {.lex_state = 0, .external_lex_state = 17},
  [2369] = {.lex_state = 0, .external_lex_state = 17},
  [2370] = {.lex_state = 0, .external_lex_state = 17},
  [2371] = {.lex_state = 0, .external_lex_state = 17},
  [2372] = {.lex_state = 0, .external_lex_state = 17},
  [2373] = {.lex_state = 0, .external_lex_state = 17},
  [2374] = {.lex_state = 0, .external_lex_state = 6},
  [2375] = {.lex_state = 0, .external_lex_state = 21},
  [2376] = {.lex_state = 0, .external_lex_state = 21},
  [2377] = {.lex_state = 0, .external_lex_state = 23},
  [2378] = {.lex_state = 0, .external_lex_state = 23},
  [2379] = {.lex_state = 0, .external_lex_state = 10},
  [2380] = {.lex_state = 0, .external_lex_state = 6},
  [2381] = {.lex_state = 0, .external_lex_state = 23},
  [2382] = {.lex_state = 0, .external_lex_state = 23},
  [2383] = {.lex_state = 0, .external_lex_state = 23},
  [2384] = {.lex_state = 0, .external_lex_state = 10},
  [2385] = {.lex_state = 0, .external_lex_state = 6},
  [2386] = {.lex_state = 0, .external_lex_state = 23},
  [2387] = {.lex_state = 0, .external_lex_state = 18},
  [2388] = {.lex_state = 0, .external_lex_state = 6},
  [2389] = {.lex_state = 0, .external_lex_state = 18},
  [2390] = {.lex_state = 0, .external_lex_state = 23},
  [2391] = {.lex_state = 0, .external_lex_state = 10},
  [2392] = {.lex_state = 0, .external_lex_state = 18},
  [2393] = {.lex_state = 0, .external_lex_state = 9},
  [2394] = {.lex_state = 0, .external_lex_state = 8},
  [2395] = {.lex_state = 0, .external_lex_state = 23},
  [2396] = {.lex_state = 0, .external_lex_state = 23},
  [2397] = {.lex_state = 0, .external_lex_state = 18},
  [2398] = {.lex_state = 0, .external_lex_state = 12},
  [2399] = {.lex_state = 0, .external_lex_state = 14},
  [2400] = {.lex_state = 0, .external_lex_state = 15},
  [2401] = {.lex_state = 0, .external_lex_state = 10},
  [2402] = {.lex_state = 0, .external_lex_state = 6},
  [2403] = {.lex_state = 0, .external_lex_state = 10},
  [2404] = {.lex_state = 0, .external_lex_state = 10},
  [2405] = {.lex_state = 0, .external_lex_state = 9},
  [2406] = {.lex_state = 0, .external_lex_state = 10},
  [2407] = {.lex_state = 0, .external_lex_state = 6},
  [2408] = {.lex_state = 0, .external_lex_state = 10},
  [2409] = {.lex_state = 0, .external_lex_state = 9},
  [2410] = {.lex_state = 0, .external_lex_state = 7},
  [2411] = {.lex_state = 0, .external_lex_state = 7},
  [2412] = {.lex_state = 0, .external_lex_state = 18},
  [2413] = {.lex_state = 0, .external_lex_state = 10},
  [2414] = {.lex_state = 0, .external_lex_state = 6},
  [2415] = {.lex_state = 0, .external_lex_state = 6},
  [2416] = {.lex_state = 0, .external_lex_state = 6},
  [2417] = {.lex_state = 0, .external_lex_state = 6},
  [2418] = {.lex_state = 0, .external_lex_state = 6},
  [2419] = {.lex_state = 0, .external_lex_state = 10},
  [2420] = {.lex_state = 0, .external_lex_state = 10},
  [2421] = {.lex_state = 0, .external_lex_state = 10},
  [2422] = {.lex_state = 0, .external_lex_state = 10},
  [2423] = {.lex_state = 0, .external_lex_state = 19},
  [2424] = {.lex_state = 0, .external_lex_state = 19},
  [2425] = {.lex_state = 0, .external_lex_state = 9},
  [2426] = {.lex_state = 0, .external_lex_state = 6},
  [2427] = {.lex_state = 0, .external_lex_state = 6},
  [2428] = {.lex_state = 0, .external_lex_state = 20},
  [2429] = {.lex_state = 0, .external_lex_state = 20},
  [2430] = {.lex_state = 0, .external_lex_state = 18},
  [2431] = {.lex_state = 0, .external_lex_state = 10},
  [2432] = {.lex_state = 0, .external_lex_state = 9},
  [2433] = {.lex_state = 0, .external_lex_state = 19},
  [2434] = {.lex_state = 0, .external_lex_state = 19},
  [2435] = {.lex_state = 0, .external_lex_state = 9},
  [2436] = {.lex_state = 0, .external_lex_state = 9},
  [2437] = {.lex_state = 0, .external_lex_state = 19},
  [2438] = {.lex_state = 0, .external_lex_state = 9},
  [2439] = {.lex_state = 0, .external_lex_state = 9},
  [2440] = {.lex_state = 0, .external_lex_state = 9},
  [2441] = {.lex_state = 0, .external_lex_state = 22},
  [2442] = {.lex_state = 0, .external_lex_state = 19},
  [2443] = {.lex_state = 0, .external_lex_state = 9},
  [2444] = {.lex_state = 0, .external_lex_state = 9},
  [2445] = {.lex_state = 0, .external_lex_state = 19},
  [2446] = {.lex_state = 0, .external_lex_state = 8},
  [2447] = {.lex_state = 0, .external_lex_state = 10},
  [2448] = {.lex_state = 0, .external_lex_state = 22},
  [2449] = {.lex_state = 0, .external_lex_state = 19},
  [2450] = {.lex_state = 0, .external_lex_state = 6},
  [2451] = {.lex_state = 0, .external_lex_state = 9},
  [2452] = {.lex_state = 0, .external_lex_state = 9},
  [2453] = {.lex_state = 0, .external_lex_state = 9},
  [2454] = {.lex_state = 0, .external_lex_state = 9},
  [2455] = {.lex_state = 0, .external_lex_state = 9},
  [2456] = {.lex_state = 0, .external_lex_state = 22},
  [2457] = {.lex_state = 0, .external_lex_state = 9},
  [2458] = {.lex_state = 0, .external_lex_state = 9},
  [2459] = {.lex_state = 0, .external_lex_state = 8},
  [2460] = {.lex_state = 0, .external_lex_state = 16},
  [2461] = {.lex_state = 0, .external_lex_state = 6},
  [2462] = {.lex_state = 0, .external_lex_state = 21},
  [2463] = {.lex_state = 0, .external_lex_state = 7},
  [2464] = {.lex_state = 0, .external_lex_state = 7},
  [2465] = {.lex_state = 0, .external_lex_state = 13},
  [2466] = {.lex_state = 0, .external_lex_state = 18},
  [2467] = {.lex_state = 0, .external_lex_state = 7},
  [2468] = {.lex_state = 0, .external_lex_state = 7},
  [2469] = {.lex_state = 0, .external_lex_state = 7},
  [2470] = {.lex_state = 0, .external_lex_state = 7},
  [2471] = {.lex_state = 0, .external_lex_state = 7},
  [2472] = {.lex_state = 0, .external_lex_state = 7},
  [2473] = {.lex_state = 0, .external_lex_state = 9},
  [2474] = {.lex_state = 0, .external_lex_state = 9},
  [2475] = {.lex_state = 0, .external_lex_state = 9},
  [2476] = {.lex_state = 0, .external_lex_state = 9},
  [2477] = {.lex_state = 0, .external_lex_state = 8},
  [2478] = {.lex_state = 0, .external_lex_state = 22},
  [2479] = {.lex_state = 0, .external_lex_state = 20},
  [2480] = {.lex_state = 0, .external_lex_state = 7},
  [2481] = {.lex_state = 0, .external_lex_state = 21},
  [2482] = {.lex_state = 0, .external_lex_state = 20},
  [2483] = {.lex_state = 0, .external_lex_state = 22},
  [2484] = {.lex_state = 0, .external_lex_state = 21},
  [2485] = {.lex_state = 0, .external_lex_state = 7},
  [2486] = {.lex_state = 0, .external_lex_state = 22},
  [2487] = {.lex_state = 0, .external_lex_state = 7},
  [2488] = {.lex_state = 0, .external_lex_state = 6},
  [2489] = {.lex_state = 0, .external_lex_state = 6},
  [2490] = {.lex_state = 0, .external_lex_state = 7},
  [2491] = {.lex_state = 0, .external_lex_state = 6},
  [2492] = {.lex_state = 0, .external_lex_state = 20},
  [2493] = {.lex_state = 0, .external_lex_state = 7},
  [2494] = {.lex_state = 0, .external_lex_state = 21},
  [2495] = {.lex_state = 0, .external_lex_state = 6},
  [2496] = {.lex_state = 0, .external_lex_state = 8},
  [2497] = {.lex_state = 0, .external_lex_state = 25},
  [2498] = {.lex_state = 0, .external_lex_state = 10},
  [2499] = {.lex_state = 0, .external_lex_state = 25},
  [2500] = {.lex_state = 0, .external_lex_state = 8},
  [2501] = {.lex_state = 0, .external_lex_state = 8},
  [2502] = {.lex_state = 0, .external_lex_state = 8},
  [2503] = {.lex_state = 0, .external_lex_state = 11},
  [2504] = {.lex_state = 0, .external_lex_state = 10},
  [2505] = {.lex_state = 0, .external_lex_state = 7},
  [2506] = {.lex_state = 0, .external_lex_state = 10},
  [2507] = {.lex_state = 0, .external_lex_state = 7},
  [2508] = {.lex_state = 0, .external_lex_state = 10},
  [2509] = {.lex_state = 0, .external_lex_state = 7},
  [2510] = {.lex_state = 0, .external_lex_state = 10},
  [2511] = {.lex_state = 0, .external_lex_state = 6},
  [2512] = {.lex_state = 0, .external_lex_state = 6},
  [2513] = {.lex_state = 0, .external_lex_state = 6},
  [2514] = {.lex_state = 0, .external_lex_state = 22},
  [2515] = {.lex_state = 0, .external_lex_state = 8},
  [2516] = {.lex_state = 0, .external_lex_state = 8},
  [2517] = {.lex_state = 0, .external_lex_state = 8},
  [2518] = {.lex_state = 0, .external_lex_state = 7},
  [2519] = {.lex_state = 0, .external_lex_state = 8},
  [2520] = {.lex_state = 0, .external_lex_state = 10},
  [2521] = {.lex_state = 0, .external_lex_state = 10},
  [2522] = {.lex_state = 0, .external_lex_state = 20},
  [2523] = {.lex_state = 0, .external_lex_state = 20},
  [2524] = {.lex_state = 0, .external_lex_state = 8},
  [2525] = {.lex_state = 0, .external_lex_state = 8},
  [2526] = {.lex_state = 0, .external_lex_state = 7},
  [2527] = {.lex_state = 0, .external_lex_state = 8},
  [2528] = {.lex_state = 0, .external_lex_state = 20},
  [2529] = {.lex_state = 0, .external_lex_state = 20},
  [2530] = {.lex_state = 0, .external_lex_state = 19},
  [2531] = {.lex_state = 0, .external_lex_state = 10},
  [2532] = {.lex_state = 0, .external_lex_state = 25},
  [2533] = {.lex_state = 0, .external_lex_state = 6},
  [2534] = {.lex_state = 0, .external_lex_state = 25},
  [2535] = {.lex_state = 0, .external_lex_state = 7},
  [2536] = {.lex_state = 0, .external_lex_state = 25},
  [2537] = {.lex_state = 0, .external_lex_state = 10},
  [2538] = {.lex_state = 0, .external_lex_state = 25},
  [2539] = {.lex_state = 0, .external_lex_state = 25},
  [2540] = {.lex_state = 0, .external_lex_state = 21},
  [2541] = {.lex_state = 0, .external_lex_state = 21},
  [2542] = {.lex_state = 0, .external_lex_state = 7},
  [2543] = {.lex_state = 0, .external_lex_state = 21},
  [2544] = {.lex_state = 0, .external_lex_state = 25},
  [2545] = {.lex_state = 0, .external_lex_state = 8},
  [2546] = {.lex_state = 0, .external_lex_state = 25},
  [2547] = {.lex_state = 0, .external_lex_state = 7},
  [2548] = {.lex_state = 0, .external_lex_state = 22},
  [2549] = {.lex_state = 0, .external_lex_state = 22},
  [2550] = {.lex_state = 0, .external_lex_state = 8},
  [2551] = {.lex_state = 0, .external_lex_state = 8},
  [2552] = {.lex_state = 0, .external_lex_state = 6},
  [2553] = {.lex_state = 0, .external_lex_state = 8},
  [2554] = {.lex_state = 0, .external_lex_state = 8},
  [2555] = {.lex_state = 0, .external_lex_state = 8},
  [2556] = {.lex_state = 0, .external_lex_state = 8},
  [2557] = {.lex_state = 0, .external_lex_state = 8},
  [2558] = {.lex_state = 0, .external_lex_state = 18},
  [2559] = {.lex_state = 0, .external_lex_state = 17},
  [2560] = {.lex_state = 0, .external_lex_state = 17},
  [2561] = {.lex_state = 0, .external_lex_state = 16},
  [2562] = {.lex_state = 0, .external_lex_state = 26},
  [2563] = {.lex_state = 0, .external_lex_state = 26},
  [2564] = {.lex_state = 0, .external_lex_state = 26},
  [2565] = {.lex_state = 0, .external_lex_state = 26},
  [2566] = {.lex_state = 0, .external_lex_state = 27},
  [2567] = {.lex_state = 0, .external_lex_state = 24},
  [2568] = {.lex_state = 0, .external_lex_state = 11},
  [2569] = {.lex_state = 0, .external_lex_state = 15},
  [2570] = {.lex_state = 0, .external_lex_state = 12},
  [2571] = {.lex_state = 0, .external_lex_state = 12},
  [2572] = {.lex_state = 0, .external_lex_state = 12},
  [2573] = {.lex_state = 0, .external_lex_state = 27},
  [2574] = {.lex_state = 0, .external_lex_state = 12},
  [2575] = {.lex_state = 0, .external_lex_state = 11},
  [2576] = {.lex_state = 0, .external_lex_state = 17},
  [2577] = {.lex_state = 0, .external_lex_state = 11},
  [2578] = {.lex_state = 0, .external_lex_state = 24},
  [2579] = {.lex_state = 0, .external_lex_state = 14},
  [2580] = {.lex_state = 0, .external_lex_state = 15},
  [2581] = {.lex_state = 0, .external_lex_state = 14},
  [2582] = {.lex_state = 0, .external_lex_state = 14},
  [2583] = {.lex_state = 0, .external_lex_state = 15},
  [2584] = {.lex_state = 0, .external_lex_state = 14},
  [2585] = {.lex_state = 0, .external_lex_state = 14},
  [2586] = {.lex_state = 0, .external_lex_state = 15},
  [2587] = {.lex_state = 0, .external_lex_state = 14},
  [2588] = {.lex_state = 0, .external_lex_state = 12},
  [2589] = {.lex_state = 0, .external_lex_state = 14},
  [2590] = {.lex_state = 0, .external_lex_state = 14},
  [2591] = {.lex_state = 0, .external_lex_state = 14},
  [2592] = {.lex_state = 0, .external_lex_state = 14},
  [2593] = {.lex_state = 0, .external_lex_state = 15},
  [2594] = {.lex_state = 0, .external_lex_state = 14},
  [2595] = {.lex_state = 0, .external_lex_state = 14},
  [2596] = {.lex_state = 0, .external_lex_state = 12},
  [2597] = {.lex_state = 0, .external_lex_state = 28},
  [2598] = {.lex_state = 0, .external_lex_state = 11},
  [2599] = {.lex_state = 0, .external_lex_state = 16},
  [2600] = {.lex_state = 0, .external_lex_state = 16},
  [2601] = {.lex_state = 0, .external_lex_state = 16},
  [2602] = {.lex_state = 0, .external_lex_state = 12},
  [2603] = {.lex_state = 0, .external_lex_state = 14},
  [2604] = {.lex_state = 0, .external_lex_state = 16},
  [2605] = {.lex_state = 0, .external_lex_state = 12},
  [2606] = {.lex_state = 0, .external_lex_state = 27},
  [2607] = {.lex_state = 0, .external_lex_state = 12},
  [2608] = {.lex_state = 0, .external_lex_state = 14},
  [2609] = {.lex_state = 0, .external_lex_state = 14},
  [2610] = {.lex_state = 0, .external_lex_state = 14},
  [2611] = {.lex_state = 0, .external_lex_state = 14},
  [2612] = {.lex_state = 0, .external_lex_state = 12},
  [2613] = {.lex_state = 0, .external_lex_state = 12},
  [2614] = {.lex_state = 0, .external_lex_state = 13},
  [2615] = {.lex_state = 0, .external_lex_state = 12},
  [2616] = {.lex_state = 0, .external_lex_state = 28},
  [2617] = {.lex_state = 0, .external_lex_state = 19},
  [2618] = {.lex_state = 0, .external_lex_state = 13},
  [2619] = {.lex_state = 0, .external_lex_state = 13},
  [2620] = {.lex_state = 0, .external_lex_state = 24},
  [2621] = {.lex_state = 0, .external_lex_state = 16},
  [2622] = {.lex_state = 0, .external_lex_state = 16},
  [2623] = {.lex_state = 0, .external_lex_state = 16},
  [2624] = {.lex_state = 0, .external_lex_state = 16},
  [2625] = {.lex_state = 0, .external_lex_state = 14},
  [2626] = {.lex_state = 0, .external_lex_state = 16},
  [2627] = {.lex_state = 0, .external_lex_state = 16},
  [2628] = {.lex_state = 0, .external_lex_state = 14},
  [2629] = {.lex_state = 0, .external_lex_state = 16},
  [2630] = {.lex_state = 0, .external_lex_state = 24},
  [2631] = {.lex_state = 0, .external_lex_state = 24},
  [2632] = {.lex_state = 0, .external_lex_state = 15},
  [2633] = {.lex_state = 0, .external_lex_state = 24},
  [2634] = {.lex_state = 0, .external_lex_state = 15},
  [2635] = {.lex_state = 0, .external_lex_state = 15},
  [2636] = {.lex_state = 0, .external_lex_state = 28},
  [2637] = {.lex_state = 0, .external_lex_state = 18},
  [2638] = {.lex_state = 0, .external_lex_state = 15},
  [2639] = {.lex_state = 0, .external_lex_state = 22},
  [2640] = {.lex_state = 0, .external_lex_state = 13},
  [2641] = {.lex_state = 0, .external_lex_state = 14},
  [2642] = {.lex_state = 0, .external_lex_state = 27},
  [2643] = {.lex_state = 0, .external_lex_state = 13},
  [2644] = {.lex_state = 0, .external_lex_state = 27},
  [2645] = {.lex_state = 0, .external_lex_state = 16},
  [2646] = {.lex_state = 0, .external_lex_state = 16},
  [2647] = {.lex_state = 0, .external_lex_state = 15},
  [2648] = {.lex_state = 0, .external_lex_state = 16},
  [2649] = {.lex_state = 0, .external_lex_state = 27},
  [2650] = {.lex_state = 0, .external_lex_state = 15},
  [2651] = {.lex_state = 0, .external_lex_state = 16},
  [2652] = {.lex_state = 0, .external_lex_state = 16},
  [2653] = {.lex_state = 0, .external_lex_state = 16},
  [2654] = {.lex_state = 0, .external_lex_state = 27},
  [2655] = {.lex_state = 0, .external_lex_state = 12},
  [2656] = {.lex_state = 0, .external_lex_state = 27},
  [2657] = {.lex_state = 0, .external_lex_state = 16},
  [2658] = {.lex_state = 0, .external_lex_state = 28},
  [2659] = {.lex_state = 0, .external_lex_state = 15},
  [2660] = {.lex_state = 0, .external_lex_state = 12},
  [2661] = {.lex_state = 0, .external_lex_state = 12},
  [2662] = {.lex_state = 0, .external_lex_state = 16},
  [2663] = {.lex_state = 0, .external_lex_state = 12},
  [2664] = {.lex_state = 0, .external_lex_state = 28},
  [2665] = {.lex_state = 0, .external_lex_state = 27},
  [2666] = {.lex_state = 0, .external_lex_state = 13},
  [2667] = {.lex_state = 0, .external_lex_state = 26},
  [2668] = {.lex_state = 0, .external_lex_state = 28},
  [2669] = {.lex_state = 0, .external_lex_state = 15},
  [2670] = {.lex_state = 0, .external_lex_state = 21},
  [2671] = {.lex_state = 0, .external_lex_state = 12},
  [2672] = {.lex_state = 0, .external_lex_state = 15},
  [2673] = {.lex_state = 0, .external_lex_state = 24},
  [2674] = {.lex_state = 0, .external_lex_state = 14},
  [2675] = {.lex_state = 0, .external_lex_state = 13},
  [2676] = {.lex_state = 0, .external_lex_state = 13},
  [2677] = {.lex_state = 0, .external_lex_state = 13},
  [2678] = {.lex_state = 0, .external_lex_state = 13},
  [2679] = {.lex_state = 0, .external_lex_state = 13},
  [2680] = {.lex_state = 0, .external_lex_state = 20},
  [2681] = {.lex_state = 0, .external_lex_state = 15},
  [2682] = {.lex_state = 0, .external_lex_state = 24},
  [2683] = {.lex_state = 0, .external_lex_state = 13},
  [2684] = {.lex_state = 0, .external_lex_state = 13},
  [2685] = {.lex_state = 0, .external_lex_state = 13},
  [2686] = {.lex_state = 0, .external_lex_state = 12},
  [2687] = {.lex_state = 0, .external_lex_state = 12},
  [2688] = {.lex_state = 0, .external_lex_state = 24},
  [2689] = {.lex_state = 0, .external_lex_state = 14},
  [2690] = {.lex_state = 0, .external_lex_state = 12},
  [2691] = {.lex_state = 0, .external_lex_state = 14},
  [2692] = {.lex_state = 0, .external_lex_state = 13},
  [2693] = {.lex_state = 0, .external_lex_state = 13},
  [2694] = {.lex_state = 0, .external_lex_state = 13},
  [2695] = {.lex_state = 0, .external_lex_state = 13},
  [2696] = {.lex_state = 0, .external_lex_state = 13},
  [2697] = {.lex_state = 0, .external_lex_state = 13},
  [2698] = {.lex_state = 0, .external_lex_state = 13},
  [2699] = {.lex_state = 0, .external_lex_state = 15},
  [2700] = {.lex_state = 0, .external_lex_state = 28},
  [2701] = {.lex_state = 0, .external_lex_state = 28},
  [2702] = {.lex_state = 0, .external_lex_state = 16},
  [2703] = {.lex_state = 0, .external_lex_state = 11},
  [2704] = {.lex_state = 0, .external_lex_state = 11},
  [2705] = {.lex_state = 0, .external_lex_state = 11},
  [2706] = {.lex_state = 0, .external_lex_state = 11},
  [2707] = {.lex_state = 0, .external_lex_state = 15},
  [2708] = {.lex_state = 0, .external_lex_state = 15},
  [2709] = {.lex_state = 0, .external_lex_state = 12},
  [2710] = {.lex_state = 0, .external_lex_state = 16},
  [2711] = {.lex_state = 0, .external_lex_state = 11},
  [2712] = {.lex_state = 0, .external_lex_state = 11},
  [2713] = {.lex_state = 0, .external_lex_state = 11},
  [2714] = {.lex_state = 0, .external_lex_state = 11},
  [2715] = {.lex_state = 0, .external_lex_state = 11},
  [2716] = {.lex_state = 0, .external_lex_state = 11},
  [2717] = {.lex_state = 0, .external_lex_state = 11},
  [2718] = {.lex_state = 0, .external_lex_state = 26},
  [2719] = {.lex_state = 0, .external_lex_state = 13},
  [2720] = {.lex_state = 0, .external_lex_state = 15},
  [2721] = {.lex_state = 0, .external_lex_state = 15},
  [2722] = {.lex_state = 0, .external_lex_state = 23},
  [2723] = {.lex_state = 0, .external_lex_state = 16},
  [2724] = {.lex_state = 0, .external_lex_state = 11},
  [2725] = {.lex_state = 0, .external_lex_state = 15},
  [2726] = {.lex_state = 0, .external_lex_state = 15},
  [2727] = {.lex_state = 0, .external_lex_state = 11},
  [2728] = {.lex_state = 0, .external_lex_state = 12},
  [2729] = {.lex_state = 0, .external_lex_state = 11},
  [2730] = {.lex_state = 0, .external_lex_state = 11},
  [2731] = {.lex_state = 0, .external_lex_state = 11},
  [2732] = {.lex_state = 0, .external_lex_state = 11},
  [2733] = {.lex_state = 0, .external_lex_state = 15},
  [2734] = {.lex_state = 0, .external_lex_state = 11},
  [2735] = {.lex_state = 0, .external_lex_state = 24},
  [2736] = {.lex_state = 0, .external_lex_state = 12},
  [2737] = {.lex_state = 0, .external_lex_state = 26},
  [2738] = {.lex_state = 0, .external_lex_state = 26},
  [2739] = {.lex_state = 0, .external_lex_state = 26},
  [2740] = {.lex_state = 0, .external_lex_state = 11},
  [2741] = {.lex_state = 0, .external_lex_state = 28},
  [2742] = {.lex_state = 0, .external_lex_state = 25},
  [2743] = {.lex_state = 0, .external_lex_state = 13},
  [2744] = {.lex_state = 0, .external_lex_state = 27},
  [2745] = {.lex_state = 0, .external_lex_state = 28},
  [2746] = {.lex_state = 0, .external_lex_state = 19},
  [2747] = {.lex_state = 0, .external_lex_state = 17},
  [2748] = {.lex_state = 0, .external_lex_state = 21},
  [2749] = {.lex_state = 0, .external_lex_state = 18},
  [2750] = {.lex_state = 0, .external_lex_state = 21},
  [2751] = {.lex_state = 0, .external_lex_state = 25},
  [2752] = {.lex_state = 0, .external_lex_state = 19},
  [2753] = {.lex_state = 0, .external_lex_state = 19},
  [2754] = {.lex_state = 0, .external_lex_state = 25},
  [2755] = {.lex_state = 0, .external_lex_state = 19},
  [2756] = {.lex_state = 0, .external_lex_state = 19},
  [2757] = {.lex_state = 0, .external_lex_state = 18},
  [2758] = {.lex_state = 0, .external_lex_state = 25},
  [2759] = {.lex_state = 0, .external_lex_state = 20},
  [2760] = {.lex_state = 0, .external_lex_state = 19},
  [2761] = {.lex_state = 0, .external_lex_state = 22},
  [2762] = {.lex_state = 0, .external_lex_state = 18},
  [2763] = {.lex_state = 0, .external_lex_state = 19},
  [2764] = {.lex_state = 0, .external_lex_state = 19},
  [2765] = {.lex_state = 0, .external_lex_state = 19},
  [2766] = {.lex_state = 0, .external_lex_state = 17},
  [2767] = {.lex_state = 0, .external_lex_state = 18},
  [2768] = {.lex_state = 0, .external_lex_state = 17},
  [2769] = {.lex_state = 0, .external_lex_state = 19},
  [2770] = {.lex_state = 0, .external_lex_state = 17},
  [2771] = {.lex_state = 0, .external_lex_state = 19},
  [2772] = {.lex_state = 0, .external_lex_state = 31},
  [2773] = {.lex_state = 0, .external_lex_state = 23},
  [2774] = {.lex_state = 0, .external_lex_state = 19},
  [2775] = {.lex_state = 0, .external_lex_state = 19},
  [2776] = {.lex_state = 0, .external_lex_state = 19},
  [2777] = {.lex_state = 0, .external_lex_state = 21},
  [2778] = {.lex_state = 0, .external_lex_state = 2},
  [2779] = {.lex_state = 0, .external_lex_state = 21},
  [2780] = {.lex_state = 0, .external_lex_state = 18},
  [2781] = {.lex_state = 0, .external_lex_state = 17},
  [2782] = {.lex_state = 0, .external_lex_state = 17},
  [2783] = {.lex_state = 0, .external_lex_state = 20},
  [2784] = {.lex_state = 0, .external_lex_state = 17},
  [2785] = {.lex_state = 0, .external_lex_state = 18},
  [2786] = {.lex_state = 0, .external_lex_state = 21},
  [2787] = {.lex_state = 0, .external_lex_state = 17},
  [2788] = {.lex_state = 0, .external_lex_state = 18},
  [2789] = {.lex_state = 0, .external_lex_state = 19},
  [2790] = {.lex_state = 0, .external_lex_state = 21},
  [2791] = {.lex_state = 0, .external_lex_state = 18},
  [2792] = {.lex_state = 0, .external_lex_state = 25},
  [2793] = {.lex_state = 0, .external_lex_state = 19},
  [2794] = {.lex_state = 0, .external_lex_state = 23},
  [2795] = {.lex_state = 0, .external_lex_state = 23},
  [2796] = {.lex_state = 0, .external_lex_state = 23},
  [2797] = {.lex_state = 0, .external_lex_state = 20},
  [2798] = {.lex_state = 0, .external_lex_state = 19},
  [2799] = {.lex_state = 0, .external_lex_state = 23},
  [2800] = {.lex_state = 0, .external_lex_state = 19},
  [2801] = {.lex_state = 0, .external_lex_state = 20},
  [2802] = {.lex_state = 0, .external_lex_state = 25},
  [2803] = {.lex_state = 0, .external_lex_state = 25},
  [2804] = {.lex_state = 0, .external_lex_state = 18},
  [2805] = {.lex_state = 0, .external_lex_state = 20},
  [2806] = {.lex_state = 0, .external_lex_state = 18},
  [2807] = {.lex_state = 0, .external_lex_state = 25},
  [2808] = {.lex_state = 0, .external_lex_state = 18},
  [2809] = {.lex_state = 0, .external_lex_state = 23},
  [2810] = {.lex_state = 0, .external_lex_state = 23},
  [2811] = {.lex_state = 0, .external_lex_state = 23},
  [2812] = {.lex_state = 0, .external_lex_state = 23},
  [2813] = {.lex_state = 0, .external_lex_state = 25},
  [2814] = {.lex_state = 0, .external_lex_state = 17},
  [2815] = {.lex_state = 0, .external_lex_state = 25},
  [2816] = {.lex_state = 0, .external_lex_state = 25},
  [2817] = {.lex_state = 0, .external_lex_state = 25},
  [2818] = {.lex_state = 0, .external_lex_state = 25},
  [2819] = {.lex_state = 0, .external_lex_state = 23},
  [2820] = {.lex_state = 0, .external_lex_state = 23},
  [2821] = {.lex_state = 0, .external_lex_state = 18},
  [2822] = {.lex_state = 0, .external_lex_state = 22},
  [2823] = {.lex_state = 0, .external_lex_state = 18},
  [2824] = {.lex_state = 0, .external_lex_state = 23},
  [2825] = {.lex_state = 0, .external_lex_state = 19},
  [2826] = {.lex_state = 0, .external_lex_state = 21},
  [2827] = {.lex_state = 0, .external_lex_state = 21},
  [2828] = {.lex_state = 0, .external_lex_state = 21},
  [2829] = {.lex_state = 0, .external_lex_state = 25},
  [2830] = {.lex_state = 0, .external_lex_state = 20},
  [2831] = {.lex_state = 0, .external_lex_state = 18},
  [2832] = {.lex_state = 0, .external_lex_state = 20},
  [2833] = {.lex_state = 0, .external_lex_state = 21},
  [2834] = {.lex_state = 0, .external_lex_state = 20},
  [2835] = {.lex_state = 0, .external_lex_state = 29},
  [2836] = {.lex_state = 0, .external_lex_state = 20},
  [2837] = {.lex_state = 0, .external_lex_state = 21},
  [2838] = {.lex_state = 0, .external_lex_state = 17},
  [2839] = {.lex_state = 0, .external_lex_state = 17},
  [2840] = {.lex_state = 0, .external_lex_state = 20},
  [2841] = {.lex_state = 0, .external_lex_state = 19},
  [2842] = {.lex_state = 0, .external_lex_state = 21},
  [2843] = {.lex_state = 0, .external_lex_state = 20},
  [2844] = {.lex_state = 0, .external_lex_state = 20},
  [2845] = {.lex_state = 0, .external_lex_state = 17},
  [2846] = {.lex_state = 0, .external_lex_state = 22},
  [2847] = {.lex_state = 0, .external_lex_state = 27},
  [2848] = {.lex_state = 0, .external_lex_state = 19},
  [2849] = {.lex_state = 0, .external_lex_state = 17},
  [2850] = {.lex_state = 0, .external_lex_state = 18},
  [2851] = {.lex_state = 0, .external_lex_state = 22},
  [2852] = {.lex_state = 0, .external_lex_state = 17},
  [2853] = {.lex_state = 0, .external_lex_state = 22},
  [2854] = {.lex_state = 0, .external_lex_state = 22},
  [2855] = {.lex_state = 0, .external_lex_state = 22},
  [2856] = {.lex_state = 0, .external_lex_state = 21},
  [2857] = {.lex_state = 0, .external_lex_state = 22},
  [2858] = {.lex_state = 0, .external_lex_state = 23},
  [2859] = {.lex_state = 0, .external_lex_state = 18},
  [2860] = {.lex_state = 0, .external_lex_state = 22},
  [2861] = {.lex_state = 0, .external_lex_state = 23},
  [2862] = {.lex_state = 0, .external_lex_state = 20},
  [2863] = {.lex_state = 0, .external_lex_state = 22},
  [2864] = {.lex_state = 0, .external_lex_state = 22},
  [2865] = {.lex_state = 0, .external_lex_state = 25},
  [2866] = {.lex_state = 0, .external_lex_state = 24},
  [2867] = {.lex_state = 0, .external_lex_state = 23},
  [2868] = {.lex_state = 0, .external_lex_state = 22},
  [2869] = {.lex_state = 0, .external_lex_state = 23},
  [2870] = {.lex_state = 0, .external_lex_state = 23},
  [2871] = {.lex_state = 0, .external_lex_state = 19},
  [2872] = {.lex_state = 0, .external_lex_state = 23},
  [2873] = {.lex_state = 0, .external_lex_state = 23},
  [2874] = {.lex_state = 0, .external_lex_state = 21},
  [2875] = {.lex_state = 0, .external_lex_state = 17},
  [2876] = {.lex_state = 0, .external_lex_state = 21},
  [2877] = {.lex_state = 0, .external_lex_state = 21},
  [2878] = {.lex_state = 0, .external_lex_state = 21},
  [2879] = {.lex_state = 0, .external_lex_state = 23},
  [2880] = {.lex_state = 0, .external_lex_state = 21},
  [2881] = {.lex_state = 0, .external_lex_state = 26},
  [2882] = {.lex_state = 0, .external_lex_state = 21},
  [2883] = {.lex_state = 0, .external_lex_state = 20},
  [2884] = {.lex_state = 0, .external_lex_state = 25},
  [2885] = {.lex_state = 0, .external_lex_state = 20},
  [2886] = {.lex_state = 0, .external_lex_state = 25},
  [2887] = {.lex_state = 0, .external_lex_state = 22},
  [2888] = {.lex_state = 0, .external_lex_state = 20},
  [2889] = {.lex_state = 0, .external_lex_state = 21},
  [2890] = {.lex_state = 0, .external_lex_state = 17},
  [2891] = {.lex_state = 0, .external_lex_state = 17},
  [2892] = {.lex_state = 0, .external_lex_state = 23},
  [2893] = {.lex_state = 0, .external_lex_state = 2},
  [2894] = {.lex_state = 0, .external_lex_state = 20},
  [2895] = {.lex_state = 0, .external_lex_state = 22},
  [2896] = {.lex_state = 0, .external_lex_state = 22},
  [2897] = {.lex_state = 0, .external_lex_state = 17},
  [2898] = {.lex_state = 0, .external_lex_state = 19},
  [2899] = {.lex_state = 0, .external_lex_state = 22},
  [2900] = {.lex_state = 0, .external_lex_state = 20},
  [2901] = {.lex_state = 0, .external_lex_state = 28},
  [2902] = {.lex_state = 0, .external_lex_state = 25},
  [2903] = {.lex_state = 0, .external_lex_state = 21},
  [2904] = {.lex_state = 0, .external_lex_state = 21},
  [2905] = {.lex_state = 0, .external_lex_state = 17},
  [2906] = {.lex_state = 0, .external_lex_state = 25},
  [2907] = {.lex_state = 0, .external_lex_state = 21},
  [2908] = {.lex_state = 0, .external_lex_state = 18},
  [2909] = {.lex_state = 0, .external_lex_state = 20},
  [2910] = {.lex_state = 0, .external_lex_state = 20},
  [2911] = {.lex_state = 0, .external_lex_state = 18},
  [2912] = {.lex_state = 0, .external_lex_state = 30},
  [2913] = {.lex_state = 0, .external_lex_state = 22},
  [2914] = {.lex_state = 0, .external_lex_state = 22},
  [2915] = {.lex_state = 0, .external_lex_state = 22},
  [2916] = {.lex_state = 0, .external_lex_state = 18},
  [2917] = {.lex_state = 0, .external_lex_state = 17},
  [2918] = {.lex_state = 0, .external_lex_state = 23},
  [2919] = {.lex_state = 0, .external_lex_state = 18},
  [2920] = {.lex_state = 0, .external_lex_state = 18},
  [2921] = {.lex_state = 0, .external_lex_state = 22},
  [2922] = {.lex_state = 0, .external_lex_state = 25},
  [2923] = {.lex_state = 0, .external_lex_state = 25},
  [2924] = {.lex_state = 0, .external_lex_state = 17},
  [2925] = {.lex_state = 0, .external_lex_state = 18},
  [2926] = {.lex_state = 0, .external_lex_state = 18},
  [2927] = {.lex_state = 0, .external_lex_state = 25},
  [2928] = {.lex_state = 0, .external_lex_state = 20},
  [2929] = {.lex_state = 0, .external_lex_state = 20},
  [2930] = {.lex_state = 0, .external_lex_state = 20},
  [2931] = {.lex_state = 0, .external_lex_state = 22},
  [2932] = {.lex_state = 0, .external_lex_state = 25},
  [2933] = {.lex_state = 0, .external_lex_state = 22},
  [2934] = {.lex_state = 0, .external_lex_state = 17},
  [2935] = {.lex_state = 0, .external_lex_state = 17},
  [2936] = {.lex_state = 0, .external_lex_state = 24},
  [2937] = {.lex_state = 0, .external_lex_state = 24},
  [2938] = {.lex_state = 0, .external_lex_state = 28},
  [2939] = {.lex_state = 0, .external_lex_state = 26},
  [2940] = {.lex_state = 0, .external_lex_state = 24},
  [2941] = {.lex_state = 0, .external_lex_state = 24},
  [2942] = {.lex_state = 0, .external_lex_state = 24},
  [2943] = {.lex_state = 0, .external_lex_state = 24},
  [2944] = {.lex_state = 0, .external_lex_state = 24},
  [2945] = {.lex_state = 0, .external_lex_state = 24},
  [2946] = {.lex_state = 0, .external_lex_state = 24},
  [2947] = {.lex_state = 0, .external_lex_state = 28},
  [2948] = {.lex_state = 0, .external_lex_state = 24},
  [2949] = {.lex_state = 0, .external_lex_state = 24},
  [2950] = {.lex_state = 0, .external_lex_state = 24},
  [2951] = {.lex_state = 0, .external_lex_state = 24},
  [2952] = {.lex_state = 0, .external_lex_state = 24},
  [2953] = {.lex_state = 0, .external_lex_state = 24},
  [2954] = {.lex_state = 0, .external_lex_state = 24},
  [2955] = {.lex_state = 0, .external_lex_state = 24},
  [2956] = {.lex_state = 0, .external_lex_state = 28},
  [2957] = {.lex_state = 0, .external_lex_state = 24},
  [2958] = {.lex_state = 0, .external_lex_state = 27},
  [2959] = {.lex_state = 0, .external_lex_state = 27},
  [2960] = {.lex_state = 0, .external_lex_state = 27},
  [2961] = {.lex_state = 0, .external_lex_state = 27},
  [2962] = {.lex_state = 0, .external_lex_state = 27},
  [2963] = {.lex_state = 0, .external_lex_state = 24},
  [2964] = {.lex_state = 0, .external_lex_state = 27},
  [2965] = {.lex_state = 0, .external_lex_state = 27},
  [2966] = {.lex_state = 0, .external_lex_state = 27},
  [2967] = {.lex_state = 0, .external_lex_state = 27},
  [2968] = {.lex_state = 0, .external_lex_state = 27},
  [2969] = {.lex_state = 0, .external_lex_state = 27},
  [2970] = {.lex_state = 0, .external_lex_state = 27},
  [2971] = {.lex_state = 0, .external_lex_state = 26},
  [2972] = {.lex_state = 0, .external_lex_state = 26},
  [2973] = {.lex_state = 0, .external_lex_state = 24},
  [2974] = {.lex_state = 0, .external_lex_state = 27},
  [2975] = {.lex_state = 0, .external_lex_state = 27},
  [2976] = {.lex_state = 0, .external_lex_state = 27},
  [2977] = {.lex_state = 0, .external_lex_state = 27},
  [2978] = {.lex_state = 0, .external_lex_state = 27},
  [2979] = {.lex_state = 0, .external_lex_state = 27},
  [2980] = {.lex_state = 0, .external_lex_state = 27},
  [2981] = {.lex_state = 0, .external_lex_state = 24},
  [2982] = {.lex_state = 0, .external_lex_state = 26},
  [2983] = {.lex_state = 0, .external_lex_state = 27},
  [2984] = {.lex_state = 0, .external_lex_state = 28},
  [2985] = {.lex_state = 0, .external_lex_state = 26},
  [2986] = {.lex_state = 0, .external_lex_state = 26},
  [2987] = {.lex_state = 0, .external_lex_state = 26},
  [2988] = {.lex_state = 0, .external_lex_state = 27},
  [2989] = {.lex_state = 0, .external_lex_state = 28},
  [2990] = {.lex_state = 0, .external_lex_state = 28},
  [2991] = {.lex_state = 0, .external_lex_state = 28},
  [2992] = {.lex_state = 0, .external_lex_state = 26},
  [2993] = {.lex_state = 0, .external_lex_state = 26},
  [2994] = {.lex_state = 0, .external_lex_state = 26},
  [2995] = {.lex_state = 0, .external_lex_state = 28},
  [2996] = {.lex_state = 0, .external_lex_state = 26},
  [2997] = {.lex_state = 0, .external_lex_state = 26},
  [2998] = {.lex_state = 0, .external_lex_state = 27},
  [2999] = {.lex_state = 0, .external_lex_state = 28},
  [3000] = {.lex_state = 0, .external_lex_state = 28},
  [3001] = {.lex_state = 0, .external_lex_state = 28},
  [3002] = {.lex_state = 0, .external_lex_state = 28},
  [3003] = {.lex_state = 0, .external_lex_state = 28},
  [3004] = {.lex_state = 0, .external_lex_state = 28},
  [3005] = {.lex_state = 0, .external_lex_state = 28},
  [3006] = {.lex_state = 0, .external_lex_state = 28},
  [3007] = {.lex_state = 0, .external_lex_state = 26},
  [3008] = {.lex_state = 0, .external_lex_state = 26},
  [3009] = {.lex_state = 0, .external_lex_state = 26},
  [3010] = {.lex_state = 0, .external_lex_state = 26},
  [3011] = {.lex_state = 0, .external_lex_state = 26},
  [3012] = {.lex_state = 0, .external_lex_state = 26},
  [3013] = {.lex_state = 0, .external_lex_state = 26},
  [3014] = {.lex_state = 0, .external_lex_state = 24},
  [3015] = {.lex_state = 0, .external_lex_state = 26},
  [3016] = {.lex_state = 0, .external_lex_state = 27},
  [3017] = {.lex_state = 0, .external_lex_state = 26},
  [3018] = {.lex_state = 0, .external_lex_state = 28},
  [3019] = {.lex_state = 0, .external_lex_state = 24},
  [3020] = {.lex_state = 0, .external_lex_state = 26},
  [3021] = {.lex_state = 0, .external_lex_state = 24},
  [3022] = {.lex_state = 0, .external_lex_state = 28},
  [3023] = {.lex_state = 0, .external_lex_state = 28},
  [3024] = {.lex_state = 0, .external_lex_state = 28},
  [3025] = {.lex_state = 0, .external_lex_state = 28},
  [3026] = {.lex_state = 0, .external_lex_state = 28},
  [3027] = {.lex_state = 0, .external_lex_state = 28},
  [3028] = {.lex_state = 0, .external_lex_state = 32},
  [3029] = {.lex_state = 0, .external_lex_state = 32},
  [3030] = {.lex_state = 0, .external_lex_state = 32},
  [3031] = {.lex_state = 0, .external_lex_state = 32},
  [3032] = {.lex_state = 0, .external_lex_state = 32},
  [3033] = {.lex_state = 0, .external_lex_state = 32},
  [3034] = {.lex_state = 0, .external_lex_state = 32},
  [3035] = {.lex_state = 0, .external_lex_state = 32},
  [3036] = {.lex_state = 0, .external_lex_state = 32},
  [3037] = {.lex_state = 0, .external_lex_state = 32},
  [3038] = {.lex_state = 0, .external_lex_state = 32},
  [3039] = {.lex_state = 0, .external_lex_state = 32},
  [3040] = {.lex_state = 0, .external_lex_state = 32},
  [3041] = {.lex_state = 0, .external_lex_state = 32},
  [3042] = {.lex_state = 0, .external_lex_state = 32},
  [3043] = {.lex_state = 0, .external_lex_state = 32},
  [3044] = {.lex_state = 0, .external_lex_state = 32},
  [3045] = {.lex_state = 0, .external_lex_state = 32},
  [3046] = {.lex_state = 0, .external_lex_state = 32},
  [3047] = {.lex_state = 0, .external_lex_state = 32},
  [3048] = {.lex_state = 0, .external_lex_state = 32},
  [3049] = {.lex_state = 0, .external_lex_state = 32},
  [3050] = {.lex_state = 0, .external_lex_state = 32},
  [3051] = {.lex_state = 0, .external_lex_state = 32},
  [3052] = {.lex_state = 0, .external_lex_state = 32},
  [3053] = {.lex_state = 0, .external_lex_state = 32},
  [3054] = {.lex_state = 0, .external_lex_state = 32},
  [3055] = {.lex_state = 0, .external_lex_state = 32},
  [3056] = {.lex_state = 0, .external_lex_state = 32},
  [3057] = {.lex_state = 0, .external_lex_state = 32},
  [3058] = {.lex_state = 0, .external_lex_state = 32},
  [3059] = {.lex_state = 0, .external_lex_state = 32},
  [3060] = {.lex_state = 0, .external_lex_state = 32},
  [3061] = {.lex_state = 0, .external_lex_state = 32},
  [3062] = {.lex_state = 0, .external_lex_state = 32},
  [3063] = {.lex_state = 0, .external_lex_state = 32},
  [3064] = {.lex_state = 0, .external_lex_state = 32},
  [3065] = {.lex_state = 0, .external_lex_state = 32},
  [3066] = {.lex_state = 0, .external_lex_state = 32},
  [3067] = {.lex_state = 0, .external_lex_state = 32},
  [3068] = {.lex_state = 0, .external_lex_state = 32},
  [3069] = {.lex_state = 0, .external_lex_state = 32},
  [3070] = {.lex_state = 0, .external_lex_state = 32},
  [3071] = {.lex_state = 0, .external_lex_state = 32},
  [3072] = {.lex_state = 0, .external_lex_state = 32},
  [3073] = {.lex_state = 0, .external_lex_state = 32},
  [3074] = {.lex_state = 0, .external_lex_state = 32},
  [3075] = {.lex_state = 0, .external_lex_state = 32},
  [3076] = {.lex_state = 0, .external_lex_state = 32},
  [3077] = {.lex_state = 0, .external_lex_state = 32},
  [3078] = {.lex_state = 0, .external_lex_state = 32},
  [3079] = {.lex_state = 0, .external_lex_state = 32},
  [3080] = {.lex_state = 0, .external_lex_state = 32},
  [3081] = {.lex_state = 0, .external_lex_state = 32},
  [3082] = {.lex_state = 0, .external_lex_state = 32},
  [3083] = {.lex_state = 0, .external_lex_state = 32},
  [3084] = {.lex_state = 0, .external_lex_state = 32},
  [3085] = {.lex_state = 0, .external_lex_state = 32},
  [3086] = {.lex_state = 0, .external_lex_state = 32},
  [3087] = {.lex_state = 0, .external_lex_state = 32},
  [3088] = {.lex_state = 0, .external_lex_state = 32},
  [3089] = {.lex_state = 0, .external_lex_state = 32},
  [3090] = {.lex_state = 0, .external_lex_state = 32},
  [3091] = {.lex_state = 0, .external_lex_state = 32},
  [3092] = {.lex_state = 0, .external_lex_state = 32},
  [3093] = {.lex_state = 0, .external_lex_state = 32},
  [3094] = {.lex_state = 0, .external_lex_state = 32},
  [3095] = {.lex_state = 0, .external_lex_state = 32},
  [3096] = {.lex_state = 0, .external_lex_state = 32},
  [3097] = {.lex_state = 0, .external_lex_state = 32},
  [3098] = {.lex_state = 0, .external_lex_state = 32},
  [3099] = {.lex_state = 0, .external_lex_state = 32},
  [3100] = {.lex_state = 0, .external_lex_state = 32},
  [3101] = {.lex_state = 0, .external_lex_state = 32},
  [3102] = {.lex_state = 0, .external_lex_state = 32},
  [3103] = {.lex_state = 0, .external_lex_state = 32},
  [3104] = {.lex_state = 0, .external_lex_state = 32},
  [3105] = {.lex_state = 0, .external_lex_state = 32},
  [3106] = {.lex_state = 0, .external_lex_state = 32},
  [3107] = {.lex_state = 0, .external_lex_state = 32},
  [3108] = {.lex_state = 0, .external_lex_state = 32},
  [3109] = {.lex_state = 0, .external_lex_state = 32},
  [3110] = {.lex_state = 0, .external_lex_state = 32},
  [3111] = {.lex_state = 0, .external_lex_state = 32},
  [3112] = {.lex_state = 0, .external_lex_state = 32},
  [3113] = {.lex_state = 0, .external_lex_state = 32},
  [3114] = {.lex_state = 0, .external_lex_state = 32},
  [3115] = {.lex_state = 0, .external_lex_state = 32},
  [3116] = {.lex_state = 0, .external_lex_state = 32},
  [3117] = {.lex_state = 0, .external_lex_state = 32},
  [3118] = {.lex_state = 0, .external_lex_state = 32},
  [3119] = {.lex_state = 0, .external_lex_state = 32},
  [3120] = {.lex_state = 0, .external_lex_state = 32},
  [3121] = {.lex_state = 0, .external_lex_state = 32},
  [3122] = {.lex_state = 0, .external_lex_state = 32},
  [3123] = {.lex_state = 0, .external_lex_state = 32},
  [3124] = {.lex_state = 0, .external_lex_state = 32},
  [3125] = {.lex_state = 0, .external_lex_state = 32},
  [3126] = {.lex_state = 0, .external_lex_state = 32},
  [3127] = {.lex_state = 0, .external_lex_state = 32},
  [3128] = {.lex_state = 0, .external_lex_state = 32},
  [3129] = {.lex_state = 0, .external_lex_state = 32},
  [3130] = {.lex_state = 0, .external_lex_state = 32},
  [3131] = {.lex_state = 0, .external_lex_state = 32},
  [3132] = {.lex_state = 0, .external_lex_state = 32},
  [3133] = {.lex_state = 0, .external_lex_state = 32},
  [3134] = {.lex_state = 0, .external_lex_state = 32},
  [3135] = {.lex_state = 0, .external_lex_state = 32},
  [3136] = {.lex_state = 0, .external_lex_state = 32},
  [3137] = {.lex_state = 0, .external_lex_state = 32},
  [3138] = {.lex_state = 0, .external_lex_state = 32},
  [3139] = {.lex_state = 0, .external_lex_state = 32},
  [3140] = {.lex_state = 0, .external_lex_state = 32},
  [3141] = {.lex_state = 0, .external_lex_state = 32},
  [3142] = {.lex_state = 0, .external_lex_state = 32},
  [3143] = {.lex_state = 0, .external_lex_state = 32},
  [3144] = {.lex_state = 0, .external_lex_state = 32},
  [3145] = {.lex_state = 0, .external_lex_state = 32},
  [3146] = {.lex_state = 0, .external_lex_state = 32},
  [3147] = {.lex_state = 0, .external_lex_state = 32},
  [3148] = {.lex_state = 0, .external_lex_state = 32},
  [3149] = {.lex_state = 0, .external_lex_state = 32},
  [3150] = {.lex_state = 0, .external_lex_state = 32},
  [3151] = {.lex_state = 0, .external_lex_state = 32},
  [3152] = {.lex_state = 0, .external_lex_state = 32},
  [3153] = {.lex_state = 0, .external_lex_state = 32},
  [3154] = {.lex_state = 0, .external_lex_state = 32},
  [3155] = {.lex_state = 0, .external_lex_state = 32},
  [3156] = {.lex_state = 0, .external_lex_state = 32},
  [3157] = {.lex_state = 0, .external_lex_state = 32},
  [3158] = {.lex_state = 0, .external_lex_state = 32},
  [3159] = {.lex_state = 0, .external_lex_state = 32},
  [3160] = {.lex_state = 0, .external_lex_state = 32},
  [3161] = {.lex_state = 0, .external_lex_state = 32},
  [3162] = {.lex_state = 0, .external_lex_state = 32},
  [3163] = {.lex_state = 0, .external_lex_state = 32},
  [3164] = {.lex_state = 0, .external_lex_state = 32},
  [3165] = {.lex_state = 0, .external_lex_state = 32},
  [3166] = {.lex_state = 0, .external_lex_state = 32},
  [3167] = {.lex_state = 0, .external_lex_state = 32},
  [3168] = {.lex_state = 0, .external_lex_state = 32},
  [3169] = {.lex_state = 0, .external_lex_state = 32},
  [3170] = {.lex_state = 0, .external_lex_state = 32},
  [3171] = {.lex_state = 0, .external_lex_state = 32},
  [3172] = {.lex_state = 0, .external_lex_state = 32},
  [3173] = {.lex_state = 0, .external_lex_state = 32},
  [3174] = {.lex_state = 0, .external_lex_state = 32},
  [3175] = {.lex_state = 0, .external_lex_state = 32},
  [3176] = {.lex_state = 0, .external_lex_state = 32},
  [3177] = {.lex_state = 0, .external_lex_state = 32},
  [3178] = {.lex_state = 0, .external_lex_state = 32},
  [3179] = {.lex_state = 0, .external_lex_state = 32},
  [3180] = {.lex_state = 0, .external_lex_state = 32},
  [3181] = {.lex_state = 0, .external_lex_state = 32},
  [3182] = {.lex_state = 0, .external_lex_state = 32},
  [3183] = {.lex_state = 0, .external_lex_state = 32},
  [3184] = {.lex_state = 0, .external_lex_state = 32},
  [3185] = {.lex_state = 0, .external_lex_state = 32},
  [3186] = {.lex_state = 0, .external_lex_state = 32},
  [3187] = {.lex_state = 0, .external_lex_state = 32},
  [3188] = {.lex_state = 0, .external_lex_state = 32},
  [3189] = {.lex_state = 0, .external_lex_state = 32},
  [3190] = {.lex_state = 0, .external_lex_state = 32},
  [3191] = {.lex_state = 0, .external_lex_state = 32},
  [3192] = {.lex_state = 0, .external_lex_state = 32},
  [3193] = {.lex_state = 0, .external_lex_state = 32},
  [3194] = {.lex_state = 0, .external_lex_state = 32},
  [3195] = {.lex_state = 0, .external_lex_state = 32},
  [3196] = {.lex_state = 0, .external_lex_state = 32},
  [3197] = {.lex_state = 0, .external_lex_state = 32},
  [3198] = {.lex_state = 0, .external_lex_state = 32},
  [3199] = {.lex_state = 0, .external_lex_state = 32},
  [3200] = {.lex_state = 0, .external_lex_state = 32},
  [3201] = {.lex_state = 0, .external_lex_state = 32},
  [3202] = {.lex_state = 0, .external_lex_state = 32},
  [3203] = {.lex_state = 0, .external_lex_state = 32},
  [3204] = {.lex_state = 0, .external_lex_state = 32},
  [3205] = {.lex_state = 0, .external_lex_state = 32},
  [3206] = {.lex_state = 0, .external_lex_state = 32},
  [3207] = {.lex_state = 0, .external_lex_state = 32},
  [3208] = {.lex_state = 0, .external_lex_state = 32},
  [3209] = {.lex_state = 0, .external_lex_state = 32},
  [3210] = {.lex_state = 0, .external_lex_state = 32},
  [3211] = {.lex_state = 0, .external_lex_state = 32},
  [3212] = {.lex_state = 0, .external_lex_state = 32},
  [3213] = {.lex_state = 0, .external_lex_state = 32},
  [3214] = {.lex_state = 0, .external_lex_state = 32},
  [3215] = {.lex_state = 0, .external_lex_state = 32},
  [3216] = {.lex_state = 0, .external_lex_state = 32},
  [3217] = {.lex_state = 0, .external_lex_state = 32},
  [3218] = {.lex_state = 0, .external_lex_state = 32},
  [3219] = {.lex_state = 0, .external_lex_state = 32},
  [3220] = {.lex_state = 0, .external_lex_state = 32},
  [3221] = {.lex_state = 0, .external_lex_state = 32},
  [3222] = {.lex_state = 0, .external_lex_state = 32},
  [3223] = {.lex_state = 0, .external_lex_state = 32},
  [3224] = {.lex_state = 0, .external_lex_state = 32},
  [3225] = {.lex_state = 0, .external_lex_state = 32},
  [3226] = {.lex_state = 0, .external_lex_state = 32},
  [3227] = {.lex_state = 0, .external_lex_state = 32},
  [3228] = {.lex_state = 0, .external_lex_state = 32},
  [3229] = {.lex_state = 0, .external_lex_state = 32},
  [3230] = {.lex_state = 0, .external_lex_state = 32},
  [3231] = {.lex_state = 0, .external_lex_state = 32},
  [3232] = {.lex_state = 0, .external_lex_state = 32},
  [3233] = {.lex_state = 0, .external_lex_state = 32},
  [3234] = {.lex_state = 0, .external_lex_state = 32},
  [3235] = {.lex_state = 0, .external_lex_state = 32},
  [3236] = {.lex_state = 0, .external_lex_state = 32},
  [3237] = {.lex_state = 0, .external_lex_state = 32},
  [3238] = {.lex_state = 0, .external_lex_state = 32},
  [3239] = {.lex_state = 0, .external_lex_state = 32},
  [3240] = {.lex_state = 0, .external_lex_state = 32},
  [3241] = {.lex_state = 0, .external_lex_state = 32},
  [3242] = {.lex_state = 0, .external_lex_state = 32},
  [3243] = {.lex_state = 0, .external_lex_state = 32},
  [3244] = {.lex_state = 0, .external_lex_state = 32},
  [3245] = {.lex_state = 0, .external_lex_state = 32},
  [3246] = {.lex_state = 0, .external_lex_state = 32},
  [3247] = {.lex_state = 0, .external_lex_state = 32},
  [3248] = {.lex_state = 0, .external_lex_state = 32},
  [3249] = {.lex_state = 0, .external_lex_state = 32},
  [3250] = {.lex_state = 0, .external_lex_state = 32},
  [3251] = {.lex_state = 0, .external_lex_state = 32},
  [3252] = {.lex_state = 0, .external_lex_state = 32},
  [3253] = {.lex_state = 0, .external_lex_state = 32},
  [3254] = {.lex_state = 0, .external_lex_state = 32},
  [3255] = {.lex_state = 0, .external_lex_state = 32},
  [3256] = {.lex_state = 0, .external_lex_state = 32},
  [3257] = {.lex_state = 0, .external_lex_state = 32},
  [3258] = {.lex_state = 0, .external_lex_state = 32},
  [3259] = {.lex_state = 0, .external_lex_state = 32},
  [3260] = {.lex_state = 0, .external_lex_state = 32},
  [3261] = {.lex_state = 0, .external_lex_state = 32},
  [3262] = {.lex_state = 0, .external_lex_state = 32},
  [3263] = {.lex_state = 0, .external_lex_state = 32},
  [3264] = {.lex_state = 0, .external_lex_state = 32},
  [3265] = {.lex_state = 0, .external_lex_state = 32},
  [3266] = {.lex_state = 0, .external_lex_state = 32},
  [3267] = {.lex_state = 0, .external_lex_state = 32},
  [3268] = {.lex_state = 0, .external_lex_state = 32},
  [3269] = {.lex_state = 0, .external_lex_state = 32},
  [3270] = {.lex_state = 0, .external_lex_state = 32},
  [3271] = {.lex_state = 0, .external_lex_state = 32},
  [3272] = {.lex_state = 0, .external_lex_state = 32},
  [3273] = {.lex_state = 0, .external_lex_state = 32},
  [3274] = {.lex_state = 0, .external_lex_state = 32},
  [3275] = {.lex_state = 0, .external_lex_state = 32},
  [3276] = {.lex_state = 0, .external_lex_state = 32},
  [3277] = {.lex_state = 0, .external_lex_state = 32},
  [3278] = {.lex_state = 0, .external_lex_state = 32},
  [3279] = {.lex_state = 0, .external_lex_state = 32},
  [3280] = {.lex_state = 0, .external_lex_state = 32},
  [3281] = {.lex_state = 0, .external_lex_state = 32},
  [3282] = {.lex_state = 0, .external_lex_state = 32},
  [3283] = {.lex_state = 0, .external_lex_state = 32},
  [3284] = {.lex_state = 0, .external_lex_state = 32},
  [3285] = {.lex_state = 0, .external_lex_state = 32},
  [3286] = {.lex_state = 0, .external_lex_state = 32},
  [3287] = {.lex_state = 0, .external_lex_state = 32},
  [3288] = {.lex_state = 0, .external_lex_state = 32},
  [3289] = {.lex_state = 0, .external_lex_state = 32},
  [3290] = {.lex_state = 0, .external_lex_state = 32},
  [3291] = {.lex_state = 0, .external_lex_state = 32},
  [3292] = {.lex_state = 0, .external_lex_state = 32},
  [3293] = {.lex_state = 0, .external_lex_state = 32},
  [3294] = {.lex_state = 0, .external_lex_state = 32},
  [3295] = {.lex_state = 0, .external_lex_state = 32},
  [3296] = {.lex_state = 0, .external_lex_state = 32},
  [3297] = {.lex_state = 0, .external_lex_state = 32},
  [3298] = {.lex_state = 0, .external_lex_state = 32},
  [3299] = {.lex_state = 0, .external_lex_state = 32},
  [3300] = {.lex_state = 0, .external_lex_state = 32},
  [3301] = {.lex_state = 0, .external_lex_state = 32},
  [3302] = {.lex_state = 0, .external_lex_state = 32},
  [3303] = {.lex_state = 0, .external_lex_state = 32},
  [3304] = {.lex_state = 0, .external_lex_state = 32},
  [3305] = {.lex_state = 0, .external_lex_state = 32},
  [3306] = {.lex_state = 0, .external_lex_state = 32},
  [3307] = {.lex_state = 0, .external_lex_state = 32},
  [3308] = {.lex_state = 0, .external_lex_state = 32},
  [3309] = {.lex_state = 0, .external_lex_state = 32},
  [3310] = {.lex_state = 0, .external_lex_state = 32},
  [3311] = {.lex_state = 0, .external_lex_state = 32},
  [3312] = {.lex_state = 0, .external_lex_state = 32},
  [3313] = {.lex_state = 0, .external_lex_state = 32},
  [3314] = {.lex_state = 0, .external_lex_state = 32},
  [3315] = {.lex_state = 0, .external_lex_state = 32},
  [3316] = {.lex_state = 0, .external_lex_state = 32},
  [3317] = {.lex_state = 0, .external_lex_state = 32},
  [3318] = {.lex_state = 0, .external_lex_state = 32},
  [3319] = {.lex_state = 0, .external_lex_state = 32},
  [3320] = {.lex_state = 0, .external_lex_state = 32},
  [3321] = {.lex_state = 0, .external_lex_state = 32},
  [3322] = {.lex_state = 0, .external_lex_state = 32},
  [3323] = {.lex_state = 0, .external_lex_state = 32},
  [3324] = {.lex_state = 0, .external_lex_state = 32},
  [3325] = {.lex_state = 0, .external_lex_state = 32},
  [3326] = {.lex_state = 0, .external_lex_state = 32},
  [3327] = {.lex_state = 0, .external_lex_state = 32},
  [3328] = {.lex_state = 0, .external_lex_state = 32},
  [3329] = {.lex_state = 0, .external_lex_state = 32},
  [3330] = {.lex_state = 0, .external_lex_state = 32},
  [3331] = {.lex_state = 0, .external_lex_state = 32},
  [3332] = {.lex_state = 0, .external_lex_state = 32},
  [3333] = {.lex_state = 0, .external_lex_state = 32},
  [3334] = {.lex_state = 0, .external_lex_state = 32},
  [3335] = {.lex_state = 0, .external_lex_state = 32},
  [3336] = {.lex_state = 0, .external_lex_state = 32},
  [3337] = {.lex_state = 0, .external_lex_state = 32},
  [3338] = {.lex_state = 0, .external_lex_state = 32},
  [3339] = {.lex_state = 0, .external_lex_state = 32},
  [3340] = {.lex_state = 0, .external_lex_state = 32},
  [3341] = {.lex_state = 0, .external_lex_state = 32},
  [3342] = {.lex_state = 0, .external_lex_state = 32},
  [3343] = {.lex_state = 0, .external_lex_state = 32},
  [3344] = {.lex_state = 0, .external_lex_state = 32},
  [3345] = {.lex_state = 0, .external_lex_state = 32},
  [3346] = {.lex_state = 0, .external_lex_state = 32},
  [3347] = {.lex_state = 0, .external_lex_state = 32},
  [3348] = {.lex_state = 0, .external_lex_state = 32},
  [3349] = {.lex_state = 0, .external_lex_state = 32},
  [3350] = {.lex_state = 0, .external_lex_state = 32},
  [3351] = {.lex_state = 0, .external_lex_state = 32},
  [3352] = {.lex_state = 0, .external_lex_state = 32},
  [3353] = {.lex_state = 0, .external_lex_state = 32},
  [3354] = {.lex_state = 0, .external_lex_state = 32},
  [3355] = {.lex_state = 0, .external_lex_state = 32},
  [3356] = {.lex_state = 0, .external_lex_state = 32},
  [3357] = {.lex_state = 0, .external_lex_state = 32},
  [3358] = {.lex_state = 0, .external_lex_state = 32},
  [3359] = {.lex_state = 0, .external_lex_state = 32},
  [3360] = {.lex_state = 0, .external_lex_state = 32},
  [3361] = {.lex_state = 0, .external_lex_state = 32},
  [3362] = {.lex_state = 0, .external_lex_state = 32},
  [3363] = {.lex_state = 0, .external_lex_state = 32},
  [3364] = {.lex_state = 0, .external_lex_state = 32},
  [3365] = {.lex_state = 0, .external_lex_state = 32},
  [3366] = {.lex_state = 0, .external_lex_state = 32},
  [3367] = {.lex_state = 0, .external_lex_state = 32},
  [3368] = {.lex_state = 0, .external_lex_state = 32},
  [3369] = {.lex_state = 0, .external_lex_state = 32},
  [3370] = {.lex_state = 0, .external_lex_state = 32},
  [3371] = {.lex_state = 0, .external_lex_state = 32},
  [3372] = {.lex_state = 0, .external_lex_state = 32},
  [3373] = {.lex_state = 0, .external_lex_state = 32},
  [3374] = {.lex_state = 0, .external_lex_state = 32},
  [3375] = {.lex_state = 0, .external_lex_state = 32},
  [3376] = {.lex_state = 0, .external_lex_state = 32},
  [3377] = {.lex_state = 0, .external_lex_state = 32},
  [3378] = {.lex_state = 0, .external_lex_state = 32},
  [3379] = {.lex_state = 0, .external_lex_state = 32},
  [3380] = {.lex_state = 0, .external_lex_state = 32},
  [3381] = {.lex_state = 0, .external_lex_state = 32},
  [3382] = {.lex_state = 0, .external_lex_state = 32},
  [3383] = {.lex_state = 0, .external_lex_state = 32},
  [3384] = {.lex_state = 0, .external_lex_state = 32},
  [3385] = {.lex_state = 0, .external_lex_state = 32},
  [3386] = {.lex_state = 0, .external_lex_state = 32},
  [3387] = {.lex_state = 0, .external_lex_state = 32},
  [3388] = {.lex_state = 0, .external_lex_state = 32},
  [3389] = {.lex_state = 0, .external_lex_state = 32},
  [3390] = {.lex_state = 0, .external_lex_state = 32},
  [3391] = {.lex_state = 0, .external_lex_state = 32},
  [3392] = {.lex_state = 0, .external_lex_state = 32},
  [3393] = {.lex_state = 0, .external_lex_state = 32},
  [3394] = {.lex_state = 0, .external_lex_state = 32},
  [3395] = {.lex_state = 0, .external_lex_state = 32},
  [3396] = {.lex_state = 0, .external_lex_state = 32},
  [3397] = {.lex_state = 0, .external_lex_state = 32},
  [3398] = {.lex_state = 0, .external_lex_state = 32},
  [3399] = {.lex_state = 0, .external_lex_state = 32},
  [3400] = {.lex_state = 0, .external_lex_state = 32},
  [3401] = {.lex_state = 0, .external_lex_state = 32},
  [3402] = {.lex_state = 0, .external_lex_state = 32},
  [3403] = {.lex_state = 0, .external_lex_state = 32},
  [3404] = {.lex_state = 0, .external_lex_state = 32},
  [3405] = {.lex_state = 0, .external_lex_state = 32},
  [3406] = {.lex_state = 0, .external_lex_state = 32},
  [3407] = {.lex_state = 0, .external_lex_state = 32},
  [3408] = {.lex_state = 0, .external_lex_state = 32},
  [3409] = {.lex_state = 0, .external_lex_state = 32},
  [3410] = {.lex_state = 0, .external_lex_state = 32},
  [3411] = {.lex_state = 0, .external_lex_state = 32},
  [3412] = {.lex_state = 0, .external_lex_state = 32},
  [3413] = {.lex_state = 0, .external_lex_state = 32},
  [3414] = {.lex_state = 0, .external_lex_state = 32},
  [3415] = {.lex_state = 0, .external_lex_state = 32},
  [3416] = {.lex_state = 0, .external_lex_state = 32},
  [3417] = {.lex_state = 0, .external_lex_state = 32},
  [3418] = {.lex_state = 0, .external_lex_state = 32},
  [3419] = {.lex_state = 0, .external_lex_state = 32},
  [3420] = {.lex_state = 0, .external_lex_state = 32},
  [3421] = {.lex_state = 0, .external_lex_state = 32},
  [3422] = {.lex_state = 0, .external_lex_state = 32},
  [3423] = {.lex_state = 0, .external_lex_state = 32},
  [3424] = {.lex_state = 0, .external_lex_state = 32},
  [3425] = {.lex_state = 0, .external_lex_state = 32},
  [3426] = {.lex_state = 0, .external_lex_state = 32},
  [3427] = {.lex_state = 0, .external_lex_state = 32},
  [3428] = {.lex_state = 0, .external_lex_state = 32},
  [3429] = {.lex_state = 0, .external_lex_state = 32},
  [3430] = {.lex_state = 0, .external_lex_state = 32},
  [3431] = {.lex_state = 0, .external_lex_state = 32},
  [3432] = {.lex_state = 0, .external_lex_state = 32},
  [3433] = {.lex_state = 0, .external_lex_state = 32},
  [3434] = {.lex_state = 0, .external_lex_state = 32},
  [3435] = {.lex_state = 0, .external_lex_state = 32},
  [3436] = {.lex_state = 0, .external_lex_state = 32},
  [3437] = {.lex_state = 0, .external_lex_state = 32},
  [3438] = {.lex_state = 0, .external_lex_state = 32},
  [3439] = {.lex_state = 0, .external_lex_state = 32},
  [3440] = {.lex_state = 0, .external_lex_state = 32},
  [3441] = {.lex_state = 0, .external_lex_state = 32},
  [3442] = {.lex_state = 0, .external_lex_state = 32},
  [3443] = {.lex_state = 0, .external_lex_state = 32},
  [3444] = {.lex_state = 0, .external_lex_state = 32},
  [3445] = {.lex_state = 0, .external_lex_state = 32},
  [3446] = {.lex_state = 0, .external_lex_state = 32},
  [3447] = {.lex_state = 0, .external_lex_state = 32},
  [3448] = {.lex_state = 0, .external_lex_state = 32},
  [3449] = {.lex_state = 0, .external_lex_state = 32},
  [3450] = {.lex_state = 0, .external_lex_state = 32},
  [3451] = {.lex_state = 0, .external_lex_state = 32},
  [3452] = {.lex_state = 0, .external_lex_state = 32},
  [3453] = {.lex_state = 0, .external_lex_state = 32},
  [3454] = {.lex_state = 0, .external_lex_state = 32},
  [3455] = {.lex_state = 0, .external_lex_state = 32},
  [3456] = {.lex_state = 0, .external_lex_state = 32},
  [3457] = {.lex_state = 0, .external_lex_state = 32},
  [3458] = {.lex_state = 0, .external_lex_state = 32},
  [3459] = {.lex_state = 0, .external_lex_state = 32},
  [3460] = {.lex_state = 0, .external_lex_state = 32},
  [3461] = {.lex_state = 0, .external_lex_state = 32},
  [3462] = {.lex_state = 0, .external_lex_state = 32},
  [3463] = {.lex_state = 0, .external_lex_state = 32},
  [3464] = {.lex_state = 0, .external_lex_state = 32},
  [3465] = {.lex_state = 0, .external_lex_state = 32},
  [3466] = {.lex_state = 0, .external_lex_state = 32},
  [3467] = {.lex_state = 0, .external_lex_state = 32},
  [3468] = {.lex_state = 0, .external_lex_state = 32},
  [3469] = {.lex_state = 0, .external_lex_state = 32},
  [3470] = {.lex_state = 0, .external_lex_state = 32},
  [3471] = {.lex_state = 0, .external_lex_state = 32},
  [3472] = {.lex_state = 0, .external_lex_state = 32},
  [3473] = {.lex_state = 0, .external_lex_state = 32},
  [3474] = {.lex_state = 0, .external_lex_state = 32},
  [3475] = {.lex_state = 0, .external_lex_state = 32},
  [3476] = {.lex_state = 0, .external_lex_state = 32},
  [3477] = {.lex_state = 0, .external_lex_state = 32},
  [3478] = {.lex_state = 0, .external_lex_state = 32},
  [3479] = {.lex_state = 0, .external_lex_state = 32},
  [3480] = {.lex_state = 0, .external_lex_state = 32},
  [3481] = {.lex_state = 0, .external_lex_state = 32},
  [3482] = {.lex_state = 0, .external_lex_state = 32},
  [3483] = {.lex_state = 0, .external_lex_state = 32},
  [3484] = {.lex_state = 0, .external_lex_state = 32},
  [3485] = {.lex_state = 0, .external_lex_state = 32},
  [3486] = {.lex_state = 0, .external_lex_state = 32},
  [3487] = {.lex_state = 0, .external_lex_state = 32},
  [3488] = {.lex_state = 0, .external_lex_state = 32},
  [3489] = {.lex_state = 0, .external_lex_state = 32},
  [3490] = {.lex_state = 0, .external_lex_state = 32},
  [3491] = {.lex_state = 0, .external_lex_state = 32},
  [3492] = {.lex_state = 0, .external_lex_state = 32},
  [3493] = {.lex_state = 0, .external_lex_state = 32},
  [3494] = {.lex_state = 0, .external_lex_state = 32},
  [3495] = {.lex_state = 0, .external_lex_state = 32},
  [3496] = {.lex_state = 0, .external_lex_state = 32},
  [3497] = {.lex_state = 0, .external_lex_state = 32},
  [3498] = {.lex_state = 0, .external_lex_state = 32},
  [3499] = {.lex_state = 0, .external_lex_state = 32},
  [3500] = {.lex_state = 0, .external_lex_state = 32},
  [3501] = {.lex_state = 0, .external_lex_state = 32},
  [3502] = {.lex_state = 0, .external_lex_state = 32},
  [3503] = {.lex_state = 0, .external_lex_state = 32},
  [3504] = {.lex_state = 0, .external_lex_state = 32},
  [3505] = {.lex_state = 0, .external_lex_state = 32},
  [3506] = {.lex_state = 0, .external_lex_state = 32},
  [3507] = {.lex_state = 0, .external_lex_state = 32},
  [3508] = {.lex_state = 0, .external_lex_state = 32},
  [3509] = {.lex_state = 0, .external_lex_state = 32},
  [3510] = {.lex_state = 0, .external_lex_state = 32},
  [3511] = {.lex_state = 0, .external_lex_state = 32},
  [3512] = {.lex_state = 0, .external_lex_state = 32},
  [3513] = {.lex_state = 0, .external_lex_state = 32},
  [3514] = {.lex_state = 0, .external_lex_state = 32},
  [3515] = {.lex_state = 0, .external_lex_state = 32},
  [3516] = {.lex_state = 0, .external_lex_state = 32},
  [3517] = {.lex_state = 0, .external_lex_state = 32},
  [3518] = {.lex_state = 0, .external_lex_state = 32},
  [3519] = {.lex_state = 0, .external_lex_state = 32},
  [3520] = {.lex_state = 0, .external_lex_state = 32},
  [3521] = {.lex_state = 0, .external_lex_state = 32},
  [3522] = {.lex_state = 0, .external_lex_state = 32},
  [3523] = {.lex_state = 0, .external_lex_state = 32},
  [3524] = {.lex_state = 0, .external_lex_state = 32},
  [3525] = {.lex_state = 0, .external_lex_state = 32},
  [3526] = {.lex_state = 0, .external_lex_state = 32},
  [3527] = {.lex_state = 0, .external_lex_state = 32},
  [3528] = {.lex_state = 0, .external_lex_state = 32},
  [3529] = {.lex_state = 0, .external_lex_state = 32},
  [3530] = {.lex_state = 0, .external_lex_state = 32},
  [3531] = {.lex_state = 0, .external_lex_state = 32},
  [3532] = {.lex_state = 0, .external_lex_state = 32},
  [3533] = {.lex_state = 0, .external_lex_state = 32},
  [3534] = {.lex_state = 0, .external_lex_state = 32},
  [3535] = {.lex_state = 0, .external_lex_state = 32},
  [3536] = {.lex_state = 0, .external_lex_state = 32},
  [3537] = {.lex_state = 0, .external_lex_state = 32},
  [3538] = {.lex_state = 0, .external_lex_state = 32},
  [3539] = {.lex_state = 0, .external_lex_state = 32},
  [3540] = {.lex_state = 0, .external_lex_state = 32},
  [3541] = {.lex_state = 0, .external_lex_state = 32},
  [3542] = {.lex_state = 0, .external_lex_state = 32},
  [3543] = {.lex_state = 0, .external_lex_state = 32},
  [3544] = {.lex_state = 0, .external_lex_state = 32},
  [3545] = {.lex_state = 0, .external_lex_state = 32},
  [3546] = {.lex_state = 0, .external_lex_state = 32},
  [3547] = {.lex_state = 0, .external_lex_state = 32},
  [3548] = {.lex_state = 0, .external_lex_state = 32},
  [3549] = {.lex_state = 0, .external_lex_state = 32},
  [3550] = {.lex_state = 0, .external_lex_state = 32},
  [3551] = {.lex_state = 0, .external_lex_state = 32},
  [3552] = {.lex_state = 0, .external_lex_state = 32},
  [3553] = {.lex_state = 0, .external_lex_state = 32},
  [3554] = {.lex_state = 0, .external_lex_state = 32},
  [3555] = {.lex_state = 0, .external_lex_state = 32},
  [3556] = {.lex_state = 0, .external_lex_state = 32},
  [3557] = {.lex_state = 0, .external_lex_state = 32},
  [3558] = {.lex_state = 0, .external_lex_state = 32},
  [3559] = {.lex_state = 0, .external_lex_state = 32},
  [3560] = {.lex_state = 0, .external_lex_state = 32},
  [3561] = {.lex_state = 0, .external_lex_state = 32},
  [3562] = {.lex_state = 0, .external_lex_state = 32},
  [3563] = {.lex_state = 0, .external_lex_state = 32},
  [3564] = {.lex_state = 0, .external_lex_state = 32},
  [3565] = {.lex_state = 0, .external_lex_state = 32},
  [3566] = {.lex_state = 0, .external_lex_state = 32},
  [3567] = {.lex_state = 0, .external_lex_state = 32},
  [3568] = {.lex_state = 0, .external_lex_state = 32},
  [3569] = {.lex_state = 0, .external_lex_state = 32},
  [3570] = {.lex_state = 0, .external_lex_state = 32},
  [3571] = {.lex_state = 0, .external_lex_state = 32},
  [3572] = {.lex_state = 0, .external_lex_state = 32},
  [3573] = {.lex_state = 0, .external_lex_state = 32},
  [3574] = {.lex_state = 0, .external_lex_state = 32},
  [3575] = {.lex_state = 0, .external_lex_state = 32},
  [3576] = {.lex_state = 0, .external_lex_state = 32},
  [3577] = {.lex_state = 0, .external_lex_state = 32},
  [3578] = {.lex_state = 0, .external_lex_state = 32},
  [3579] = {.lex_state = 0, .external_lex_state = 32},
  [3580] = {.lex_state = 0, .external_lex_state = 32},
  [3581] = {.lex_state = 0, .external_lex_state = 32},
  [3582] = {.lex_state = 0, .external_lex_state = 32},
  [3583] = {.lex_state = 0, .external_lex_state = 32},
  [3584] = {.lex_state = 0, .external_lex_state = 32},
  [3585] = {.lex_state = 0, .external_lex_state = 32},
  [3586] = {.lex_state = 0, .external_lex_state = 32},
  [3587] = {.lex_state = 0, .external_lex_state = 32},
  [3588] = {.lex_state = 0, .external_lex_state = 32},
  [3589] = {.lex_state = 0, .external_lex_state = 32},
  [3590] = {.lex_state = 0, .external_lex_state = 32},
  [3591] = {.lex_state = 0, .external_lex_state = 32},
  [3592] = {.lex_state = 0, .external_lex_state = 32},
  [3593] = {.lex_state = 0, .external_lex_state = 32},
  [3594] = {.lex_state = 0, .external_lex_state = 32},
  [3595] = {.lex_state = 0, .external_lex_state = 32},
  [3596] = {.lex_state = 0, .external_lex_state = 32},
  [3597] = {.lex_state = 0, .external_lex_state = 32},
  [3598] = {.lex_state = 0, .external_lex_state = 32},
  [3599] = {.lex_state = 0, .external_lex_state = 32},
  [3600] = {.lex_state = 0, .external_lex_state = 32},
  [3601] = {.lex_state = 0, .external_lex_state = 32},
  [3602] = {.lex_state = 0, .external_lex_state = 32},
  [3603] = {.lex_state = 0, .external_lex_state = 32},
  [3604] = {.lex_state = 0, .external_lex_state = 32},
  [3605] = {.lex_state = 0, .external_lex_state = 32},
  [3606] = {.lex_state = 0, .external_lex_state = 32},
  [3607] = {.lex_state = 0, .external_lex_state = 32},
  [3608] = {.lex_state = 0, .external_lex_state = 32},
  [3609] = {.lex_state = 0, .external_lex_state = 32},
  [3610] = {.lex_state = 0, .external_lex_state = 32},
  [3611] = {.lex_state = 0, .external_lex_state = 32},
  [3612] = {.lex_state = 0, .external_lex_state = 32},
  [3613] = {.lex_state = 0, .external_lex_state = 32},
  [3614] = {.lex_state = 0, .external_lex_state = 32},
  [3615] = {.lex_state = 0, .external_lex_state = 32},
  [3616] = {.lex_state = 0, .external_lex_state = 32},
  [3617] = {.lex_state = 0, .external_lex_state = 32},
  [3618] = {.lex_state = 0, .external_lex_state = 32},
  [3619] = {.lex_state = 0, .external_lex_state = 32},
  [3620] = {.lex_state = 0, .external_lex_state = 32},
  [3621] = {.lex_state = 0, .external_lex_state = 32},
  [3622] = {.lex_state = 0, .external_lex_state = 32},
  [3623] = {.lex_state = 0, .external_lex_state = 32},
  [3624] = {.lex_state = 0, .external_lex_state = 32},
  [3625] = {.lex_state = 0, .external_lex_state = 32},
  [3626] = {.lex_state = 0, .external_lex_state = 32},
  [3627] = {.lex_state = 0, .external_lex_state = 32},
  [3628] = {.lex_state = 0, .external_lex_state = 32},
  [3629] = {.lex_state = 0, .external_lex_state = 32},
  [3630] = {.lex_state = 0, .external_lex_state = 32},
  [3631] = {.lex_state = 0, .external_lex_state = 32},
  [3632] = {.lex_state = 0, .external_lex_state = 32},
  [3633] = {.lex_state = 0, .external_lex_state = 32},
  [3634] = {.lex_state = 0, .external_lex_state = 32},
  [3635] = {.lex_state = 0, .external_lex_state = 32},
  [3636] = {.lex_state = 0, .external_lex_state = 32},
  [3637] = {.lex_state = 0, .external_lex_state = 32},
  [3638] = {.lex_state = 0, .external_lex_state = 32},
  [3639] = {.lex_state = 0, .external_lex_state = 32},
  [3640] = {.lex_state = 0, .external_lex_state = 32},
  [3641] = {.lex_state = 0, .external_lex_state = 32},
  [3642] = {.lex_state = 0, .external_lex_state = 32},
  [3643] = {.lex_state = 0, .external_lex_state = 32},
  [3644] = {.lex_state = 0, .external_lex_state = 32},
  [3645] = {.lex_state = 0, .external_lex_state = 32},
  [3646] = {.lex_state = 0, .external_lex_state = 32},
  [3647] = {.lex_state = 0, .external_lex_state = 32},
  [3648] = {.lex_state = 0, .external_lex_state = 32},
  [3649] = {.lex_state = 0, .external_lex_state = 32},
  [3650] = {.lex_state = 0, .external_lex_state = 32},
  [3651] = {.lex_state = 0, .external_lex_state = 32},
  [3652] = {.lex_state = 0, .external_lex_state = 32},
  [3653] = {.lex_state = 0, .external_lex_state = 32},
  [3654] = {.lex_state = 0, .external_lex_state = 32},
  [3655] = {.lex_state = 0, .external_lex_state = 32},
  [3656] = {.lex_state = 0, .external_lex_state = 32},
  [3657] = {.lex_state = 0, .external_lex_state = 32},
  [3658] = {.lex_state = 0, .external_lex_state = 32},
  [3659] = {.lex_state = 0, .external_lex_state = 32},
  [3660] = {.lex_state = 0, .external_lex_state = 32},
  [3661] = {.lex_state = 0, .external_lex_state = 32},
  [3662] = {.lex_state = 0, .external_lex_state = 32},
  [3663] = {.lex_state = 0, .external_lex_state = 32},
  [3664] = {.lex_state = 0, .external_lex_state = 32},
  [3665] = {.lex_state = 0, .external_lex_state = 32},
  [3666] = {.lex_state = 0, .external_lex_state = 32},
  [3667] = {.lex_state = 0, .external_lex_state = 32},
  [3668] = {.lex_state = 0, .external_lex_state = 32},
  [3669] = {.lex_state = 0, .external_lex_state = 32},
  [3670] = {.lex_state = 0, .external_lex_state = 32},
  [3671] = {.lex_state = 0, .external_lex_state = 32},
  [3672] = {.lex_state = 0, .external_lex_state = 32},
  [3673] = {.lex_state = 0, .external_lex_state = 32},
  [3674] = {.lex_state = 0, .external_lex_state = 32},
  [3675] = {.lex_state = 0, .external_lex_state = 32},
  [3676] = {.lex_state = 0, .external_lex_state = 32},
  [3677] = {.lex_state = 0, .external_lex_state = 32},
  [3678] = {.lex_state = 0, .external_lex_state = 32},
  [3679] = {.lex_state = 0, .external_lex_state = 32},
  [3680] = {.lex_state = 0, .external_lex_state = 32},
  [3681] = {.lex_state = 0, .external_lex_state = 32},
  [3682] = {.lex_state = 0, .external_lex_state = 32},
  [3683] = {.lex_state = 0, .external_lex_state = 32},
  [3684] = {.lex_state = 0, .external_lex_state = 32},
  [3685] = {.lex_state = 0, .external_lex_state = 32},
  [3686] = {.lex_state = 0, .external_lex_state = 32},
  [3687] = {.lex_state = 0, .external_lex_state = 32},
  [3688] = {.lex_state = 0, .external_lex_state = 32},
  [3689] = {.lex_state = 0, .external_lex_state = 32},
  [3690] = {.lex_state = 0, .external_lex_state = 32},
  [3691] = {.lex_state = 0, .external_lex_state = 32},
  [3692] = {.lex_state = 0, .external_lex_state = 32},
  [3693] = {.lex_state = 0, .external_lex_state = 32},
  [3694] = {.lex_state = 0, .external_lex_state = 32},
  [3695] = {.lex_state = 0, .external_lex_state = 32},
  [3696] = {.lex_state = 0, .external_lex_state = 32},
  [3697] = {.lex_state = 0, .external_lex_state = 32},
  [3698] = {.lex_state = 0, .external_lex_state = 32},
  [3699] = {.lex_state = 0, .external_lex_state = 32},
  [3700] = {.lex_state = 0, .external_lex_state = 32},
  [3701] = {.lex_state = 0, .external_lex_state = 32},
  [3702] = {.lex_state = 0, .external_lex_state = 32},
  [3703] = {.lex_state = 0, .external_lex_state = 32},
  [3704] = {.lex_state = 0, .external_lex_state = 32},
  [3705] = {.lex_state = 0, .external_lex_state = 32},
  [3706] = {.lex_state = 0, .external_lex_state = 32},
  [3707] = {.lex_state = 0, .external_lex_state = 32},
  [3708] = {.lex_state = 0, .external_lex_state = 32},
  [3709] = {.lex_state = 0, .external_lex_state = 32},
  [3710] = {.lex_state = 0, .external_lex_state = 32},
  [3711] = {.lex_state = 0, .external_lex_state = 32},
  [3712] = {.lex_state = 0, .external_lex_state = 32},
  [3713] = {.lex_state = 0, .external_lex_state = 32},
  [3714] = {.lex_state = 0, .external_lex_state = 32},
  [3715] = {.lex_state = 0, .external_lex_state = 32},
  [3716] = {.lex_state = 0, .external_lex_state = 32},
  [3717] = {.lex_state = 0, .external_lex_state = 32},
  [3718] = {.lex_state = 0, .external_lex_state = 32},
  [3719] = {.lex_state = 0, .external_lex_state = 32},
  [3720] = {.lex_state = 0, .external_lex_state = 32},
  [3721] = {.lex_state = 0, .external_lex_state = 32},
  [3722] = {.lex_state = 0, .external_lex_state = 32},
  [3723] = {.lex_state = 0, .external_lex_state = 32},
  [3724] = {.lex_state = 0, .external_lex_state = 32},
  [3725] = {.lex_state = 0, .external_lex_state = 32},
  [3726] = {.lex_state = 0, .external_lex_state = 32},
  [3727] = {.lex_state = 0, .external_lex_state = 32},
  [3728] = {.lex_state = 0, .external_lex_state = 32},
  [3729] = {.lex_state = 0, .external_lex_state = 32},
  [3730] = {.lex_state = 0, .external_lex_state = 32},
  [3731] = {.lex_state = 0, .external_lex_state = 32},
  [3732] = {.lex_state = 0, .external_lex_state = 32},
  [3733] = {.lex_state = 0, .external_lex_state = 32},
  [3734] = {.lex_state = 0, .external_lex_state = 32},
  [3735] = {.lex_state = 0, .external_lex_state = 32},
  [3736] = {.lex_state = 0, .external_lex_state = 32},
  [3737] = {.lex_state = 0, .external_lex_state = 32},
  [3738] = {.lex_state = 0, .external_lex_state = 32},
  [3739] = {.lex_state = 0, .external_lex_state = 32},
  [3740] = {.lex_state = 0, .external_lex_state = 32},
  [3741] = {.lex_state = 0, .external_lex_state = 32},
  [3742] = {.lex_state = 0, .external_lex_state = 32},
  [3743] = {.lex_state = 0, .external_lex_state = 32},
  [3744] = {.lex_state = 0, .external_lex_state = 32},
  [3745] = {.lex_state = 0, .external_lex_state = 32},
  [3746] = {.lex_state = 0, .external_lex_state = 32},
  [3747] = {.lex_state = 0, .external_lex_state = 32},
  [3748] = {.lex_state = 0, .external_lex_state = 32},
  [3749] = {.lex_state = 0, .external_lex_state = 32},
  [3750] = {.lex_state = 0, .external_lex_state = 32},
  [3751] = {.lex_state = 0, .external_lex_state = 32},
  [3752] = {.lex_state = 0, .external_lex_state = 32},
  [3753] = {.lex_state = 0, .external_lex_state = 32},
  [3754] = {.lex_state = 0, .external_lex_state = 32},
  [3755] = {.lex_state = 0, .external_lex_state = 32},
  [3756] = {.lex_state = 0, .external_lex_state = 32},
  [3757] = {.lex_state = 0, .external_lex_state = 32},
  [3758] = {.lex_state = 0, .external_lex_state = 32},
  [3759] = {.lex_state = 0, .external_lex_state = 32},
  [3760] = {.lex_state = 0, .external_lex_state = 32},
  [3761] = {.lex_state = 0, .external_lex_state = 32},
  [3762] = {.lex_state = 0, .external_lex_state = 32},
  [3763] = {.lex_state = 0, .external_lex_state = 32},
  [3764] = {.lex_state = 0, .external_lex_state = 32},
  [3765] = {.lex_state = 0, .external_lex_state = 32},
  [3766] = {.lex_state = 0, .external_lex_state = 32},
  [3767] = {.lex_state = 0, .external_lex_state = 32},
  [3768] = {.lex_state = 0, .external_lex_state = 32},
  [3769] = {.lex_state = 0, .external_lex_state = 32},
  [3770] = {.lex_state = 0, .external_lex_state = 32},
  [3771] = {.lex_state = 0, .external_lex_state = 32},
  [3772] = {.lex_state = 0, .external_lex_state = 32},
  [3773] = {.lex_state = 0, .external_lex_state = 32},
  [3774] = {.lex_state = 0, .external_lex_state = 32},
  [3775] = {.lex_state = 0, .external_lex_state = 32},
  [3776] = {.lex_state = 0, .external_lex_state = 32},
  [3777] = {.lex_state = 0, .external_lex_state = 32},
  [3778] = {.lex_state = 0, .external_lex_state = 32},
  [3779] = {.lex_state = 0, .external_lex_state = 32},
  [3780] = {.lex_state = 0, .external_lex_state = 32},
  [3781] = {.lex_state = 0, .external_lex_state = 32},
  [3782] = {.lex_state = 0, .external_lex_state = 32},
  [3783] = {.lex_state = 0, .external_lex_state = 32},
  [3784] = {.lex_state = 0, .external_lex_state = 32},
  [3785] = {.lex_state = 0, .external_lex_state = 32},
  [3786] = {.lex_state = 0, .external_lex_state = 32},
  [3787] = {.lex_state = 0, .external_lex_state = 32},
  [3788] = {.lex_state = 0, .external_lex_state = 32},
  [3789] = {.lex_state = 0, .external_lex_state = 32},
  [3790] = {.lex_state = 0, .external_lex_state = 32},
  [3791] = {.lex_state = 0, .external_lex_state = 32},
  [3792] = {.lex_state = 0, .external_lex_state = 32},
  [3793] = {.lex_state = 0, .external_lex_state = 32},
  [3794] = {.lex_state = 0, .external_lex_state = 32},
  [3795] = {.lex_state = 0, .external_lex_state = 32},
  [3796] = {.lex_state = 0, .external_lex_state = 32},
  [3797] = {.lex_state = 0, .external_lex_state = 32},
  [3798] = {.lex_state = 0, .external_lex_state = 32},
  [3799] = {.lex_state = 0, .external_lex_state = 32},
  [3800] = {.lex_state = 0, .external_lex_state = 32},
  [3801] = {.lex_state = 0, .external_lex_state = 32},
  [3802] = {.lex_state = 0, .external_lex_state = 32},
  [3803] = {.lex_state = 0, .external_lex_state = 32},
  [3804] = {.lex_state = 0, .external_lex_state = 32},
  [3805] = {.lex_state = 0, .external_lex_state = 32},
  [3806] = {.lex_state = 0, .external_lex_state = 32},
  [3807] = {.lex_state = 0, .external_lex_state = 32},
  [3808] = {.lex_state = 0, .external_lex_state = 32},
  [3809] = {.lex_state = 0, .external_lex_state = 32},
  [3810] = {.lex_state = 0, .external_lex_state = 32},
  [3811] = {.lex_state = 0, .external_lex_state = 32},
  [3812] = {.lex_state = 0, .external_lex_state = 32},
  [3813] = {.lex_state = 0, .external_lex_state = 32},
  [3814] = {.lex_state = 0, .external_lex_state = 32},
  [3815] = {.lex_state = 0, .external_lex_state = 32},
  [3816] = {.lex_state = 0, .external_lex_state = 32},
  [3817] = {.lex_state = 0, .external_lex_state = 32},
  [3818] = {.lex_state = 0, .external_lex_state = 32},
  [3819] = {.lex_state = 0, .external_lex_state = 32},
  [3820] = {.lex_state = 0, .external_lex_state = 32},
  [3821] = {.lex_state = 0, .external_lex_state = 32},
  [3822] = {.lex_state = 0, .external_lex_state = 32},
  [3823] = {.lex_state = 0, .external_lex_state = 32},
  [3824] = {.lex_state = 0, .external_lex_state = 32},
  [3825] = {.lex_state = 0, .external_lex_state = 32},
  [3826] = {.lex_state = 0, .external_lex_state = 32},
  [3827] = {.lex_state = 0, .external_lex_state = 32},
  [3828] = {.lex_state = 0, .external_lex_state = 32},
  [3829] = {.lex_state = 0, .external_lex_state = 32},
  [3830] = {.lex_state = 0, .external_lex_state = 32},
  [3831] = {.lex_state = 0, .external_lex_state = 32},
  [3832] = {.lex_state = 0, .external_lex_state = 32},
  [3833] = {.lex_state = 0, .external_lex_state = 32},
  [3834] = {.lex_state = 0, .external_lex_state = 32},
  [3835] = {.lex_state = 0, .external_lex_state = 32},
  [3836] = {.lex_state = 0, .external_lex_state = 32},
  [3837] = {.lex_state = 0, .external_lex_state = 32},
  [3838] = {.lex_state = 0, .external_lex_state = 32},
  [3839] = {.lex_state = 0, .external_lex_state = 32},
  [3840] = {.lex_state = 0, .external_lex_state = 32},
  [3841] = {.lex_state = 0, .external_lex_state = 32},
  [3842] = {.lex_state = 0, .external_lex_state = 32},
  [3843] = {.lex_state = 0, .external_lex_state = 32},
  [3844] = {.lex_state = 0, .external_lex_state = 32},
  [3845] = {.lex_state = 0, .external_lex_state = 32},
  [3846] = {.lex_state = 0, .external_lex_state = 32},
  [3847] = {.lex_state = 0, .external_lex_state = 32},
  [3848] = {.lex_state = 0, .external_lex_state = 32},
  [3849] = {.lex_state = 0, .external_lex_state = 32},
  [3850] = {.lex_state = 0, .external_lex_state = 32},
  [3851] = {.lex_state = 0, .external_lex_state = 32},
  [3852] = {.lex_state = 0, .external_lex_state = 32},
  [3853] = {.lex_state = 0, .external_lex_state = 32},
  [3854] = {.lex_state = 0, .external_lex_state = 32},
  [3855] = {.lex_state = 0, .external_lex_state = 32},
  [3856] = {.lex_state = 0, .external_lex_state = 32},
  [3857] = {.lex_state = 0, .external_lex_state = 32},
  [3858] = {.lex_state = 0, .external_lex_state = 32},
  [3859] = {.lex_state = 0, .external_lex_state = 32},
  [3860] = {.lex_state = 0, .external_lex_state = 32},
  [3861] = {.lex_state = 0, .external_lex_state = 32},
  [3862] = {.lex_state = 0, .external_lex_state = 32},
  [3863] = {.lex_state = 0, .external_lex_state = 32},
  [3864] = {.lex_state = 0, .external_lex_state = 32},
  [3865] = {.lex_state = 0, .external_lex_state = 32},
  [3866] = {.lex_state = 0, .external_lex_state = 32},
  [3867] = {.lex_state = 0, .external_lex_state = 32},
  [3868] = {.lex_state = 0, .external_lex_state = 32},
  [3869] = {.lex_state = 0, .external_lex_state = 32},
  [3870] = {.lex_state = 0, .external_lex_state = 32},
  [3871] = {.lex_state = 0, .external_lex_state = 32},
  [3872] = {.lex_state = 0, .external_lex_state = 32},
  [3873] = {.lex_state = 0, .external_lex_state = 32},
  [3874] = {.lex_state = 0, .external_lex_state = 32},
  [3875] = {.lex_state = 0, .external_lex_state = 32},
  [3876] = {.lex_state = 0, .external_lex_state = 32},
  [3877] = {.lex_state = 0, .external_lex_state = 32},
  [3878] = {.lex_state = 0, .external_lex_state = 32},
  [3879] = {.lex_state = 0, .external_lex_state = 32},
  [3880] = {.lex_state = 0, .external_lex_state = 32},
  [3881] = {.lex_state = 0, .external_lex_state = 32},
  [3882] = {.lex_state = 0, .external_lex_state = 32},
  [3883] = {.lex_state = 0, .external_lex_state = 32},
  [3884] = {.lex_state = 0, .external_lex_state = 32},
  [3885] = {.lex_state = 0, .external_lex_state = 32},
  [3886] = {.lex_state = 0, .external_lex_state = 32},
  [3887] = {.lex_state = 0, .external_lex_state = 32},
  [3888] = {.lex_state = 0, .external_lex_state = 32},
  [3889] = {.lex_state = 0, .external_lex_state = 32},
  [3890] = {.lex_state = 0, .external_lex_state = 32},
  [3891] = {.lex_state = 0, .external_lex_state = 32},
  [3892] = {.lex_state = 0, .external_lex_state = 32},
  [3893] = {.lex_state = 0, .external_lex_state = 32},
  [3894] = {.lex_state = 0, .external_lex_state = 32},
  [3895] = {.lex_state = 0, .external_lex_state = 32},
  [3896] = {.lex_state = 0, .external_lex_state = 32},
  [3897] = {.lex_state = 0, .external_lex_state = 32},
  [3898] = {.lex_state = 0, .external_lex_state = 32},
  [3899] = {.lex_state = 0, .external_lex_state = 32},
  [3900] = {.lex_state = 0, .external_lex_state = 32},
  [3901] = {.lex_state = 0, .external_lex_state = 32},
  [3902] = {.lex_state = 0, .external_lex_state = 32},
  [3903] = {.lex_state = 0, .external_lex_state = 32},
  [3904] = {.lex_state = 0, .external_lex_state = 32},
  [3905] = {.lex_state = 0, .external_lex_state = 32},
  [3906] = {.lex_state = 0, .external_lex_state = 32},
  [3907] = {.lex_state = 0, .external_lex_state = 32},
  [3908] = {.lex_state = 0, .external_lex_state = 32},
  [3909] = {.lex_state = 0, .external_lex_state = 32},
  [3910] = {.lex_state = 0, .external_lex_state = 32},
  [3911] = {.lex_state = 0, .external_lex_state = 32},
  [3912] = {.lex_state = 0, .external_lex_state = 32},
  [3913] = {.lex_state = 0, .external_lex_state = 32},
  [3914] = {.lex_state = 0, .external_lex_state = 32},
  [3915] = {.lex_state = 0, .external_lex_state = 32},
  [3916] = {.lex_state = 0, .external_lex_state = 32},
  [3917] = {.lex_state = 0, .external_lex_state = 32},
  [3918] = {.lex_state = 0, .external_lex_state = 32},
  [3919] = {.lex_state = 0, .external_lex_state = 32},
  [3920] = {.lex_state = 0, .external_lex_state = 32},
  [3921] = {.lex_state = 0, .external_lex_state = 32},
  [3922] = {.lex_state = 0, .external_lex_state = 32},
  [3923] = {.lex_state = 0, .external_lex_state = 32},
  [3924] = {.lex_state = 0, .external_lex_state = 32},
  [3925] = {.lex_state = 0, .external_lex_state = 32},
  [3926] = {.lex_state = 0, .external_lex_state = 32},
  [3927] = {.lex_state = 0, .external_lex_state = 32},
  [3928] = {.lex_state = 0, .external_lex_state = 32},
  [3929] = {.lex_state = 0, .external_lex_state = 32},
  [3930] = {.lex_state = 0, .external_lex_state = 32},
  [3931] = {.lex_state = 0, .external_lex_state = 32},
  [3932] = {.lex_state = 0, .external_lex_state = 32},
  [3933] = {.lex_state = 0, .external_lex_state = 32},
  [3934] = {.lex_state = 0, .external_lex_state = 32},
  [3935] = {.lex_state = 0, .external_lex_state = 32},
  [3936] = {.lex_state = 0, .external_lex_state = 32},
  [3937] = {.lex_state = 0, .external_lex_state = 32},
  [3938] = {.lex_state = 0, .external_lex_state = 32},
  [3939] = {.lex_state = 0, .external_lex_state = 32},
  [3940] = {.lex_state = 0, .external_lex_state = 32},
  [3941] = {.lex_state = 0, .external_lex_state = 32},
  [3942] = {.lex_state = 0, .external_lex_state = 32},
  [3943] = {.lex_state = 0, .external_lex_state = 32},
  [3944] = {.lex_state = 0, .external_lex_state = 32},
  [3945] = {.lex_state = 0, .external_lex_state = 32},
  [3946] = {.lex_state = 0, .external_lex_state = 32},
  [3947] = {.lex_state = 0, .external_lex_state = 32},
  [3948] = {.lex_state = 0, .external_lex_state = 32},
  [3949] = {.lex_state = 0, .external_lex_state = 32},
  [3950] = {.lex_state = 0, .external_lex_state = 32},
  [3951] = {.lex_state = 0, .external_lex_state = 32},
  [3952] = {.lex_state = 0, .external_lex_state = 32},
  [3953] = {.lex_state = 0, .external_lex_state = 32},
  [3954] = {.lex_state = 0, .external_lex_state = 32},
  [3955] = {.lex_state = 0, .external_lex_state = 32},
  [3956] = {.lex_state = 0, .external_lex_state = 32},
  [3957] = {.lex_state = 0, .external_lex_state = 32},
  [3958] = {.lex_state = 0, .external_lex_state = 32},
  [3959] = {.lex_state = 0, .external_lex_state = 32},
  [3960] = {.lex_state = 0, .external_lex_state = 32},
  [3961] = {.lex_state = 0, .external_lex_state = 32},
  [3962] = {.lex_state = 0, .external_lex_state = 32},
  [3963] = {.lex_state = 0, .external_lex_state = 32},
  [3964] = {.lex_state = 0, .external_lex_state = 32},
  [3965] = {.lex_state = 0, .external_lex_state = 32},
  [3966] = {.lex_state = 0, .external_lex_state = 32},
  [3967] = {.lex_state = 0, .external_lex_state = 32},
  [3968] = {.lex_state = 0, .external_lex_state = 32},
  [3969] = {.lex_state = 0, .external_lex_state = 32},
  [3970] = {.lex_state = 0, .external_lex_state = 32},
  [3971] = {.lex_state = 0, .external_lex_state = 32},
  [3972] = {.lex_state = 0, .external_lex_state = 32},
  [3973] = {.lex_state = 0, .external_lex_state = 32},
  [3974] = {.lex_state = 0, .external_lex_state = 32},
  [3975] = {.lex_state = 0, .external_lex_state = 32},
  [3976] = {.lex_state = 0, .external_lex_state = 32},
  [3977] = {.lex_state = 0, .external_lex_state = 32},
  [3978] = {.lex_state = 0, .external_lex_state = 32},
  [3979] = {.lex_state = 0, .external_lex_state = 32},
  [3980] = {.lex_state = 0, .external_lex_state = 32},
  [3981] = {.lex_state = 0, .external_lex_state = 32},
  [3982] = {.lex_state = 0, .external_lex_state = 32},
  [3983] = {.lex_state = 0, .external_lex_state = 32},
  [3984] = {.lex_state = 0, .external_lex_state = 32},
  [3985] = {.lex_state = 0, .external_lex_state = 32},
  [3986] = {.lex_state = 0, .external_lex_state = 32},
  [3987] = {.lex_state = 0, .external_lex_state = 32},
  [3988] = {.lex_state = 0, .external_lex_state = 32},
  [3989] = {.lex_state = 0, .external_lex_state = 33},
  [3990] = {.lex_state = 0, .external_lex_state = 32},
  [3991] = {.lex_state = 0, .external_lex_state = 32},
  [3992] = {.lex_state = 0, .external_lex_state = 32},
  [3993] = {.lex_state = 0, .external_lex_state = 32},
  [3994] = {.lex_state = 0, .external_lex_state = 32},
  [3995] = {.lex_state = 0, .external_lex_state = 32},
  [3996] = {.lex_state = 0, .external_lex_state = 32},
  [3997] = {.lex_state = 0, .external_lex_state = 32},
  [3998] = {.lex_state = 0, .external_lex_state = 32},
  [3999] = {.lex_state = 0, .external_lex_state = 32},
  [4000] = {.lex_state = 0, .external_lex_state = 32},
  [4001] = {.lex_state = 0, .external_lex_state = 32},
  [4002] = {.lex_state = 0, .external_lex_state = 32},
  [4003] = {.lex_state = 0, .external_lex_state = 32},
  [4004] = {.lex_state = 0, .external_lex_state = 32},
  [4005] = {.lex_state = 0, .external_lex_state = 32},
  [4006] = {.lex_state = 0, .external_lex_state = 32},
  [4007] = {.lex_state = 0, .external_lex_state = 32},
  [4008] = {.lex_state = 0, .external_lex_state = 32},
  [4009] = {.lex_state = 0, .external_lex_state = 32},
  [4010] = {.lex_state = 0, .external_lex_state = 32},
  [4011] = {.lex_state = 0, .external_lex_state = 32},
  [4012] = {.lex_state = 0, .external_lex_state = 32},
  [4013] = {.lex_state = 0, .external_lex_state = 32},
  [4014] = {.lex_state = 0, .external_lex_state = 32},
  [4015] = {.lex_state = 0, .external_lex_state = 32},
  [4016] = {.lex_state = 0, .external_lex_state = 32},
  [4017] = {.lex_state = 0, .external_lex_state = 32},
  [4018] = {.lex_state = 0, .external_lex_state = 32},
  [4019] = {.lex_state = 0, .external_lex_state = 32},
  [4020] = {.lex_state = 0, .external_lex_state = 32},
  [4021] = {.lex_state = 0, .external_lex_state = 32},
  [4022] = {.lex_state = 0, .external_lex_state = 32},
  [4023] = {.lex_state = 0, .external_lex_state = 32},
  [4024] = {.lex_state = 0, .external_lex_state = 32},
  [4025] = {.lex_state = 0, .external_lex_state = 32},
  [4026] = {.lex_state = 0, .external_lex_state = 32},
  [4027] = {.lex_state = 0, .external_lex_state = 32},
  [4028] = {.lex_state = 0, .external_lex_state = 32},
  [4029] = {.lex_state = 0, .external_lex_state = 32},
  [4030] = {.lex_state = 0, .external_lex_state = 32},
  [4031] = {.lex_state = 0, .external_lex_state = 32},
  [4032] = {.lex_state = 0, .external_lex_state = 32},
  [4033] = {.lex_state = 0, .external_lex_state = 32},
  [4034] = {.lex_state = 0, .external_lex_state = 32},
  [4035] = {.lex_state = 0, .external_lex_state = 32},
  [4036] = {.lex_state = 0, .external_lex_state = 32},
  [4037] = {.lex_state = 0, .external_lex_state = 32},
  [4038] = {.lex_state = 0, .external_lex_state = 32},
  [4039] = {.lex_state = 0, .external_lex_state = 32},
  [4040] = {.lex_state = 0, .external_lex_state = 32},
  [4041] = {.lex_state = 0, .external_lex_state = 32},
  [4042] = {.lex_state = 0, .external_lex_state = 32},
  [4043] = {.lex_state = 0, .external_lex_state = 32},
  [4044] = {.lex_state = 0, .external_lex_state = 32},
  [4045] = {.lex_state = 0, .external_lex_state = 32},
  [4046] = {.lex_state = 0, .external_lex_state = 32},
  [4047] = {.lex_state = 0, .external_lex_state = 32},
  [4048] = {.lex_state = 0, .external_lex_state = 32},
  [4049] = {.lex_state = 0, .external_lex_state = 32},
  [4050] = {.lex_state = 0, .external_lex_state = 32},
  [4051] = {.lex_state = 0, .external_lex_state = 32},
  [4052] = {.lex_state = 0, .external_lex_state = 32},
  [4053] = {.lex_state = 0, .external_lex_state = 32},
  [4054] = {.lex_state = 0, .external_lex_state = 32},
  [4055] = {.lex_state = 0, .external_lex_state = 32},
  [4056] = {.lex_state = 0, .external_lex_state = 32},
  [4057] = {.lex_state = 0, .external_lex_state = 32},
  [4058] = {.lex_state = 0, .external_lex_state = 32},
  [4059] = {.lex_state = 0, .external_lex_state = 32},
  [4060] = {.lex_state = 0, .external_lex_state = 32},
  [4061] = {.lex_state = 0, .external_lex_state = 32},
  [4062] = {.lex_state = 0, .external_lex_state = 32},
  [4063] = {.lex_state = 0, .external_lex_state = 32},
  [4064] = {.lex_state = 0, .external_lex_state = 32},
  [4065] = {.lex_state = 0, .external_lex_state = 32},
  [4066] = {.lex_state = 0, .external_lex_state = 32},
  [4067] = {.lex_state = 0, .external_lex_state = 32},
  [4068] = {.lex_state = 0, .external_lex_state = 32},
  [4069] = {.lex_state = 0, .external_lex_state = 32},
  [4070] = {.lex_state = 0, .external_lex_state = 32},
  [4071] = {.lex_state = 0, .external_lex_state = 32},
  [4072] = {.lex_state = 0, .external_lex_state = 32},
  [4073] = {.lex_state = 0, .external_lex_state = 32},
  [4074] = {.lex_state = 0, .external_lex_state = 32},
  [4075] = {.lex_state = 0, .external_lex_state = 32},
  [4076] = {.lex_state = 0, .external_lex_state = 32},
  [4077] = {.lex_state = 0, .external_lex_state = 32},
  [4078] = {.lex_state = 0, .external_lex_state = 32},
  [4079] = {.lex_state = 0, .external_lex_state = 32},
  [4080] = {.lex_state = 0, .external_lex_state = 32},
  [4081] = {.lex_state = 0, .external_lex_state = 32},
  [4082] = {.lex_state = 0, .external_lex_state = 32},
  [4083] = {.lex_state = 0, .external_lex_state = 32},
  [4084] = {.lex_state = 0, .external_lex_state = 32},
  [4085] = {.lex_state = 0, .external_lex_state = 32},
  [4086] = {.lex_state = 0, .external_lex_state = 32},
  [4087] = {.lex_state = 0, .external_lex_state = 32},
  [4088] = {.lex_state = 0, .external_lex_state = 32},
  [4089] = {.lex_state = 0, .external_lex_state = 34},
  [4090] = {.lex_state = 0, .external_lex_state = 34},
  [4091] = {.lex_state = 0, .external_lex_state = 34},
  [4092] = {.lex_state = 0, .external_lex_state = 34},
  [4093] = {.lex_state = 0, .external_lex_state = 34},
  [4094] = {.lex_state = 0, .external_lex_state = 34},
  [4095] = {.lex_state = 0, .external_lex_state = 34},
  [4096] = {.lex_state = 0, .external_lex_state = 34},
  [4097] = {.lex_state = 0, .external_lex_state = 34},
  [4098] = {.lex_state = 0, .external_lex_state = 34},
  [4099] = {.lex_state = 0, .external_lex_state = 34},
  [4100] = {.lex_state = 0, .external_lex_state = 34},
  [4101] = {.lex_state = 0, .external_lex_state = 34},
  [4102] = {.lex_state = 0, .external_lex_state = 34},
  [4103] = {.lex_state = 0, .external_lex_state = 34},
  [4104] = {.lex_state = 0, .external_lex_state = 34},
  [4105] = {.lex_state = 0, .external_lex_state = 34},
  [4106] = {.lex_state = 0, .external_lex_state = 34},
  [4107] = {.lex_state = 0, .external_lex_state = 34},
  [4108] = {.lex_state = 0, .external_lex_state = 34},
  [4109] = {.lex_state = 0, .external_lex_state = 34},
  [4110] = {.lex_state = 0, .external_lex_state = 34},
  [4111] = {.lex_state = 0, .external_lex_state = 34},
  [4112] = {.lex_state = 0, .external_lex_state = 34},
  [4113] = {.lex_state = 0, .external_lex_state = 34},
  [4114] = {.lex_state = 0, .external_lex_state = 34},
  [4115] = {.lex_state = 0, .external_lex_state = 34},
  [4116] = {.lex_state = 0, .external_lex_state = 34},
  [4117] = {.lex_state = 0, .external_lex_state = 34},
  [4118] = {.lex_state = 0, .external_lex_state = 34},
  [4119] = {.lex_state = 0, .external_lex_state = 34},
  [4120] = {.lex_state = 0, .external_lex_state = 34},
  [4121] = {.lex_state = 0, .external_lex_state = 34},
  [4122] = {.lex_state = 0, .external_lex_state = 34},
  [4123] = {.lex_state = 0, .external_lex_state = 34},
  [4124] = {.lex_state = 0, .external_lex_state = 34},
  [4125] = {.lex_state = 0, .external_lex_state = 34},
  [4126] = {.lex_state = 0, .external_lex_state = 34},
  [4127] = {.lex_state = 0, .external_lex_state = 34},
  [4128] = {.lex_state = 0, .external_lex_state = 34},
  [4129] = {.lex_state = 0, .external_lex_state = 34},
  [4130] = {.lex_state = 0, .external_lex_state = 34},
  [4131] = {.lex_state = 0, .external_lex_state = 34},
  [4132] = {.lex_state = 0, .external_lex_state = 34},
  [4133] = {.lex_state = 0, .external_lex_state = 34},
  [4134] = {.lex_state = 0, .external_lex_state = 34},
  [4135] = {.lex_state = 0, .external_lex_state = 34},
  [4136] = {.lex_state = 0, .external_lex_state = 34},
  [4137] = {.lex_state = 0, .external_lex_state = 34},
  [4138] = {.lex_state = 0, .external_lex_state = 34},
  [4139] = {.lex_state = 0, .external_lex_state = 34},
  [4140] = {.lex_state = 0, .external_lex_state = 34},
  [4141] = {.lex_state = 0, .external_lex_state = 34},
  [4142] = {.lex_state = 0, .external_lex_state = 34},
  [4143] = {.lex_state = 0, .external_lex_state = 34},
  [4144] = {.lex_state = 0, .external_lex_state = 34},
  [4145] = {.lex_state = 0, .external_lex_state = 34},
  [4146] = {.lex_state = 0, .external_lex_state = 34},
  [4147] = {.lex_state = 0, .external_lex_state = 34},
  [4148] = {.lex_state = 0, .external_lex_state = 34},
  [4149] = {.lex_state = 0, .external_lex_state = 34},
  [4150] = {.lex_state = 0, .external_lex_state = 34},
  [4151] = {.lex_state = 0, .external_lex_state = 34},
  [4152] = {.lex_state = 0, .external_lex_state = 34},
  [4153] = {.lex_state = 0, .external_lex_state = 34},
  [4154] = {.lex_state = 0, .external_lex_state = 34},
  [4155] = {.lex_state = 0, .external_lex_state = 34},
  [4156] = {.lex_state = 0, .external_lex_state = 34},
  [4157] = {.lex_state = 0, .external_lex_state = 34},
  [4158] = {.lex_state = 0, .external_lex_state = 34},
  [4159] = {.lex_state = 0, .external_lex_state = 34},
  [4160] = {.lex_state = 0, .external_lex_state = 34},
  [4161] = {.lex_state = 0, .external_lex_state = 34},
  [4162] = {.lex_state = 0, .external_lex_state = 34},
  [4163] = {.lex_state = 0, .external_lex_state = 34},
  [4164] = {.lex_state = 0, .external_lex_state = 34},
  [4165] = {.lex_state = 0, .external_lex_state = 34},
  [4166] = {.lex_state = 0, .external_lex_state = 34},
  [4167] = {.lex_state = 0, .external_lex_state = 34},
  [4168] = {.lex_state = 0, .external_lex_state = 34},
  [4169] = {.lex_state = 0, .external_lex_state = 34},
  [4170] = {.lex_state = 0, .external_lex_state = 34},
  [4171] = {.lex_state = 0, .external_lex_state = 34},
  [4172] = {.lex_state = 0, .external_lex_state = 34},
  [4173] = {.lex_state = 0, .external_lex_state = 34},
  [4174] = {.lex_state = 0, .external_lex_state = 34},
  [4175] = {.lex_state = 0, .external_lex_state = 34},
  [4176] = {.lex_state = 0, .external_lex_state = 34},
  [4177] = {.lex_state = 0, .external_lex_state = 34},
  [4178] = {.lex_state = 0, .external_lex_state = 34},
  [4179] = {.lex_state = 0, .external_lex_state = 34},
  [4180] = {.lex_state = 0, .external_lex_state = 34},
  [4181] = {.lex_state = 0, .external_lex_state = 34},
  [4182] = {.lex_state = 0, .external_lex_state = 34},
  [4183] = {.lex_state = 0, .external_lex_state = 34},
  [4184] = {.lex_state = 0, .external_lex_state = 34},
  [4185] = {.lex_state = 0, .external_lex_state = 34},
  [4186] = {.lex_state = 0, .external_lex_state = 34},
  [4187] = {.lex_state = 0, .external_lex_state = 34},
  [4188] = {.lex_state = 0, .external_lex_state = 34},
  [4189] = {.lex_state = 0, .external_lex_state = 34},
  [4190] = {.lex_state = 0, .external_lex_state = 34},
  [4191] = {.lex_state = 0, .external_lex_state = 34},
  [4192] = {.lex_state = 0, .external_lex_state = 34},
  [4193] = {.lex_state = 0, .external_lex_state = 34},
  [4194] = {.lex_state = 0, .external_lex_state = 34},
  [4195] = {.lex_state = 0, .external_lex_state = 34},
  [4196] = {.lex_state = 0, .external_lex_state = 34},
  [4197] = {.lex_state = 0, .external_lex_state = 34},
  [4198] = {.lex_state = 0, .external_lex_state = 34},
  [4199] = {.lex_state = 0, .external_lex_state = 34},
  [4200] = {.lex_state = 0, .external_lex_state = 34},
  [4201] = {.lex_state = 0, .external_lex_state = 34},
  [4202] = {.lex_state = 0, .external_lex_state = 34},
  [4203] = {.lex_state = 0, .external_lex_state = 34},
  [4204] = {.lex_state = 0, .external_lex_state = 34},
  [4205] = {.lex_state = 0, .external_lex_state = 34},
  [4206] = {.lex_state = 0, .external_lex_state = 34},
  [4207] = {.lex_state = 0, .external_lex_state = 34},
  [4208] = {.lex_state = 0, .external_lex_state = 34},
  [4209] = {.lex_state = 0, .external_lex_state = 34},
  [4210] = {.lex_state = 0, .external_lex_state = 34},
  [4211] = {.lex_state = 0, .external_lex_state = 34},
  [4212] = {.lex_state = 0, .external_lex_state = 34},
  [4213] = {.lex_state = 0, .external_lex_state = 34},
  [4214] = {.lex_state = 0, .external_lex_state = 34},
  [4215] = {.lex_state = 0, .external_lex_state = 34},
  [4216] = {.lex_state = 0, .external_lex_state = 34},
  [4217] = {.lex_state = 0, .external_lex_state = 34},
  [4218] = {.lex_state = 0, .external_lex_state = 34},
  [4219] = {.lex_state = 0, .external_lex_state = 34},
  [4220] = {.lex_state = 0, .external_lex_state = 34},
  [4221] = {.lex_state = 0, .external_lex_state = 34},
  [4222] = {.lex_state = 0, .external_lex_state = 34},
  [4223] = {.lex_state = 0, .external_lex_state = 34},
  [4224] = {.lex_state = 0, .external_lex_state = 34},
  [4225] = {.lex_state = 0, .external_lex_state = 34},
  [4226] = {.lex_state = 0, .external_lex_state = 34},
  [4227] = {.lex_state = 0, .external_lex_state = 34},
  [4228] = {.lex_state = 0, .external_lex_state = 34},
  [4229] = {.lex_state = 0, .external_lex_state = 34},
  [4230] = {.lex_state = 0, .external_lex_state = 34},
  [4231] = {.lex_state = 0, .external_lex_state = 34},
  [4232] = {.lex_state = 0, .external_lex_state = 34},
  [4233] = {.lex_state = 0, .external_lex_state = 34},
  [4234] = {.lex_state = 0, .external_lex_state = 34},
  [4235] = {.lex_state = 0, .external_lex_state = 34},
  [4236] = {.lex_state = 0, .external_lex_state = 34},
  [4237] = {.lex_state = 0, .external_lex_state = 34},
  [4238] = {.lex_state = 0, .external_lex_state = 34},
  [4239] = {.lex_state = 0, .external_lex_state = 34},
  [4240] = {.lex_state = 0, .external_lex_state = 34},
  [4241] = {.lex_state = 0, .external_lex_state = 34},
  [4242] = {.lex_state = 0, .external_lex_state = 34},
  [4243] = {.lex_state = 0, .external_lex_state = 34},
  [4244] = {.lex_state = 0, .external_lex_state = 34},
  [4245] = {.lex_state = 0, .external_lex_state = 34},
  [4246] = {.lex_state = 0, .external_lex_state = 34},
  [4247] = {.lex_state = 0, .external_lex_state = 34},
  [4248] = {.lex_state = 0, .external_lex_state = 34},
  [4249] = {.lex_state = 0, .external_lex_state = 34},
  [4250] = {.lex_state = 0, .external_lex_state = 34},
  [4251] = {.lex_state = 0, .external_lex_state = 34},
  [4252] = {.lex_state = 0, .external_lex_state = 34},
  [4253] = {.lex_state = 0, .external_lex_state = 34},
  [4254] = {.lex_state = 0, .external_lex_state = 34},
  [4255] = {.lex_state = 0, .external_lex_state = 34},
  [4256] = {.lex_state = 0, .external_lex_state = 34},
  [4257] = {.lex_state = 0, .external_lex_state = 34},
  [4258] = {.lex_state = 0, .external_lex_state = 34},
  [4259] = {.lex_state = 0, .external_lex_state = 34},
  [4260] = {.lex_state = 0, .external_lex_state = 34},
  [4261] = {.lex_state = 0, .external_lex_state = 34},
  [4262] = {.lex_state = 0, .external_lex_state = 34},
  [4263] = {.lex_state = 0, .external_lex_state = 34},
  [4264] = {.lex_state = 0, .external_lex_state = 34},
  [4265] = {.lex_state = 0, .external_lex_state = 34},
  [4266] = {.lex_state = 0, .external_lex_state = 34},
  [4267] = {.lex_state = 0, .external_lex_state = 34},
  [4268] = {.lex_state = 0, .external_lex_state = 34},
  [4269] = {.lex_state = 0, .external_lex_state = 34},
  [4270] = {.lex_state = 0, .external_lex_state = 34},
  [4271] = {.lex_state = 0, .external_lex_state = 34},
  [4272] = {.lex_state = 0, .external_lex_state = 34},
  [4273] = {.lex_state = 0, .external_lex_state = 34},
  [4274] = {.lex_state = 0, .external_lex_state = 34},
  [4275] = {.lex_state = 0, .external_lex_state = 34},
  [4276] = {.lex_state = 0, .external_lex_state = 34},
  [4277] = {.lex_state = 0, .external_lex_state = 34},
  [4278] = {.lex_state = 0, .external_lex_state = 34},
  [4279] = {.lex_state = 0, .external_lex_state = 34},
  [4280] = {.lex_state = 0, .external_lex_state = 34},
  [4281] = {.lex_state = 0, .external_lex_state = 34},
  [4282] = {.lex_state = 0, .external_lex_state = 34},
  [4283] = {.lex_state = 0, .external_lex_state = 34},
  [4284] = {.lex_state = 0, .external_lex_state = 34},
  [4285] = {.lex_state = 0, .external_lex_state = 34},
  [4286] = {.lex_state = 0, .external_lex_state = 34},
  [4287] = {.lex_state = 0, .external_lex_state = 34},
  [4288] = {.lex_state = 0, .external_lex_state = 34},
  [4289] = {.lex_state = 0, .external_lex_state = 34},
  [4290] = {.lex_state = 0, .external_lex_state = 34},
  [4291] = {.lex_state = 0, .external_lex_state = 34},
  [4292] = {.lex_state = 0, .external_lex_state = 34},
  [4293] = {.lex_state = 0, .external_lex_state = 34},
  [4294] = {.lex_state = 0, .external_lex_state = 34},
  [4295] = {.lex_state = 0, .external_lex_state = 34},
  [4296] = {.lex_state = 0, .external_lex_state = 34},
  [4297] = {.lex_state = 0, .external_lex_state = 34},
  [4298] = {.lex_state = 0, .external_lex_state = 34},
  [4299] = {.lex_state = 0, .external_lex_state = 34},
  [4300] = {.lex_state = 0, .external_lex_state = 34},
  [4301] = {.lex_state = 0, .external_lex_state = 34},
  [4302] = {.lex_state = 0, .external_lex_state = 34},
  [4303] = {.lex_state = 0, .external_lex_state = 34},
  [4304] = {.lex_state = 0, .external_lex_state = 34},
  [4305] = {.lex_state = 0, .external_lex_state = 34},
  [4306] = {.lex_state = 0, .external_lex_state = 34},
  [4307] = {.lex_state = 0, .external_lex_state = 34},
  [4308] = {.lex_state = 0, .external_lex_state = 34},
  [4309] = {.lex_state = 0, .external_lex_state = 34},
  [4310] = {.lex_state = 0, .external_lex_state = 34},
  [4311] = {.lex_state = 0, .external_lex_state = 34},
  [4312] = {.lex_state = 0, .external_lex_state = 34},
  [4313] = {.lex_state = 0, .external_lex_state = 34},
  [4314] = {.lex_state = 0, .external_lex_state = 34},
  [4315] = {.lex_state = 0, .external_lex_state = 34},
  [4316] = {.lex_state = 0, .external_lex_state = 34},
  [4317] = {.lex_state = 0, .external_lex_state = 34},
  [4318] = {.lex_state = 0, .external_lex_state = 34},
  [4319] = {.lex_state = 0, .external_lex_state = 34},
  [4320] = {.lex_state = 0, .external_lex_state = 34},
  [4321] = {.lex_state = 0, .external_lex_state = 34},
  [4322] = {.lex_state = 0, .external_lex_state = 34},
  [4323] = {.lex_state = 0, .external_lex_state = 34},
  [4324] = {.lex_state = 0, .external_lex_state = 34},
  [4325] = {.lex_state = 0, .external_lex_state = 34},
  [4326] = {.lex_state = 0, .external_lex_state = 34},
  [4327] = {.lex_state = 0, .external_lex_state = 34},
  [4328] = {.lex_state = 0, .external_lex_state = 34},
  [4329] = {.lex_state = 0, .external_lex_state = 34},
  [4330] = {.lex_state = 0, .external_lex_state = 34},
  [4331] = {.lex_state = 0, .external_lex_state = 34},
  [4332] = {.lex_state = 0, .external_lex_state = 34},
  [4333] = {.lex_state = 0, .external_lex_state = 34},
  [4334] = {.lex_state = 0, .external_lex_state = 34},
  [4335] = {.lex_state = 0, .external_lex_state = 34},
  [4336] = {.lex_state = 0, .external_lex_state = 34},
  [4337] = {.lex_state = 0, .external_lex_state = 34},
  [4338] = {.lex_state = 0, .external_lex_state = 34},
  [4339] = {.lex_state = 0, .external_lex_state = 34},
  [4340] = {.lex_state = 0, .external_lex_state = 34},
  [4341] = {.lex_state = 0, .external_lex_state = 34},
  [4342] = {.lex_state = 0, .external_lex_state = 34},
  [4343] = {.lex_state = 0, .external_lex_state = 34},
  [4344] = {.lex_state = 0, .external_lex_state = 34},
  [4345] = {.lex_state = 0, .external_lex_state = 34},
  [4346] = {.lex_state = 0, .external_lex_state = 34},
  [4347] = {.lex_state = 0, .external_lex_state = 34},
  [4348] = {.lex_state = 0, .external_lex_state = 34},
  [4349] = {.lex_state = 0, .external_lex_state = 34},
  [4350] = {.lex_state = 0, .external_lex_state = 34},
  [4351] = {.lex_state = 0, .external_lex_state = 34},
  [4352] = {.lex_state = 0, .external_lex_state = 34},
  [4353] = {.lex_state = 0, .external_lex_state = 34},
  [4354] = {.lex_state = 0, .external_lex_state = 34},
  [4355] = {.lex_state = 0, .external_lex_state = 34},
  [4356] = {.lex_state = 0, .external_lex_state = 34},
  [4357] = {.lex_state = 0, .external_lex_state = 34},
  [4358] = {.lex_state = 0, .external_lex_state = 34},
  [4359] = {.lex_state = 0, .external_lex_state = 34},
  [4360] = {.lex_state = 0, .external_lex_state = 34},
  [4361] = {.lex_state = 0, .external_lex_state = 34},
  [4362] = {.lex_state = 0, .external_lex_state = 34},
  [4363] = {.lex_state = 0, .external_lex_state = 34},
  [4364] = {.lex_state = 0, .external_lex_state = 34},
  [4365] = {.lex_state = 0, .external_lex_state = 34},
  [4366] = {.lex_state = 0, .external_lex_state = 34},
  [4367] = {.lex_state = 0, .external_lex_state = 34},
  [4368] = {.lex_state = 0, .external_lex_state = 34},
  [4369] = {.lex_state = 1, .external_lex_state = 35},
  [4370] = {.lex_state = 1, .external_lex_state = 35},
  [4371] = {.lex_state = 1, .external_lex_state = 36},
  [4372] = {.lex_state = 1, .external_lex_state = 36},
  [4373] = {.lex_state = 1, .external_lex_state = 37},
  [4374] = {.lex_state = 0, .external_lex_state = 38},
  [4375] = {.lex_state = 0, .external_lex_state = 38},
  [4376] = {.lex_state = 0, .external_lex_state = 38},
  [4377] = {.lex_state = 0, .external_lex_state = 38},
  [4378] = {.lex_state = 0, .external_lex_state = 38},
  [4379] = {.lex_state = 1, .external_lex_state = 39},
  [4380] = {.lex_state = 0, .external_lex_state = 38},
  [4381] = {.lex_state = 0, .external_lex_state = 38},
  [4382] = {.lex_state = 0, .external_lex_state = 38},
  [4383] = {.lex_state = 0, .external_lex_state = 38},
  [4384] = {.lex_state = 0, .external_lex_state = 38},
  [4385] = {.lex_state = 0, .external_lex_state = 38},
  [4386] = {.lex_state = 1, .external_lex_state = 35},
  [4387] = {.lex_state = 0, .external_lex_state = 38},
  [4388] = {.lex_state = 0, .external_lex_state = 38},
  [4389] = {.lex_state = 0, .external_lex_state = 38},
  [4390] = {.lex_state = 0, .external_lex_state = 38},
  [4391] = {.lex_state = 0, .external_lex_state = 38},
  [4392] = {.lex_state = 0, .external_lex_state = 38},
  [4393] = {.lex_state = 0, .external_lex_state = 38},
  [4394] = {.lex_state = 0, .external_lex_state = 38},
  [4395] = {.lex_state = 0, .external_lex_state = 38},
  [4396] = {.lex_state = 0, .external_lex_state = 38},
  [4397] = {.lex_state = 0, .external_lex_state = 38},
  [4398] = {.lex_state = 0, .external_lex_state = 38},
  [4399] = {.lex_state = 0, .external_lex_state = 38},
  [4400] = {.lex_state = 0, .external_lex_state = 38},
  [4401] = {.lex_state = 0, .external_lex_state = 38},
  [4402] = {.lex_state = 0, .external_lex_state = 38},
  [4403] = {.lex_state = 0, .external_lex_state = 38},
  [4404] = {.lex_state = 0, .external_lex_state = 38},
  [4405] = {.lex_state = 0, .external_lex_state = 38},
  [4406] = {.lex_state = 0, .external_lex_state = 38},
  [4407] = {.lex_state = 0, .external_lex_state = 38},
  [4408] = {.lex_state = 0, .external_lex_state = 38},
  [4409] = {.lex_state = 0, .external_lex_state = 38},
  [4410] = {.lex_state = 0, .external_lex_state = 38},
  [4411] = {.lex_state = 0, .external_lex_state = 38},
  [4412] = {.lex_state = 0, .external_lex_state = 38},
  [4413] = {.lex_state = 0, .external_lex_state = 38},
  [4414] = {.lex_state = 0, .external_lex_state = 38},
  [4415] = {.lex_state = 0, .external_lex_state = 38},
  [4416] = {.lex_state = 0, .external_lex_state = 38},
  [4417] = {.lex_state = 0, .external_lex_state = 38},
  [4418] = {.lex_state = 0, .external_lex_state = 38},
  [4419] = {.lex_state = 0, .external_lex_state = 38},
  [4420] = {.lex_state = 0, .external_lex_state = 38},
  [4421] = {.lex_state = 0, .external_lex_state = 38},
  [4422] = {.lex_state = 0, .external_lex_state = 38},
  [4423] = {.lex_state = 0, .external_lex_state = 38},
  [4424] = {.lex_state = 0, .external_lex_state = 38},
  [4425] = {.lex_state = 0, .external_lex_state = 38},
  [4426] = {.lex_state = 0, .external_lex_state = 38},
  [4427] = {.lex_state = 0, .external_lex_state = 38},
  [4428] = {.lex_state = 0, .external_lex_state = 38},
  [4429] = {.lex_state = 0, .external_lex_state = 38},
  [4430] = {.lex_state = 0, .external_lex_state = 38},
  [4431] = {.lex_state = 0, .external_lex_state = 38},
  [4432] = {.lex_state = 0, .external_lex_state = 38},
  [4433] = {.lex_state = 0, .external_lex_state = 38},
  [4434] = {.lex_state = 0, .external_lex_state = 40},
  [4435] = {.lex_state = 0, .external_lex_state = 40},
  [4436] = {.lex_state = 0, .external_lex_state = 40},
  [4437] = {.lex_state = 0, .external_lex_state = 40},
  [4438] = {.lex_state = 0, .external_lex_state = 40},
  [4439] = {.lex_state = 0, .external_lex_state = 40},
  [4440] = {.lex_state = 0, .external_lex_state = 40},
  [4441] = {.lex_state = 0, .external_lex_state = 40},
  [4442] = {.lex_state = 0, .external_lex_state = 40},
  [4443] = {.lex_state = 0, .external_lex_state = 40},
  [4444] = {.lex_state = 0, .external_lex_state = 40},
  [4445] = {.lex_state = 0, .external_lex_state = 40},
  [4446] = {.lex_state = 0, .external_lex_state = 40},
  [4447] = {.lex_state = 0, .external_lex_state = 40},
  [4448] = {.lex_state = 0, .external_lex_state = 40},
  [4449] = {.lex_state = 0, .external_lex_state = 40},
  [4450] = {.lex_state = 0, .external_lex_state = 40},
  [4451] = {.lex_state = 0, .external_lex_state = 40},
  [4452] = {.lex_state = 0, .external_lex_state = 40},
  [4453] = {.lex_state = 0, .external_lex_state = 40},
  [4454] = {.lex_state = 0, .external_lex_state = 40},
  [4455] = {.lex_state = 0, .external_lex_state = 40},
  [4456] = {.lex_state = 0, .external_lex_state = 40},
  [4457] = {.lex_state = 0, .external_lex_state = 40},
  [4458] = {.lex_state = 0, .external_lex_state = 40},
  [4459] = {.lex_state = 0, .external_lex_state = 40},
  [4460] = {.lex_state = 0, .external_lex_state = 40},
  [4461] = {.lex_state = 0, .external_lex_state = 40},
  [4462] = {.lex_state = 0, .external_lex_state = 40},
  [4463] = {.lex_state = 0, .external_lex_state = 40},
  [4464] = {.lex_state = 0, .external_lex_state = 40},
  [4465] = {.lex_state = 0, .external_lex_state = 40},
  [4466] = {.lex_state = 0, .external_lex_state = 40},
  [4467] = {.lex_state = 0, .external_lex_state = 40},
  [4468] = {.lex_state = 0, .external_lex_state = 40},
  [4469] = {.lex_state = 0, .external_lex_state = 40},
  [4470] = {.lex_state = 0, .external_lex_state = 40},
  [4471] = {.lex_state = 0, .external_lex_state = 40},
  [4472] = {.lex_state = 0, .external_lex_state = 40},
  [4473] = {.lex_state = 0, .external_lex_state = 40},
  [4474] = {.lex_state = 0, .external_lex_state = 40},
  [4475] = {.lex_state = 0, .external_lex_state = 40},
  [4476] = {.lex_state = 0, .external_lex_state = 40},
  [4477] = {.lex_state = 0, .external_lex_state = 40},
  [4478] = {.lex_state = 0, .external_lex_state = 40},
  [4479] = {.lex_state = 0, .external_lex_state = 40},
  [4480] = {.lex_state = 0, .external_lex_state = 40},
  [4481] = {.lex_state = 0, .external_lex_state = 40},
  [4482] = {.lex_state = 0, .external_lex_state = 40},
  [4483] = {.lex_state = 0, .external_lex_state = 40},
  [4484] = {.lex_state = 0, .external_lex_state = 40},
  [4485] = {.lex_state = 0, .external_lex_state = 40},
  [4486] = {.lex_state = 0, .external_lex_state = 40},
  [4487] = {.lex_state = 0, .external_lex_state = 40},
  [4488] = {.lex_state = 0, .external_lex_state = 40},
  [4489] = {.lex_state = 0, .external_lex_state = 40},
  [4490] = {.lex_state = 0, .external_lex_state = 40},
  [4491] = {.lex_state = 0, .external_lex_state = 40},
  [4492] = {.lex_state = 0, .external_lex_state = 40},
  [4493] = {.lex_state = 0, .external_lex_state = 40},
  [4494] = {.lex_state = 0, .external_lex_state = 40},
  [4495] = {.lex_state = 0, .external_lex_state = 40},
  [4496] = {.lex_state = 0, .external_lex_state = 40},
  [4497] = {.lex_state = 0, .external_lex_state = 40},
  [4498] = {.lex_state = 0, .external_lex_state = 40},
  [4499] = {.lex_state = 0, .external_lex_state = 40},
  [4500] = {.lex_state = 0, .external_lex_state = 40},
  [4501] = {.lex_state = 0, .external_lex_state = 40},
  [4502] = {.lex_state = 0, .external_lex_state = 40},
  [4503] = {.lex_state = 0, .external_lex_state = 40},
  [4504] = {.lex_state = 0, .external_lex_state = 40},
  [4505] = {.lex_state = 0, .external_lex_state = 40},
  [4506] = {.lex_state = 0, .external_lex_state = 40},
  [4507] = {.lex_state = 0, .external_lex_state = 40},
  [4508] = {.lex_state = 0, .external_lex_state = 40},
  [4509] = {.lex_state = 0, .external_lex_state = 40},
  [4510] = {.lex_state = 0, .external_lex_state = 40},
  [4511] = {.lex_state = 0, .external_lex_state = 40},
  [4512] = {.lex_state = 0, .external_lex_state = 40},
  [4513] = {.lex_state = 0, .external_lex_state = 40},
  [4514] = {.lex_state = 0, .external_lex_state = 40},
  [4515] = {.lex_state = 0, .external_lex_state = 40},
  [4516] = {.lex_state = 0, .external_lex_state = 40},
  [4517] = {.lex_state = 0, .external_lex_state = 40},
  [4518] = {.lex_state = 0, .external_lex_state = 40},
  [4519] = {.lex_state = 0, .external_lex_state = 40},
  [4520] = {.lex_state = 0, .external_lex_state = 40},
  [4521] = {.lex_state = 0, .external_lex_state = 40},
  [4522] = {.lex_state = 0, .external_lex_state = 40},
  [4523] = {.lex_state = 0, .external_lex_state = 40},
  [4524] = {.lex_state = 0, .external_lex_state = 40},
  [4525] = {.lex_state = 0, .external_lex_state = 40},
  [4526] = {.lex_state = 0, .external_lex_state = 40},
  [4527] = {.lex_state = 0, .external_lex_state = 40},
  [4528] = {.lex_state = 0, .external_lex_state = 40},
  [4529] = {.lex_state = 0, .external_lex_state = 40},
  [4530] = {.lex_state = 0, .external_lex_state = 40},
  [4531] = {.lex_state = 0, .external_lex_state = 40},
  [4532] = {.lex_state = 0, .external_lex_state = 40},
  [4533] = {.lex_state = 0, .external_lex_state = 40},
  [4534] = {.lex_state = 0, .external_lex_state = 40},
  [4535] = {.lex_state = 0, .external_lex_state = 40},
  [4536] = {.lex_state = 0, .external_lex_state = 40},
  [4537] = {.lex_state = 0, .external_lex_state = 40},
  [4538] = {.lex_state = 0, .external_lex_state = 40},
  [4539] = {.lex_state = 0, .external_lex_state = 40},
  [4540] = {.lex_state = 0, .external_lex_state = 40},
  [4541] = {.lex_state = 0, .external_lex_state = 40},
  [4542] = {.lex_state = 0, .external_lex_state = 40},
  [4543] = {.lex_state = 0, .external_lex_state = 40},
  [4544] = {.lex_state = 0, .external_lex_state = 40},
  [4545] = {.lex_state = 0, .external_lex_state = 40},
  [4546] = {.lex_state = 0, .external_lex_state = 40},
  [4547] = {.lex_state = 0, .external_lex_state = 40},
  [4548] = {.lex_state = 0, .external_lex_state = 40},
  [4549] = {.lex_state = 0, .external_lex_state = 40},
  [4550] = {.lex_state = 0, .external_lex_state = 40},
  [4551] = {.lex_state = 0, .external_lex_state = 40},
  [4552] = {.lex_state = 0, .external_lex_state = 40},
  [4553] = {.lex_state = 0, .external_lex_state = 40},
  [4554] = {.lex_state = 0, .external_lex_state = 40},
  [4555] = {.lex_state = 0, .external_lex_state = 40},
  [4556] = {.lex_state = 0, .external_lex_state = 40},
  [4557] = {.lex_state = 0, .external_lex_state = 40},
  [4558] = {.lex_state = 0, .external_lex_state = 40},
  [4559] = {.lex_state = 0, .external_lex_state = 40},
  [4560] = {.lex_state = 0, .external_lex_state = 40},
  [4561] = {.lex_state = 0, .external_lex_state = 40},
  [4562] = {.lex_state = 0, .external_lex_state = 40},
  [4563] = {.lex_state = 0, .external_lex_state = 40},
  [4564] = {.lex_state = 0, .external_lex_state = 40},
  [4565] = {.lex_state = 0, .external_lex_state = 40},
  [4566] = {.lex_state = 0, .external_lex_state = 40},
  [4567] = {.lex_state = 0, .external_lex_state = 40},
  [4568] = {.lex_state = 0, .external_lex_state = 40},
  [4569] = {.lex_state = 0, .external_lex_state = 40},
  [4570] = {.lex_state = 0, .external_lex_state = 40},
  [4571] = {.lex_state = 0, .external_lex_state = 40},
  [4572] = {.lex_state = 0, .external_lex_state = 40},
  [4573] = {.lex_state = 0, .external_lex_state = 40},
  [4574] = {.lex_state = 0, .external_lex_state = 40},
  [4575] = {.lex_state = 0, .external_lex_state = 40},
  [4576] = {.lex_state = 0, .external_lex_state = 40},
  [4577] = {.lex_state = 0, .external_lex_state = 40},
  [4578] = {.lex_state = 0, .external_lex_state = 40},
  [4579] = {.lex_state = 0, .external_lex_state = 40},
  [4580] = {.lex_state = 0, .external_lex_state = 40},
  [4581] = {.lex_state = 0, .external_lex_state = 40},
  [4582] = {.lex_state = 0, .external_lex_state = 40},
  [4583] = {.lex_state = 0, .external_lex_state = 40},
  [4584] = {.lex_state = 0, .external_lex_state = 40},
  [4585] = {.lex_state = 0, .external_lex_state = 40},
  [4586] = {.lex_state = 0, .external_lex_state = 40},
  [4587] = {.lex_state = 0, .external_lex_state = 40},
  [4588] = {.lex_state = 0, .external_lex_state = 40},
  [4589] = {.lex_state = 0, .external_lex_state = 40},
  [4590] = {.lex_state = 0, .external_lex_state = 40},
  [4591] = {.lex_state = 0, .external_lex_state = 40},
  [4592] = {.lex_state = 0, .external_lex_state = 40},
  [4593] = {.lex_state = 0, .external_lex_state = 40},
  [4594] = {.lex_state = 0, .external_lex_state = 40},
  [4595] = {.lex_state = 0, .external_lex_state = 40},
  [4596] = {.lex_state = 0, .external_lex_state = 40},
  [4597] = {.lex_state = 0, .external_lex_state = 40},
  [4598] = {.lex_state = 0, .external_lex_state = 40},
  [4599] = {.lex_state = 0, .external_lex_state = 40},
  [4600] = {.lex_state = 0, .external_lex_state = 40},
  [4601] = {.lex_state = 0, .external_lex_state = 40},
  [4602] = {.lex_state = 0, .external_lex_state = 40},
  [4603] = {.lex_state = 0, .external_lex_state = 40},
  [4604] = {.lex_state = 0, .external_lex_state = 40},
  [4605] = {.lex_state = 0, .external_lex_state = 40},
  [4606] = {.lex_state = 0, .external_lex_state = 40},
  [4607] = {.lex_state = 0, .external_lex_state = 40},
  [4608] = {.lex_state = 0, .external_lex_state = 40},
  [4609] = {.lex_state = 0, .external_lex_state = 40},
  [4610] = {.lex_state = 0, .external_lex_state = 40},
  [4611] = {.lex_state = 0, .external_lex_state = 40},
  [4612] = {.lex_state = 0, .external_lex_state = 40},
  [4613] = {.lex_state = 0, .external_lex_state = 40},
  [4614] = {.lex_state = 0, .external_lex_state = 40},
  [4615] = {.lex_state = 0, .external_lex_state = 40},
  [4616] = {.lex_state = 0, .external_lex_state = 40},
  [4617] = {.lex_state = 0, .external_lex_state = 40},
  [4618] = {.lex_state = 0, .external_lex_state = 40},
  [4619] = {.lex_state = 0, .external_lex_state = 40},
  [4620] = {.lex_state = 0, .external_lex_state = 40},
  [4621] = {.lex_state = 0, .external_lex_state = 40},
  [4622] = {.lex_state = 0, .external_lex_state = 40},
  [4623] = {.lex_state = 0, .external_lex_state = 40},
  [4624] = {.lex_state = 0, .external_lex_state = 40},
  [4625] = {.lex_state = 0, .external_lex_state = 40},
  [4626] = {.lex_state = 0, .external_lex_state = 40},
  [4627] = {.lex_state = 0, .external_lex_state = 40},
  [4628] = {.lex_state = 0, .external_lex_state = 40},
  [4629] = {.lex_state = 0, .external_lex_state = 40},
  [4630] = {.lex_state = 0, .external_lex_state = 40},
  [4631] = {.lex_state = 0, .external_lex_state = 40},
  [4632] = {.lex_state = 0, .external_lex_state = 40},
  [4633] = {.lex_state = 0, .external_lex_state = 40},
  [4634] = {.lex_state = 1, .external_lex_state = 36},
  [4635] = {.lex_state = 0, .external_lex_state = 40},
  [4636] = {.lex_state = 0, .external_lex_state = 40},
  [4637] = {.lex_state = 0, .external_lex_state = 40},
  [4638] = {.lex_state = 0, .external_lex_state = 40},
  [4639] = {.lex_state = 0, .external_lex_state = 40},
  [4640] = {.lex_state = 0, .external_lex_state = 40},
  [4641] = {.lex_state = 0, .external_lex_state = 40},
  [4642] = {.lex_state = 0, .external_lex_state = 40},
  [4643] = {.lex_state = 0, .external_lex_state = 40},
  [4644] = {.lex_state = 0, .external_lex_state = 40},
  [4645] = {.lex_state = 0, .external_lex_state = 40},
  [4646] = {.lex_state = 0, .external_lex_state = 40},
  [4647] = {.lex_state = 0, .external_lex_state = 40},
  [4648] = {.lex_state = 0, .external_lex_state = 40},
  [4649] = {.lex_state = 0, .external_lex_state = 40},
  [4650] = {.lex_state = 0, .external_lex_state = 40},
  [4651] = {.lex_state = 0, .external_lex_state = 40},
  [4652] = {.lex_state = 0, .external_lex_state = 40},
  [4653] = {.lex_state = 0, .external_lex_state = 40},
  [4654] = {.lex_state = 0, .external_lex_state = 29},
  [4655] = {.lex_state = 0, .external_lex_state = 38},
  [4656] = {.lex_state = 0, .external_lex_state = 31},
  [4657] = {.lex_state = 0, .external_lex_state = 31},
  [4658] = {.lex_state = 0, .external_lex_state = 31},
  [4659] = {.lex_state = 0, .external_lex_state = 29},
  [4660] = {.lex_state = 0, .external_lex_state = 30},
  [4661] = {.lex_state = 0, .external_lex_state = 30},
  [4662] = {.lex_state = 0, .external_lex_state = 31},
  [4663] = {.lex_state = 0, .external_lex_state = 31},
  [4664] = {.lex_state = 0, .external_lex_state = 29},
  [4665] = {.lex_state = 0, .external_lex_state = 30},
  [4666] = {.lex_state = 0, .external_lex_state = 29},
  [4667] = {.lex_state = 0, .external_lex_state = 31},
  [4668] = {.lex_state = 0, .external_lex_state = 38},
  [4669] = {.lex_state = 0, .external_lex_state = 30},
  [4670] = {.lex_state = 0, .external_lex_state = 38},
  [4671] = {.lex_state = 0, .external_lex_state = 30},
  [4672] = {.lex_state = 0, .external_lex_state = 31},
  [4673] = {.lex_state = 0, .external_lex_state = 30},
  [4674] = {.lex_state = 0, .external_lex_state = 38},
  [4675] = {.lex_state = 0, .external_lex_state = 38},
  [4676] = {.lex_state = 0, .external_lex_state = 29},
  [4677] = {.lex_state = 0, .external_lex_state = 29},
  [4678] = {.lex_state = 0, .external_lex_state = 38},
  [4679] = {.lex_state = 0, .external_lex_state = 30},
  [4680] = {.lex_state = 1, .external_lex_state = 38},
  [4681] = {.lex_state = 0, .external_lex_state = 38},
  [4682] = {.lex_state = 0, .external_lex_state = 29},
  [4683] = {.lex_state = 0, .external_lex_state = 38},
  [4684] = {.lex_state = 0, .external_lex_state = 40},
  [4685] = {.lex_state = 0, .external_lex_state = 40},
  [4686] = {.lex_state = 0, .external_lex_state = 40},
  [4687] = {.lex_state = 0, .external_lex_state = 40},
  [4688] = {.lex_state = 0, .external_lex_state = 40},
  [4689] = {.lex_state = 0, .external_lex_state = 40},
  [4690] = {.lex_state = 1, .external_lex_state = 40},
  [4691] = {.lex_state = 0, .external_lex_state = 40},
  [4692] = {.lex_state = 0, .external_lex_state = 40},
  [4693] = {.lex_state = 0, .external_lex_state = 32},
  [4694] = {.lex_state = 0, .external_lex_state = 38},
  [4695] = {.lex_state = 0, .external_lex_state = 38},
  [4696] = {.lex_state = 0, .external_lex_state = 38},
  [4697] = {.lex_state = 0, .external_lex_state = 38},
  [4698] = {.lex_state = 0, .external_lex_state = 38},
  [4699] = {.lex_state = 0, .external_lex_state = 38},
  [4700] = {.lex_state = 0, .external_lex_state = 38},
  [4701] = {.lex_state = 0, .external_lex_state = 38},
  [4702] = {.lex_state = 0, .external_lex_state = 38},
  [4703] = {.lex_state = 0, .external_lex_state = 38},
  [4704] = {.lex_state = 0, .external_lex_state = 38},
  [4705] = {.lex_state = 0, .external_lex_state = 38},
  [4706] = {.lex_state = 0, .external_lex_state = 38},
  [4707] = {.lex_state = 0, .external_lex_state = 38},
  [4708] = {.lex_state = 0, .external_lex_state = 38},
  [4709] = {.lex_state = 0, .external_lex_state = 38},
  [4710] = {.lex_state = 0, .external_lex_state = 38},
  [4711] = {.lex_state = 0, .external_lex_state = 38},
  [4712] = {.lex_state = 0, .external_lex_state = 38},
  [4713] = {.lex_state = 0, .external_lex_state = 40},
  [4714] = {.lex_state = 0, .external_lex_state = 40},
  [4715] = {.lex_state = 0, .external_lex_state = 40},
  [4716] = {.lex_state = 0, .external_lex_state = 40},
  [4717] = {.lex_state = 0, .external_lex_state = 40},
  [4718] = {.lex_state = 0, .external_lex_state = 40},
  [4719] = {.lex_state = 0, .external_lex_state = 40},
  [4720] = {.lex_state = 0, .external_lex_state = 40},
  [4721] = {.lex_state = 0, .external_lex_state = 40},
  [4722] = {.lex_state = 0, .external_lex_state = 40},
  [4723] = {.lex_state = 0, .external_lex_state = 40},
  [4724] = {.lex_state = 0, .external_lex_state = 40},
  [4725] = {.lex_state = 0, .external_lex_state = 40},
  [4726] = {.lex_state = 0, .external_lex_state = 40},
  [4727] = {.lex_state = 0, .external_lex_state = 40},
  [4728] = {.lex_state = 0, .external_lex_state = 40},
  [4729] = {.lex_state = 0, .external_lex_state = 40},
  [4730] = {.lex_state = 0, .external_lex_state = 40},
  [4731] = {.lex_state = 0, .external_lex_state = 40},
  [4732] = {.lex_state = 3, .external_lex_state = 41},
  [4733] = {.lex_state = 3, .external_lex_state = 41},
  [4734] = {.lex_state = 3, .external_lex_state = 41},
  [4735] = {.lex_state = 3, .external_lex_state = 41},
  [4736] = {.lex_state = 3, .external_lex_state = 41},
  [4737] = {.lex_state = 3, .external_lex_state = 41},
  [4738] = {.lex_state = 3, .external_lex_state = 41},
  [4739] = {.lex_state = 3, .external_lex_state = 41},
  [4740] = {.lex_state = 3, .external_lex_state = 41},
  [4741] = {.lex_state = 3, .external_lex_state = 41},
  [4742] = {.lex_state = 3, .external_lex_state = 41},
  [4743] = {.lex_state = 3, .external_lex_state = 41},
  [4744] = {.lex_state = 3, .external_lex_state = 41},
  [4745] = {.lex_state = 3, .external_lex_state = 41},
  [4746] = {.lex_state = 3, .external_lex_state = 41},
  [4747] = {.lex_state = 3, .external_lex_state = 41},
  [4748] = {.lex_state = 3, .external_lex_state = 41},
  [4749] = {.lex_state = 3, .external_lex_state = 41},
  [4750] = {.lex_state = 3, .external_lex_state = 41},
  [4751] = {.lex_state = 3, .external_lex_state = 41},
  [4752] = {.lex_state = 3, .external_lex_state = 41},
  [4753] = {.lex_state = 3, .external_lex_state = 41},
  [4754] = {.lex_state = 3, .external_lex_state = 41},
  [4755] = {.lex_state = 3, .external_lex_state = 41},
  [4756] = {.lex_state = 3, .external_lex_state = 41},
  [4757] = {.lex_state = 3, .external_lex_state = 41},
  [4758] = {.lex_state = 3},
  [4759] = {.lex_state = 0, .external_lex_state = 41},
  [4760] = {.lex_state = 0, .external_lex_state = 42},
  [4761] = {.lex_state = 2},
  [4762] = {.lex_state = 4},
  [4763] = {.lex_state = 2},
  [4764] = {.lex_state = 4},
  [4765] = {.lex_state = 0, .external_lex_state = 42},
  [4766] = {.lex_state = 4},
  [4767] = {.lex_state = 0, .external_lex_state = 41},
  [4768] = {.lex_state = 2},
  [4769] = {.lex_state = 0, .external_lex_state = 41},
  [4770] = {.lex_state = 4},
  [4771] = {.lex_state = 0, .external_lex_state = 41},
  [4772] = {.lex_state = 0, .external_lex_state = 42},
  [4773] = {.lex_state = 4},
  [4774] = {.lex_state = 2},
  [4775] = {.lex_state = 0, .external_lex_state = 42},
  [4776] = {.lex_state = 2},
  [4777] = {.lex_state = 4},
  [4778] = {.lex_state = 2},
  [4779] = {.lex_state = 0, .external_lex_state = 42},
  [4780] = {.lex_state = 2},
  [4781] = {.lex_state = 4},
  [4782] = {.lex_state = 0, .external_lex_state = 41},
  [4783] = {.lex_state = 0, .external_lex_state = 42},
  [4784] = {.lex_state = 2},
  [4785] = {.lex_state = 0, .external_lex_state = 42},
  [4786] = {.lex_state = 4},
  [4787] = {.lex_state = 0, .external_lex_state = 42},
  [4788] = {.lex_state = 0, .external_lex_state = 41},
  [4789] = {.lex_state = 0, .external_lex_state = 41},
  [4790] = {.lex_state = 0, .external_lex_state = 41},
  [4791] = {.lex_state = 0, .external_lex_state = 41},
  [4792] = {.lex_state = 0, .external_lex_state = 42},
  [4793] = {.lex_state = 0, .external_lex_state = 41},
  [4794] = {.lex_state = 2},
  [4795] = {.lex_state = 0, .external_lex_state = 42},
  [4796] = {.lex_state = 4},
  [4797] = {.lex_state = 2},
  [4798] = {.lex_state = 0, .external_lex_state = 42},
  [4799] = {.lex_state = 0, .external_lex_state = 41},
  [4800] = {.lex_state = 0, .external_lex_state = 42},
  [4801] = {.lex_state = 4},
  [4802] = {.lex_state = 2},
  [4803] = {.lex_state = 0, .external_lex_state = 42},
  [4804] = {.lex_state = 0, .external_lex_state = 41},
  [4805] = {.lex_state = 4},
  [4806] = {.lex_state = 0, .external_lex_state = 41},
  [4807] = {.lex_state = 0, .external_lex_state = 42},
  [4808] = {.lex_state = 0, .external_lex_state = 42},
  [4809] = {.lex_state = 0, .external_lex_state = 42},
  [4810] = {.lex_state = 0, .external_lex_state = 42},
  [4811] = {.lex_state = 0, .external_lex_state = 42},
  [4812] = {.lex_state = 4},
  [4813] = {.lex_state = 2},
  [4814] = {.lex_state = 2},
  [4815] = {.lex_state = 2},
  [4816] = {.lex_state = 4},
  [4817] = {.lex_state = 2},
  [4818] = {.lex_state = 0, .external_lex_state = 42},
  [4819] = {.lex_state = 4},
  [4820] = {.lex_state = 2},
  [4821] = {.lex_state = 0, .external_lex_state = 42},
  [4822] = {.lex_state = 4},
  [4823] = {.lex_state = 2},
  [4824] = {.lex_state = 4},
  [4825] = {.lex_state = 2},
  [4826] = {.lex_state = 0, .external_lex_state = 42},
  [4827] = {.lex_state = 2},
  [4828] = {.lex_state = 4},
  [4829] = {.lex_state = 4},
  [4830] = {.lex_state = 0, .external_lex_state = 42},
  [4831] = {.lex_state = 0, .external_lex_state = 42},
  [4832] = {.lex_state = 2},
  [4833] = {.lex_state = 4},
  [4834] = {.lex_state = 0, .external_lex_state = 42},
  [4835] = {.lex_state = 0, .external_lex_state = 41},
  [4836] = {.lex_state = 0, .external_lex_state = 41},
  [4837] = {.lex_state = 0, .external_lex_state = 41},
  [4838] = {.lex_state = 0, .external_lex_state = 41},
  [4839] = {.lex_state = 0, .external_lex_state = 42},
  [4840] = {.lex_state = 0, .external_lex_state = 41},
  [4841] = {.lex_state = 0, .external_lex_state = 42},
  [4842] = {.lex_state = 4},
  [4843] = {.lex_state = 2},
  [4844] = {.lex_state = 0, .external_lex_state = 42},
  [4845] = {.lex_state = 0, .external_lex_state = 41},
  [4846] = {.lex_state = 0, .external_lex_state = 42},
  [4847] = {.lex_state = 4},
  [4848] = {.lex_state = 2},
  [4849] = {.lex_state = 4},
  [4850] = {.lex_state = 0, .external_lex_state = 41},
  [4851] = {.lex_state = 0, .external_lex_state = 41},
  [4852] = {.lex_state = 0, .external_lex_state = 41},
  [4853] = {.lex_state = 0, .external_lex_state = 42},
  [4854] = {.lex_state = 4},
  [4855] = {.lex_state = 0, .external_lex_state = 42},
  [4856] = {.lex_state = 2},
  [4857] = {.lex_state = 2},
  [4858] = {.lex_state = 0, .external_lex_state = 41},
  [4859] = {.lex_state = 0, .external_lex_state = 42},
  [4860] = {.lex_state = 4},
  [4861] = {.lex_state = 2},
  [4862] = {.lex_state = 0, .external_lex_state = 42},
  [4863] = {.lex_state = 0, .external_lex_state = 42},
  [4864] = {.lex_state = 4},
  [4865] = {.lex_state = 2},
  [4866] = {.lex_state = 0, .external_lex_state = 41},
  [4867] = {.lex_state = 2},
  [4868] = {.lex_state = 0, .external_lex_state = 42},
  [4869] = {.lex_state = 0, .external_lex_state = 41},
  [4870] = {.lex_state = 4},
  [4871] = {.lex_state = 0, .external_lex_state = 41},
  [4872] = {.lex_state = 0, .external_lex_state = 41},
  [4873] = {.lex_state = 0, .external_lex_state = 42},
  [4874] = {.lex_state = 4},
  [4875] = {.lex_state = 4},
  [4876] = {.lex_state = 0, .external_lex_state = 42},
  [4877] = {.lex_state = 4},
  [4878] = {.lex_state = 2},
  [4879] = {.lex_state = 0, .external_lex_state = 42},
  [4880] = {.lex_state = 2},
  [4881] = {.lex_state = 4},
  [4882] = {.lex_state = 2},
  [4883] = {.lex_state = 4},
  [4884] = {.lex_state = 2},
  [4885] = {.lex_state = 0, .external_lex_state = 42},
  [4886] = {.lex_state = 2},
  [4887] = {.lex_state = 0, .external_lex_state = 42},
  [4888] = {.lex_state = 2},
  [4889] = {.lex_state = 0, .external_lex_state = 42},
  [4890] = {.lex_state = 0, .external_lex_state = 42},
  [4891] = {.lex_state = 4},
  [4892] = {.lex_state = 0, .external_lex_state = 42},
  [4893] = {.lex_state = 0, .external_lex_state = 42},
  [4894] = {.lex_state = 0, .external_lex_state = 41},
  [4895] = {.lex_state = 0, .external_lex_state = 42},
  [4896] = {.lex_state = 0, .external_lex_state = 41},
  [4897] = {.lex_state = 2},
  [4898] = {.lex_state = 0, .external_lex_state = 41},
  [4899] = {.lex_state = 0, .external_lex_state = 42},
  [4900] = {.lex_state = 0, .external_lex_state = 42},
  [4901] = {.lex_state = 0, .external_lex_state = 41},
  [4902] = {.lex_state = 0, .external_lex_state = 42},
  [4903] = {.lex_state = 0, .external_lex_state = 42},
  [4904] = {.lex_state = 0, .external_lex_state = 42},
  [4905] = {.lex_state = 0, .external_lex_state = 42},
  [4906] = {.lex_state = 0, .external_lex_state = 42},
  [4907] = {.lex_state = 4},
  [4908] = {.lex_state = 0, .external_lex_state = 42},
  [4909] = {.lex_state = 4},
  [4910] = {.lex_state = 0, .external_lex_state = 42},
  [4911] = {.lex_state = 0, .external_lex_state = 42},
  [4912] = {.lex_state = 0, .external_lex_state = 42},
  [4913] = {.lex_state = 2},
  [4914] = {.lex_state = 0, .external_lex_state = 42},
  [4915] = {.lex_state = 2},
  [4916] = {.lex_state = 0, .external_lex_state = 42},
  [4917] = {.lex_state = 0, .external_lex_state = 42},
  [4918] = {.lex_state = 0, .external_lex_state = 42},
  [4919] = {.lex_state = 2},
  [4920] = {.lex_state = 0, .external_lex_state = 42},
  [4921] = {.lex_state = 4},
  [4922] = {.lex_state = 0, .external_lex_state = 42},
  [4923] = {.lex_state = 0, .external_lex_state = 42},
  [4924] = {.lex_state = 0, .external_lex_state = 42},
  [4925] = {.lex_state = 4},
  [4926] = {.lex_state = 0, .external_lex_state = 42},
  [4927] = {.lex_state = 0, .external_lex_state = 41},
  [4928] = {.lex_state = 0, .external_lex_state = 42},
  [4929] = {.lex_state = 0, .external_lex_state = 42},
  [4930] = {.lex_state = 0, .external_lex_state = 42},
  [4931] = {.lex_state = 2},
  [4932] = {.lex_state = 0, .external_lex_state = 42},
  [4933] = {.lex_state = 4},
  [4934] = {.lex_state = 0, .external_lex_state = 42},
  [4935] = {.lex_state = 0, .external_lex_state = 42},
  [4936] = {.lex_state = 0, .external_lex_state = 42},
  [4937] = {.lex_state = 0, .external_lex_state = 42},
  [4938] = {.lex_state = 0, .external_lex_state = 42},
  [4939] = {.lex_state = 0, .external_lex_state = 42},
  [4940] = {.lex_state = 0, .external_lex_state = 42},
  [4941] = {.lex_state = 0, .external_lex_state = 42},
  [4942] = {.lex_state = 0, .external_lex_state = 42},
  [4943] = {.lex_state = 2},
  [4944] = {.lex_state = 0, .external_lex_state = 42},
  [4945] = {.lex_state = 4},
  [4946] = {.lex_state = 0, .external_lex_state = 42},
  [4947] = {.lex_state = 0, .external_lex_state = 42},
  [4948] = {.lex_state = 0, .external_lex_state = 42},
  [4949] = {.lex_state = 0, .external_lex_state = 42},
  [4950] = {.lex_state = 0, .external_lex_state = 42},
  [4951] = {.lex_state = 0, .external_lex_state = 41},
  [4952] = {.lex_state = 0, .external_lex_state = 42},
  [4953] = {.lex_state = 0, .external_lex_state = 42},
  [4954] = {.lex_state = 0, .external_lex_state = 42},
  [4955] = {.lex_state = 0, .external_lex_state = 42},
  [4956] = {.lex_state = 0, .external_lex_state = 42},
  [4957] = {.lex_state = 0, .external_lex_state = 41},
  [4958] = {.lex_state = 0, .external_lex_state = 42},
  [4959] = {.lex_state = 0, .external_lex_state = 42},
  [4960] = {.lex_state = 0, .external_lex_state = 42},
  [4961] = {.lex_state = 0, .external_lex_state = 41},
  [4962] = {.lex_state = 0, .external_lex_state = 42},
  [4963] = {.lex_state = 2},
  [4964] = {.lex_state = 0, .external_lex_state = 42},
  [4965] = {.lex_state = 0, .external_lex_state = 42},
  [4966] = {.lex_state = 0, .external_lex_state = 42},
  [4967] = {.lex_state = 0, .external_lex_state = 42},
  [4968] = {.lex_state = 0, .external_lex_state = 42},
  [4969] = {.lex_state = 4},
  [4970] = {.lex_state = 0, .external_lex_state = 42},
  [4971] = {.lex_state = 0, .external_lex_state = 42},
  [4972] = {.lex_state = 0, .external_lex_state = 42},
  [4973] = {.lex_state = 2},
  [4974] = {.lex_state = 0, .external_lex_state = 42},
  [4975] = {.lex_state = 0, .external_lex_state = 42},
  [4976] = {.lex_state = 0, .external_lex_state = 42},
  [4977] = {.lex_state = 0, .external_lex_state = 42},
  [4978] = {.lex_state = 0, .external_lex_state = 42},
  [4979] = {.lex_state = 2},
  [4980] = {.lex_state = 0, .external_lex_state = 42},
  [4981] = {.lex_state = 4},
  [4982] = {.lex_state = 0, .external_lex_state = 42},
  [4983] = {.lex_state = 0, .external_lex_state = 42},
  [4984] = {.lex_state = 0, .external_lex_state = 42},
  [4985] = {.lex_state = 0, .external_lex_state = 42},
  [4986] = {.lex_state = 0, .external_lex_state = 42},
  [4987] = {.lex_state = 0, .external_lex_state = 41},
  [4988] = {.lex_state = 0, .external_lex_state = 42},
  [4989] = {.lex_state = 0, .external_lex_state = 42},
  [4990] = {.lex_state = 0, .external_lex_state = 42},
  [4991] = {.lex_state = 0, .external_lex_state = 42},
  [4992] = {.lex_state = 0, .external_lex_state = 42},
  [4993] = {.lex_state = 2},
  [4994] = {.lex_state = 0, .external_lex_state = 42},
  [4995] = {.lex_state = 0, .external_lex_state = 42},
  [4996] = {.lex_state = 0, .external_lex_state = 42},
  [4997] = {.lex_state = 4},
  [4998] = {.lex_state = 0, .external_lex_state = 42},
  [4999] = {.lex_state = 0, .external_lex_state = 42},
  [5000] = {.lex_state = 0, .external_lex_state = 42},
  [5001] = {.lex_state = 0, .external_lex_state = 42},
  [5002] = {.lex_state = 0, .external_lex_state = 42},
  [5003] = {.lex_state = 0, .external_lex_state = 41},
  [5004] = {.lex_state = 0, .external_lex_state = 42},
  [5005] = {.lex_state = 4},
  [5006] = {.lex_state = 0, .external_lex_state = 42},
  [5007] = {.lex_state = 0, .external_lex_state = 42},
  [5008] = {.lex_state = 0, .external_lex_state = 42},
  [5009] = {.lex_state = 0, .external_lex_state = 41},
  [5010] = {.lex_state = 0, .external_lex_state = 42},
  [5011] = {.lex_state = 2},
  [5012] = {.lex_state = 0, .external_lex_state = 42},
  [5013] = {.lex_state = 0, .external_lex_state = 42},
  [5014] = {.lex_state = 0, .external_lex_state = 42},
  [5015] = {.lex_state = 0, .external_lex_state = 42},
  [5016] = {.lex_state = 0, .external_lex_state = 42},
  [5017] = {.lex_state = 0, .external_lex_state = 41},
  [5018] = {.lex_state = 0, .external_lex_state = 42},
  [5019] = {.lex_state = 0, .external_lex_state = 42},
  [5020] = {.lex_state = 0, .external_lex_state = 42},
  [5021] = {.lex_state = 0, .external_lex_state = 41},
  [5022] = {.lex_state = 0, .external_lex_state = 42},
  [5023] = {.lex_state = 2},
  [5024] = {.lex_state = 0, .external_lex_state = 42},
  [5025] = {.lex_state = 0, .external_lex_state = 42},
  [5026] = {.lex_state = 0, .external_lex_state = 42},
  [5027] = {.lex_state = 4},
  [5028] = {.lex_state = 0, .external_lex_state = 42},
  [5029] = {.lex_state = 0, .external_lex_state = 41},
  [5030] = {.lex_state = 0, .external_lex_state = 42},
  [5031] = {.lex_state = 0, .external_lex_state = 42},
  [5032] = {.lex_state = 0, .external_lex_state = 42},
  [5033] = {.lex_state = 4},
  [5034] = {.lex_state = 0, .external_lex_state = 42},
  [5035] = {.lex_state = 0, .external_lex_state = 42},
  [5036] = {.lex_state = 0, .external_lex_state = 42},
  [5037] = {.lex_state = 0, .external_lex_state = 42},
  [5038] = {.lex_state = 0, .external_lex_state = 42},
  [5039] = {.lex_state = 2},
  [5040] = {.lex_state = 0, .external_lex_state = 42},
  [5041] = {.lex_state = 4},
  [5042] = {.lex_state = 0, .external_lex_state = 42},
  [5043] = {.lex_state = 0, .external_lex_state = 42},
  [5044] = {.lex_state = 0, .external_lex_state = 42},
  [5045] = {.lex_state = 0, .external_lex_state = 42},
  [5046] = {.lex_state = 0, .external_lex_state = 42},
  [5047] = {.lex_state = 0, .external_lex_state = 41},
  [5048] = {.lex_state = 0, .external_lex_state = 42},
  [5049] = {.lex_state = 0, .external_lex_state = 42},
  [5050] = {.lex_state = 0, .external_lex_state = 42},
  [5051] = {.lex_state = 0, .external_lex_state = 42},
  [5052] = {.lex_state = 0, .external_lex_state = 42},
  [5053] = {.lex_state = 0, .external_lex_state = 41},
  [5054] = {.lex_state = 0, .external_lex_state = 42},
  [5055] = {.lex_state = 0, .external_lex_state = 42},
  [5056] = {.lex_state = 0, .external_lex_state = 41},
  [5057] = {.lex_state = 4},
  [5058] = {.lex_state = 0, .external_lex_state = 41},
  [5059] = {.lex_state = 0, .external_lex_state = 42},
  [5060] = {.lex_state = 0, .external_lex_state = 42},
  [5061] = {.lex_state = 0, .external_lex_state = 41},
  [5062] = {.lex_state = 0, .external_lex_state = 42},
  [5063] = {.lex_state = 2},
  [5064] = {.lex_state = 0, .external_lex_state = 42},
  [5065] = {.lex_state = 2},
  [5066] = {.lex_state = 0, .external_lex_state = 42},
  [5067] = {.lex_state = 4},
  [5068] = {.lex_state = 2},
  [5069] = {.lex_state = 4},
  [5070] = {.lex_state = 0, .external_lex_state = 41},
  [5071] = {.lex_state = 4},
  [5072] = {.lex_state = 0, .external_lex_state = 41},
  [5073] = {.lex_state = 0, .external_lex_state = 41},
  [5074] = {.lex_state = 2},
  [5075] = {.lex_state = 2},
  [5076] = {.lex_state = 4},
  [5077] = {.lex_state = 4},
  [5078] = {.lex_state = 4},
  [5079] = {.lex_state = 2},
  [5080] = {.lex_state = 2},
  [5081] = {.lex_state = 4},
  [5082] = {.lex_state = 0, .external_lex_state = 41},
  [5083] = {.lex_state = 0, .external_lex_state = 41},
  [5084] = {.lex_state = 2},
  [5085] = {.lex_state = 4},
  [5086] = {.lex_state = 2},
  [5087] = {.lex_state = 2},
  [5088] = {.lex_state = 4},
  [5089] = {.lex_state = 4},
  [5090] = {.lex_state = 4},
  [5091] = {.lex_state = 2},
  [5092] = {.lex_state = 0, .external_lex_state = 41},
  [5093] = {.lex_state = 0, .external_lex_state = 43},
  [5094] = {.lex_state = 0, .external_lex_state = 43},
  [5095] = {.lex_state = 0, .external_lex_state = 43},
  [5096] = {.lex_state = 0, .external_lex_state = 43},
  [5097] = {.lex_state = 0, .external_lex_state = 43},
  [5098] = {.lex_state = 0, .external_lex_state = 43},
  [5099] = {.lex_state = 0, .external_lex_state = 43},
  [5100] = {.lex_state = 0, .external_lex_state = 43},
  [5101] = {.lex_state = 0, .external_lex_state = 43},
  [5102] = {.lex_state = 0, .external_lex_state = 43},
  [5103] = {.lex_state = 0, .external_lex_state = 43},
  [5104] = {.lex_state = 0, .external_lex_state = 43},
  [5105] = {.lex_state = 0, .external_lex_state = 43},
  [5106] = {.lex_state = 0, .external_lex_state = 43},
  [5107] = {.lex_state = 0, .external_lex_state = 43},
  [5108] = {.lex_state = 0, .external_lex_state = 43},
  [5109] = {.lex_state = 0, .external_lex_state = 41},
  [5110] = {.lex_state = 0, .external_lex_state = 41},
  [5111] = {.lex_state = 0, .external_lex_state = 43},
  [5112] = {.lex_state = 0, .external_lex_state = 43},
  [5113] = {.lex_state = 0, .external_lex_state = 43},
  [5114] = {.lex_state = 0, .external_lex_state = 43},
  [5115] = {.lex_state = 0, .external_lex_state = 43},
  [5116] = {.lex_state = 0, .external_lex_state = 43},
  [5117] = {.lex_state = 0, .external_lex_state = 43},
  [5118] = {.lex_state = 2},
  [5119] = {.lex_state = 0, .external_lex_state = 43},
  [5120] = {.lex_state = 0, .external_lex_state = 43},
  [5121] = {.lex_state = 0, .external_lex_state = 42},
  [5122] = {.lex_state = 0, .external_lex_state = 43},
  [5123] = {.lex_state = 4},
  [5124] = {.lex_state = 0, .external_lex_state = 43},
  [5125] = {.lex_state = 0, .external_lex_state = 43},
  [5126] = {.lex_state = 0},
  [5127] = {.lex_state = 0},
  [5128] = {.lex_state = 0},
  [5129] = {.lex_state = 0},
  [5130] = {.lex_state = 0},
  [5131] = {.lex_state = 0},
  [5132] = {.lex_state = 0, .external_lex_state = 41},
  [5133] = {.lex_state = 0},
  [5134] = {.lex_state = 0},
  [5135] = {.lex_state = 0},
  [5136] = {.lex_state = 0, .external_lex_state = 41},
  [5137] = {.lex_state = 0},
  [5138] = {.lex_state = 0},
  [5139] = {.lex_state = 0},
  [5140] = {.lex_state = 0},
  [5141] = {.lex_state = 0},
  [5142] = {.lex_state = 0},
  [5143] = {.lex_state = 0},
  [5144] = {.lex_state = 0},
  [5145] = {.lex_state = 0, .external_lex_state = 41},
  [5146] = {.lex_state = 0, .external_lex_state = 41},
  [5147] = {.lex_state = 0},
  [5148] = {.lex_state = 0},
  [5149] = {.lex_state = 0},
  [5150] = {.lex_state = 0},
  [5151] = {.lex_state = 0},
  [5152] = {.lex_state = 0},
  [5153] = {.lex_state = 0},
  [5154] = {.lex_state = 0},
  [5155] = {.lex_state = 0},
  [5156] = {.lex_state = 0},
  [5157] = {.lex_state = 0},
  [5158] = {.lex_state = 1},
  [5159] = {.lex_state = 1},
  [5160] = {.lex_state = 1},
  [5161] = {.lex_state = 1},
  [5162] = {.lex_state = 1},
  [5163] = {.lex_state = 1},
  [5164] = {.lex_state = 1},
  [5165] = {.lex_state = 1},
  [5166] = {.lex_state = 1},
  [5167] = {.lex_state = 1},
  [5168] = {.lex_state = 1},
  [5169] = {.lex_state = 0},
  [5170] = {.lex_state = 1},
  [5171] = {.lex_state = 1},
  [5172] = {.lex_state = 1},
  [5173] = {.lex_state = 1},
  [5174] = {.lex_state = 1},
  [5175] = {.lex_state = 1},
  [5176] = {.lex_state = 1},
  [5177] = {.lex_state = 1},
  [5178] = {.lex_state = 1},
  [5179] = {.lex_state = 1},
  [5180] = {.lex_state = 1},
  [5181] = {.lex_state = 1},
  [5182] = {.lex_state = 1},
  [5183] = {.lex_state = 1},
  [5184] = {.lex_state = 1},
  [5185] = {.lex_state = 1},
  [5186] = {.lex_state = 1},
  [5187] = {.lex_state = 1},
  [5188] = {.lex_state = 1},
  [5189] = {.lex_state = 1},
  [5190] = {.lex_state = 1},
  [5191] = {.lex_state = 1},
  [5192] = {.lex_state = 1},
  [5193] = {.lex_state = 1},
  [5194] = {.lex_state = 1},
  [5195] = {.lex_state = 1},
  [5196] = {.lex_state = 1},
  [5197] = {.lex_state = 1},
  [5198] = {.lex_state = 1},
  [5199] = {.lex_state = 1},
  [5200] = {.lex_state = 1},
  [5201] = {.lex_state = 1},
  [5202] = {.lex_state = 1},
  [5203] = {.lex_state = 1},
  [5204] = {.lex_state = 1},
  [5205] = {.lex_state = 1},
  [5206] = {.lex_state = 1},
  [5207] = {.lex_state = 1},
  [5208] = {.lex_state = 1},
  [5209] = {.lex_state = 1},
  [5210] = {.lex_state = 1},
  [5211] = {.lex_state = 1},
  [5212] = {.lex_state = 1},
  [5213] = {.lex_state = 1},
  [5214] = {.lex_state = 1},
  [5215] = {.lex_state = 1},
  [5216] = {.lex_state = 1},
  [5217] = {.lex_state = 1},
  [5218] = {.lex_state = 1},
  [5219] = {.lex_state = 1},
  [5220] = {.lex_state = 1},
  [5221] = {.lex_state = 1},
  [5222] = {.lex_state = 1},
  [5223] = {.lex_state = 1},
  [5224] = {.lex_state = 1},
  [5225] = {.lex_state = 1},
  [5226] = {.lex_state = 1},
  [5227] = {.lex_state = 1},
  [5228] = {.lex_state = 1},
  [5229] = {.lex_state = 1},
  [5230] = {.lex_state = 1},
  [5231] = {.lex_state = 1},
  [5232] = {.lex_state = 1},
  [5233] = {.lex_state = 1},
  [5234] = {.lex_state = 1},
  [5235] = {.lex_state = 1},
  [5236] = {.lex_state = 1},
  [5237] = {.lex_state = 1},
  [5238] = {.lex_state = 1},
  [5239] = {.lex_state = 1},
  [5240] = {.lex_state = 1},
  [5241] = {.lex_state = 1},
  [5242] = {.lex_state = 1},
  [5243] = {.lex_state = 1},
  [5244] = {.lex_state = 1},
  [5245] = {.lex_state = 1},
  [5246] = {.lex_state = 1},
  [5247] = {.lex_state = 1},
  [5248] = {.lex_state = 1},
  [5249] = {.lex_state = 1},
  [5250] = {.lex_state = 1},
  [5251] = {.lex_state = 1},
  [5252] = {.lex_state = 1},
  [5253] = {.lex_state = 1},
  [5254] = {.lex_state = 1},
  [5255] = {.lex_state = 1},
  [5256] = {.lex_state = 1},
  [5257] = {.lex_state = 1},
  [5258] = {.lex_state = 1},
  [5259] = {.lex_state = 1},
  [5260] = {.lex_state = 1},
  [5261] = {.lex_state = 1},
  [5262] = {.lex_state = 1},
  [5263] = {.lex_state = 1},
  [5264] = {.lex_state = 1},
  [5265] = {.lex_state = 1},
  [5266] = {.lex_state = 1},
  [5267] = {.lex_state = 1},
  [5268] = {.lex_state = 1},
  [5269] = {.lex_state = 1},
  [5270] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [aux_sym_binary_operator_token1] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_L] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [aux_sym__hex_literal_token1] = ACTIONS(1),
    [sym__number_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [sym_dot_dot_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [sym__raw_string_literal] = ACTIONS(1),
    [sym__external_else] = ACTIONS(1),
    [sym__external_open_parenthesis] = ACTIONS(1),
    [sym__external_close_parenthesis] = ACTIONS(1),
    [sym__external_open_brace] = ACTIONS(1),
    [sym__external_close_brace] = ACTIONS(1),
    [sym__external_open_bracket] = ACTIONS(1),
    [sym__external_close_bracket] = ACTIONS(1),
    [sym__external_open_bracket2] = ACTIONS(1),
    [sym__external_close_bracket2] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5169),
    [sym_function_definition] = STATE(2018),
    [sym_if_statement] = STATE(2018),
    [sym_for_statement] = STATE(2018),
    [sym_while_statement] = STATE(2018),
    [sym_repeat_statement] = STATE(2018),
    [sym_braced_expression] = STATE(2018),
    [sym_parenthesized_expression] = STATE(2018),
    [sym_call] = STATE(2018),
    [sym_subset] = STATE(2018),
    [sym_subset2] = STATE(2018),
    [sym_unary_operator] = STATE(2018),
    [sym_binary_operator] = STATE(2018),
    [sym_extract_operator] = STATE(2018),
    [sym_namespace_operator] = STATE(2018),
    [sym_integer] = STATE(2018),
    [sym_complex] = STATE(2018),
    [sym_float] = STATE(2018),
    [sym__hex_literal] = STATE(2739),
    [sym__float_literal] = STATE(2739),
    [sym_string] = STATE(2562),
    [sym__single_quoted_string] = STATE(2738),
    [sym__double_quoted_string] = STATE(2737),
    [sym_na] = STATE(2018),
    [sym__expression] = STATE(2018),
    [sym__string_or_identifier] = STATE(5152),
    [sym__open_parenthesis] = STATE(293),
    [sym__open_brace] = STATE(292),
    [aux_sym_program_repeat1] = STATE(2778),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_function] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_for] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [aux_sym__hex_literal_token1] = ACTIONS(29),
    [sym__number_literal] = ACTIONS(31),
    [anon_sym_SQUOTE] = ACTIONS(33),
    [anon_sym_DQUOTE] = ACTIONS(35),
    [sym_return] = ACTIONS(37),
    [sym_next] = ACTIONS(37),
    [sym_break] = ACTIONS(37),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
    [sym_inf] = ACTIONS(37),
    [sym_nan] = ACTIONS(37),
    [anon_sym_NA] = ACTIONS(39),
    [anon_sym_NA_integer_] = ACTIONS(39),
    [anon_sym_NA_real_] = ACTIONS(39),
    [anon_sym_NA_complex_] = ACTIONS(39),
    [anon_sym_NA_character_] = ACTIONS(39),
    [sym_dots] = ACTIONS(37),
    [sym_dot_dot_i] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(43),
    [sym__semicolon] = ACTIONS(43),
    [sym__raw_string_literal] = ACTIONS(45),
    [sym__external_open_parenthesis] = ACTIONS(47),
    [sym__external_open_brace] = ACTIONS(49),
  },
  [2] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2244),
    [aux_sym_braced_expression_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [3] = {
    [sym_function_definition] = STATE(506),
    [sym_if_statement] = STATE(506),
    [sym_for_statement] = STATE(506),
    [sym_while_statement] = STATE(506),
    [sym_repeat_statement] = STATE(506),
    [sym_braced_expression] = STATE(506),
    [sym_parenthesized_expression] = STATE(506),
    [sym_call] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_unary_operator] = STATE(506),
    [sym_binary_operator] = STATE(506),
    [sym_extract_operator] = STATE(506),
    [sym_namespace_operator] = STATE(506),
    [sym_integer] = STATE(506),
    [sym_complex] = STATE(506),
    [sym_float] = STATE(506),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__close_parenthesis] = STATE(2443),
    [sym__open_brace] = STATE(10),
    [aux_sym_parenthesized_expression_repeat1] = STATE(7),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(139),
    [sym_next] = ACTIONS(139),
    [sym_break] = ACTIONS(139),
    [sym_true] = ACTIONS(139),
    [sym_false] = ACTIONS(139),
    [sym_null] = ACTIONS(139),
    [sym_inf] = ACTIONS(139),
    [sym_nan] = ACTIONS(139),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(139),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(151),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_close_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [4] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2256),
    [aux_sym_braced_expression_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(159),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [5] = {
    [sym_function_definition] = STATE(502),
    [sym_if_statement] = STATE(502),
    [sym_for_statement] = STATE(502),
    [sym_while_statement] = STATE(502),
    [sym_repeat_statement] = STATE(502),
    [sym_braced_expression] = STATE(502),
    [sym_parenthesized_expression] = STATE(502),
    [sym_call] = STATE(502),
    [sym_subset] = STATE(502),
    [sym_subset2] = STATE(502),
    [sym_unary_operator] = STATE(502),
    [sym_binary_operator] = STATE(502),
    [sym_extract_operator] = STATE(502),
    [sym_namespace_operator] = STATE(502),
    [sym_integer] = STATE(502),
    [sym_complex] = STATE(502),
    [sym_float] = STATE(502),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__close_parenthesis] = STATE(2551),
    [sym__open_brace] = STATE(18),
    [aux_sym_parenthesized_expression_repeat1] = STATE(9),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(205),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
    [sym__external_close_bracket2] = ACTIONS(129),
  },
  [6] = {
    [sym_function_definition] = STATE(502),
    [sym_if_statement] = STATE(502),
    [sym_for_statement] = STATE(502),
    [sym_while_statement] = STATE(502),
    [sym_repeat_statement] = STATE(502),
    [sym_braced_expression] = STATE(502),
    [sym_parenthesized_expression] = STATE(502),
    [sym_call] = STATE(502),
    [sym_subset] = STATE(502),
    [sym_subset2] = STATE(502),
    [sym_unary_operator] = STATE(502),
    [sym_binary_operator] = STATE(502),
    [sym_extract_operator] = STATE(502),
    [sym_namespace_operator] = STATE(502),
    [sym_integer] = STATE(502),
    [sym_complex] = STATE(502),
    [sym_float] = STATE(502),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__close_parenthesis] = STATE(2358),
    [sym__open_brace] = STATE(18),
    [aux_sym_parenthesized_expression_repeat1] = STATE(95),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(213),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
    [sym__external_close_bracket2] = ACTIONS(211),
  },
  [7] = {
    [sym_function_definition] = STATE(506),
    [sym_if_statement] = STATE(506),
    [sym_for_statement] = STATE(506),
    [sym_while_statement] = STATE(506),
    [sym_repeat_statement] = STATE(506),
    [sym_braced_expression] = STATE(506),
    [sym_parenthesized_expression] = STATE(506),
    [sym_call] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_unary_operator] = STATE(506),
    [sym_binary_operator] = STATE(506),
    [sym_extract_operator] = STATE(506),
    [sym_namespace_operator] = STATE(506),
    [sym_integer] = STATE(506),
    [sym_complex] = STATE(506),
    [sym_float] = STATE(506),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__close_parenthesis] = STATE(2457),
    [sym__open_brace] = STATE(10),
    [aux_sym_parenthesized_expression_repeat1] = STATE(83),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(139),
    [sym_next] = ACTIONS(139),
    [sym_break] = ACTIONS(139),
    [sym_true] = ACTIONS(139),
    [sym_false] = ACTIONS(139),
    [sym_null] = ACTIONS(139),
    [sym_inf] = ACTIONS(139),
    [sym_nan] = ACTIONS(139),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(139),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(215),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_close_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [8] = {
    [sym_function_definition] = STATE(506),
    [sym_if_statement] = STATE(506),
    [sym_for_statement] = STATE(506),
    [sym_while_statement] = STATE(506),
    [sym_repeat_statement] = STATE(506),
    [sym_braced_expression] = STATE(506),
    [sym_parenthesized_expression] = STATE(506),
    [sym_call] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_unary_operator] = STATE(506),
    [sym_binary_operator] = STATE(506),
    [sym_extract_operator] = STATE(506),
    [sym_namespace_operator] = STATE(506),
    [sym_integer] = STATE(506),
    [sym_complex] = STATE(506),
    [sym_float] = STATE(506),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__close_parenthesis] = STATE(2328),
    [sym__open_brace] = STATE(10),
    [aux_sym_parenthesized_expression_repeat1] = STATE(83),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(139),
    [sym_next] = ACTIONS(139),
    [sym_break] = ACTIONS(139),
    [sym_true] = ACTIONS(139),
    [sym_false] = ACTIONS(139),
    [sym_null] = ACTIONS(139),
    [sym_inf] = ACTIONS(139),
    [sym_nan] = ACTIONS(139),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(139),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(217),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_close_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [9] = {
    [sym_function_definition] = STATE(502),
    [sym_if_statement] = STATE(502),
    [sym_for_statement] = STATE(502),
    [sym_while_statement] = STATE(502),
    [sym_repeat_statement] = STATE(502),
    [sym_braced_expression] = STATE(502),
    [sym_parenthesized_expression] = STATE(502),
    [sym_call] = STATE(502),
    [sym_subset] = STATE(502),
    [sym_subset2] = STATE(502),
    [sym_unary_operator] = STATE(502),
    [sym_binary_operator] = STATE(502),
    [sym_extract_operator] = STATE(502),
    [sym_namespace_operator] = STATE(502),
    [sym_integer] = STATE(502),
    [sym_complex] = STATE(502),
    [sym_float] = STATE(502),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__close_parenthesis] = STATE(2516),
    [sym__open_brace] = STATE(18),
    [aux_sym_parenthesized_expression_repeat1] = STATE(95),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(219),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
    [sym__external_close_bracket2] = ACTIONS(211),
  },
  [10] = {
    [sym_function_definition] = STATE(522),
    [sym_if_statement] = STATE(522),
    [sym_for_statement] = STATE(522),
    [sym_while_statement] = STATE(522),
    [sym_repeat_statement] = STATE(522),
    [sym_braced_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(522),
    [sym_call] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_unary_operator] = STATE(522),
    [sym_binary_operator] = STATE(522),
    [sym_extract_operator] = STATE(522),
    [sym_namespace_operator] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_complex] = STATE(522),
    [sym_float] = STATE(522),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [sym__close_brace] = STATE(2322),
    [aux_sym_braced_expression_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(225),
    [sym__semicolon] = ACTIONS(225),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(227),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [11] = {
    [sym_function_definition] = STATE(522),
    [sym_if_statement] = STATE(522),
    [sym_for_statement] = STATE(522),
    [sym_while_statement] = STATE(522),
    [sym_repeat_statement] = STATE(522),
    [sym_braced_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(522),
    [sym_call] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_unary_operator] = STATE(522),
    [sym_binary_operator] = STATE(522),
    [sym_extract_operator] = STATE(522),
    [sym_namespace_operator] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_complex] = STATE(522),
    [sym_float] = STATE(522),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [sym__close_brace] = STATE(2724),
    [aux_sym_braced_expression_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(225),
    [sym__semicolon] = ACTIONS(225),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(229),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [12] = {
    [sym_function_definition] = STATE(522),
    [sym_if_statement] = STATE(522),
    [sym_for_statement] = STATE(522),
    [sym_while_statement] = STATE(522),
    [sym_repeat_statement] = STATE(522),
    [sym_braced_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(522),
    [sym_call] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_unary_operator] = STATE(522),
    [sym_binary_operator] = STATE(522),
    [sym_extract_operator] = STATE(522),
    [sym_namespace_operator] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_complex] = STATE(522),
    [sym_float] = STATE(522),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [sym__close_brace] = STATE(2711),
    [aux_sym_braced_expression_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(225),
    [sym__semicolon] = ACTIONS(225),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(231),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [13] = {
    [sym_function_definition] = STATE(507),
    [sym_if_statement] = STATE(507),
    [sym_for_statement] = STATE(507),
    [sym_while_statement] = STATE(507),
    [sym_repeat_statement] = STATE(507),
    [sym_braced_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_call] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_unary_operator] = STATE(507),
    [sym_binary_operator] = STATE(507),
    [sym_extract_operator] = STATE(507),
    [sym_namespace_operator] = STATE(507),
    [sym_integer] = STATE(507),
    [sym_complex] = STATE(507),
    [sym_float] = STATE(507),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [sym__close_brace] = STATE(2621),
    [aux_sym_braced_expression_repeat1] = STATE(39),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(233),
    [sym_next] = ACTIONS(233),
    [sym_break] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_null] = ACTIONS(233),
    [sym_inf] = ACTIONS(233),
    [sym_nan] = ACTIONS(233),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(233),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(239),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [14] = {
    [sym_function_definition] = STATE(502),
    [sym_if_statement] = STATE(502),
    [sym_for_statement] = STATE(502),
    [sym_while_statement] = STATE(502),
    [sym_repeat_statement] = STATE(502),
    [sym_braced_expression] = STATE(502),
    [sym_parenthesized_expression] = STATE(502),
    [sym_call] = STATE(502),
    [sym_subset] = STATE(502),
    [sym_subset2] = STATE(502),
    [sym_unary_operator] = STATE(502),
    [sym_binary_operator] = STATE(502),
    [sym_extract_operator] = STATE(502),
    [sym_namespace_operator] = STATE(502),
    [sym_integer] = STATE(502),
    [sym_complex] = STATE(502),
    [sym_float] = STATE(502),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__close_parenthesis] = STATE(2347),
    [sym__open_brace] = STATE(18),
    [aux_sym_parenthesized_expression_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(241),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
    [sym__external_close_bracket2] = ACTIONS(129),
  },
  [15] = {
    [sym_function_definition] = STATE(522),
    [sym_if_statement] = STATE(522),
    [sym_for_statement] = STATE(522),
    [sym_while_statement] = STATE(522),
    [sym_repeat_statement] = STATE(522),
    [sym_braced_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(522),
    [sym_call] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_unary_operator] = STATE(522),
    [sym_binary_operator] = STATE(522),
    [sym_extract_operator] = STATE(522),
    [sym_namespace_operator] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_complex] = STATE(522),
    [sym_float] = STATE(522),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [sym__close_brace] = STATE(2329),
    [aux_sym_braced_expression_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(225),
    [sym__semicolon] = ACTIONS(225),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(243),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [16] = {
    [sym_function_definition] = STATE(507),
    [sym_if_statement] = STATE(507),
    [sym_for_statement] = STATE(507),
    [sym_while_statement] = STATE(507),
    [sym_repeat_statement] = STATE(507),
    [sym_braced_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_call] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_unary_operator] = STATE(507),
    [sym_binary_operator] = STATE(507),
    [sym_extract_operator] = STATE(507),
    [sym_namespace_operator] = STATE(507),
    [sym_integer] = STATE(507),
    [sym_complex] = STATE(507),
    [sym_float] = STATE(507),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [sym__close_brace] = STATE(2645),
    [aux_sym_braced_expression_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(233),
    [sym_next] = ACTIONS(233),
    [sym_break] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_null] = ACTIONS(233),
    [sym_inf] = ACTIONS(233),
    [sym_nan] = ACTIONS(233),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(233),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(245),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [17] = {
    [sym_function_definition] = STATE(507),
    [sym_if_statement] = STATE(507),
    [sym_for_statement] = STATE(507),
    [sym_while_statement] = STATE(507),
    [sym_repeat_statement] = STATE(507),
    [sym_braced_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_call] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_unary_operator] = STATE(507),
    [sym_binary_operator] = STATE(507),
    [sym_extract_operator] = STATE(507),
    [sym_namespace_operator] = STATE(507),
    [sym_integer] = STATE(507),
    [sym_complex] = STATE(507),
    [sym_float] = STATE(507),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [sym__close_brace] = STATE(2357),
    [aux_sym_braced_expression_repeat1] = STATE(39),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(233),
    [sym_next] = ACTIONS(233),
    [sym_break] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_null] = ACTIONS(233),
    [sym_inf] = ACTIONS(233),
    [sym_nan] = ACTIONS(233),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(233),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(247),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [18] = {
    [sym_function_definition] = STATE(507),
    [sym_if_statement] = STATE(507),
    [sym_for_statement] = STATE(507),
    [sym_while_statement] = STATE(507),
    [sym_repeat_statement] = STATE(507),
    [sym_braced_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_call] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_unary_operator] = STATE(507),
    [sym_binary_operator] = STATE(507),
    [sym_extract_operator] = STATE(507),
    [sym_namespace_operator] = STATE(507),
    [sym_integer] = STATE(507),
    [sym_complex] = STATE(507),
    [sym_float] = STATE(507),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [sym__close_brace] = STATE(2348),
    [aux_sym_braced_expression_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(233),
    [sym_next] = ACTIONS(233),
    [sym_break] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_null] = ACTIONS(233),
    [sym_inf] = ACTIONS(233),
    [sym_nan] = ACTIONS(233),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(233),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(249),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [19] = {
    [sym_function_definition] = STATE(575),
    [sym_if_statement] = STATE(575),
    [sym_for_statement] = STATE(575),
    [sym_while_statement] = STATE(575),
    [sym_repeat_statement] = STATE(575),
    [sym_braced_expression] = STATE(575),
    [sym_parenthesized_expression] = STATE(575),
    [sym_call] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_unary_operator] = STATE(575),
    [sym_binary_operator] = STATE(575),
    [sym_extract_operator] = STATE(575),
    [sym_namespace_operator] = STATE(575),
    [sym_integer] = STATE(575),
    [sym_complex] = STATE(575),
    [sym_float] = STATE(575),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__close_parenthesis] = STATE(2257),
    [sym__open_brace] = STATE(4),
    [aux_sym_parenthesized_expression_repeat1] = STATE(21),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(251),
    [sym_next] = ACTIONS(251),
    [sym_break] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_null] = ACTIONS(251),
    [sym_inf] = ACTIONS(251),
    [sym_nan] = ACTIONS(251),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(251),
    [sym_dot_dot_i] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(255),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(257),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [20] = {
    [sym_function_definition] = STATE(506),
    [sym_if_statement] = STATE(506),
    [sym_for_statement] = STATE(506),
    [sym_while_statement] = STATE(506),
    [sym_repeat_statement] = STATE(506),
    [sym_braced_expression] = STATE(506),
    [sym_parenthesized_expression] = STATE(506),
    [sym_call] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_unary_operator] = STATE(506),
    [sym_binary_operator] = STATE(506),
    [sym_extract_operator] = STATE(506),
    [sym_namespace_operator] = STATE(506),
    [sym_integer] = STATE(506),
    [sym_complex] = STATE(506),
    [sym_float] = STATE(506),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__close_parenthesis] = STATE(2321),
    [sym__open_brace] = STATE(10),
    [aux_sym_parenthesized_expression_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(139),
    [sym_next] = ACTIONS(139),
    [sym_break] = ACTIONS(139),
    [sym_true] = ACTIONS(139),
    [sym_false] = ACTIONS(139),
    [sym_null] = ACTIONS(139),
    [sym_inf] = ACTIONS(139),
    [sym_nan] = ACTIONS(139),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(139),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(259),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_close_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [21] = {
    [sym_function_definition] = STATE(575),
    [sym_if_statement] = STATE(575),
    [sym_for_statement] = STATE(575),
    [sym_while_statement] = STATE(575),
    [sym_repeat_statement] = STATE(575),
    [sym_braced_expression] = STATE(575),
    [sym_parenthesized_expression] = STATE(575),
    [sym_call] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_unary_operator] = STATE(575),
    [sym_binary_operator] = STATE(575),
    [sym_extract_operator] = STATE(575),
    [sym_namespace_operator] = STATE(575),
    [sym_integer] = STATE(575),
    [sym_complex] = STATE(575),
    [sym_float] = STATE(575),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__close_parenthesis] = STATE(2245),
    [sym__open_brace] = STATE(4),
    [aux_sym_parenthesized_expression_repeat1] = STATE(58),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(251),
    [sym_next] = ACTIONS(251),
    [sym_break] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_null] = ACTIONS(251),
    [sym_inf] = ACTIONS(251),
    [sym_nan] = ACTIONS(251),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(251),
    [sym_dot_dot_i] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(255),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(261),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [22] = {
    [sym_function_definition] = STATE(509),
    [sym_if_statement] = STATE(509),
    [sym_for_statement] = STATE(509),
    [sym_while_statement] = STATE(509),
    [sym_repeat_statement] = STATE(509),
    [sym_braced_expression] = STATE(509),
    [sym_parenthesized_expression] = STATE(509),
    [sym_call] = STATE(509),
    [sym_subset] = STATE(509),
    [sym_subset2] = STATE(509),
    [sym_unary_operator] = STATE(509),
    [sym_binary_operator] = STATE(509),
    [sym_extract_operator] = STATE(509),
    [sym_namespace_operator] = STATE(509),
    [sym_integer] = STATE(509),
    [sym_complex] = STATE(509),
    [sym_float] = STATE(509),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(509),
    [sym__expression] = STATE(509),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(47),
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_COLON_EQ] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_DASH_GT_GT] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_STAR_STAR] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(263),
    [aux_sym_binary_operator_token1] = ACTIONS(263),
    [anon_sym_PIPE_GT] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(267),
    [sym_next] = ACTIONS(267),
    [sym_break] = ACTIONS(267),
    [sym_true] = ACTIONS(267),
    [sym_false] = ACTIONS(267),
    [sym_null] = ACTIONS(267),
    [sym_inf] = ACTIONS(267),
    [sym_nan] = ACTIONS(267),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(267),
    [sym_dot_dot_i] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(263),
    [sym__newline] = ACTIONS(271),
    [sym__semicolon] = ACTIONS(263),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(263),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(263),
    [sym__external_open_bracket] = ACTIONS(263),
    [sym__external_open_bracket2] = ACTIONS(263),
  },
  [23] = {
    [sym_function_definition] = STATE(917),
    [sym_if_statement] = STATE(917),
    [sym_for_statement] = STATE(917),
    [sym_while_statement] = STATE(917),
    [sym_repeat_statement] = STATE(917),
    [sym_braced_expression] = STATE(917),
    [sym_parenthesized_expression] = STATE(917),
    [sym_call] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_unary_operator] = STATE(917),
    [sym_binary_operator] = STATE(917),
    [sym_extract_operator] = STATE(917),
    [sym_namespace_operator] = STATE(917),
    [sym_integer] = STATE(917),
    [sym_complex] = STATE(917),
    [sym_float] = STATE(917),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__close_parenthesis] = STATE(2660),
    [sym__open_brace] = STATE(59),
    [aux_sym_parenthesized_expression_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(305),
    [sym_next] = ACTIONS(305),
    [sym_break] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_null] = ACTIONS(305),
    [sym_inf] = ACTIONS(305),
    [sym_nan] = ACTIONS(305),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(305),
    [sym_dot_dot_i] = ACTIONS(309),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(311),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(317),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_close_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [24] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [sym__close_brace] = STATE(2490),
    [aux_sym_braced_expression_repeat1] = STATE(68),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(353),
    [sym_next] = ACTIONS(353),
    [sym_break] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_null] = ACTIONS(353),
    [sym_inf] = ACTIONS(353),
    [sym_nan] = ACTIONS(353),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(353),
    [sym_dot_dot_i] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(359),
    [sym__semicolon] = ACTIONS(359),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(367),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [25] = {
    [sym_function_definition] = STATE(553),
    [sym_if_statement] = STATE(553),
    [sym_for_statement] = STATE(553),
    [sym_while_statement] = STATE(553),
    [sym_repeat_statement] = STATE(553),
    [sym_braced_expression] = STATE(553),
    [sym_parenthesized_expression] = STATE(553),
    [sym_call] = STATE(553),
    [sym_subset] = STATE(553),
    [sym_subset2] = STATE(553),
    [sym_unary_operator] = STATE(553),
    [sym_binary_operator] = STATE(553),
    [sym_extract_operator] = STATE(553),
    [sym_namespace_operator] = STATE(553),
    [sym_integer] = STATE(553),
    [sym_complex] = STATE(553),
    [sym_float] = STATE(553),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(553),
    [sym__expression] = STATE(553),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [26] = {
    [sym_function_definition] = STATE(554),
    [sym_if_statement] = STATE(554),
    [sym_for_statement] = STATE(554),
    [sym_while_statement] = STATE(554),
    [sym_repeat_statement] = STATE(554),
    [sym_braced_expression] = STATE(554),
    [sym_parenthesized_expression] = STATE(554),
    [sym_call] = STATE(554),
    [sym_subset] = STATE(554),
    [sym_subset2] = STATE(554),
    [sym_unary_operator] = STATE(554),
    [sym_binary_operator] = STATE(554),
    [sym_extract_operator] = STATE(554),
    [sym_namespace_operator] = STATE(554),
    [sym_integer] = STATE(554),
    [sym_complex] = STATE(554),
    [sym_float] = STATE(554),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(554),
    [sym__expression] = STATE(554),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(28),
    [ts_builtin_sym_end] = ACTIONS(377),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(377),
    [anon_sym_LT_LT_DASH] = ACTIONS(377),
    [anon_sym_COLON_EQ] = ACTIONS(377),
    [anon_sym_DASH_GT] = ACTIONS(379),
    [anon_sym_DASH_GT_GT] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(377),
    [anon_sym_LT] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(377),
    [anon_sym_BANG_EQ] = ACTIONS(377),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_STAR_STAR] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [aux_sym_binary_operator_token1] = ACTIONS(377),
    [anon_sym_PIPE_GT] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(377),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(377),
    [sym__newline] = ACTIONS(385),
    [sym__semicolon] = ACTIONS(377),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(377),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(377),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(377),
    [sym__external_open_bracket] = ACTIONS(377),
    [sym__external_open_bracket2] = ACTIONS(377),
  },
  [27] = {
    [sym_function_definition] = STATE(556),
    [sym_if_statement] = STATE(556),
    [sym_for_statement] = STATE(556),
    [sym_while_statement] = STATE(556),
    [sym_repeat_statement] = STATE(556),
    [sym_braced_expression] = STATE(556),
    [sym_parenthesized_expression] = STATE(556),
    [sym_call] = STATE(556),
    [sym_subset] = STATE(556),
    [sym_subset2] = STATE(556),
    [sym_unary_operator] = STATE(556),
    [sym_binary_operator] = STATE(556),
    [sym_extract_operator] = STATE(556),
    [sym_namespace_operator] = STATE(556),
    [sym_integer] = STATE(556),
    [sym_complex] = STATE(556),
    [sym_float] = STATE(556),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(556),
    [sym__expression] = STATE(556),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(30),
    [ts_builtin_sym_end] = ACTIONS(387),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(387),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [aux_sym_binary_operator_token1] = ACTIONS(387),
    [anon_sym_PIPE_GT] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_DOLLAR] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(391),
    [sym_next] = ACTIONS(391),
    [sym_break] = ACTIONS(391),
    [sym_true] = ACTIONS(391),
    [sym_false] = ACTIONS(391),
    [sym_null] = ACTIONS(391),
    [sym_inf] = ACTIONS(391),
    [sym_nan] = ACTIONS(391),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(391),
    [sym_dot_dot_i] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(395),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(387),
  },
  [28] = {
    [sym_function_definition] = STATE(557),
    [sym_if_statement] = STATE(557),
    [sym_for_statement] = STATE(557),
    [sym_while_statement] = STATE(557),
    [sym_repeat_statement] = STATE(557),
    [sym_braced_expression] = STATE(557),
    [sym_parenthesized_expression] = STATE(557),
    [sym_call] = STATE(557),
    [sym_subset] = STATE(557),
    [sym_subset2] = STATE(557),
    [sym_unary_operator] = STATE(557),
    [sym_binary_operator] = STATE(557),
    [sym_extract_operator] = STATE(557),
    [sym_namespace_operator] = STATE(557),
    [sym_integer] = STATE(557),
    [sym_complex] = STATE(557),
    [sym_float] = STATE(557),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(557),
    [sym__expression] = STATE(557),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(397),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(397),
    [anon_sym_LT_LT_DASH] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_STAR_STAR] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [aux_sym_binary_operator_token1] = ACTIONS(397),
    [anon_sym_PIPE_GT] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(401),
    [sym_next] = ACTIONS(401),
    [sym_break] = ACTIONS(401),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [sym_null] = ACTIONS(401),
    [sym_inf] = ACTIONS(401),
    [sym_nan] = ACTIONS(401),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(401),
    [sym_dot_dot_i] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(397),
    [sym__newline] = ACTIONS(397),
    [sym__semicolon] = ACTIONS(397),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(397),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(397),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(397),
    [sym__external_open_bracket] = ACTIONS(397),
    [sym__external_open_bracket2] = ACTIONS(397),
  },
  [29] = {
    [sym_function_definition] = STATE(789),
    [sym_if_statement] = STATE(789),
    [sym_for_statement] = STATE(789),
    [sym_while_statement] = STATE(789),
    [sym_repeat_statement] = STATE(789),
    [sym_braced_expression] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_call] = STATE(789),
    [sym_subset] = STATE(789),
    [sym_subset2] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_binary_operator] = STATE(789),
    [sym_extract_operator] = STATE(789),
    [sym_namespace_operator] = STATE(789),
    [sym_integer] = STATE(789),
    [sym_complex] = STATE(789),
    [sym_float] = STATE(789),
    [sym__hex_literal] = STATE(2210),
    [sym__float_literal] = STATE(2210),
    [sym_string] = STATE(2209),
    [sym__single_quoted_string] = STATE(2211),
    [sym__double_quoted_string] = STATE(2212),
    [sym_na] = STATE(789),
    [sym__expression] = STATE(789),
    [sym__string_or_identifier] = STATE(5127),
    [sym__open_parenthesis] = STATE(5),
    [sym__open_brace] = STATE(42),
    [sym__close_brace] = STATE(2858),
    [aux_sym_braced_expression_repeat1] = STATE(35),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(415),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(427),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(429),
    [sym__number_literal] = ACTIONS(431),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(439),
    [anon_sym_NA_integer_] = ACTIONS(439),
    [anon_sym_NA_real_] = ACTIONS(439),
    [anon_sym_NA_complex_] = ACTIONS(439),
    [anon_sym_NA_character_] = ACTIONS(439),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(445),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(447),
    [sym__external_open_brace] = ACTIONS(449),
    [sym__external_close_brace] = ACTIONS(451),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [30] = {
    [sym_function_definition] = STATE(560),
    [sym_if_statement] = STATE(560),
    [sym_for_statement] = STATE(560),
    [sym_while_statement] = STATE(560),
    [sym_repeat_statement] = STATE(560),
    [sym_braced_expression] = STATE(560),
    [sym_parenthesized_expression] = STATE(560),
    [sym_call] = STATE(560),
    [sym_subset] = STATE(560),
    [sym_subset2] = STATE(560),
    [sym_unary_operator] = STATE(560),
    [sym_binary_operator] = STATE(560),
    [sym_extract_operator] = STATE(560),
    [sym_namespace_operator] = STATE(560),
    [sym_integer] = STATE(560),
    [sym_complex] = STATE(560),
    [sym_float] = STATE(560),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(560),
    [sym__expression] = STATE(560),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(453),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [anon_sym_LT_LT_DASH] = ACTIONS(453),
    [anon_sym_COLON_EQ] = ACTIONS(453),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(453),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [aux_sym_binary_operator_token1] = ACTIONS(453),
    [anon_sym_PIPE_GT] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(453),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(457),
    [sym_next] = ACTIONS(457),
    [sym_break] = ACTIONS(457),
    [sym_true] = ACTIONS(457),
    [sym_false] = ACTIONS(457),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(457),
    [sym_nan] = ACTIONS(457),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(457),
    [sym_dot_dot_i] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(453),
  },
  [31] = {
    [sym_function_definition] = STATE(561),
    [sym_if_statement] = STATE(561),
    [sym_for_statement] = STATE(561),
    [sym_while_statement] = STATE(561),
    [sym_repeat_statement] = STATE(561),
    [sym_braced_expression] = STATE(561),
    [sym_parenthesized_expression] = STATE(561),
    [sym_call] = STATE(561),
    [sym_subset] = STATE(561),
    [sym_subset2] = STATE(561),
    [sym_unary_operator] = STATE(561),
    [sym_binary_operator] = STATE(561),
    [sym_extract_operator] = STATE(561),
    [sym_namespace_operator] = STATE(561),
    [sym_integer] = STATE(561),
    [sym_complex] = STATE(561),
    [sym_float] = STATE(561),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(561),
    [sym__expression] = STATE(561),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(32),
    [ts_builtin_sym_end] = ACTIONS(461),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(461),
    [anon_sym_LT_LT_DASH] = ACTIONS(461),
    [anon_sym_COLON_EQ] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_DASH_GT_GT] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [aux_sym_binary_operator_token1] = ACTIONS(461),
    [anon_sym_PIPE_GT] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_DOLLAR] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(461),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(465),
    [sym_next] = ACTIONS(465),
    [sym_break] = ACTIONS(465),
    [sym_true] = ACTIONS(465),
    [sym_false] = ACTIONS(465),
    [sym_null] = ACTIONS(465),
    [sym_inf] = ACTIONS(465),
    [sym_nan] = ACTIONS(465),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(465),
    [sym_dot_dot_i] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(469),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(461),
  },
  [32] = {
    [sym_function_definition] = STATE(544),
    [sym_if_statement] = STATE(544),
    [sym_for_statement] = STATE(544),
    [sym_while_statement] = STATE(544),
    [sym_repeat_statement] = STATE(544),
    [sym_braced_expression] = STATE(544),
    [sym_parenthesized_expression] = STATE(544),
    [sym_call] = STATE(544),
    [sym_subset] = STATE(544),
    [sym_subset2] = STATE(544),
    [sym_unary_operator] = STATE(544),
    [sym_binary_operator] = STATE(544),
    [sym_extract_operator] = STATE(544),
    [sym_namespace_operator] = STATE(544),
    [sym_integer] = STATE(544),
    [sym_complex] = STATE(544),
    [sym_float] = STATE(544),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(544),
    [sym__expression] = STATE(544),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(471),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(471),
    [anon_sym_LT_LT_DASH] = ACTIONS(471),
    [anon_sym_COLON_EQ] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_GT] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(471),
    [aux_sym_binary_operator_token1] = ACTIONS(471),
    [anon_sym_PIPE_GT] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(471),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(475),
    [sym_next] = ACTIONS(475),
    [sym_break] = ACTIONS(475),
    [sym_true] = ACTIONS(475),
    [sym_false] = ACTIONS(475),
    [sym_null] = ACTIONS(475),
    [sym_inf] = ACTIONS(475),
    [sym_nan] = ACTIONS(475),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(475),
    [sym_dot_dot_i] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(471),
    [sym__newline] = ACTIONS(471),
    [sym__semicolon] = ACTIONS(471),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(471),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(471),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(471),
    [sym__external_open_bracket] = ACTIONS(471),
    [sym__external_open_bracket2] = ACTIONS(471),
  },
  [33] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2787),
    [aux_sym_braced_expression_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(479),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [34] = {
    [sym_function_definition] = STATE(796),
    [sym_if_statement] = STATE(796),
    [sym_for_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_repeat_statement] = STATE(796),
    [sym_braced_expression] = STATE(796),
    [sym_parenthesized_expression] = STATE(796),
    [sym_call] = STATE(796),
    [sym_subset] = STATE(796),
    [sym_subset2] = STATE(796),
    [sym_unary_operator] = STATE(796),
    [sym_binary_operator] = STATE(796),
    [sym_extract_operator] = STATE(796),
    [sym_namespace_operator] = STATE(796),
    [sym_integer] = STATE(796),
    [sym_complex] = STATE(796),
    [sym_float] = STATE(796),
    [sym__hex_literal] = STATE(2206),
    [sym__float_literal] = STATE(2206),
    [sym_string] = STATE(2166),
    [sym__single_quoted_string] = STATE(2200),
    [sym__double_quoted_string] = STATE(2201),
    [sym_na] = STATE(796),
    [sym__expression] = STATE(796),
    [sym__string_or_identifier] = STATE(5154),
    [sym__open_parenthesis] = STATE(3),
    [sym__open_brace] = STATE(45),
    [sym__close_brace] = STATE(2931),
    [aux_sym_braced_expression_repeat1] = STATE(195),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_BSLASH] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(505),
    [sym__number_literal] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(515),
    [anon_sym_NA_integer_] = ACTIONS(515),
    [anon_sym_NA_real_] = ACTIONS(515),
    [anon_sym_NA_complex_] = ACTIONS(515),
    [anon_sym_NA_character_] = ACTIONS(515),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(517),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(521),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(525),
    [sym__external_close_brace] = ACTIONS(527),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [35] = {
    [sym_function_definition] = STATE(789),
    [sym_if_statement] = STATE(789),
    [sym_for_statement] = STATE(789),
    [sym_while_statement] = STATE(789),
    [sym_repeat_statement] = STATE(789),
    [sym_braced_expression] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_call] = STATE(789),
    [sym_subset] = STATE(789),
    [sym_subset2] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_binary_operator] = STATE(789),
    [sym_extract_operator] = STATE(789),
    [sym_namespace_operator] = STATE(789),
    [sym_integer] = STATE(789),
    [sym_complex] = STATE(789),
    [sym_float] = STATE(789),
    [sym__hex_literal] = STATE(2210),
    [sym__float_literal] = STATE(2210),
    [sym_string] = STATE(2209),
    [sym__single_quoted_string] = STATE(2211),
    [sym__double_quoted_string] = STATE(2212),
    [sym_na] = STATE(789),
    [sym__expression] = STATE(789),
    [sym__string_or_identifier] = STATE(5127),
    [sym__open_parenthesis] = STATE(5),
    [sym__open_brace] = STATE(42),
    [sym__close_brace] = STATE(2809),
    [aux_sym_braced_expression_repeat1] = STATE(159),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(415),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(427),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(429),
    [sym__number_literal] = ACTIONS(431),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(439),
    [anon_sym_NA_integer_] = ACTIONS(439),
    [anon_sym_NA_real_] = ACTIONS(439),
    [anon_sym_NA_complex_] = ACTIONS(439),
    [anon_sym_NA_character_] = ACTIONS(439),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(445),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(447),
    [sym__external_open_brace] = ACTIONS(449),
    [sym__external_close_brace] = ACTIONS(529),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [36] = {
    [sym_function_definition] = STATE(552),
    [sym_if_statement] = STATE(552),
    [sym_for_statement] = STATE(552),
    [sym_while_statement] = STATE(552),
    [sym_repeat_statement] = STATE(552),
    [sym_braced_expression] = STATE(552),
    [sym_parenthesized_expression] = STATE(552),
    [sym_call] = STATE(552),
    [sym_subset] = STATE(552),
    [sym_subset2] = STATE(552),
    [sym_unary_operator] = STATE(552),
    [sym_binary_operator] = STATE(552),
    [sym_extract_operator] = STATE(552),
    [sym_namespace_operator] = STATE(552),
    [sym_integer] = STATE(552),
    [sym_complex] = STATE(552),
    [sym_float] = STATE(552),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(552),
    [sym__expression] = STATE(552),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(531),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(531),
    [anon_sym_LT_LT_DASH] = ACTIONS(531),
    [anon_sym_COLON_EQ] = ACTIONS(531),
    [anon_sym_DASH_GT] = ACTIONS(533),
    [anon_sym_DASH_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [aux_sym_binary_operator_token1] = ACTIONS(531),
    [anon_sym_PIPE_GT] = ACTIONS(531),
    [anon_sym_COLON] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(535),
    [sym_next] = ACTIONS(535),
    [sym_break] = ACTIONS(535),
    [sym_true] = ACTIONS(535),
    [sym_false] = ACTIONS(535),
    [sym_null] = ACTIONS(535),
    [sym_inf] = ACTIONS(535),
    [sym_nan] = ACTIONS(535),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(535),
    [sym_dot_dot_i] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(539),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(531),
  },
  [37] = {
    [sym_function_definition] = STATE(575),
    [sym_if_statement] = STATE(575),
    [sym_for_statement] = STATE(575),
    [sym_while_statement] = STATE(575),
    [sym_repeat_statement] = STATE(575),
    [sym_braced_expression] = STATE(575),
    [sym_parenthesized_expression] = STATE(575),
    [sym_call] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_unary_operator] = STATE(575),
    [sym_binary_operator] = STATE(575),
    [sym_extract_operator] = STATE(575),
    [sym_namespace_operator] = STATE(575),
    [sym_integer] = STATE(575),
    [sym_complex] = STATE(575),
    [sym_float] = STATE(575),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__close_parenthesis] = STATE(2590),
    [sym__open_brace] = STATE(4),
    [aux_sym_parenthesized_expression_repeat1] = STATE(58),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(251),
    [sym_next] = ACTIONS(251),
    [sym_break] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_null] = ACTIONS(251),
    [sym_inf] = ACTIONS(251),
    [sym_nan] = ACTIONS(251),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(251),
    [sym_dot_dot_i] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(255),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(541),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [38] = {
    [sym_function_definition] = STATE(569),
    [sym_if_statement] = STATE(569),
    [sym_for_statement] = STATE(569),
    [sym_while_statement] = STATE(569),
    [sym_repeat_statement] = STATE(569),
    [sym_braced_expression] = STATE(569),
    [sym_parenthesized_expression] = STATE(569),
    [sym_call] = STATE(569),
    [sym_subset] = STATE(569),
    [sym_subset2] = STATE(569),
    [sym_unary_operator] = STATE(569),
    [sym_binary_operator] = STATE(569),
    [sym_extract_operator] = STATE(569),
    [sym_namespace_operator] = STATE(569),
    [sym_integer] = STATE(569),
    [sym_complex] = STATE(569),
    [sym_float] = STATE(569),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(569),
    [sym__expression] = STATE(569),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(545),
    [anon_sym_LT_LT_DASH] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(543),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [aux_sym_binary_operator_token1] = ACTIONS(545),
    [anon_sym_PIPE_GT] = ACTIONS(545),
    [anon_sym_COLON] = ACTIONS(543),
    [anon_sym_DOLLAR] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(545),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(547),
    [sym_next] = ACTIONS(547),
    [sym_break] = ACTIONS(547),
    [sym_true] = ACTIONS(547),
    [sym_false] = ACTIONS(547),
    [sym_null] = ACTIONS(547),
    [sym_inf] = ACTIONS(547),
    [sym_nan] = ACTIONS(547),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(547),
    [sym_dot_dot_i] = ACTIONS(549),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(551),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(545),
    [sym__external_close_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(545),
  },
  [39] = {
    [sym_function_definition] = STATE(507),
    [sym_if_statement] = STATE(507),
    [sym_for_statement] = STATE(507),
    [sym_while_statement] = STATE(507),
    [sym_repeat_statement] = STATE(507),
    [sym_braced_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_call] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_unary_operator] = STATE(507),
    [sym_binary_operator] = STATE(507),
    [sym_extract_operator] = STATE(507),
    [sym_namespace_operator] = STATE(507),
    [sym_integer] = STATE(507),
    [sym_complex] = STATE(507),
    [sym_float] = STATE(507),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_braced_expression_repeat1] = STATE(39),
    [sym_identifier] = ACTIONS(553),
    [anon_sym_BSLASH] = ACTIONS(556),
    [anon_sym_function] = ACTIONS(559),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_while] = ACTIONS(570),
    [anon_sym_repeat] = ACTIONS(573),
    [anon_sym_QMARK] = ACTIONS(576),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_BANG] = ACTIONS(582),
    [anon_sym_PLUS] = ACTIONS(585),
    [anon_sym_DASH] = ACTIONS(588),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(593),
    [sym__number_literal] = ACTIONS(596),
    [anon_sym_SQUOTE] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(602),
    [sym_return] = ACTIONS(605),
    [sym_next] = ACTIONS(605),
    [sym_break] = ACTIONS(605),
    [sym_true] = ACTIONS(605),
    [sym_false] = ACTIONS(605),
    [sym_null] = ACTIONS(605),
    [sym_inf] = ACTIONS(605),
    [sym_nan] = ACTIONS(605),
    [anon_sym_NA] = ACTIONS(608),
    [anon_sym_NA_integer_] = ACTIONS(608),
    [anon_sym_NA_real_] = ACTIONS(608),
    [anon_sym_NA_complex_] = ACTIONS(608),
    [anon_sym_NA_character_] = ACTIONS(608),
    [sym_dots] = ACTIONS(605),
    [sym_dot_dot_i] = ACTIONS(611),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(614),
    [sym__semicolon] = ACTIONS(614),
    [sym__raw_string_literal] = ACTIONS(617),
    [sym__external_else] = ACTIONS(591),
    [sym__external_open_parenthesis] = ACTIONS(620),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(623),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
    [sym__external_close_bracket2] = ACTIONS(591),
  },
  [40] = {
    [sym_function_definition] = STATE(921),
    [sym_if_statement] = STATE(921),
    [sym_for_statement] = STATE(921),
    [sym_while_statement] = STATE(921),
    [sym_repeat_statement] = STATE(921),
    [sym_braced_expression] = STATE(921),
    [sym_parenthesized_expression] = STATE(921),
    [sym_call] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_unary_operator] = STATE(921),
    [sym_binary_operator] = STATE(921),
    [sym_extract_operator] = STATE(921),
    [sym_namespace_operator] = STATE(921),
    [sym_integer] = STATE(921),
    [sym_complex] = STATE(921),
    [sym_float] = STATE(921),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [sym__close_brace] = STATE(2785),
    [aux_sym_braced_expression_repeat1] = STATE(124),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(658),
    [sym_next] = ACTIONS(658),
    [sym_break] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_null] = ACTIONS(658),
    [sym_inf] = ACTIONS(658),
    [sym_nan] = ACTIONS(658),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(658),
    [sym_dot_dot_i] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(664),
    [sym__semicolon] = ACTIONS(664),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(672),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [41] = {
    [sym_function_definition] = STATE(796),
    [sym_if_statement] = STATE(796),
    [sym_for_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_repeat_statement] = STATE(796),
    [sym_braced_expression] = STATE(796),
    [sym_parenthesized_expression] = STATE(796),
    [sym_call] = STATE(796),
    [sym_subset] = STATE(796),
    [sym_subset2] = STATE(796),
    [sym_unary_operator] = STATE(796),
    [sym_binary_operator] = STATE(796),
    [sym_extract_operator] = STATE(796),
    [sym_namespace_operator] = STATE(796),
    [sym_integer] = STATE(796),
    [sym_complex] = STATE(796),
    [sym_float] = STATE(796),
    [sym__hex_literal] = STATE(2206),
    [sym__float_literal] = STATE(2206),
    [sym_string] = STATE(2166),
    [sym__single_quoted_string] = STATE(2200),
    [sym__double_quoted_string] = STATE(2201),
    [sym_na] = STATE(796),
    [sym__expression] = STATE(796),
    [sym__string_or_identifier] = STATE(5154),
    [sym__open_parenthesis] = STATE(3),
    [sym__open_brace] = STATE(45),
    [sym__close_brace] = STATE(2458),
    [aux_sym_braced_expression_repeat1] = STATE(195),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_BSLASH] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(505),
    [sym__number_literal] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(515),
    [anon_sym_NA_integer_] = ACTIONS(515),
    [anon_sym_NA_real_] = ACTIONS(515),
    [anon_sym_NA_complex_] = ACTIONS(515),
    [anon_sym_NA_character_] = ACTIONS(515),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(517),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(521),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(525),
    [sym__external_close_brace] = ACTIONS(674),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [42] = {
    [sym_function_definition] = STATE(789),
    [sym_if_statement] = STATE(789),
    [sym_for_statement] = STATE(789),
    [sym_while_statement] = STATE(789),
    [sym_repeat_statement] = STATE(789),
    [sym_braced_expression] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_call] = STATE(789),
    [sym_subset] = STATE(789),
    [sym_subset2] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_binary_operator] = STATE(789),
    [sym_extract_operator] = STATE(789),
    [sym_namespace_operator] = STATE(789),
    [sym_integer] = STATE(789),
    [sym_complex] = STATE(789),
    [sym_float] = STATE(789),
    [sym__hex_literal] = STATE(2210),
    [sym__float_literal] = STATE(2210),
    [sym_string] = STATE(2209),
    [sym__single_quoted_string] = STATE(2211),
    [sym__double_quoted_string] = STATE(2212),
    [sym_na] = STATE(789),
    [sym__expression] = STATE(789),
    [sym__string_or_identifier] = STATE(5127),
    [sym__open_parenthesis] = STATE(5),
    [sym__open_brace] = STATE(42),
    [sym__close_brace] = STATE(2550),
    [aux_sym_braced_expression_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(415),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(427),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(429),
    [sym__number_literal] = ACTIONS(431),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(439),
    [anon_sym_NA_integer_] = ACTIONS(439),
    [anon_sym_NA_real_] = ACTIONS(439),
    [anon_sym_NA_complex_] = ACTIONS(439),
    [anon_sym_NA_character_] = ACTIONS(439),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(445),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(447),
    [sym__external_open_brace] = ACTIONS(449),
    [sym__external_close_brace] = ACTIONS(676),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [43] = {
    [sym_function_definition] = STATE(522),
    [sym_if_statement] = STATE(522),
    [sym_for_statement] = STATE(522),
    [sym_while_statement] = STATE(522),
    [sym_repeat_statement] = STATE(522),
    [sym_braced_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(522),
    [sym_call] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_unary_operator] = STATE(522),
    [sym_binary_operator] = STATE(522),
    [sym_extract_operator] = STATE(522),
    [sym_namespace_operator] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_complex] = STATE(522),
    [sym_float] = STATE(522),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_braced_expression_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_BSLASH] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(687),
    [anon_sym_for] = ACTIONS(690),
    [anon_sym_while] = ACTIONS(693),
    [anon_sym_repeat] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(699),
    [anon_sym_TILDE] = ACTIONS(702),
    [anon_sym_BANG] = ACTIONS(705),
    [anon_sym_PLUS] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(711),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(714),
    [sym__number_literal] = ACTIONS(717),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_DQUOTE] = ACTIONS(723),
    [sym_return] = ACTIONS(726),
    [sym_next] = ACTIONS(726),
    [sym_break] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_null] = ACTIONS(726),
    [sym_inf] = ACTIONS(726),
    [sym_nan] = ACTIONS(726),
    [anon_sym_NA] = ACTIONS(729),
    [anon_sym_NA_integer_] = ACTIONS(729),
    [anon_sym_NA_real_] = ACTIONS(729),
    [anon_sym_NA_complex_] = ACTIONS(729),
    [anon_sym_NA_character_] = ACTIONS(729),
    [sym_dots] = ACTIONS(726),
    [sym_dot_dot_i] = ACTIONS(732),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(735),
    [sym__semicolon] = ACTIONS(735),
    [sym__raw_string_literal] = ACTIONS(738),
    [sym__external_else] = ACTIONS(591),
    [sym__external_open_parenthesis] = ACTIONS(741),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(744),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_close_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
  },
  [44] = {
    [sym_function_definition] = STATE(935),
    [sym_if_statement] = STATE(935),
    [sym_for_statement] = STATE(935),
    [sym_while_statement] = STATE(935),
    [sym_repeat_statement] = STATE(935),
    [sym_braced_expression] = STATE(935),
    [sym_parenthesized_expression] = STATE(935),
    [sym_call] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_unary_operator] = STATE(935),
    [sym_binary_operator] = STATE(935),
    [sym_extract_operator] = STATE(935),
    [sym_namespace_operator] = STATE(935),
    [sym_integer] = STATE(935),
    [sym_complex] = STATE(935),
    [sym_float] = STATE(935),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__close_parenthesis] = STATE(2504),
    [sym__open_brace] = STATE(56),
    [aux_sym_parenthesized_expression_repeat1] = STATE(138),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(747),
    [sym_next] = ACTIONS(747),
    [sym_break] = ACTIONS(747),
    [sym_true] = ACTIONS(747),
    [sym_false] = ACTIONS(747),
    [sym_null] = ACTIONS(747),
    [sym_inf] = ACTIONS(747),
    [sym_nan] = ACTIONS(747),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(747),
    [sym_dot_dot_i] = ACTIONS(749),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(751),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(753),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
    [sym__external_close_bracket2] = ACTIONS(211),
  },
  [45] = {
    [sym_function_definition] = STATE(796),
    [sym_if_statement] = STATE(796),
    [sym_for_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_repeat_statement] = STATE(796),
    [sym_braced_expression] = STATE(796),
    [sym_parenthesized_expression] = STATE(796),
    [sym_call] = STATE(796),
    [sym_subset] = STATE(796),
    [sym_subset2] = STATE(796),
    [sym_unary_operator] = STATE(796),
    [sym_binary_operator] = STATE(796),
    [sym_extract_operator] = STATE(796),
    [sym_namespace_operator] = STATE(796),
    [sym_integer] = STATE(796),
    [sym_complex] = STATE(796),
    [sym_float] = STATE(796),
    [sym__hex_literal] = STATE(2206),
    [sym__float_literal] = STATE(2206),
    [sym_string] = STATE(2166),
    [sym__single_quoted_string] = STATE(2200),
    [sym__double_quoted_string] = STATE(2201),
    [sym_na] = STATE(796),
    [sym__expression] = STATE(796),
    [sym__string_or_identifier] = STATE(5154),
    [sym__open_parenthesis] = STATE(3),
    [sym__open_brace] = STATE(45),
    [sym__close_brace] = STATE(2444),
    [aux_sym_braced_expression_repeat1] = STATE(41),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_BSLASH] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(505),
    [sym__number_literal] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(515),
    [anon_sym_NA_integer_] = ACTIONS(515),
    [anon_sym_NA_real_] = ACTIONS(515),
    [anon_sym_NA_complex_] = ACTIONS(515),
    [anon_sym_NA_character_] = ACTIONS(515),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(517),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(521),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(525),
    [sym__external_close_brace] = ACTIONS(755),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [46] = {
    [sym_function_definition] = STATE(535),
    [sym_if_statement] = STATE(535),
    [sym_for_statement] = STATE(535),
    [sym_while_statement] = STATE(535),
    [sym_repeat_statement] = STATE(535),
    [sym_braced_expression] = STATE(535),
    [sym_parenthesized_expression] = STATE(535),
    [sym_call] = STATE(535),
    [sym_subset] = STATE(535),
    [sym_subset2] = STATE(535),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(535),
    [sym_extract_operator] = STATE(535),
    [sym_namespace_operator] = STATE(535),
    [sym_integer] = STATE(535),
    [sym_complex] = STATE(535),
    [sym_float] = STATE(535),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(535),
    [sym__expression] = STATE(535),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(757),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(761),
    [sym_next] = ACTIONS(761),
    [sym_break] = ACTIONS(761),
    [sym_true] = ACTIONS(761),
    [sym_false] = ACTIONS(761),
    [sym_null] = ACTIONS(761),
    [sym_inf] = ACTIONS(761),
    [sym_nan] = ACTIONS(761),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(761),
    [sym_dot_dot_i] = ACTIONS(763),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(757),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
  },
  [47] = {
    [sym_function_definition] = STATE(515),
    [sym_if_statement] = STATE(515),
    [sym_for_statement] = STATE(515),
    [sym_while_statement] = STATE(515),
    [sym_repeat_statement] = STATE(515),
    [sym_braced_expression] = STATE(515),
    [sym_parenthesized_expression] = STATE(515),
    [sym_call] = STATE(515),
    [sym_subset] = STATE(515),
    [sym_subset2] = STATE(515),
    [sym_unary_operator] = STATE(515),
    [sym_binary_operator] = STATE(515),
    [sym_extract_operator] = STATE(515),
    [sym_namespace_operator] = STATE(515),
    [sym_integer] = STATE(515),
    [sym_complex] = STATE(515),
    [sym_float] = STATE(515),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(515),
    [sym__expression] = STATE(515),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(2195),
    [ts_builtin_sym_end] = ACTIONS(765),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(769),
    [sym_next] = ACTIONS(769),
    [sym_break] = ACTIONS(769),
    [sym_true] = ACTIONS(769),
    [sym_false] = ACTIONS(769),
    [sym_null] = ACTIONS(769),
    [sym_inf] = ACTIONS(769),
    [sym_nan] = ACTIONS(769),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(769),
    [sym_dot_dot_i] = ACTIONS(771),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(765),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(765),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
  },
  [48] = {
    [sym_function_definition] = STATE(789),
    [sym_if_statement] = STATE(789),
    [sym_for_statement] = STATE(789),
    [sym_while_statement] = STATE(789),
    [sym_repeat_statement] = STATE(789),
    [sym_braced_expression] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_call] = STATE(789),
    [sym_subset] = STATE(789),
    [sym_subset2] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_binary_operator] = STATE(789),
    [sym_extract_operator] = STATE(789),
    [sym_namespace_operator] = STATE(789),
    [sym_integer] = STATE(789),
    [sym_complex] = STATE(789),
    [sym_float] = STATE(789),
    [sym__hex_literal] = STATE(2210),
    [sym__float_literal] = STATE(2210),
    [sym_string] = STATE(2209),
    [sym__single_quoted_string] = STATE(2211),
    [sym__double_quoted_string] = STATE(2212),
    [sym_na] = STATE(789),
    [sym__expression] = STATE(789),
    [sym__string_or_identifier] = STATE(5127),
    [sym__open_parenthesis] = STATE(5),
    [sym__open_brace] = STATE(42),
    [sym__close_brace] = STATE(2515),
    [aux_sym_braced_expression_repeat1] = STATE(159),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(415),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(427),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(429),
    [sym__number_literal] = ACTIONS(431),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(439),
    [anon_sym_NA_integer_] = ACTIONS(439),
    [anon_sym_NA_real_] = ACTIONS(439),
    [anon_sym_NA_complex_] = ACTIONS(439),
    [anon_sym_NA_character_] = ACTIONS(439),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(445),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(447),
    [sym__external_open_brace] = ACTIONS(449),
    [sym__external_close_brace] = ACTIONS(773),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [49] = {
    [sym_function_definition] = STATE(514),
    [sym_if_statement] = STATE(514),
    [sym_for_statement] = STATE(514),
    [sym_while_statement] = STATE(514),
    [sym_repeat_statement] = STATE(514),
    [sym_braced_expression] = STATE(514),
    [sym_parenthesized_expression] = STATE(514),
    [sym_call] = STATE(514),
    [sym_subset] = STATE(514),
    [sym_subset2] = STATE(514),
    [sym_unary_operator] = STATE(514),
    [sym_binary_operator] = STATE(514),
    [sym_extract_operator] = STATE(514),
    [sym_namespace_operator] = STATE(514),
    [sym_integer] = STATE(514),
    [sym_complex] = STATE(514),
    [sym_float] = STATE(514),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(514),
    [sym__expression] = STATE(514),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_function_definition_repeat1] = STATE(46),
    [ts_builtin_sym_end] = ACTIONS(545),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(545),
    [anon_sym_LT_LT_DASH] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(543),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [aux_sym_binary_operator_token1] = ACTIONS(545),
    [anon_sym_PIPE_GT] = ACTIONS(545),
    [anon_sym_COLON] = ACTIONS(543),
    [anon_sym_DOLLAR] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(545),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(775),
    [sym_next] = ACTIONS(775),
    [sym_break] = ACTIONS(775),
    [sym_true] = ACTIONS(775),
    [sym_false] = ACTIONS(775),
    [sym_null] = ACTIONS(775),
    [sym_inf] = ACTIONS(775),
    [sym_nan] = ACTIONS(775),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(775),
    [sym_dot_dot_i] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(779),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(545),
  },
  [50] = {
    [sym_function_definition] = STATE(917),
    [sym_if_statement] = STATE(917),
    [sym_for_statement] = STATE(917),
    [sym_while_statement] = STATE(917),
    [sym_repeat_statement] = STATE(917),
    [sym_braced_expression] = STATE(917),
    [sym_parenthesized_expression] = STATE(917),
    [sym_call] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_unary_operator] = STATE(917),
    [sym_binary_operator] = STATE(917),
    [sym_extract_operator] = STATE(917),
    [sym_namespace_operator] = STATE(917),
    [sym_integer] = STATE(917),
    [sym_complex] = STATE(917),
    [sym_float] = STATE(917),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__close_parenthesis] = STATE(2489),
    [sym__open_brace] = STATE(59),
    [aux_sym_parenthesized_expression_repeat1] = STATE(123),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(305),
    [sym_next] = ACTIONS(305),
    [sym_break] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_null] = ACTIONS(305),
    [sym_inf] = ACTIONS(305),
    [sym_nan] = ACTIONS(305),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(305),
    [sym_dot_dot_i] = ACTIONS(309),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(311),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(781),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_close_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [51] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(4710),
    [aux_sym_braced_expression_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(783),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [52] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(4694),
    [aux_sym_braced_expression_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(785),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [53] = {
    [sym_function_definition] = STATE(564),
    [sym_if_statement] = STATE(564),
    [sym_for_statement] = STATE(564),
    [sym_while_statement] = STATE(564),
    [sym_repeat_statement] = STATE(564),
    [sym_braced_expression] = STATE(564),
    [sym_parenthesized_expression] = STATE(564),
    [sym_call] = STATE(564),
    [sym_subset] = STATE(564),
    [sym_subset2] = STATE(564),
    [sym_unary_operator] = STATE(564),
    [sym_binary_operator] = STATE(564),
    [sym_extract_operator] = STATE(564),
    [sym_namespace_operator] = STATE(564),
    [sym_integer] = STATE(564),
    [sym_complex] = STATE(564),
    [sym_float] = STATE(564),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(564),
    [sym__expression] = STATE(564),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_COLON_EQ] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_DASH_GT_GT] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_STAR_STAR] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(263),
    [aux_sym_binary_operator_token1] = ACTIONS(263),
    [anon_sym_PIPE_GT] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(787),
    [sym_next] = ACTIONS(787),
    [sym_break] = ACTIONS(787),
    [sym_true] = ACTIONS(787),
    [sym_false] = ACTIONS(787),
    [sym_null] = ACTIONS(787),
    [sym_inf] = ACTIONS(787),
    [sym_nan] = ACTIONS(787),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(787),
    [sym_dot_dot_i] = ACTIONS(789),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(263),
    [sym__newline] = ACTIONS(791),
    [sym__semicolon] = ACTIONS(263),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(263),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(263),
    [sym__external_open_bracket] = ACTIONS(263),
    [sym__external_close_bracket] = ACTIONS(263),
    [sym__external_open_bracket2] = ACTIONS(263),
  },
  [54] = {
    [sym_function_definition] = STATE(935),
    [sym_if_statement] = STATE(935),
    [sym_for_statement] = STATE(935),
    [sym_while_statement] = STATE(935),
    [sym_repeat_statement] = STATE(935),
    [sym_braced_expression] = STATE(935),
    [sym_parenthesized_expression] = STATE(935),
    [sym_call] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_unary_operator] = STATE(935),
    [sym_binary_operator] = STATE(935),
    [sym_extract_operator] = STATE(935),
    [sym_namespace_operator] = STATE(935),
    [sym_integer] = STATE(935),
    [sym_complex] = STATE(935),
    [sym_float] = STATE(935),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__close_parenthesis] = STATE(2406),
    [sym__open_brace] = STATE(56),
    [aux_sym_parenthesized_expression_repeat1] = STATE(44),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(747),
    [sym_next] = ACTIONS(747),
    [sym_break] = ACTIONS(747),
    [sym_true] = ACTIONS(747),
    [sym_false] = ACTIONS(747),
    [sym_null] = ACTIONS(747),
    [sym_inf] = ACTIONS(747),
    [sym_nan] = ACTIONS(747),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(747),
    [sym_dot_dot_i] = ACTIONS(749),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(751),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(793),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
    [sym__external_close_bracket2] = ACTIONS(129),
  },
  [55] = {
    [sym_function_definition] = STATE(570),
    [sym_if_statement] = STATE(570),
    [sym_for_statement] = STATE(570),
    [sym_while_statement] = STATE(570),
    [sym_repeat_statement] = STATE(570),
    [sym_braced_expression] = STATE(570),
    [sym_parenthesized_expression] = STATE(570),
    [sym_call] = STATE(570),
    [sym_subset] = STATE(570),
    [sym_subset2] = STATE(570),
    [sym_unary_operator] = STATE(570),
    [sym_binary_operator] = STATE(570),
    [sym_extract_operator] = STATE(570),
    [sym_namespace_operator] = STATE(570),
    [sym_integer] = STATE(570),
    [sym_complex] = STATE(570),
    [sym_float] = STATE(570),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(570),
    [sym__expression] = STATE(570),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(795),
    [sym_next] = ACTIONS(795),
    [sym_break] = ACTIONS(795),
    [sym_true] = ACTIONS(795),
    [sym_false] = ACTIONS(795),
    [sym_null] = ACTIONS(795),
    [sym_inf] = ACTIONS(795),
    [sym_nan] = ACTIONS(795),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(795),
    [sym_dot_dot_i] = ACTIONS(797),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(765),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(765),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_close_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
  },
  [56] = {
    [sym_function_definition] = STATE(921),
    [sym_if_statement] = STATE(921),
    [sym_for_statement] = STATE(921),
    [sym_while_statement] = STATE(921),
    [sym_repeat_statement] = STATE(921),
    [sym_braced_expression] = STATE(921),
    [sym_parenthesized_expression] = STATE(921),
    [sym_call] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_unary_operator] = STATE(921),
    [sym_binary_operator] = STATE(921),
    [sym_extract_operator] = STATE(921),
    [sym_namespace_operator] = STATE(921),
    [sym_integer] = STATE(921),
    [sym_complex] = STATE(921),
    [sym_float] = STATE(921),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [sym__close_brace] = STATE(2408),
    [aux_sym_braced_expression_repeat1] = STATE(98),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(658),
    [sym_next] = ACTIONS(658),
    [sym_break] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_null] = ACTIONS(658),
    [sym_inf] = ACTIONS(658),
    [sym_nan] = ACTIONS(658),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(658),
    [sym_dot_dot_i] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(664),
    [sym__semicolon] = ACTIONS(664),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(799),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [57] = {
    [sym_function_definition] = STATE(917),
    [sym_if_statement] = STATE(917),
    [sym_for_statement] = STATE(917),
    [sym_while_statement] = STATE(917),
    [sym_repeat_statement] = STATE(917),
    [sym_braced_expression] = STATE(917),
    [sym_parenthesized_expression] = STATE(917),
    [sym_call] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_unary_operator] = STATE(917),
    [sym_binary_operator] = STATE(917),
    [sym_extract_operator] = STATE(917),
    [sym_namespace_operator] = STATE(917),
    [sym_integer] = STATE(917),
    [sym_complex] = STATE(917),
    [sym_float] = STATE(917),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__close_parenthesis] = STATE(2416),
    [sym__open_brace] = STATE(59),
    [aux_sym_parenthesized_expression_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(305),
    [sym_next] = ACTIONS(305),
    [sym_break] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_null] = ACTIONS(305),
    [sym_inf] = ACTIONS(305),
    [sym_nan] = ACTIONS(305),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(305),
    [sym_dot_dot_i] = ACTIONS(309),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(311),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(801),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_close_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [58] = {
    [sym_function_definition] = STATE(575),
    [sym_if_statement] = STATE(575),
    [sym_for_statement] = STATE(575),
    [sym_while_statement] = STATE(575),
    [sym_repeat_statement] = STATE(575),
    [sym_braced_expression] = STATE(575),
    [sym_parenthesized_expression] = STATE(575),
    [sym_call] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_unary_operator] = STATE(575),
    [sym_binary_operator] = STATE(575),
    [sym_extract_operator] = STATE(575),
    [sym_namespace_operator] = STATE(575),
    [sym_integer] = STATE(575),
    [sym_complex] = STATE(575),
    [sym_float] = STATE(575),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_parenthesized_expression_repeat1] = STATE(58),
    [ts_builtin_sym_end] = ACTIONS(803),
    [sym_identifier] = ACTIONS(805),
    [anon_sym_BSLASH] = ACTIONS(808),
    [anon_sym_function] = ACTIONS(811),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(816),
    [anon_sym_for] = ACTIONS(819),
    [anon_sym_while] = ACTIONS(822),
    [anon_sym_repeat] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(828),
    [anon_sym_TILDE] = ACTIONS(831),
    [anon_sym_BANG] = ACTIONS(834),
    [anon_sym_PLUS] = ACTIONS(837),
    [anon_sym_DASH] = ACTIONS(840),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(843),
    [sym__number_literal] = ACTIONS(846),
    [anon_sym_SQUOTE] = ACTIONS(849),
    [anon_sym_DQUOTE] = ACTIONS(852),
    [sym_return] = ACTIONS(855),
    [sym_next] = ACTIONS(855),
    [sym_break] = ACTIONS(855),
    [sym_true] = ACTIONS(855),
    [sym_false] = ACTIONS(855),
    [sym_null] = ACTIONS(855),
    [sym_inf] = ACTIONS(855),
    [sym_nan] = ACTIONS(855),
    [anon_sym_NA] = ACTIONS(858),
    [anon_sym_NA_integer_] = ACTIONS(858),
    [anon_sym_NA_real_] = ACTIONS(858),
    [anon_sym_NA_complex_] = ACTIONS(858),
    [anon_sym_NA_character_] = ACTIONS(858),
    [sym_dots] = ACTIONS(855),
    [sym_dot_dot_i] = ACTIONS(861),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(864),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(867),
    [sym__external_else] = ACTIONS(803),
    [sym__external_open_parenthesis] = ACTIONS(870),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(873),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
  },
  [59] = {
    [sym_function_definition] = STATE(770),
    [sym_if_statement] = STATE(770),
    [sym_for_statement] = STATE(770),
    [sym_while_statement] = STATE(770),
    [sym_repeat_statement] = STATE(770),
    [sym_braced_expression] = STATE(770),
    [sym_parenthesized_expression] = STATE(770),
    [sym_call] = STATE(770),
    [sym_subset] = STATE(770),
    [sym_subset2] = STATE(770),
    [sym_unary_operator] = STATE(770),
    [sym_binary_operator] = STATE(770),
    [sym_extract_operator] = STATE(770),
    [sym_namespace_operator] = STATE(770),
    [sym_integer] = STATE(770),
    [sym_complex] = STATE(770),
    [sym_float] = STATE(770),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(770),
    [sym__expression] = STATE(770),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [sym__close_brace] = STATE(2427),
    [aux_sym_braced_expression_repeat1] = STATE(93),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(876),
    [sym_next] = ACTIONS(876),
    [sym_break] = ACTIONS(876),
    [sym_true] = ACTIONS(876),
    [sym_false] = ACTIONS(876),
    [sym_null] = ACTIONS(876),
    [sym_inf] = ACTIONS(876),
    [sym_nan] = ACTIONS(876),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(876),
    [sym_dot_dot_i] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(880),
    [sym__semicolon] = ACTIONS(880),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(882),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [60] = {
    [sym_function_definition] = STATE(589),
    [sym_if_statement] = STATE(589),
    [sym_for_statement] = STATE(589),
    [sym_while_statement] = STATE(589),
    [sym_repeat_statement] = STATE(589),
    [sym_braced_expression] = STATE(589),
    [sym_parenthesized_expression] = STATE(589),
    [sym_call] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_unary_operator] = STATE(589),
    [sym_binary_operator] = STATE(589),
    [sym_extract_operator] = STATE(589),
    [sym_namespace_operator] = STATE(589),
    [sym_integer] = STATE(589),
    [sym_complex] = STATE(589),
    [sym_float] = STATE(589),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(884),
    [sym_next] = ACTIONS(884),
    [sym_break] = ACTIONS(884),
    [sym_true] = ACTIONS(884),
    [sym_false] = ACTIONS(884),
    [sym_null] = ACTIONS(884),
    [sym_inf] = ACTIONS(884),
    [sym_nan] = ACTIONS(884),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(884),
    [sym_dot_dot_i] = ACTIONS(886),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(757),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_close_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
  },
  [61] = {
    [sym_function_definition] = STATE(770),
    [sym_if_statement] = STATE(770),
    [sym_for_statement] = STATE(770),
    [sym_while_statement] = STATE(770),
    [sym_repeat_statement] = STATE(770),
    [sym_braced_expression] = STATE(770),
    [sym_parenthesized_expression] = STATE(770),
    [sym_call] = STATE(770),
    [sym_subset] = STATE(770),
    [sym_subset2] = STATE(770),
    [sym_unary_operator] = STATE(770),
    [sym_binary_operator] = STATE(770),
    [sym_extract_operator] = STATE(770),
    [sym_namespace_operator] = STATE(770),
    [sym_integer] = STATE(770),
    [sym_complex] = STATE(770),
    [sym_float] = STATE(770),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(770),
    [sym__expression] = STATE(770),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [sym__close_brace] = STATE(2760),
    [aux_sym_braced_expression_repeat1] = STATE(110),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(876),
    [sym_next] = ACTIONS(876),
    [sym_break] = ACTIONS(876),
    [sym_true] = ACTIONS(876),
    [sym_false] = ACTIONS(876),
    [sym_null] = ACTIONS(876),
    [sym_inf] = ACTIONS(876),
    [sym_nan] = ACTIONS(876),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(876),
    [sym_dot_dot_i] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(880),
    [sym__semicolon] = ACTIONS(880),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(888),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [62] = {
    [sym_function_definition] = STATE(935),
    [sym_if_statement] = STATE(935),
    [sym_for_statement] = STATE(935),
    [sym_while_statement] = STATE(935),
    [sym_repeat_statement] = STATE(935),
    [sym_braced_expression] = STATE(935),
    [sym_parenthesized_expression] = STATE(935),
    [sym_call] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_unary_operator] = STATE(935),
    [sym_binary_operator] = STATE(935),
    [sym_extract_operator] = STATE(935),
    [sym_namespace_operator] = STATE(935),
    [sym_integer] = STATE(935),
    [sym_complex] = STATE(935),
    [sym_float] = STATE(935),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__close_parenthesis] = STATE(2708),
    [sym__open_brace] = STATE(56),
    [aux_sym_parenthesized_expression_repeat1] = STATE(138),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(747),
    [sym_next] = ACTIONS(747),
    [sym_break] = ACTIONS(747),
    [sym_true] = ACTIONS(747),
    [sym_false] = ACTIONS(747),
    [sym_null] = ACTIONS(747),
    [sym_inf] = ACTIONS(747),
    [sym_nan] = ACTIONS(747),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(747),
    [sym_dot_dot_i] = ACTIONS(749),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(751),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(890),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
    [sym__external_close_bracket2] = ACTIONS(211),
  },
  [63] = {
    [sym_function_definition] = STATE(796),
    [sym_if_statement] = STATE(796),
    [sym_for_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_repeat_statement] = STATE(796),
    [sym_braced_expression] = STATE(796),
    [sym_parenthesized_expression] = STATE(796),
    [sym_call] = STATE(796),
    [sym_subset] = STATE(796),
    [sym_subset2] = STATE(796),
    [sym_unary_operator] = STATE(796),
    [sym_binary_operator] = STATE(796),
    [sym_extract_operator] = STATE(796),
    [sym_namespace_operator] = STATE(796),
    [sym_integer] = STATE(796),
    [sym_complex] = STATE(796),
    [sym_float] = STATE(796),
    [sym__hex_literal] = STATE(2206),
    [sym__float_literal] = STATE(2206),
    [sym_string] = STATE(2166),
    [sym__single_quoted_string] = STATE(2200),
    [sym__double_quoted_string] = STATE(2201),
    [sym_na] = STATE(796),
    [sym__expression] = STATE(796),
    [sym__string_or_identifier] = STATE(5154),
    [sym__open_parenthesis] = STATE(3),
    [sym__open_brace] = STATE(45),
    [sym__close_brace] = STATE(2896),
    [aux_sym_braced_expression_repeat1] = STATE(34),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_BSLASH] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(505),
    [sym__number_literal] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(515),
    [anon_sym_NA_integer_] = ACTIONS(515),
    [anon_sym_NA_real_] = ACTIONS(515),
    [anon_sym_NA_complex_] = ACTIONS(515),
    [anon_sym_NA_character_] = ACTIONS(515),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(517),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(521),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(525),
    [sym__external_close_brace] = ACTIONS(892),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [64] = {
    [sym_function_definition] = STATE(575),
    [sym_if_statement] = STATE(575),
    [sym_for_statement] = STATE(575),
    [sym_while_statement] = STATE(575),
    [sym_repeat_statement] = STATE(575),
    [sym_braced_expression] = STATE(575),
    [sym_parenthesized_expression] = STATE(575),
    [sym_call] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_unary_operator] = STATE(575),
    [sym_binary_operator] = STATE(575),
    [sym_extract_operator] = STATE(575),
    [sym_namespace_operator] = STATE(575),
    [sym_integer] = STATE(575),
    [sym_complex] = STATE(575),
    [sym_float] = STATE(575),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__close_parenthesis] = STATE(2581),
    [sym__open_brace] = STATE(4),
    [aux_sym_parenthesized_expression_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(251),
    [sym_next] = ACTIONS(251),
    [sym_break] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_null] = ACTIONS(251),
    [sym_inf] = ACTIONS(251),
    [sym_nan] = ACTIONS(251),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(251),
    [sym_dot_dot_i] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(255),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(894),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [65] = {
    [sym_function_definition] = STATE(603),
    [sym_if_statement] = STATE(603),
    [sym_for_statement] = STATE(603),
    [sym_while_statement] = STATE(603),
    [sym_repeat_statement] = STATE(603),
    [sym_braced_expression] = STATE(603),
    [sym_parenthesized_expression] = STATE(603),
    [sym_call] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_unary_operator] = STATE(603),
    [sym_binary_operator] = STATE(603),
    [sym_extract_operator] = STATE(603),
    [sym_namespace_operator] = STATE(603),
    [sym_integer] = STATE(603),
    [sym_complex] = STATE(603),
    [sym_float] = STATE(603),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(531),
    [anon_sym_LT_LT_DASH] = ACTIONS(531),
    [anon_sym_COLON_EQ] = ACTIONS(531),
    [anon_sym_DASH_GT] = ACTIONS(533),
    [anon_sym_DASH_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [aux_sym_binary_operator_token1] = ACTIONS(531),
    [anon_sym_PIPE_GT] = ACTIONS(531),
    [anon_sym_COLON] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(896),
    [sym_next] = ACTIONS(896),
    [sym_break] = ACTIONS(896),
    [sym_true] = ACTIONS(896),
    [sym_false] = ACTIONS(896),
    [sym_null] = ACTIONS(896),
    [sym_inf] = ACTIONS(896),
    [sym_nan] = ACTIONS(896),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(896),
    [sym_dot_dot_i] = ACTIONS(898),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(900),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(531),
    [sym__external_close_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(531),
  },
  [66] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [aux_sym_braced_expression_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(591),
    [sym_identifier] = ACTIONS(902),
    [anon_sym_BSLASH] = ACTIONS(905),
    [anon_sym_function] = ACTIONS(908),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(911),
    [anon_sym_for] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(917),
    [anon_sym_repeat] = ACTIONS(920),
    [anon_sym_QMARK] = ACTIONS(923),
    [anon_sym_TILDE] = ACTIONS(926),
    [anon_sym_BANG] = ACTIONS(929),
    [anon_sym_PLUS] = ACTIONS(932),
    [anon_sym_DASH] = ACTIONS(935),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(938),
    [sym__number_literal] = ACTIONS(941),
    [anon_sym_SQUOTE] = ACTIONS(944),
    [anon_sym_DQUOTE] = ACTIONS(947),
    [sym_return] = ACTIONS(950),
    [sym_next] = ACTIONS(950),
    [sym_break] = ACTIONS(950),
    [sym_true] = ACTIONS(950),
    [sym_false] = ACTIONS(950),
    [sym_null] = ACTIONS(950),
    [sym_inf] = ACTIONS(950),
    [sym_nan] = ACTIONS(950),
    [anon_sym_NA] = ACTIONS(953),
    [anon_sym_NA_integer_] = ACTIONS(953),
    [anon_sym_NA_real_] = ACTIONS(953),
    [anon_sym_NA_complex_] = ACTIONS(953),
    [anon_sym_NA_character_] = ACTIONS(953),
    [sym_dots] = ACTIONS(950),
    [sym_dot_dot_i] = ACTIONS(956),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(959),
    [sym__semicolon] = ACTIONS(959),
    [sym__raw_string_literal] = ACTIONS(962),
    [sym__external_else] = ACTIONS(591),
    [sym__external_open_parenthesis] = ACTIONS(965),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(968),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
  },
  [67] = {
    [sym_function_definition] = STATE(791),
    [sym_if_statement] = STATE(791),
    [sym_for_statement] = STATE(791),
    [sym_while_statement] = STATE(791),
    [sym_repeat_statement] = STATE(791),
    [sym_braced_expression] = STATE(791),
    [sym_parenthesized_expression] = STATE(791),
    [sym_call] = STATE(791),
    [sym_subset] = STATE(791),
    [sym_subset2] = STATE(791),
    [sym_unary_operator] = STATE(791),
    [sym_binary_operator] = STATE(791),
    [sym_extract_operator] = STATE(791),
    [sym_namespace_operator] = STATE(791),
    [sym_integer] = STATE(791),
    [sym_complex] = STATE(791),
    [sym_float] = STATE(791),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(791),
    [sym__expression] = STATE(791),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__close_parenthesis] = STATE(2493),
    [sym__open_brace] = STATE(24),
    [aux_sym_parenthesized_expression_repeat1] = STATE(84),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(971),
    [sym_next] = ACTIONS(971),
    [sym_break] = ACTIONS(971),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_inf] = ACTIONS(971),
    [sym_nan] = ACTIONS(971),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(971),
    [sym_dot_dot_i] = ACTIONS(973),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(975),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(977),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [68] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [sym__close_brace] = STATE(2469),
    [aux_sym_braced_expression_repeat1] = STATE(145),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(353),
    [sym_next] = ACTIONS(353),
    [sym_break] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_null] = ACTIONS(353),
    [sym_inf] = ACTIONS(353),
    [sym_nan] = ACTIONS(353),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(353),
    [sym_dot_dot_i] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(359),
    [sym__semicolon] = ACTIONS(359),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(979),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [69] = {
    [sym_function_definition] = STATE(917),
    [sym_if_statement] = STATE(917),
    [sym_for_statement] = STATE(917),
    [sym_while_statement] = STATE(917),
    [sym_repeat_statement] = STATE(917),
    [sym_braced_expression] = STATE(917),
    [sym_parenthesized_expression] = STATE(917),
    [sym_call] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_unary_operator] = STATE(917),
    [sym_binary_operator] = STATE(917),
    [sym_extract_operator] = STATE(917),
    [sym_namespace_operator] = STATE(917),
    [sym_integer] = STATE(917),
    [sym_complex] = STATE(917),
    [sym_float] = STATE(917),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__close_parenthesis] = STATE(2596),
    [sym__open_brace] = STATE(59),
    [aux_sym_parenthesized_expression_repeat1] = STATE(123),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(305),
    [sym_next] = ACTIONS(305),
    [sym_break] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_null] = ACTIONS(305),
    [sym_inf] = ACTIONS(305),
    [sym_nan] = ACTIONS(305),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(305),
    [sym_dot_dot_i] = ACTIONS(309),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(311),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(981),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_close_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [70] = {
    [sym_function_definition] = STATE(770),
    [sym_if_statement] = STATE(770),
    [sym_for_statement] = STATE(770),
    [sym_while_statement] = STATE(770),
    [sym_repeat_statement] = STATE(770),
    [sym_braced_expression] = STATE(770),
    [sym_parenthesized_expression] = STATE(770),
    [sym_call] = STATE(770),
    [sym_subset] = STATE(770),
    [sym_subset2] = STATE(770),
    [sym_unary_operator] = STATE(770),
    [sym_binary_operator] = STATE(770),
    [sym_extract_operator] = STATE(770),
    [sym_namespace_operator] = STATE(770),
    [sym_integer] = STATE(770),
    [sym_complex] = STATE(770),
    [sym_float] = STATE(770),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(770),
    [sym__expression] = STATE(770),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [sym__close_brace] = STATE(2771),
    [aux_sym_braced_expression_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(876),
    [sym_next] = ACTIONS(876),
    [sym_break] = ACTIONS(876),
    [sym_true] = ACTIONS(876),
    [sym_false] = ACTIONS(876),
    [sym_null] = ACTIONS(876),
    [sym_inf] = ACTIONS(876),
    [sym_nan] = ACTIONS(876),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(876),
    [sym_dot_dot_i] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(880),
    [sym__semicolon] = ACTIONS(880),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(983),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [71] = {
    [sym_function_definition] = STATE(563),
    [sym_if_statement] = STATE(563),
    [sym_for_statement] = STATE(563),
    [sym_while_statement] = STATE(563),
    [sym_repeat_statement] = STATE(563),
    [sym_braced_expression] = STATE(563),
    [sym_parenthesized_expression] = STATE(563),
    [sym_call] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_unary_operator] = STATE(563),
    [sym_binary_operator] = STATE(563),
    [sym_extract_operator] = STATE(563),
    [sym_namespace_operator] = STATE(563),
    [sym_integer] = STATE(563),
    [sym_complex] = STATE(563),
    [sym_float] = STATE(563),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(985),
    [sym_next] = ACTIONS(985),
    [sym_break] = ACTIONS(985),
    [sym_true] = ACTIONS(985),
    [sym_false] = ACTIONS(985),
    [sym_null] = ACTIONS(985),
    [sym_inf] = ACTIONS(985),
    [sym_nan] = ACTIONS(985),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(985),
    [sym_dot_dot_i] = ACTIONS(987),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [72] = {
    [sym_function_definition] = STATE(664),
    [sym_if_statement] = STATE(664),
    [sym_for_statement] = STATE(664),
    [sym_while_statement] = STATE(664),
    [sym_repeat_statement] = STATE(664),
    [sym_braced_expression] = STATE(664),
    [sym_parenthesized_expression] = STATE(664),
    [sym_call] = STATE(664),
    [sym_subset] = STATE(664),
    [sym_subset2] = STATE(664),
    [sym_unary_operator] = STATE(664),
    [sym_binary_operator] = STATE(664),
    [sym_extract_operator] = STATE(664),
    [sym_namespace_operator] = STATE(664),
    [sym_integer] = STATE(664),
    [sym_complex] = STATE(664),
    [sym_float] = STATE(664),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(664),
    [sym__expression] = STATE(664),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(471),
    [anon_sym_LT_LT_DASH] = ACTIONS(471),
    [anon_sym_COLON_EQ] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_GT] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(471),
    [aux_sym_binary_operator_token1] = ACTIONS(471),
    [anon_sym_PIPE_GT] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(471),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(989),
    [sym_next] = ACTIONS(989),
    [sym_break] = ACTIONS(989),
    [sym_true] = ACTIONS(989),
    [sym_false] = ACTIONS(989),
    [sym_null] = ACTIONS(989),
    [sym_inf] = ACTIONS(989),
    [sym_nan] = ACTIONS(989),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(989),
    [sym_dot_dot_i] = ACTIONS(991),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(471),
    [sym__newline] = ACTIONS(471),
    [sym__semicolon] = ACTIONS(471),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(471),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(471),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(471),
    [sym__external_open_bracket] = ACTIONS(471),
    [sym__external_open_bracket2] = ACTIONS(471),
    [sym__external_close_bracket2] = ACTIONS(471),
  },
  [73] = {
    [sym_function_definition] = STATE(605),
    [sym_if_statement] = STATE(605),
    [sym_for_statement] = STATE(605),
    [sym_while_statement] = STATE(605),
    [sym_repeat_statement] = STATE(605),
    [sym_braced_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_call] = STATE(605),
    [sym_subset] = STATE(605),
    [sym_subset2] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_binary_operator] = STATE(605),
    [sym_extract_operator] = STATE(605),
    [sym_namespace_operator] = STATE(605),
    [sym_integer] = STATE(605),
    [sym_complex] = STATE(605),
    [sym_float] = STATE(605),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(605),
    [sym__expression] = STATE(605),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(96),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(377),
    [anon_sym_LT_LT_DASH] = ACTIONS(377),
    [anon_sym_COLON_EQ] = ACTIONS(377),
    [anon_sym_DASH_GT] = ACTIONS(379),
    [anon_sym_DASH_GT_GT] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(377),
    [anon_sym_LT] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(377),
    [anon_sym_BANG_EQ] = ACTIONS(377),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_STAR_STAR] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [aux_sym_binary_operator_token1] = ACTIONS(377),
    [anon_sym_PIPE_GT] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(377),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(993),
    [sym_next] = ACTIONS(993),
    [sym_break] = ACTIONS(993),
    [sym_true] = ACTIONS(993),
    [sym_false] = ACTIONS(993),
    [sym_null] = ACTIONS(993),
    [sym_inf] = ACTIONS(993),
    [sym_nan] = ACTIONS(993),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(993),
    [sym_dot_dot_i] = ACTIONS(995),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(377),
    [sym__newline] = ACTIONS(997),
    [sym__semicolon] = ACTIONS(377),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(377),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(377),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(377),
    [sym__external_open_bracket] = ACTIONS(377),
    [sym__external_close_bracket] = ACTIONS(377),
    [sym__external_open_bracket2] = ACTIONS(377),
  },
  [74] = {
    [sym_function_definition] = STATE(921),
    [sym_if_statement] = STATE(921),
    [sym_for_statement] = STATE(921),
    [sym_while_statement] = STATE(921),
    [sym_repeat_statement] = STATE(921),
    [sym_braced_expression] = STATE(921),
    [sym_parenthesized_expression] = STATE(921),
    [sym_call] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_unary_operator] = STATE(921),
    [sym_binary_operator] = STATE(921),
    [sym_extract_operator] = STATE(921),
    [sym_namespace_operator] = STATE(921),
    [sym_integer] = STATE(921),
    [sym_complex] = STATE(921),
    [sym_float] = STATE(921),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [sym__close_brace] = STATE(2908),
    [aux_sym_braced_expression_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(658),
    [sym_next] = ACTIONS(658),
    [sym_break] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_null] = ACTIONS(658),
    [sym_inf] = ACTIONS(658),
    [sym_nan] = ACTIONS(658),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(658),
    [sym_dot_dot_i] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(664),
    [sym__semicolon] = ACTIONS(664),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(999),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [75] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2692),
    [aux_sym_braced_expression_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(1001),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [76] = {
    [sym_function_definition] = STATE(935),
    [sym_if_statement] = STATE(935),
    [sym_for_statement] = STATE(935),
    [sym_while_statement] = STATE(935),
    [sym_repeat_statement] = STATE(935),
    [sym_braced_expression] = STATE(935),
    [sym_parenthesized_expression] = STATE(935),
    [sym_call] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_unary_operator] = STATE(935),
    [sym_binary_operator] = STATE(935),
    [sym_extract_operator] = STATE(935),
    [sym_namespace_operator] = STATE(935),
    [sym_integer] = STATE(935),
    [sym_complex] = STATE(935),
    [sym_float] = STATE(935),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__close_parenthesis] = STATE(2659),
    [sym__open_brace] = STATE(56),
    [aux_sym_parenthesized_expression_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(747),
    [sym_next] = ACTIONS(747),
    [sym_break] = ACTIONS(747),
    [sym_true] = ACTIONS(747),
    [sym_false] = ACTIONS(747),
    [sym_null] = ACTIONS(747),
    [sym_inf] = ACTIONS(747),
    [sym_nan] = ACTIONS(747),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(747),
    [sym_dot_dot_i] = ACTIONS(749),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(751),
    [sym__semicolon] = ACTIONS(129),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(1003),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(129),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
    [sym__external_close_bracket2] = ACTIONS(129),
  },
  [77] = {
    [sym_function_definition] = STATE(620),
    [sym_if_statement] = STATE(620),
    [sym_for_statement] = STATE(620),
    [sym_while_statement] = STATE(620),
    [sym_repeat_statement] = STATE(620),
    [sym_braced_expression] = STATE(620),
    [sym_parenthesized_expression] = STATE(620),
    [sym_call] = STATE(620),
    [sym_subset] = STATE(620),
    [sym_subset2] = STATE(620),
    [sym_unary_operator] = STATE(620),
    [sym_binary_operator] = STATE(620),
    [sym_extract_operator] = STATE(620),
    [sym_namespace_operator] = STATE(620),
    [sym_integer] = STATE(620),
    [sym_complex] = STATE(620),
    [sym_float] = STATE(620),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(620),
    [sym__expression] = STATE(620),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(87),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(545),
    [anon_sym_LT_LT_DASH] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(543),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [aux_sym_binary_operator_token1] = ACTIONS(545),
    [anon_sym_PIPE_GT] = ACTIONS(545),
    [anon_sym_COLON] = ACTIONS(543),
    [anon_sym_DOLLAR] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(545),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1005),
    [sym_next] = ACTIONS(1005),
    [sym_break] = ACTIONS(1005),
    [sym_true] = ACTIONS(1005),
    [sym_false] = ACTIONS(1005),
    [sym_null] = ACTIONS(1005),
    [sym_inf] = ACTIONS(1005),
    [sym_nan] = ACTIONS(1005),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1005),
    [sym_dot_dot_i] = ACTIONS(1007),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(1009),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(545),
    [sym__external_close_bracket2] = ACTIONS(545),
  },
  [78] = {
    [sym_function_definition] = STATE(653),
    [sym_if_statement] = STATE(653),
    [sym_for_statement] = STATE(653),
    [sym_while_statement] = STATE(653),
    [sym_repeat_statement] = STATE(653),
    [sym_braced_expression] = STATE(653),
    [sym_parenthesized_expression] = STATE(653),
    [sym_call] = STATE(653),
    [sym_subset] = STATE(653),
    [sym_subset2] = STATE(653),
    [sym_unary_operator] = STATE(653),
    [sym_binary_operator] = STATE(653),
    [sym_extract_operator] = STATE(653),
    [sym_namespace_operator] = STATE(653),
    [sym_integer] = STATE(653),
    [sym_complex] = STATE(653),
    [sym_float] = STATE(653),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(653),
    [sym__expression] = STATE(653),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(90),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(531),
    [anon_sym_LT_LT_DASH] = ACTIONS(531),
    [anon_sym_COLON_EQ] = ACTIONS(531),
    [anon_sym_DASH_GT] = ACTIONS(533),
    [anon_sym_DASH_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [aux_sym_binary_operator_token1] = ACTIONS(531),
    [anon_sym_PIPE_GT] = ACTIONS(531),
    [anon_sym_COLON] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1011),
    [sym_next] = ACTIONS(1011),
    [sym_break] = ACTIONS(1011),
    [sym_true] = ACTIONS(1011),
    [sym_false] = ACTIONS(1011),
    [sym_null] = ACTIONS(1011),
    [sym_inf] = ACTIONS(1011),
    [sym_nan] = ACTIONS(1011),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1011),
    [sym_dot_dot_i] = ACTIONS(1013),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(1015),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(531),
    [sym__external_close_bracket2] = ACTIONS(531),
  },
  [79] = {
    [sym_function_definition] = STATE(662),
    [sym_if_statement] = STATE(662),
    [sym_for_statement] = STATE(662),
    [sym_while_statement] = STATE(662),
    [sym_repeat_statement] = STATE(662),
    [sym_braced_expression] = STATE(662),
    [sym_parenthesized_expression] = STATE(662),
    [sym_call] = STATE(662),
    [sym_subset] = STATE(662),
    [sym_subset2] = STATE(662),
    [sym_unary_operator] = STATE(662),
    [sym_binary_operator] = STATE(662),
    [sym_extract_operator] = STATE(662),
    [sym_namespace_operator] = STATE(662),
    [sym_integer] = STATE(662),
    [sym_complex] = STATE(662),
    [sym_float] = STATE(662),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(662),
    [sym__expression] = STATE(662),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(461),
    [anon_sym_LT_LT_DASH] = ACTIONS(461),
    [anon_sym_COLON_EQ] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_DASH_GT_GT] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [aux_sym_binary_operator_token1] = ACTIONS(461),
    [anon_sym_PIPE_GT] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_DOLLAR] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(461),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1017),
    [sym_next] = ACTIONS(1017),
    [sym_break] = ACTIONS(1017),
    [sym_true] = ACTIONS(1017),
    [sym_false] = ACTIONS(1017),
    [sym_null] = ACTIONS(1017),
    [sym_inf] = ACTIONS(1017),
    [sym_nan] = ACTIONS(1017),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1017),
    [sym_dot_dot_i] = ACTIONS(1019),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(1021),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(461),
    [sym__external_close_bracket2] = ACTIONS(461),
  },
  [80] = {
    [sym_function_definition] = STATE(615),
    [sym_if_statement] = STATE(615),
    [sym_for_statement] = STATE(615),
    [sym_while_statement] = STATE(615),
    [sym_repeat_statement] = STATE(615),
    [sym_braced_expression] = STATE(615),
    [sym_parenthesized_expression] = STATE(615),
    [sym_call] = STATE(615),
    [sym_subset] = STATE(615),
    [sym_subset2] = STATE(615),
    [sym_unary_operator] = STATE(615),
    [sym_binary_operator] = STATE(615),
    [sym_extract_operator] = STATE(615),
    [sym_namespace_operator] = STATE(615),
    [sym_integer] = STATE(615),
    [sym_complex] = STATE(615),
    [sym_float] = STATE(615),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(615),
    [sym__expression] = STATE(615),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(99),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_COLON_EQ] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_DASH_GT_GT] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_STAR_STAR] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(263),
    [aux_sym_binary_operator_token1] = ACTIONS(263),
    [anon_sym_PIPE_GT] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1023),
    [sym_next] = ACTIONS(1023),
    [sym_break] = ACTIONS(1023),
    [sym_true] = ACTIONS(1023),
    [sym_false] = ACTIONS(1023),
    [sym_null] = ACTIONS(1023),
    [sym_inf] = ACTIONS(1023),
    [sym_nan] = ACTIONS(1023),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1023),
    [sym_dot_dot_i] = ACTIONS(1025),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(263),
    [sym__newline] = ACTIONS(1027),
    [sym__semicolon] = ACTIONS(263),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(263),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(263),
    [sym__external_open_bracket] = ACTIONS(263),
    [sym__external_open_bracket2] = ACTIONS(263),
    [sym__external_close_bracket2] = ACTIONS(263),
  },
  [81] = {
    [sym_function_definition] = STATE(661),
    [sym_if_statement] = STATE(661),
    [sym_for_statement] = STATE(661),
    [sym_while_statement] = STATE(661),
    [sym_repeat_statement] = STATE(661),
    [sym_braced_expression] = STATE(661),
    [sym_parenthesized_expression] = STATE(661),
    [sym_call] = STATE(661),
    [sym_subset] = STATE(661),
    [sym_subset2] = STATE(661),
    [sym_unary_operator] = STATE(661),
    [sym_binary_operator] = STATE(661),
    [sym_extract_operator] = STATE(661),
    [sym_namespace_operator] = STATE(661),
    [sym_integer] = STATE(661),
    [sym_complex] = STATE(661),
    [sym_float] = STATE(661),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(661),
    [sym__expression] = STATE(661),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [anon_sym_LT_LT_DASH] = ACTIONS(453),
    [anon_sym_COLON_EQ] = ACTIONS(453),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(453),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [aux_sym_binary_operator_token1] = ACTIONS(453),
    [anon_sym_PIPE_GT] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(453),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1029),
    [sym_next] = ACTIONS(1029),
    [sym_break] = ACTIONS(1029),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [sym_null] = ACTIONS(1029),
    [sym_inf] = ACTIONS(1029),
    [sym_nan] = ACTIONS(1029),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1029),
    [sym_dot_dot_i] = ACTIONS(1031),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(453),
    [sym__external_close_bracket2] = ACTIONS(453),
  },
  [82] = {
    [sym_function_definition] = STATE(612),
    [sym_if_statement] = STATE(612),
    [sym_for_statement] = STATE(612),
    [sym_while_statement] = STATE(612),
    [sym_repeat_statement] = STATE(612),
    [sym_braced_expression] = STATE(612),
    [sym_parenthesized_expression] = STATE(612),
    [sym_call] = STATE(612),
    [sym_subset] = STATE(612),
    [sym_subset2] = STATE(612),
    [sym_unary_operator] = STATE(612),
    [sym_binary_operator] = STATE(612),
    [sym_extract_operator] = STATE(612),
    [sym_namespace_operator] = STATE(612),
    [sym_integer] = STATE(612),
    [sym_complex] = STATE(612),
    [sym_float] = STATE(612),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(612),
    [sym__expression] = STATE(612),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(91),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(461),
    [anon_sym_LT_LT_DASH] = ACTIONS(461),
    [anon_sym_COLON_EQ] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_DASH_GT_GT] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [aux_sym_binary_operator_token1] = ACTIONS(461),
    [anon_sym_PIPE_GT] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_DOLLAR] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(461),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(1033),
    [sym_next] = ACTIONS(1033),
    [sym_break] = ACTIONS(1033),
    [sym_true] = ACTIONS(1033),
    [sym_false] = ACTIONS(1033),
    [sym_null] = ACTIONS(1033),
    [sym_inf] = ACTIONS(1033),
    [sym_nan] = ACTIONS(1033),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(1033),
    [sym_dot_dot_i] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(1037),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(461),
    [sym__external_close_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(461),
  },
  [83] = {
    [sym_function_definition] = STATE(506),
    [sym_if_statement] = STATE(506),
    [sym_for_statement] = STATE(506),
    [sym_while_statement] = STATE(506),
    [sym_repeat_statement] = STATE(506),
    [sym_braced_expression] = STATE(506),
    [sym_parenthesized_expression] = STATE(506),
    [sym_call] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_unary_operator] = STATE(506),
    [sym_binary_operator] = STATE(506),
    [sym_extract_operator] = STATE(506),
    [sym_namespace_operator] = STATE(506),
    [sym_integer] = STATE(506),
    [sym_complex] = STATE(506),
    [sym_float] = STATE(506),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_parenthesized_expression_repeat1] = STATE(83),
    [sym_identifier] = ACTIONS(1039),
    [anon_sym_BSLASH] = ACTIONS(1042),
    [anon_sym_function] = ACTIONS(1045),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(1048),
    [anon_sym_for] = ACTIONS(1051),
    [anon_sym_while] = ACTIONS(1054),
    [anon_sym_repeat] = ACTIONS(1057),
    [anon_sym_QMARK] = ACTIONS(1060),
    [anon_sym_TILDE] = ACTIONS(1063),
    [anon_sym_BANG] = ACTIONS(1066),
    [anon_sym_PLUS] = ACTIONS(1069),
    [anon_sym_DASH] = ACTIONS(1072),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(1075),
    [sym__number_literal] = ACTIONS(1078),
    [anon_sym_SQUOTE] = ACTIONS(1081),
    [anon_sym_DQUOTE] = ACTIONS(1084),
    [sym_return] = ACTIONS(1087),
    [sym_next] = ACTIONS(1087),
    [sym_break] = ACTIONS(1087),
    [sym_true] = ACTIONS(1087),
    [sym_false] = ACTIONS(1087),
    [sym_null] = ACTIONS(1087),
    [sym_inf] = ACTIONS(1087),
    [sym_nan] = ACTIONS(1087),
    [anon_sym_NA] = ACTIONS(1090),
    [anon_sym_NA_integer_] = ACTIONS(1090),
    [anon_sym_NA_real_] = ACTIONS(1090),
    [anon_sym_NA_complex_] = ACTIONS(1090),
    [anon_sym_NA_character_] = ACTIONS(1090),
    [sym_dots] = ACTIONS(1087),
    [sym_dot_dot_i] = ACTIONS(1093),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(1096),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(1099),
    [sym__external_else] = ACTIONS(803),
    [sym__external_open_parenthesis] = ACTIONS(1102),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(1105),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_close_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
  },
  [84] = {
    [sym_function_definition] = STATE(791),
    [sym_if_statement] = STATE(791),
    [sym_for_statement] = STATE(791),
    [sym_while_statement] = STATE(791),
    [sym_repeat_statement] = STATE(791),
    [sym_braced_expression] = STATE(791),
    [sym_parenthesized_expression] = STATE(791),
    [sym_call] = STATE(791),
    [sym_subset] = STATE(791),
    [sym_subset2] = STATE(791),
    [sym_unary_operator] = STATE(791),
    [sym_binary_operator] = STATE(791),
    [sym_extract_operator] = STATE(791),
    [sym_namespace_operator] = STATE(791),
    [sym_integer] = STATE(791),
    [sym_complex] = STATE(791),
    [sym_float] = STATE(791),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(791),
    [sym__expression] = STATE(791),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__close_parenthesis] = STATE(2470),
    [sym__open_brace] = STATE(24),
    [aux_sym_parenthesized_expression_repeat1] = STATE(139),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(971),
    [sym_next] = ACTIONS(971),
    [sym_break] = ACTIONS(971),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_inf] = ACTIONS(971),
    [sym_nan] = ACTIONS(971),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(971),
    [sym_dot_dot_i] = ACTIONS(973),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(975),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(1108),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [85] = {
    [sym_function_definition] = STATE(658),
    [sym_if_statement] = STATE(658),
    [sym_for_statement] = STATE(658),
    [sym_while_statement] = STATE(658),
    [sym_repeat_statement] = STATE(658),
    [sym_braced_expression] = STATE(658),
    [sym_parenthesized_expression] = STATE(658),
    [sym_call] = STATE(658),
    [sym_subset] = STATE(658),
    [sym_subset2] = STATE(658),
    [sym_unary_operator] = STATE(658),
    [sym_binary_operator] = STATE(658),
    [sym_extract_operator] = STATE(658),
    [sym_namespace_operator] = STATE(658),
    [sym_integer] = STATE(658),
    [sym_complex] = STATE(658),
    [sym_float] = STATE(658),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(658),
    [sym__expression] = STATE(658),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(397),
    [anon_sym_LT_LT_DASH] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_STAR_STAR] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [aux_sym_binary_operator_token1] = ACTIONS(397),
    [anon_sym_PIPE_GT] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1110),
    [sym_next] = ACTIONS(1110),
    [sym_break] = ACTIONS(1110),
    [sym_true] = ACTIONS(1110),
    [sym_false] = ACTIONS(1110),
    [sym_null] = ACTIONS(1110),
    [sym_inf] = ACTIONS(1110),
    [sym_nan] = ACTIONS(1110),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1110),
    [sym_dot_dot_i] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(397),
    [sym__newline] = ACTIONS(397),
    [sym__semicolon] = ACTIONS(397),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(397),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(397),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(397),
    [sym__external_open_bracket] = ACTIONS(397),
    [sym__external_open_bracket2] = ACTIONS(397),
    [sym__external_close_bracket2] = ACTIONS(397),
  },
  [86] = {
    [sym_function_definition] = STATE(611),
    [sym_if_statement] = STATE(611),
    [sym_for_statement] = STATE(611),
    [sym_while_statement] = STATE(611),
    [sym_repeat_statement] = STATE(611),
    [sym_braced_expression] = STATE(611),
    [sym_parenthesized_expression] = STATE(611),
    [sym_call] = STATE(611),
    [sym_subset] = STATE(611),
    [sym_subset2] = STATE(611),
    [sym_unary_operator] = STATE(611),
    [sym_binary_operator] = STATE(611),
    [sym_extract_operator] = STATE(611),
    [sym_namespace_operator] = STATE(611),
    [sym_integer] = STATE(611),
    [sym_complex] = STATE(611),
    [sym_float] = STATE(611),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(611),
    [sym__expression] = STATE(611),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [anon_sym_LT_LT_DASH] = ACTIONS(453),
    [anon_sym_COLON_EQ] = ACTIONS(453),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(453),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [aux_sym_binary_operator_token1] = ACTIONS(453),
    [anon_sym_PIPE_GT] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(453),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(1114),
    [sym_next] = ACTIONS(1114),
    [sym_break] = ACTIONS(1114),
    [sym_true] = ACTIONS(1114),
    [sym_false] = ACTIONS(1114),
    [sym_null] = ACTIONS(1114),
    [sym_inf] = ACTIONS(1114),
    [sym_nan] = ACTIONS(1114),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(1114),
    [sym_dot_dot_i] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(453),
    [sym__external_close_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(453),
  },
  [87] = {
    [sym_function_definition] = STATE(639),
    [sym_if_statement] = STATE(639),
    [sym_for_statement] = STATE(639),
    [sym_while_statement] = STATE(639),
    [sym_repeat_statement] = STATE(639),
    [sym_braced_expression] = STATE(639),
    [sym_parenthesized_expression] = STATE(639),
    [sym_call] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_unary_operator] = STATE(639),
    [sym_binary_operator] = STATE(639),
    [sym_extract_operator] = STATE(639),
    [sym_namespace_operator] = STATE(639),
    [sym_integer] = STATE(639),
    [sym_complex] = STATE(639),
    [sym_float] = STATE(639),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1118),
    [sym_next] = ACTIONS(1118),
    [sym_break] = ACTIONS(1118),
    [sym_true] = ACTIONS(1118),
    [sym_false] = ACTIONS(1118),
    [sym_null] = ACTIONS(1118),
    [sym_inf] = ACTIONS(1118),
    [sym_nan] = ACTIONS(1118),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1118),
    [sym_dot_dot_i] = ACTIONS(1120),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(757),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
    [sym__external_close_bracket2] = ACTIONS(757),
  },
  [88] = {
    [sym_function_definition] = STATE(657),
    [sym_if_statement] = STATE(657),
    [sym_for_statement] = STATE(657),
    [sym_while_statement] = STATE(657),
    [sym_repeat_statement] = STATE(657),
    [sym_braced_expression] = STATE(657),
    [sym_parenthesized_expression] = STATE(657),
    [sym_call] = STATE(657),
    [sym_subset] = STATE(657),
    [sym_subset2] = STATE(657),
    [sym_unary_operator] = STATE(657),
    [sym_binary_operator] = STATE(657),
    [sym_extract_operator] = STATE(657),
    [sym_namespace_operator] = STATE(657),
    [sym_integer] = STATE(657),
    [sym_complex] = STATE(657),
    [sym_float] = STATE(657),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(657),
    [sym__expression] = STATE(657),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(387),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [aux_sym_binary_operator_token1] = ACTIONS(387),
    [anon_sym_PIPE_GT] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_DOLLAR] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1122),
    [sym_next] = ACTIONS(1122),
    [sym_break] = ACTIONS(1122),
    [sym_true] = ACTIONS(1122),
    [sym_false] = ACTIONS(1122),
    [sym_null] = ACTIONS(1122),
    [sym_inf] = ACTIONS(1122),
    [sym_nan] = ACTIONS(1122),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1122),
    [sym_dot_dot_i] = ACTIONS(1124),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(1126),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(387),
    [sym__external_close_bracket2] = ACTIONS(387),
  },
  [89] = {
    [sym_function_definition] = STATE(655),
    [sym_if_statement] = STATE(655),
    [sym_for_statement] = STATE(655),
    [sym_while_statement] = STATE(655),
    [sym_repeat_statement] = STATE(655),
    [sym_braced_expression] = STATE(655),
    [sym_parenthesized_expression] = STATE(655),
    [sym_call] = STATE(655),
    [sym_subset] = STATE(655),
    [sym_subset2] = STATE(655),
    [sym_unary_operator] = STATE(655),
    [sym_binary_operator] = STATE(655),
    [sym_extract_operator] = STATE(655),
    [sym_namespace_operator] = STATE(655),
    [sym_integer] = STATE(655),
    [sym_complex] = STATE(655),
    [sym_float] = STATE(655),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(655),
    [sym__expression] = STATE(655),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(85),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(377),
    [anon_sym_LT_LT_DASH] = ACTIONS(377),
    [anon_sym_COLON_EQ] = ACTIONS(377),
    [anon_sym_DASH_GT] = ACTIONS(379),
    [anon_sym_DASH_GT_GT] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(377),
    [anon_sym_LT] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(377),
    [anon_sym_BANG_EQ] = ACTIONS(377),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_STAR_STAR] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [aux_sym_binary_operator_token1] = ACTIONS(377),
    [anon_sym_PIPE_GT] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(377),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1128),
    [sym_next] = ACTIONS(1128),
    [sym_break] = ACTIONS(1128),
    [sym_true] = ACTIONS(1128),
    [sym_false] = ACTIONS(1128),
    [sym_null] = ACTIONS(1128),
    [sym_inf] = ACTIONS(1128),
    [sym_nan] = ACTIONS(1128),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1128),
    [sym_dot_dot_i] = ACTIONS(1130),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(377),
    [sym__newline] = ACTIONS(1132),
    [sym__semicolon] = ACTIONS(377),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(377),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(377),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(377),
    [sym__external_open_bracket] = ACTIONS(377),
    [sym__external_open_bracket2] = ACTIONS(377),
    [sym__external_close_bracket2] = ACTIONS(377),
  },
  [90] = {
    [sym_function_definition] = STATE(654),
    [sym_if_statement] = STATE(654),
    [sym_for_statement] = STATE(654),
    [sym_while_statement] = STATE(654),
    [sym_repeat_statement] = STATE(654),
    [sym_braced_expression] = STATE(654),
    [sym_parenthesized_expression] = STATE(654),
    [sym_call] = STATE(654),
    [sym_subset] = STATE(654),
    [sym_subset2] = STATE(654),
    [sym_unary_operator] = STATE(654),
    [sym_binary_operator] = STATE(654),
    [sym_extract_operator] = STATE(654),
    [sym_namespace_operator] = STATE(654),
    [sym_integer] = STATE(654),
    [sym_complex] = STATE(654),
    [sym_float] = STATE(654),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(654),
    [sym__expression] = STATE(654),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1134),
    [sym_next] = ACTIONS(1134),
    [sym_break] = ACTIONS(1134),
    [sym_true] = ACTIONS(1134),
    [sym_false] = ACTIONS(1134),
    [sym_null] = ACTIONS(1134),
    [sym_inf] = ACTIONS(1134),
    [sym_nan] = ACTIONS(1134),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1134),
    [sym_dot_dot_i] = ACTIONS(1136),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [91] = {
    [sym_function_definition] = STATE(614),
    [sym_if_statement] = STATE(614),
    [sym_for_statement] = STATE(614),
    [sym_while_statement] = STATE(614),
    [sym_repeat_statement] = STATE(614),
    [sym_braced_expression] = STATE(614),
    [sym_parenthesized_expression] = STATE(614),
    [sym_call] = STATE(614),
    [sym_subset] = STATE(614),
    [sym_subset2] = STATE(614),
    [sym_unary_operator] = STATE(614),
    [sym_binary_operator] = STATE(614),
    [sym_extract_operator] = STATE(614),
    [sym_namespace_operator] = STATE(614),
    [sym_integer] = STATE(614),
    [sym_complex] = STATE(614),
    [sym_float] = STATE(614),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(614),
    [sym__expression] = STATE(614),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(471),
    [anon_sym_LT_LT_DASH] = ACTIONS(471),
    [anon_sym_COLON_EQ] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_GT] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(471),
    [aux_sym_binary_operator_token1] = ACTIONS(471),
    [anon_sym_PIPE_GT] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(471),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(1138),
    [sym_next] = ACTIONS(1138),
    [sym_break] = ACTIONS(1138),
    [sym_true] = ACTIONS(1138),
    [sym_false] = ACTIONS(1138),
    [sym_null] = ACTIONS(1138),
    [sym_inf] = ACTIONS(1138),
    [sym_nan] = ACTIONS(1138),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(1138),
    [sym_dot_dot_i] = ACTIONS(1140),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(471),
    [sym__newline] = ACTIONS(471),
    [sym__semicolon] = ACTIONS(471),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(471),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(471),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(471),
    [sym__external_open_bracket] = ACTIONS(471),
    [sym__external_close_bracket] = ACTIONS(471),
    [sym__external_open_bracket2] = ACTIONS(471),
  },
  [92] = {
    [sym_function_definition] = STATE(607),
    [sym_if_statement] = STATE(607),
    [sym_for_statement] = STATE(607),
    [sym_while_statement] = STATE(607),
    [sym_repeat_statement] = STATE(607),
    [sym_braced_expression] = STATE(607),
    [sym_parenthesized_expression] = STATE(607),
    [sym_call] = STATE(607),
    [sym_subset] = STATE(607),
    [sym_subset2] = STATE(607),
    [sym_unary_operator] = STATE(607),
    [sym_binary_operator] = STATE(607),
    [sym_extract_operator] = STATE(607),
    [sym_namespace_operator] = STATE(607),
    [sym_integer] = STATE(607),
    [sym_complex] = STATE(607),
    [sym_float] = STATE(607),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(607),
    [sym__expression] = STATE(607),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(86),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(387),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [aux_sym_binary_operator_token1] = ACTIONS(387),
    [anon_sym_PIPE_GT] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_DOLLAR] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(1142),
    [sym_next] = ACTIONS(1142),
    [sym_break] = ACTIONS(1142),
    [sym_true] = ACTIONS(1142),
    [sym_false] = ACTIONS(1142),
    [sym_null] = ACTIONS(1142),
    [sym_inf] = ACTIONS(1142),
    [sym_nan] = ACTIONS(1142),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(1142),
    [sym_dot_dot_i] = ACTIONS(1144),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(1146),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(387),
    [sym__external_close_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(387),
  },
  [93] = {
    [sym_function_definition] = STATE(770),
    [sym_if_statement] = STATE(770),
    [sym_for_statement] = STATE(770),
    [sym_while_statement] = STATE(770),
    [sym_repeat_statement] = STATE(770),
    [sym_braced_expression] = STATE(770),
    [sym_parenthesized_expression] = STATE(770),
    [sym_call] = STATE(770),
    [sym_subset] = STATE(770),
    [sym_subset2] = STATE(770),
    [sym_unary_operator] = STATE(770),
    [sym_binary_operator] = STATE(770),
    [sym_extract_operator] = STATE(770),
    [sym_namespace_operator] = STATE(770),
    [sym_integer] = STATE(770),
    [sym_complex] = STATE(770),
    [sym_float] = STATE(770),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(770),
    [sym__expression] = STATE(770),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [sym__close_brace] = STATE(2488),
    [aux_sym_braced_expression_repeat1] = STATE(110),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(876),
    [sym_next] = ACTIONS(876),
    [sym_break] = ACTIONS(876),
    [sym_true] = ACTIONS(876),
    [sym_false] = ACTIONS(876),
    [sym_null] = ACTIONS(876),
    [sym_inf] = ACTIONS(876),
    [sym_nan] = ACTIONS(876),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(876),
    [sym_dot_dot_i] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(880),
    [sym__semicolon] = ACTIONS(880),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(1148),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [94] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2685),
    [aux_sym_braced_expression_repeat1] = STATE(75),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(1150),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [95] = {
    [sym_function_definition] = STATE(502),
    [sym_if_statement] = STATE(502),
    [sym_for_statement] = STATE(502),
    [sym_while_statement] = STATE(502),
    [sym_repeat_statement] = STATE(502),
    [sym_braced_expression] = STATE(502),
    [sym_parenthesized_expression] = STATE(502),
    [sym_call] = STATE(502),
    [sym_subset] = STATE(502),
    [sym_subset2] = STATE(502),
    [sym_unary_operator] = STATE(502),
    [sym_binary_operator] = STATE(502),
    [sym_extract_operator] = STATE(502),
    [sym_namespace_operator] = STATE(502),
    [sym_integer] = STATE(502),
    [sym_complex] = STATE(502),
    [sym_float] = STATE(502),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(502),
    [sym__expression] = STATE(502),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_parenthesized_expression_repeat1] = STATE(95),
    [sym_identifier] = ACTIONS(1152),
    [anon_sym_BSLASH] = ACTIONS(1155),
    [anon_sym_function] = ACTIONS(1158),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(1161),
    [anon_sym_for] = ACTIONS(1164),
    [anon_sym_while] = ACTIONS(1167),
    [anon_sym_repeat] = ACTIONS(1170),
    [anon_sym_QMARK] = ACTIONS(1173),
    [anon_sym_TILDE] = ACTIONS(1176),
    [anon_sym_BANG] = ACTIONS(1179),
    [anon_sym_PLUS] = ACTIONS(1182),
    [anon_sym_DASH] = ACTIONS(1185),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(1188),
    [sym__number_literal] = ACTIONS(1191),
    [anon_sym_SQUOTE] = ACTIONS(1194),
    [anon_sym_DQUOTE] = ACTIONS(1197),
    [sym_return] = ACTIONS(1200),
    [sym_next] = ACTIONS(1200),
    [sym_break] = ACTIONS(1200),
    [sym_true] = ACTIONS(1200),
    [sym_false] = ACTIONS(1200),
    [sym_null] = ACTIONS(1200),
    [sym_inf] = ACTIONS(1200),
    [sym_nan] = ACTIONS(1200),
    [anon_sym_NA] = ACTIONS(1203),
    [anon_sym_NA_integer_] = ACTIONS(1203),
    [anon_sym_NA_real_] = ACTIONS(1203),
    [anon_sym_NA_complex_] = ACTIONS(1203),
    [anon_sym_NA_character_] = ACTIONS(1203),
    [sym_dots] = ACTIONS(1200),
    [sym_dot_dot_i] = ACTIONS(1206),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(1209),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(1212),
    [sym__external_else] = ACTIONS(803),
    [sym__external_open_parenthesis] = ACTIONS(1215),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(1218),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
    [sym__external_close_bracket2] = ACTIONS(803),
  },
  [96] = {
    [sym_function_definition] = STATE(608),
    [sym_if_statement] = STATE(608),
    [sym_for_statement] = STATE(608),
    [sym_while_statement] = STATE(608),
    [sym_repeat_statement] = STATE(608),
    [sym_braced_expression] = STATE(608),
    [sym_parenthesized_expression] = STATE(608),
    [sym_call] = STATE(608),
    [sym_subset] = STATE(608),
    [sym_subset2] = STATE(608),
    [sym_unary_operator] = STATE(608),
    [sym_binary_operator] = STATE(608),
    [sym_extract_operator] = STATE(608),
    [sym_namespace_operator] = STATE(608),
    [sym_integer] = STATE(608),
    [sym_complex] = STATE(608),
    [sym_float] = STATE(608),
    [sym__hex_literal] = STATE(2021),
    [sym__float_literal] = STATE(2021),
    [sym_string] = STATE(2016),
    [sym__single_quoted_string] = STATE(2027),
    [sym__double_quoted_string] = STATE(2041),
    [sym_na] = STATE(608),
    [sym__expression] = STATE(608),
    [sym__string_or_identifier] = STATE(5131),
    [sym__open_parenthesis] = STATE(20),
    [sym__open_brace] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(2199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(105),
    [anon_sym_function] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(115),
    [anon_sym_repeat] = ACTIONS(117),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_LT_DASH] = ACTIONS(397),
    [anon_sym_LT_LT_DASH] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_STAR_STAR] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [aux_sym_binary_operator_token1] = ACTIONS(397),
    [anon_sym_PIPE_GT] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [aux_sym__hex_literal_token1] = ACTIONS(131),
    [sym__number_literal] = ACTIONS(133),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_return] = ACTIONS(1221),
    [sym_next] = ACTIONS(1221),
    [sym_break] = ACTIONS(1221),
    [sym_true] = ACTIONS(1221),
    [sym_false] = ACTIONS(1221),
    [sym_null] = ACTIONS(1221),
    [sym_inf] = ACTIONS(1221),
    [sym_nan] = ACTIONS(1221),
    [anon_sym_NA] = ACTIONS(141),
    [anon_sym_NA_integer_] = ACTIONS(141),
    [anon_sym_NA_real_] = ACTIONS(141),
    [anon_sym_NA_complex_] = ACTIONS(141),
    [anon_sym_NA_character_] = ACTIONS(141),
    [sym_dots] = ACTIONS(1221),
    [sym_dot_dot_i] = ACTIONS(1223),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(397),
    [sym__newline] = ACTIONS(397),
    [sym__semicolon] = ACTIONS(397),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(397),
    [sym__external_open_parenthesis] = ACTIONS(149),
    [sym__external_close_parenthesis] = ACTIONS(397),
    [sym__external_open_brace] = ACTIONS(153),
    [sym__external_close_brace] = ACTIONS(397),
    [sym__external_open_bracket] = ACTIONS(397),
    [sym__external_close_bracket] = ACTIONS(397),
    [sym__external_open_bracket2] = ACTIONS(397),
  },
  [97] = {
    [sym_function_definition] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_repeat_statement] = STATE(599),
    [sym_braced_expression] = STATE(599),
    [sym_parenthesized_expression] = STATE(599),
    [sym_call] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_unary_operator] = STATE(599),
    [sym_binary_operator] = STATE(599),
    [sym_extract_operator] = STATE(599),
    [sym_namespace_operator] = STATE(599),
    [sym_integer] = STATE(599),
    [sym_complex] = STATE(599),
    [sym_float] = STATE(599),
    [sym__hex_literal] = STATE(1984),
    [sym__float_literal] = STATE(1984),
    [sym_string] = STATE(1982),
    [sym__single_quoted_string] = STATE(1985),
    [sym__double_quoted_string] = STATE(1990),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym__string_or_identifier] = STATE(5151),
    [sym__open_parenthesis] = STATE(19),
    [sym__open_brace] = STATE(4),
    [sym__close_brace] = STATE(2891),
    [aux_sym_braced_expression_repeat1] = STATE(33),
    [sym_identifier] = ACTIONS(53),
    [anon_sym_BSLASH] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_for] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(79),
    [sym__number_literal] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [sym_return] = ACTIONS(87),
    [sym_next] = ACTIONS(87),
    [sym_break] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_inf] = ACTIONS(87),
    [sym_nan] = ACTIONS(87),
    [anon_sym_NA] = ACTIONS(89),
    [anon_sym_NA_integer_] = ACTIONS(89),
    [anon_sym_NA_real_] = ACTIONS(89),
    [anon_sym_NA_complex_] = ACTIONS(89),
    [anon_sym_NA_character_] = ACTIONS(89),
    [sym_dots] = ACTIONS(87),
    [sym_dot_dot_i] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(93),
    [sym__semicolon] = ACTIONS(93),
    [sym__raw_string_literal] = ACTIONS(95),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(97),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(99),
    [sym__external_close_brace] = ACTIONS(1225),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [98] = {
    [sym_function_definition] = STATE(921),
    [sym_if_statement] = STATE(921),
    [sym_for_statement] = STATE(921),
    [sym_while_statement] = STATE(921),
    [sym_repeat_statement] = STATE(921),
    [sym_braced_expression] = STATE(921),
    [sym_parenthesized_expression] = STATE(921),
    [sym_call] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_unary_operator] = STATE(921),
    [sym_binary_operator] = STATE(921),
    [sym_extract_operator] = STATE(921),
    [sym_namespace_operator] = STATE(921),
    [sym_integer] = STATE(921),
    [sym_complex] = STATE(921),
    [sym_float] = STATE(921),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [sym__close_brace] = STATE(2498),
    [aux_sym_braced_expression_repeat1] = STATE(124),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(658),
    [sym_next] = ACTIONS(658),
    [sym_break] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_null] = ACTIONS(658),
    [sym_inf] = ACTIONS(658),
    [sym_nan] = ACTIONS(658),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(658),
    [sym_dot_dot_i] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(664),
    [sym__semicolon] = ACTIONS(664),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(1227),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [99] = {
    [sym_function_definition] = STATE(621),
    [sym_if_statement] = STATE(621),
    [sym_for_statement] = STATE(621),
    [sym_while_statement] = STATE(621),
    [sym_repeat_statement] = STATE(621),
    [sym_braced_expression] = STATE(621),
    [sym_parenthesized_expression] = STATE(621),
    [sym_call] = STATE(621),
    [sym_subset] = STATE(621),
    [sym_subset2] = STATE(621),
    [sym_unary_operator] = STATE(621),
    [sym_binary_operator] = STATE(621),
    [sym_extract_operator] = STATE(621),
    [sym_namespace_operator] = STATE(621),
    [sym_integer] = STATE(621),
    [sym_complex] = STATE(621),
    [sym_float] = STATE(621),
    [sym__hex_literal] = STATE(1925),
    [sym__float_literal] = STATE(1925),
    [sym_string] = STATE(1927),
    [sym__single_quoted_string] = STATE(1923),
    [sym__double_quoted_string] = STATE(1934),
    [sym_na] = STATE(621),
    [sym__expression] = STATE(621),
    [sym__string_or_identifier] = STATE(5137),
    [sym__open_parenthesis] = STATE(14),
    [sym__open_brace] = STATE(18),
    [aux_sym_function_definition_repeat1] = STATE(2196),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(185),
    [sym__number_literal] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_return] = ACTIONS(1229),
    [sym_next] = ACTIONS(1229),
    [sym_break] = ACTIONS(1229),
    [sym_true] = ACTIONS(1229),
    [sym_false] = ACTIONS(1229),
    [sym_null] = ACTIONS(1229),
    [sym_inf] = ACTIONS(1229),
    [sym_nan] = ACTIONS(1229),
    [anon_sym_NA] = ACTIONS(195),
    [anon_sym_NA_integer_] = ACTIONS(195),
    [anon_sym_NA_real_] = ACTIONS(195),
    [anon_sym_NA_complex_] = ACTIONS(195),
    [anon_sym_NA_character_] = ACTIONS(195),
    [sym_dots] = ACTIONS(1229),
    [sym_dot_dot_i] = ACTIONS(1231),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(201),
    [sym__external_else] = ACTIONS(765),
    [sym__external_open_parenthesis] = ACTIONS(203),
    [sym__external_close_parenthesis] = ACTIONS(765),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
    [sym__external_close_bracket2] = ACTIONS(765),
  },
  [100] = {
    [sym_function_definition] = STATE(863),
    [sym_if_statement] = STATE(863),
    [sym_for_statement] = STATE(863),
    [sym_while_statement] = STATE(863),
    [sym_repeat_statement] = STATE(863),
    [sym_braced_expression] = STATE(863),
    [sym_parenthesized_expression] = STATE(863),
    [sym_call] = STATE(863),
    [sym_subset] = STATE(863),
    [sym_subset2] = STATE(863),
    [sym_unary_operator] = STATE(863),
    [sym_binary_operator] = STATE(863),
    [sym_extract_operator] = STATE(863),
    [sym_namespace_operator] = STATE(863),
    [sym_integer] = STATE(863),
    [sym_complex] = STATE(863),
    [sym_float] = STATE(863),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(863),
    [sym__expression] = STATE(863),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [aux_sym_function_definition_repeat1] = STATE(2281),
    [ts_builtin_sym_end] = ACTIONS(757),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(1233),
    [sym_next] = ACTIONS(1233),
    [sym_break] = ACTIONS(1233),
    [sym_true] = ACTIONS(1233),
    [sym_false] = ACTIONS(1233),
    [sym_null] = ACTIONS(1233),
    [sym_inf] = ACTIONS(1233),
    [sym_nan] = ACTIONS(1233),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(1233),
    [sym_dot_dot_i] = ACTIONS(1235),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
  },
  [101] = {
    [sym_function_definition] = STATE(804),
    [sym_if_statement] = STATE(804),
    [sym_for_statement] = STATE(804),
    [sym_while_statement] = STATE(804),
    [sym_repeat_statement] = STATE(804),
    [sym_braced_expression] = STATE(804),
    [sym_parenthesized_expression] = STATE(804),
    [sym_call] = STATE(804),
    [sym_subset] = STATE(804),
    [sym_subset2] = STATE(804),
    [sym_unary_operator] = STATE(804),
    [sym_binary_operator] = STATE(804),
    [sym_extract_operator] = STATE(804),
    [sym_namespace_operator] = STATE(804),
    [sym_integer] = STATE(804),
    [sym_complex] = STATE(804),
    [sym_float] = STATE(804),
    [sym__hex_literal] = STATE(2206),
    [sym__float_literal] = STATE(2206),
    [sym_string] = STATE(2166),
    [sym__single_quoted_string] = STATE(2200),
    [sym__double_quoted_string] = STATE(2201),
    [sym_na] = STATE(804),
    [sym__expression] = STATE(804),
    [sym__string_or_identifier] = STATE(5154),
    [sym__open_parenthesis] = STATE(3),
    [sym__open_brace] = STATE(45),
    [aux_sym_function_definition_repeat1] = STATE(2302),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_BSLASH] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(505),
    [sym__number_literal] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(1237),
    [sym_next] = ACTIONS(1237),
    [sym_break] = ACTIONS(1237),
    [sym_true] = ACTIONS(1237),
    [sym_false] = ACTIONS(1237),
    [sym_null] = ACTIONS(1237),
    [sym_inf] = ACTIONS(1237),
    [sym_nan] = ACTIONS(1237),
    [anon_sym_NA] = ACTIONS(515),
    [anon_sym_NA_integer_] = ACTIONS(515),
    [anon_sym_NA_real_] = ACTIONS(515),
    [anon_sym_NA_complex_] = ACTIONS(515),
    [anon_sym_NA_character_] = ACTIONS(515),
    [sym_dots] = ACTIONS(1237),
    [sym_dot_dot_i] = ACTIONS(1239),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(521),
    [sym__external_else] = ACTIONS(765),
    [sym__external_open_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(525),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_close_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
  },
  [102] = {
    [sym_function_definition] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_while_statement] = STATE(1139),
    [sym_repeat_statement] = STATE(1139),
    [sym_braced_expression] = STATE(1139),
    [sym_parenthesized_expression] = STATE(1139),
    [sym_call] = STATE(1139),
    [sym_subset] = STATE(1139),
    [sym_subset2] = STATE(1139),
    [sym_unary_operator] = STATE(1139),
    [sym_binary_operator] = STATE(1139),
    [sym_extract_operator] = STATE(1139),
    [sym_namespace_operator] = STATE(1139),
    [sym_integer] = STATE(1139),
    [sym_complex] = STATE(1139),
    [sym_float] = STATE(1139),
    [sym__hex_literal] = STATE(2272),
    [sym__float_literal] = STATE(2272),
    [sym_string] = STATE(2271),
    [sym__single_quoted_string] = STATE(2273),
    [sym__double_quoted_string] = STATE(2274),
    [sym_na] = STATE(1139),
    [sym__expression] = STATE(1139),
    [sym__string_or_identifier] = STATE(5157),
    [sym__open_parenthesis] = STATE(120),
    [sym__close_parenthesis] = STATE(2851),
    [sym__open_brace] = STATE(11),
    [aux_sym_parenthesized_expression_repeat1] = STATE(236),
    [sym_identifier] = ACTIONS(1241),
    [anon_sym_BSLASH] = ACTIONS(1243),
    [anon_sym_function] = ACTIONS(1245),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(1247),
    [anon_sym_for] = ACTIONS(1249),
    [anon_sym_while] = ACTIONS(1251),
    [anon_sym_repeat] = ACTIONS(1253),
    [anon_sym_QMARK] = ACTIONS(1255),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1259),
    [anon_sym_PLUS] = ACTIONS(1261),
    [anon_sym_DASH] = ACTIONS(1263),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(1265),
    [sym__number_literal] = ACTIONS(1267),
    [anon_sym_SQUOTE] = ACTIONS(1269),
    [anon_sym_DQUOTE] = ACTIONS(1271),
    [sym_return] = ACTIONS(1273),
    [sym_next] = ACTIONS(1273),
    [sym_break] = ACTIONS(1273),
    [sym_true] = ACTIONS(1273),
    [sym_false] = ACTIONS(1273),
    [sym_null] = ACTIONS(1273),
    [sym_inf] = ACTIONS(1273),
    [sym_nan] = ACTIONS(1273),
    [anon_sym_NA] = ACTIONS(1275),
    [anon_sym_NA_integer_] = ACTIONS(1275),
    [anon_sym_NA_real_] = ACTIONS(1275),
    [anon_sym_NA_complex_] = ACTIONS(1275),
    [anon_sym_NA_character_] = ACTIONS(1275),
    [sym_dots] = ACTIONS(1273),
    [sym_dot_dot_i] = ACTIONS(1277),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(1279),
    [sym__raw_string_literal] = ACTIONS(1281),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(1283),
    [sym__external_close_parenthesis] = ACTIONS(1285),
    [sym__external_open_brace] = ACTIONS(1287),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_close_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [103] = {
    [sym_function_definition] = STATE(970),
    [sym_if_statement] = STATE(970),
    [sym_for_statement] = STATE(970),
    [sym_while_statement] = STATE(970),
    [sym_repeat_statement] = STATE(970),
    [sym_braced_expression] = STATE(970),
    [sym_parenthesized_expression] = STATE(970),
    [sym_call] = STATE(970),
    [sym_subset] = STATE(970),
    [sym_subset2] = STATE(970),
    [sym_unary_operator] = STATE(970),
    [sym_binary_operator] = STATE(970),
    [sym_extract_operator] = STATE(970),
    [sym_namespace_operator] = STATE(970),
    [sym_integer] = STATE(970),
    [sym_complex] = STATE(970),
    [sym_float] = STATE(970),
    [sym__hex_literal] = STATE(2266),
    [sym__float_literal] = STATE(2266),
    [sym_string] = STATE(2284),
    [sym__single_quoted_string] = STATE(2265),
    [sym__double_quoted_string] = STATE(2264),
    [sym_na] = STATE(970),
    [sym__expression] = STATE(970),
    [sym__string_or_identifier] = STATE(5147),
    [sym__open_parenthesis] = STATE(23),
    [sym__open_brace] = STATE(180),
    [sym__close_brace] = STATE(2588),
    [aux_sym_braced_expression_repeat1] = STATE(294),
    [sym_identifier] = ACTIONS(1289),
    [anon_sym_BSLASH] = ACTIONS(1291),
    [anon_sym_function] = ACTIONS(1293),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1295),
    [anon_sym_for] = ACTIONS(1297),
    [anon_sym_while] = ACTIONS(1299),
    [anon_sym_repeat] = ACTIONS(1301),
    [anon_sym_QMARK] = ACTIONS(1303),
    [anon_sym_TILDE] = ACTIONS(1305),
    [anon_sym_BANG] = ACTIONS(1307),
    [anon_sym_PLUS] = ACTIONS(1309),
    [anon_sym_DASH] = ACTIONS(1311),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(1313),
    [sym__number_literal] = ACTIONS(1315),
    [anon_sym_SQUOTE] = ACTIONS(1317),
    [anon_sym_DQUOTE] = ACTIONS(1319),
    [sym_return] = ACTIONS(1321),
    [sym_next] = ACTIONS(1321),
    [sym_break] = ACTIONS(1321),
    [sym_true] = ACTIONS(1321),
    [sym_false] = ACTIONS(1321),
    [sym_null] = ACTIONS(1321),
    [sym_inf] = ACTIONS(1321),
    [sym_nan] = ACTIONS(1321),
    [anon_sym_NA] = ACTIONS(1323),
    [anon_sym_NA_integer_] = ACTIONS(1323),
    [anon_sym_NA_real_] = ACTIONS(1323),
    [anon_sym_NA_complex_] = ACTIONS(1323),
    [anon_sym_NA_character_] = ACTIONS(1323),
    [sym_dots] = ACTIONS(1321),
    [sym_dot_dot_i] = ACTIONS(1325),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(1327),
    [sym__semicolon] = ACTIONS(1327),
    [sym__raw_string_literal] = ACTIONS(1329),
    [sym__external_open_parenthesis] = ACTIONS(1331),
    [sym__external_open_brace] = ACTIONS(1333),
    [sym__external_close_brace] = ACTIONS(1335),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [104] = {
    [sym_function_definition] = STATE(1219),
    [sym_if_statement] = STATE(1219),
    [sym_for_statement] = STATE(1219),
    [sym_while_statement] = STATE(1219),
    [sym_repeat_statement] = STATE(1219),
    [sym_braced_expression] = STATE(1219),
    [sym_parenthesized_expression] = STATE(1219),
    [sym_call] = STATE(1219),
    [sym_subset] = STATE(1219),
    [sym_subset2] = STATE(1219),
    [sym_unary_operator] = STATE(1219),
    [sym_binary_operator] = STATE(1219),
    [sym_extract_operator] = STATE(1219),
    [sym_namespace_operator] = STATE(1219),
    [sym_integer] = STATE(1219),
    [sym_complex] = STATE(1219),
    [sym_float] = STATE(1219),
    [sym__hex_literal] = STATE(2356),
    [sym__float_literal] = STATE(2356),
    [sym_string] = STATE(2231),
    [sym__single_quoted_string] = STATE(2355),
    [sym__double_quoted_string] = STATE(2354),
    [sym_na] = STATE(1219),
    [sym__expression] = STATE(1219),
    [sym__string_or_identifier] = STATE(5156),
    [sym__open_parenthesis] = STATE(190),
    [sym__close_parenthesis] = STATE(2803),
    [sym__open_brace] = STATE(94),
    [aux_sym_parenthesized_expression_repeat1] = STATE(245),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(1337),
    [anon_sym_BSLASH] = ACTIONS(1339),
    [anon_sym_function] = ACTIONS(1341),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(1343),
    [anon_sym_for] = ACTIONS(1345),
    [anon_sym_while] = ACTIONS(1347),
    [anon_sym_repeat] = ACTIONS(1349),
    [anon_sym_QMARK] = ACTIONS(1351),
    [anon_sym_TILDE] = ACTIONS(1353),
    [anon_sym_BANG] = ACTIONS(1355),
    [anon_sym_PLUS] = ACTIONS(1357),
    [anon_sym_DASH] = ACTIONS(1359),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(1361),
    [sym__number_literal] = ACTIONS(1363),
    [anon_sym_SQUOTE] = ACTIONS(1365),
    [anon_sym_DQUOTE] = ACTIONS(1367),
    [sym_return] = ACTIONS(1369),
    [sym_next] = ACTIONS(1369),
    [sym_break] = ACTIONS(1369),
    [sym_true] = ACTIONS(1369),
    [sym_false] = ACTIONS(1369),
    [sym_null] = ACTIONS(1369),
    [sym_inf] = ACTIONS(1369),
    [sym_nan] = ACTIONS(1369),
    [anon_sym_NA] = ACTIONS(1371),
    [anon_sym_NA_integer_] = ACTIONS(1371),
    [anon_sym_NA_real_] = ACTIONS(1371),
    [anon_sym_NA_complex_] = ACTIONS(1371),
    [anon_sym_NA_character_] = ACTIONS(1371),
    [sym_dots] = ACTIONS(1369),
    [sym_dot_dot_i] = ACTIONS(1373),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(1375),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(1377),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(1379),
    [sym__external_close_parenthesis] = ACTIONS(1381),
    [sym__external_open_brace] = ACTIONS(1383),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [105] = {
    [sym_function_definition] = STATE(1072),
    [sym_if_statement] = STATE(1072),
    [sym_for_statement] = STATE(1072),
    [sym_while_statement] = STATE(1072),
    [sym_repeat_statement] = STATE(1072),
    [sym_braced_expression] = STATE(1072),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_call] = STATE(1072),
    [sym_subset] = STATE(1072),
    [sym_subset2] = STATE(1072),
    [sym_unary_operator] = STATE(1072),
    [sym_binary_operator] = STATE(1072),
    [sym_extract_operator] = STATE(1072),
    [sym_namespace_operator] = STATE(1072),
    [sym_integer] = STATE(1072),
    [sym_complex] = STATE(1072),
    [sym_float] = STATE(1072),
    [sym__hex_literal] = STATE(2311),
    [sym__float_literal] = STATE(2311),
    [sym_string] = STATE(2312),
    [sym__single_quoted_string] = STATE(2310),
    [sym__double_quoted_string] = STATE(2309),
    [sym_na] = STATE(1072),
    [sym__expression] = STATE(1072),
    [sym__string_or_identifier] = STATE(5134),
    [sym__open_parenthesis] = STATE(64),
    [sym__open_brace] = STATE(199),
    [sym__close_brace] = STATE(2802),
    [aux_sym_braced_expression_repeat1] = STATE(279),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym_identifier] = ACTIONS(1385),
    [anon_sym_BSLASH] = ACTIONS(1387),
    [anon_sym_function] = ACTIONS(1389),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1391),
    [anon_sym_for] = ACTIONS(1393),
    [anon_sym_while] = ACTIONS(1395),
    [anon_sym_repeat] = ACTIONS(1397),
    [anon_sym_QMARK] = ACTIONS(1399),
    [anon_sym_TILDE] = ACTIONS(1401),
    [anon_sym_BANG] = ACTIONS(1403),
    [anon_sym_PLUS] = ACTIONS(1405),
    [anon_sym_DASH] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(1409),
    [sym__number_literal] = ACTIONS(1411),
    [anon_sym_SQUOTE] = ACTIONS(1413),
    [anon_sym_DQUOTE] = ACTIONS(1415),
    [sym_return] = ACTIONS(1417),
    [sym_next] = ACTIONS(1417),
    [sym_break] = ACTIONS(1417),
    [sym_true] = ACTIONS(1417),
    [sym_false] = ACTIONS(1417),
    [sym_null] = ACTIONS(1417),
    [sym_inf] = ACTIONS(1417),
    [sym_nan] = ACTIONS(1417),
    [anon_sym_NA] = ACTIONS(1419),
    [anon_sym_NA_integer_] = ACTIONS(1419),
    [anon_sym_NA_real_] = ACTIONS(1419),
    [anon_sym_NA_complex_] = ACTIONS(1419),
    [anon_sym_NA_character_] = ACTIONS(1419),
    [sym_dots] = ACTIONS(1417),
    [sym_dot_dot_i] = ACTIONS(1421),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(1423),
    [sym__semicolon] = ACTIONS(1423),
    [sym__raw_string_literal] = ACTIONS(1425),
    [sym__external_else] = ACTIONS(51),
    [sym__external_open_parenthesis] = ACTIONS(1427),
    [sym__external_open_brace] = ACTIONS(1429),
    [sym__external_close_brace] = ACTIONS(1431),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [106] = {
    [sym_function_definition] = STATE(1152),
    [sym_if_statement] = STATE(1152),
    [sym_for_statement] = STATE(1152),
    [sym_while_statement] = STATE(1152),
    [sym_repeat_statement] = STATE(1152),
    [sym_braced_expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(1152),
    [sym_call] = STATE(1152),
    [sym_subset] = STATE(1152),
    [sym_subset2] = STATE(1152),
    [sym_unary_operator] = STATE(1152),
    [sym_binary_operator] = STATE(1152),
    [sym_extract_operator] = STATE(1152),
    [sym_namespace_operator] = STATE(1152),
    [sym_integer] = STATE(1152),
    [sym_complex] = STATE(1152),
    [sym_float] = STATE(1152),
    [sym__hex_literal] = STATE(2235),
    [sym__float_literal] = STATE(2235),
    [sym_string] = STATE(2234),
    [sym__single_quoted_string] = STATE(2236),
    [sym__double_quoted_string] = STATE(2237),
    [sym_na] = STATE(1152),
    [sym__expression] = STATE(1152),
    [sym__string_or_identifier] = STATE(5150),
    [sym__open_parenthesis] = STATE(76),
    [sym__open_brace] = STATE(188),
    [sym__close_brace] = STATE(2707),
    [aux_sym_braced_expression_repeat1] = STATE(262),
    [sym_identifier] = ACTIONS(1433),
    [anon_sym_BSLASH] = ACTIONS(1435),
    [anon_sym_function] = ACTIONS(1437),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1441),
    [anon_sym_while] = ACTIONS(1443),
    [anon_sym_repeat] = ACTIONS(1445),
    [anon_sym_QMARK] = ACTIONS(1447),
    [anon_sym_TILDE] = ACTIONS(1449),
    [anon_sym_BANG] = ACTIONS(1451),
    [anon_sym_PLUS] = ACTIONS(1453),
    [anon_sym_DASH] = ACTIONS(1455),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(1457),
    [sym__number_literal] = ACTIONS(1459),
    [anon_sym_SQUOTE] = ACTIONS(1461),
    [anon_sym_DQUOTE] = ACTIONS(1463),
    [sym_return] = ACTIONS(1465),
    [sym_next] = ACTIONS(1465),
    [sym_break] = ACTIONS(1465),
    [sym_true] = ACTIONS(1465),
    [sym_false] = ACTIONS(1465),
    [sym_null] = ACTIONS(1465),
    [sym_inf] = ACTIONS(1465),
    [sym_nan] = ACTIONS(1465),
    [anon_sym_NA] = ACTIONS(1467),
    [anon_sym_NA_integer_] = ACTIONS(1467),
    [anon_sym_NA_real_] = ACTIONS(1467),
    [anon_sym_NA_complex_] = ACTIONS(1467),
    [anon_sym_NA_character_] = ACTIONS(1467),
    [sym_dots] = ACTIONS(1465),
    [sym_dot_dot_i] = ACTIONS(1469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(1471),
    [sym__semicolon] = ACTIONS(1471),
    [sym__raw_string_literal] = ACTIONS(1473),
    [sym__external_open_parenthesis] = ACTIONS(1475),
    [sym__external_open_brace] = ACTIONS(1477),
    [sym__external_close_brace] = ACTIONS(1479),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [107] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [sym__close_brace] = STATE(2948),
    [aux_sym_braced_expression_repeat1] = STATE(145),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(353),
    [sym_next] = ACTIONS(353),
    [sym_break] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_null] = ACTIONS(353),
    [sym_inf] = ACTIONS(353),
    [sym_nan] = ACTIONS(353),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(353),
    [sym_dot_dot_i] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(359),
    [sym__semicolon] = ACTIONS(359),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(1481),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [108] = {
    [sym_function_definition] = STATE(774),
    [sym_if_statement] = STATE(774),
    [sym_for_statement] = STATE(774),
    [sym_while_statement] = STATE(774),
    [sym_repeat_statement] = STATE(774),
    [sym_braced_expression] = STATE(774),
    [sym_parenthesized_expression] = STATE(774),
    [sym_call] = STATE(774),
    [sym_subset] = STATE(774),
    [sym_subset2] = STATE(774),
    [sym_unary_operator] = STATE(774),
    [sym_binary_operator] = STATE(774),
    [sym_extract_operator] = STATE(774),
    [sym_namespace_operator] = STATE(774),
    [sym_integer] = STATE(774),
    [sym_complex] = STATE(774),
    [sym_float] = STATE(774),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(774),
    [sym__expression] = STATE(774),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(111),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_COLON_EQ] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_DASH_GT_GT] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_STAR_STAR] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(263),
    [aux_sym_binary_operator_token1] = ACTIONS(263),
    [anon_sym_PIPE_GT] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1483),
    [sym_next] = ACTIONS(1483),
    [sym_break] = ACTIONS(1483),
    [sym_true] = ACTIONS(1483),
    [sym_false] = ACTIONS(1483),
    [sym_null] = ACTIONS(1483),
    [sym_inf] = ACTIONS(1483),
    [sym_nan] = ACTIONS(1483),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1483),
    [sym_dot_dot_i] = ACTIONS(1485),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(263),
    [sym__newline] = ACTIONS(1487),
    [sym__semicolon] = ACTIONS(263),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(263),
    [sym__external_open_bracket] = ACTIONS(263),
    [sym__external_close_bracket] = ACTIONS(263),
    [sym__external_open_bracket2] = ACTIONS(263),
  },
  [109] = {
    [sym_function_definition] = STATE(753),
    [sym_if_statement] = STATE(753),
    [sym_for_statement] = STATE(753),
    [sym_while_statement] = STATE(753),
    [sym_repeat_statement] = STATE(753),
    [sym_braced_expression] = STATE(753),
    [sym_parenthesized_expression] = STATE(753),
    [sym_call] = STATE(753),
    [sym_subset] = STATE(753),
    [sym_subset2] = STATE(753),
    [sym_unary_operator] = STATE(753),
    [sym_binary_operator] = STATE(753),
    [sym_extract_operator] = STATE(753),
    [sym_namespace_operator] = STATE(753),
    [sym_integer] = STATE(753),
    [sym_complex] = STATE(753),
    [sym_float] = STATE(753),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(753),
    [sym__expression] = STATE(753),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(113),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(545),
    [anon_sym_LT_LT_DASH] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(543),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [aux_sym_binary_operator_token1] = ACTIONS(545),
    [anon_sym_PIPE_GT] = ACTIONS(545),
    [anon_sym_COLON] = ACTIONS(543),
    [anon_sym_DOLLAR] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(545),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1489),
    [sym_next] = ACTIONS(1489),
    [sym_break] = ACTIONS(1489),
    [sym_true] = ACTIONS(1489),
    [sym_false] = ACTIONS(1489),
    [sym_null] = ACTIONS(1489),
    [sym_inf] = ACTIONS(1489),
    [sym_nan] = ACTIONS(1489),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1489),
    [sym_dot_dot_i] = ACTIONS(1491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(1493),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(545),
    [sym__external_close_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(545),
  },
  [110] = {
    [sym_function_definition] = STATE(770),
    [sym_if_statement] = STATE(770),
    [sym_for_statement] = STATE(770),
    [sym_while_statement] = STATE(770),
    [sym_repeat_statement] = STATE(770),
    [sym_braced_expression] = STATE(770),
    [sym_parenthesized_expression] = STATE(770),
    [sym_call] = STATE(770),
    [sym_subset] = STATE(770),
    [sym_subset2] = STATE(770),
    [sym_unary_operator] = STATE(770),
    [sym_binary_operator] = STATE(770),
    [sym_extract_operator] = STATE(770),
    [sym_namespace_operator] = STATE(770),
    [sym_integer] = STATE(770),
    [sym_complex] = STATE(770),
    [sym_float] = STATE(770),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(770),
    [sym__expression] = STATE(770),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_braced_expression_repeat1] = STATE(110),
    [sym_identifier] = ACTIONS(1495),
    [anon_sym_BSLASH] = ACTIONS(1498),
    [anon_sym_function] = ACTIONS(1501),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(1504),
    [anon_sym_for] = ACTIONS(1507),
    [anon_sym_while] = ACTIONS(1510),
    [anon_sym_repeat] = ACTIONS(1513),
    [anon_sym_QMARK] = ACTIONS(1516),
    [anon_sym_TILDE] = ACTIONS(1519),
    [anon_sym_BANG] = ACTIONS(1522),
    [anon_sym_PLUS] = ACTIONS(1525),
    [anon_sym_DASH] = ACTIONS(1528),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(1531),
    [sym__number_literal] = ACTIONS(1534),
    [anon_sym_SQUOTE] = ACTIONS(1537),
    [anon_sym_DQUOTE] = ACTIONS(1540),
    [sym_return] = ACTIONS(1543),
    [sym_next] = ACTIONS(1543),
    [sym_break] = ACTIONS(1543),
    [sym_true] = ACTIONS(1543),
    [sym_false] = ACTIONS(1543),
    [sym_null] = ACTIONS(1543),
    [sym_inf] = ACTIONS(1543),
    [sym_nan] = ACTIONS(1543),
    [anon_sym_NA] = ACTIONS(1546),
    [anon_sym_NA_integer_] = ACTIONS(1546),
    [anon_sym_NA_real_] = ACTIONS(1546),
    [anon_sym_NA_complex_] = ACTIONS(1546),
    [anon_sym_NA_character_] = ACTIONS(1546),
    [sym_dots] = ACTIONS(1543),
    [sym_dot_dot_i] = ACTIONS(1549),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(1552),
    [sym__semicolon] = ACTIONS(1552),
    [sym__raw_string_literal] = ACTIONS(1555),
    [sym__external_open_parenthesis] = ACTIONS(1558),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(1561),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_close_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
  },
  [111] = {
    [sym_function_definition] = STATE(749),
    [sym_if_statement] = STATE(749),
    [sym_for_statement] = STATE(749),
    [sym_while_statement] = STATE(749),
    [sym_repeat_statement] = STATE(749),
    [sym_braced_expression] = STATE(749),
    [sym_parenthesized_expression] = STATE(749),
    [sym_call] = STATE(749),
    [sym_subset] = STATE(749),
    [sym_subset2] = STATE(749),
    [sym_unary_operator] = STATE(749),
    [sym_binary_operator] = STATE(749),
    [sym_extract_operator] = STATE(749),
    [sym_namespace_operator] = STATE(749),
    [sym_integer] = STATE(749),
    [sym_complex] = STATE(749),
    [sym_float] = STATE(749),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(749),
    [sym__expression] = STATE(749),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1564),
    [sym_next] = ACTIONS(1564),
    [sym_break] = ACTIONS(1564),
    [sym_true] = ACTIONS(1564),
    [sym_false] = ACTIONS(1564),
    [sym_null] = ACTIONS(1564),
    [sym_inf] = ACTIONS(1564),
    [sym_nan] = ACTIONS(1564),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1564),
    [sym_dot_dot_i] = ACTIONS(1566),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(765),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_close_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
  },
  [112] = {
    [sym_function_definition] = STATE(1133),
    [sym_if_statement] = STATE(1133),
    [sym_for_statement] = STATE(1133),
    [sym_while_statement] = STATE(1133),
    [sym_repeat_statement] = STATE(1133),
    [sym_braced_expression] = STATE(1133),
    [sym_parenthesized_expression] = STATE(1133),
    [sym_call] = STATE(1133),
    [sym_subset] = STATE(1133),
    [sym_subset2] = STATE(1133),
    [sym_unary_operator] = STATE(1133),
    [sym_binary_operator] = STATE(1133),
    [sym_extract_operator] = STATE(1133),
    [sym_namespace_operator] = STATE(1133),
    [sym_integer] = STATE(1133),
    [sym_complex] = STATE(1133),
    [sym_float] = STATE(1133),
    [sym__hex_literal] = STATE(2288),
    [sym__float_literal] = STATE(2288),
    [sym_string] = STATE(2287),
    [sym__single_quoted_string] = STATE(2289),
    [sym__double_quoted_string] = STATE(2290),
    [sym_na] = STATE(1133),
    [sym__expression] = STATE(1133),
    [sym__string_or_identifier] = STATE(5144),
    [sym__open_parenthesis] = STATE(119),
    [sym__close_parenthesis] = STATE(2810),
    [sym__open_brace] = STATE(16),
    [aux_sym_parenthesized_expression_repeat1] = STATE(271),
    [sym_identifier] = ACTIONS(1568),
    [anon_sym_BSLASH] = ACTIONS(1570),
    [anon_sym_function] = ACTIONS(1572),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(1574),
    [anon_sym_for] = ACTIONS(1576),
    [anon_sym_while] = ACTIONS(1578),
    [anon_sym_repeat] = ACTIONS(1580),
    [anon_sym_QMARK] = ACTIONS(1582),
    [anon_sym_TILDE] = ACTIONS(1584),
    [anon_sym_BANG] = ACTIONS(1586),
    [anon_sym_PLUS] = ACTIONS(1588),
    [anon_sym_DASH] = ACTIONS(1590),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(1592),
    [sym__number_literal] = ACTIONS(1594),
    [anon_sym_SQUOTE] = ACTIONS(1596),
    [anon_sym_DQUOTE] = ACTIONS(1598),
    [sym_return] = ACTIONS(1600),
    [sym_next] = ACTIONS(1600),
    [sym_break] = ACTIONS(1600),
    [sym_true] = ACTIONS(1600),
    [sym_false] = ACTIONS(1600),
    [sym_null] = ACTIONS(1600),
    [sym_inf] = ACTIONS(1600),
    [sym_nan] = ACTIONS(1600),
    [anon_sym_NA] = ACTIONS(1602),
    [anon_sym_NA_integer_] = ACTIONS(1602),
    [anon_sym_NA_real_] = ACTIONS(1602),
    [anon_sym_NA_complex_] = ACTIONS(1602),
    [anon_sym_NA_character_] = ACTIONS(1602),
    [sym_dots] = ACTIONS(1600),
    [sym_dot_dot_i] = ACTIONS(1604),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(211),
    [sym__newline] = ACTIONS(1606),
    [sym__raw_string_literal] = ACTIONS(1608),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(1610),
    [sym__external_close_parenthesis] = ACTIONS(1612),
    [sym__external_open_brace] = ACTIONS(1614),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
    [sym__external_close_bracket2] = ACTIONS(211),
  },
  [113] = {
    [sym_function_definition] = STATE(713),
    [sym_if_statement] = STATE(713),
    [sym_for_statement] = STATE(713),
    [sym_while_statement] = STATE(713),
    [sym_repeat_statement] = STATE(713),
    [sym_braced_expression] = STATE(713),
    [sym_parenthesized_expression] = STATE(713),
    [sym_call] = STATE(713),
    [sym_subset] = STATE(713),
    [sym_subset2] = STATE(713),
    [sym_unary_operator] = STATE(713),
    [sym_binary_operator] = STATE(713),
    [sym_extract_operator] = STATE(713),
    [sym_namespace_operator] = STATE(713),
    [sym_integer] = STATE(713),
    [sym_complex] = STATE(713),
    [sym_float] = STATE(713),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(713),
    [sym__expression] = STATE(713),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1616),
    [sym_next] = ACTIONS(1616),
    [sym_break] = ACTIONS(1616),
    [sym_true] = ACTIONS(1616),
    [sym_false] = ACTIONS(1616),
    [sym_null] = ACTIONS(1616),
    [sym_inf] = ACTIONS(1616),
    [sym_nan] = ACTIONS(1616),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1616),
    [sym_dot_dot_i] = ACTIONS(1618),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_close_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
  },
  [114] = {
    [sym_function_definition] = STATE(695),
    [sym_if_statement] = STATE(695),
    [sym_for_statement] = STATE(695),
    [sym_while_statement] = STATE(695),
    [sym_repeat_statement] = STATE(695),
    [sym_braced_expression] = STATE(695),
    [sym_parenthesized_expression] = STATE(695),
    [sym_call] = STATE(695),
    [sym_subset] = STATE(695),
    [sym_subset2] = STATE(695),
    [sym_unary_operator] = STATE(695),
    [sym_binary_operator] = STATE(695),
    [sym_extract_operator] = STATE(695),
    [sym_namespace_operator] = STATE(695),
    [sym_integer] = STATE(695),
    [sym_complex] = STATE(695),
    [sym_float] = STATE(695),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(695),
    [sym__expression] = STATE(695),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(115),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(531),
    [anon_sym_LT_LT_DASH] = ACTIONS(531),
    [anon_sym_COLON_EQ] = ACTIONS(531),
    [anon_sym_DASH_GT] = ACTIONS(533),
    [anon_sym_DASH_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [aux_sym_binary_operator_token1] = ACTIONS(531),
    [anon_sym_PIPE_GT] = ACTIONS(531),
    [anon_sym_COLON] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1620),
    [sym_next] = ACTIONS(1620),
    [sym_break] = ACTIONS(1620),
    [sym_true] = ACTIONS(1620),
    [sym_false] = ACTIONS(1620),
    [sym_null] = ACTIONS(1620),
    [sym_inf] = ACTIONS(1620),
    [sym_nan] = ACTIONS(1620),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1620),
    [sym_dot_dot_i] = ACTIONS(1622),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(1624),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(531),
    [sym__external_close_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(531),
  },
  [115] = {
    [sym_function_definition] = STATE(690),
    [sym_if_statement] = STATE(690),
    [sym_for_statement] = STATE(690),
    [sym_while_statement] = STATE(690),
    [sym_repeat_statement] = STATE(690),
    [sym_braced_expression] = STATE(690),
    [sym_parenthesized_expression] = STATE(690),
    [sym_call] = STATE(690),
    [sym_subset] = STATE(690),
    [sym_subset2] = STATE(690),
    [sym_unary_operator] = STATE(690),
    [sym_binary_operator] = STATE(690),
    [sym_extract_operator] = STATE(690),
    [sym_namespace_operator] = STATE(690),
    [sym_integer] = STATE(690),
    [sym_complex] = STATE(690),
    [sym_float] = STATE(690),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(690),
    [sym__expression] = STATE(690),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1626),
    [sym_next] = ACTIONS(1626),
    [sym_break] = ACTIONS(1626),
    [sym_true] = ACTIONS(1626),
    [sym_false] = ACTIONS(1626),
    [sym_null] = ACTIONS(1626),
    [sym_inf] = ACTIONS(1626),
    [sym_nan] = ACTIONS(1626),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1626),
    [sym_dot_dot_i] = ACTIONS(1628),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [116] = {
    [sym_function_definition] = STATE(689),
    [sym_if_statement] = STATE(689),
    [sym_for_statement] = STATE(689),
    [sym_while_statement] = STATE(689),
    [sym_repeat_statement] = STATE(689),
    [sym_braced_expression] = STATE(689),
    [sym_parenthesized_expression] = STATE(689),
    [sym_call] = STATE(689),
    [sym_subset] = STATE(689),
    [sym_subset2] = STATE(689),
    [sym_unary_operator] = STATE(689),
    [sym_binary_operator] = STATE(689),
    [sym_extract_operator] = STATE(689),
    [sym_namespace_operator] = STATE(689),
    [sym_integer] = STATE(689),
    [sym_complex] = STATE(689),
    [sym_float] = STATE(689),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(689),
    [sym__expression] = STATE(689),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(118),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(377),
    [anon_sym_LT_LT_DASH] = ACTIONS(377),
    [anon_sym_COLON_EQ] = ACTIONS(377),
    [anon_sym_DASH_GT] = ACTIONS(379),
    [anon_sym_DASH_GT_GT] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(377),
    [anon_sym_LT] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(377),
    [anon_sym_BANG_EQ] = ACTIONS(377),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_STAR_STAR] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [aux_sym_binary_operator_token1] = ACTIONS(377),
    [anon_sym_PIPE_GT] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(377),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1630),
    [sym_next] = ACTIONS(1630),
    [sym_break] = ACTIONS(1630),
    [sym_true] = ACTIONS(1630),
    [sym_false] = ACTIONS(1630),
    [sym_null] = ACTIONS(1630),
    [sym_inf] = ACTIONS(1630),
    [sym_nan] = ACTIONS(1630),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1630),
    [sym_dot_dot_i] = ACTIONS(1632),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(377),
    [sym__newline] = ACTIONS(1634),
    [sym__semicolon] = ACTIONS(377),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(377),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(377),
    [sym__external_open_bracket] = ACTIONS(377),
    [sym__external_close_bracket] = ACTIONS(377),
    [sym__external_open_bracket2] = ACTIONS(377),
  },
  [117] = {
    [sym_function_definition] = STATE(686),
    [sym_if_statement] = STATE(686),
    [sym_for_statement] = STATE(686),
    [sym_while_statement] = STATE(686),
    [sym_repeat_statement] = STATE(686),
    [sym_braced_expression] = STATE(686),
    [sym_parenthesized_expression] = STATE(686),
    [sym_call] = STATE(686),
    [sym_subset] = STATE(686),
    [sym_subset2] = STATE(686),
    [sym_unary_operator] = STATE(686),
    [sym_binary_operator] = STATE(686),
    [sym_extract_operator] = STATE(686),
    [sym_namespace_operator] = STATE(686),
    [sym_integer] = STATE(686),
    [sym_complex] = STATE(686),
    [sym_float] = STATE(686),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(686),
    [sym__expression] = STATE(686),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(122),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(387),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [aux_sym_binary_operator_token1] = ACTIONS(387),
    [anon_sym_PIPE_GT] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_DOLLAR] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1636),
    [sym_next] = ACTIONS(1636),
    [sym_break] = ACTIONS(1636),
    [sym_true] = ACTIONS(1636),
    [sym_false] = ACTIONS(1636),
    [sym_null] = ACTIONS(1636),
    [sym_inf] = ACTIONS(1636),
    [sym_nan] = ACTIONS(1636),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1636),
    [sym_dot_dot_i] = ACTIONS(1638),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(1640),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(387),
    [sym__external_close_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(387),
  },
  [118] = {
    [sym_function_definition] = STATE(685),
    [sym_if_statement] = STATE(685),
    [sym_for_statement] = STATE(685),
    [sym_while_statement] = STATE(685),
    [sym_repeat_statement] = STATE(685),
    [sym_braced_expression] = STATE(685),
    [sym_parenthesized_expression] = STATE(685),
    [sym_call] = STATE(685),
    [sym_subset] = STATE(685),
    [sym_subset2] = STATE(685),
    [sym_unary_operator] = STATE(685),
    [sym_binary_operator] = STATE(685),
    [sym_extract_operator] = STATE(685),
    [sym_namespace_operator] = STATE(685),
    [sym_integer] = STATE(685),
    [sym_complex] = STATE(685),
    [sym_float] = STATE(685),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(685),
    [sym__expression] = STATE(685),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(397),
    [anon_sym_LT_LT_DASH] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_STAR_STAR] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [aux_sym_binary_operator_token1] = ACTIONS(397),
    [anon_sym_PIPE_GT] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1642),
    [sym_next] = ACTIONS(1642),
    [sym_break] = ACTIONS(1642),
    [sym_true] = ACTIONS(1642),
    [sym_false] = ACTIONS(1642),
    [sym_null] = ACTIONS(1642),
    [sym_inf] = ACTIONS(1642),
    [sym_nan] = ACTIONS(1642),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1642),
    [sym_dot_dot_i] = ACTIONS(1644),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(397),
    [sym__newline] = ACTIONS(397),
    [sym__semicolon] = ACTIONS(397),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(397),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(397),
    [sym__external_open_bracket] = ACTIONS(397),
    [sym__external_close_bracket] = ACTIONS(397),
    [sym__external_open_bracket2] = ACTIONS(397),
  },
  [119] = {
    [sym_function_definition] = STATE(1133),
    [sym_if_statement] = STATE(1133),
    [sym_for_statement] = STATE(1133),
    [sym_while_statement] = STATE(1133),
    [sym_repeat_statement] = STATE(1133),
    [sym_braced_expression] = STATE(1133),
    [sym_parenthesized_expression] = STATE(1133),
    [sym_call] = STATE(1133),
    [sym_subset] = STATE(1133),
    [sym_subset2] = STATE(1133),
    [sym_unary_operator] = STATE(1133),
    [sym_binary_operator] = STATE(1133),
    [sym_extract_operator] = STATE(1133),
    [sym_namespace_operator] = STATE(1133),
    [sym_integer] = STATE(1133),
    [sym_complex] = STATE(1133),
    [sym_float] = STATE(1133),
    [sym__hex_literal] = STATE(2288),
    [sym__float_literal] = STATE(2288),
    [sym_string] = STATE(2287),
    [sym__single_quoted_string] = STATE(2289),
    [sym__double_quoted_string] = STATE(2290),
    [sym_na] = STATE(1133),
    [sym__expression] = STATE(1133),
    [sym__string_or_identifier] = STATE(5144),
    [sym__open_parenthesis] = STATE(119),
    [sym__close_parenthesis] = STATE(2646),
    [sym__open_brace] = STATE(16),
    [aux_sym_parenthesized_expression_repeat1] = STATE(176),
    [sym_identifier] = ACTIONS(1568),
    [anon_sym_BSLASH] = ACTIONS(1570),
    [anon_sym_function] = ACTIONS(1572),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(1574),
    [anon_sym_for] = ACTIONS(1576),
    [anon_sym_while] = ACTIONS(1578),
    [anon_sym_repeat] = ACTIONS(1580),
    [anon_sym_QMARK] = ACTIONS(1582),
    [anon_sym_TILDE] = ACTIONS(1584),
    [anon_sym_BANG] = ACTIONS(1586),
    [anon_sym_PLUS] = ACTIONS(1588),
    [anon_sym_DASH] = ACTIONS(1590),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(1592),
    [sym__number_literal] = ACTIONS(1594),
    [anon_sym_SQUOTE] = ACTIONS(1596),
    [anon_sym_DQUOTE] = ACTIONS(1598),
    [sym_return] = ACTIONS(1600),
    [sym_next] = ACTIONS(1600),
    [sym_break] = ACTIONS(1600),
    [sym_true] = ACTIONS(1600),
    [sym_false] = ACTIONS(1600),
    [sym_null] = ACTIONS(1600),
    [sym_inf] = ACTIONS(1600),
    [sym_nan] = ACTIONS(1600),
    [anon_sym_NA] = ACTIONS(1602),
    [anon_sym_NA_integer_] = ACTIONS(1602),
    [anon_sym_NA_real_] = ACTIONS(1602),
    [anon_sym_NA_complex_] = ACTIONS(1602),
    [anon_sym_NA_character_] = ACTIONS(1602),
    [sym_dots] = ACTIONS(1600),
    [sym_dot_dot_i] = ACTIONS(1604),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(1606),
    [sym__raw_string_literal] = ACTIONS(1608),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(1610),
    [sym__external_close_parenthesis] = ACTIONS(1646),
    [sym__external_open_brace] = ACTIONS(1614),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
    [sym__external_close_bracket2] = ACTIONS(129),
  },
  [120] = {
    [sym_function_definition] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_while_statement] = STATE(1139),
    [sym_repeat_statement] = STATE(1139),
    [sym_braced_expression] = STATE(1139),
    [sym_parenthesized_expression] = STATE(1139),
    [sym_call] = STATE(1139),
    [sym_subset] = STATE(1139),
    [sym_subset2] = STATE(1139),
    [sym_unary_operator] = STATE(1139),
    [sym_binary_operator] = STATE(1139),
    [sym_extract_operator] = STATE(1139),
    [sym_namespace_operator] = STATE(1139),
    [sym_integer] = STATE(1139),
    [sym_complex] = STATE(1139),
    [sym_float] = STATE(1139),
    [sym__hex_literal] = STATE(2272),
    [sym__float_literal] = STATE(2272),
    [sym_string] = STATE(2271),
    [sym__single_quoted_string] = STATE(2273),
    [sym__double_quoted_string] = STATE(2274),
    [sym_na] = STATE(1139),
    [sym__expression] = STATE(1139),
    [sym__string_or_identifier] = STATE(5157),
    [sym__open_parenthesis] = STATE(120),
    [sym__close_parenthesis] = STATE(2727),
    [sym__open_brace] = STATE(11),
    [aux_sym_parenthesized_expression_repeat1] = STATE(170),
    [sym_identifier] = ACTIONS(1241),
    [anon_sym_BSLASH] = ACTIONS(1243),
    [anon_sym_function] = ACTIONS(1245),
    [anon_sym_EQ] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(1247),
    [anon_sym_for] = ACTIONS(1249),
    [anon_sym_while] = ACTIONS(1251),
    [anon_sym_repeat] = ACTIONS(1253),
    [anon_sym_QMARK] = ACTIONS(1255),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1259),
    [anon_sym_PLUS] = ACTIONS(1261),
    [anon_sym_DASH] = ACTIONS(1263),
    [anon_sym_LT_DASH] = ACTIONS(129),
    [anon_sym_LT_LT_DASH] = ACTIONS(129),
    [anon_sym_COLON_EQ] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_DASH_GT_GT] = ACTIONS(129),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_PIPE_PIPE] = ACTIONS(129),
    [anon_sym_AMP_AMP] = ACTIONS(129),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(129),
    [anon_sym_STAR_STAR] = ACTIONS(129),
    [anon_sym_CARET] = ACTIONS(129),
    [aux_sym_binary_operator_token1] = ACTIONS(129),
    [anon_sym_PIPE_GT] = ACTIONS(129),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_AT] = ACTIONS(129),
    [aux_sym__hex_literal_token1] = ACTIONS(1265),
    [sym__number_literal] = ACTIONS(1267),
    [anon_sym_SQUOTE] = ACTIONS(1269),
    [anon_sym_DQUOTE] = ACTIONS(1271),
    [sym_return] = ACTIONS(1273),
    [sym_next] = ACTIONS(1273),
    [sym_break] = ACTIONS(1273),
    [sym_true] = ACTIONS(1273),
    [sym_false] = ACTIONS(1273),
    [sym_null] = ACTIONS(1273),
    [sym_inf] = ACTIONS(1273),
    [sym_nan] = ACTIONS(1273),
    [anon_sym_NA] = ACTIONS(1275),
    [anon_sym_NA_integer_] = ACTIONS(1275),
    [anon_sym_NA_real_] = ACTIONS(1275),
    [anon_sym_NA_complex_] = ACTIONS(1275),
    [anon_sym_NA_character_] = ACTIONS(1275),
    [sym_dots] = ACTIONS(1273),
    [sym_dot_dot_i] = ACTIONS(1277),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(129),
    [sym__newline] = ACTIONS(1279),
    [sym__raw_string_literal] = ACTIONS(1281),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(1283),
    [sym__external_close_parenthesis] = ACTIONS(1648),
    [sym__external_open_brace] = ACTIONS(1287),
    [sym__external_open_bracket] = ACTIONS(129),
    [sym__external_close_bracket] = ACTIONS(129),
    [sym__external_open_bracket2] = ACTIONS(129),
  },
  [121] = {
    [sym_function_definition] = STATE(970),
    [sym_if_statement] = STATE(970),
    [sym_for_statement] = STATE(970),
    [sym_while_statement] = STATE(970),
    [sym_repeat_statement] = STATE(970),
    [sym_braced_expression] = STATE(970),
    [sym_parenthesized_expression] = STATE(970),
    [sym_call] = STATE(970),
    [sym_subset] = STATE(970),
    [sym_subset2] = STATE(970),
    [sym_unary_operator] = STATE(970),
    [sym_binary_operator] = STATE(970),
    [sym_extract_operator] = STATE(970),
    [sym_namespace_operator] = STATE(970),
    [sym_integer] = STATE(970),
    [sym_complex] = STATE(970),
    [sym_float] = STATE(970),
    [sym__hex_literal] = STATE(2266),
    [sym__float_literal] = STATE(2266),
    [sym_string] = STATE(2284),
    [sym__single_quoted_string] = STATE(2265),
    [sym__double_quoted_string] = STATE(2264),
    [sym_na] = STATE(970),
    [sym__expression] = STATE(970),
    [sym__string_or_identifier] = STATE(5147),
    [sym__open_parenthesis] = STATE(23),
    [sym__open_brace] = STATE(180),
    [sym__close_brace] = STATE(2999),
    [aux_sym_braced_expression_repeat1] = STATE(294),
    [sym_identifier] = ACTIONS(1289),
    [anon_sym_BSLASH] = ACTIONS(1291),
    [anon_sym_function] = ACTIONS(1293),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1295),
    [anon_sym_for] = ACTIONS(1297),
    [anon_sym_while] = ACTIONS(1299),
    [anon_sym_repeat] = ACTIONS(1301),
    [anon_sym_QMARK] = ACTIONS(1303),
    [anon_sym_TILDE] = ACTIONS(1305),
    [anon_sym_BANG] = ACTIONS(1307),
    [anon_sym_PLUS] = ACTIONS(1309),
    [anon_sym_DASH] = ACTIONS(1311),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(1313),
    [sym__number_literal] = ACTIONS(1315),
    [anon_sym_SQUOTE] = ACTIONS(1317),
    [anon_sym_DQUOTE] = ACTIONS(1319),
    [sym_return] = ACTIONS(1321),
    [sym_next] = ACTIONS(1321),
    [sym_break] = ACTIONS(1321),
    [sym_true] = ACTIONS(1321),
    [sym_false] = ACTIONS(1321),
    [sym_null] = ACTIONS(1321),
    [sym_inf] = ACTIONS(1321),
    [sym_nan] = ACTIONS(1321),
    [anon_sym_NA] = ACTIONS(1323),
    [anon_sym_NA_integer_] = ACTIONS(1323),
    [anon_sym_NA_real_] = ACTIONS(1323),
    [anon_sym_NA_complex_] = ACTIONS(1323),
    [anon_sym_NA_character_] = ACTIONS(1323),
    [sym_dots] = ACTIONS(1321),
    [sym_dot_dot_i] = ACTIONS(1325),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(1327),
    [sym__semicolon] = ACTIONS(1327),
    [sym__raw_string_literal] = ACTIONS(1329),
    [sym__external_open_parenthesis] = ACTIONS(1331),
    [sym__external_open_brace] = ACTIONS(1333),
    [sym__external_close_brace] = ACTIONS(1650),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_close_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [122] = {
    [sym_function_definition] = STATE(682),
    [sym_if_statement] = STATE(682),
    [sym_for_statement] = STATE(682),
    [sym_while_statement] = STATE(682),
    [sym_repeat_statement] = STATE(682),
    [sym_braced_expression] = STATE(682),
    [sym_parenthesized_expression] = STATE(682),
    [sym_call] = STATE(682),
    [sym_subset] = STATE(682),
    [sym_subset2] = STATE(682),
    [sym_unary_operator] = STATE(682),
    [sym_binary_operator] = STATE(682),
    [sym_extract_operator] = STATE(682),
    [sym_namespace_operator] = STATE(682),
    [sym_integer] = STATE(682),
    [sym_complex] = STATE(682),
    [sym_float] = STATE(682),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(682),
    [sym__expression] = STATE(682),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [anon_sym_LT_LT_DASH] = ACTIONS(453),
    [anon_sym_COLON_EQ] = ACTIONS(453),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(453),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [aux_sym_binary_operator_token1] = ACTIONS(453),
    [anon_sym_PIPE_GT] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(453),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1652),
    [sym_next] = ACTIONS(1652),
    [sym_break] = ACTIONS(1652),
    [sym_true] = ACTIONS(1652),
    [sym_false] = ACTIONS(1652),
    [sym_null] = ACTIONS(1652),
    [sym_inf] = ACTIONS(1652),
    [sym_nan] = ACTIONS(1652),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1652),
    [sym_dot_dot_i] = ACTIONS(1654),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(453),
    [sym__external_close_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(453),
  },
  [123] = {
    [sym_function_definition] = STATE(917),
    [sym_if_statement] = STATE(917),
    [sym_for_statement] = STATE(917),
    [sym_while_statement] = STATE(917),
    [sym_repeat_statement] = STATE(917),
    [sym_braced_expression] = STATE(917),
    [sym_parenthesized_expression] = STATE(917),
    [sym_call] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_unary_operator] = STATE(917),
    [sym_binary_operator] = STATE(917),
    [sym_extract_operator] = STATE(917),
    [sym_namespace_operator] = STATE(917),
    [sym_integer] = STATE(917),
    [sym_complex] = STATE(917),
    [sym_float] = STATE(917),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_parenthesized_expression_repeat1] = STATE(123),
    [sym_identifier] = ACTIONS(1656),
    [anon_sym_BSLASH] = ACTIONS(1659),
    [anon_sym_function] = ACTIONS(1662),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(1665),
    [anon_sym_for] = ACTIONS(1668),
    [anon_sym_while] = ACTIONS(1671),
    [anon_sym_repeat] = ACTIONS(1674),
    [anon_sym_QMARK] = ACTIONS(1677),
    [anon_sym_TILDE] = ACTIONS(1680),
    [anon_sym_BANG] = ACTIONS(1683),
    [anon_sym_PLUS] = ACTIONS(1686),
    [anon_sym_DASH] = ACTIONS(1689),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(1692),
    [sym__number_literal] = ACTIONS(1695),
    [anon_sym_SQUOTE] = ACTIONS(1698),
    [anon_sym_DQUOTE] = ACTIONS(1701),
    [sym_return] = ACTIONS(1704),
    [sym_next] = ACTIONS(1704),
    [sym_break] = ACTIONS(1704),
    [sym_true] = ACTIONS(1704),
    [sym_false] = ACTIONS(1704),
    [sym_null] = ACTIONS(1704),
    [sym_inf] = ACTIONS(1704),
    [sym_nan] = ACTIONS(1704),
    [anon_sym_NA] = ACTIONS(1707),
    [anon_sym_NA_integer_] = ACTIONS(1707),
    [anon_sym_NA_real_] = ACTIONS(1707),
    [anon_sym_NA_complex_] = ACTIONS(1707),
    [anon_sym_NA_character_] = ACTIONS(1707),
    [sym_dots] = ACTIONS(1704),
    [sym_dot_dot_i] = ACTIONS(1710),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(1713),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(1716),
    [sym__external_open_parenthesis] = ACTIONS(1719),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(1722),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_close_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
  },
  [124] = {
    [sym_function_definition] = STATE(921),
    [sym_if_statement] = STATE(921),
    [sym_for_statement] = STATE(921),
    [sym_while_statement] = STATE(921),
    [sym_repeat_statement] = STATE(921),
    [sym_braced_expression] = STATE(921),
    [sym_parenthesized_expression] = STATE(921),
    [sym_call] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_unary_operator] = STATE(921),
    [sym_binary_operator] = STATE(921),
    [sym_extract_operator] = STATE(921),
    [sym_namespace_operator] = STATE(921),
    [sym_integer] = STATE(921),
    [sym_complex] = STATE(921),
    [sym_float] = STATE(921),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_braced_expression_repeat1] = STATE(124),
    [sym_identifier] = ACTIONS(1725),
    [anon_sym_BSLASH] = ACTIONS(1728),
    [anon_sym_function] = ACTIONS(1731),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(1734),
    [anon_sym_for] = ACTIONS(1737),
    [anon_sym_while] = ACTIONS(1740),
    [anon_sym_repeat] = ACTIONS(1743),
    [anon_sym_QMARK] = ACTIONS(1746),
    [anon_sym_TILDE] = ACTIONS(1749),
    [anon_sym_BANG] = ACTIONS(1752),
    [anon_sym_PLUS] = ACTIONS(1755),
    [anon_sym_DASH] = ACTIONS(1758),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(1761),
    [sym__number_literal] = ACTIONS(1764),
    [anon_sym_SQUOTE] = ACTIONS(1767),
    [anon_sym_DQUOTE] = ACTIONS(1770),
    [sym_return] = ACTIONS(1773),
    [sym_next] = ACTIONS(1773),
    [sym_break] = ACTIONS(1773),
    [sym_true] = ACTIONS(1773),
    [sym_false] = ACTIONS(1773),
    [sym_null] = ACTIONS(1773),
    [sym_inf] = ACTIONS(1773),
    [sym_nan] = ACTIONS(1773),
    [anon_sym_NA] = ACTIONS(1776),
    [anon_sym_NA_integer_] = ACTIONS(1776),
    [anon_sym_NA_real_] = ACTIONS(1776),
    [anon_sym_NA_complex_] = ACTIONS(1776),
    [anon_sym_NA_character_] = ACTIONS(1776),
    [sym_dots] = ACTIONS(1773),
    [sym_dot_dot_i] = ACTIONS(1779),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(1782),
    [sym__semicolon] = ACTIONS(1782),
    [sym__raw_string_literal] = ACTIONS(1785),
    [sym__external_open_parenthesis] = ACTIONS(1788),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(1791),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
    [sym__external_close_bracket2] = ACTIONS(591),
  },
  [125] = {
    [sym_function_definition] = STATE(681),
    [sym_if_statement] = STATE(681),
    [sym_for_statement] = STATE(681),
    [sym_while_statement] = STATE(681),
    [sym_repeat_statement] = STATE(681),
    [sym_braced_expression] = STATE(681),
    [sym_parenthesized_expression] = STATE(681),
    [sym_call] = STATE(681),
    [sym_subset] = STATE(681),
    [sym_subset2] = STATE(681),
    [sym_unary_operator] = STATE(681),
    [sym_binary_operator] = STATE(681),
    [sym_extract_operator] = STATE(681),
    [sym_namespace_operator] = STATE(681),
    [sym_integer] = STATE(681),
    [sym_complex] = STATE(681),
    [sym_float] = STATE(681),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(681),
    [sym__expression] = STATE(681),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(127),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(461),
    [anon_sym_LT_LT_DASH] = ACTIONS(461),
    [anon_sym_COLON_EQ] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_DASH_GT_GT] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [aux_sym_binary_operator_token1] = ACTIONS(461),
    [anon_sym_PIPE_GT] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_DOLLAR] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(461),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1794),
    [sym_next] = ACTIONS(1794),
    [sym_break] = ACTIONS(1794),
    [sym_true] = ACTIONS(1794),
    [sym_false] = ACTIONS(1794),
    [sym_null] = ACTIONS(1794),
    [sym_inf] = ACTIONS(1794),
    [sym_nan] = ACTIONS(1794),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1794),
    [sym_dot_dot_i] = ACTIONS(1796),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(1798),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(461),
    [sym__external_close_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(461),
  },
  [126] = {
    [sym_function_definition] = STATE(791),
    [sym_if_statement] = STATE(791),
    [sym_for_statement] = STATE(791),
    [sym_while_statement] = STATE(791),
    [sym_repeat_statement] = STATE(791),
    [sym_braced_expression] = STATE(791),
    [sym_parenthesized_expression] = STATE(791),
    [sym_call] = STATE(791),
    [sym_subset] = STATE(791),
    [sym_subset2] = STATE(791),
    [sym_unary_operator] = STATE(791),
    [sym_binary_operator] = STATE(791),
    [sym_extract_operator] = STATE(791),
    [sym_namespace_operator] = STATE(791),
    [sym_integer] = STATE(791),
    [sym_complex] = STATE(791),
    [sym_float] = STATE(791),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(791),
    [sym__expression] = STATE(791),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__close_parenthesis] = STATE(2843),
    [sym__open_brace] = STATE(24),
    [aux_sym_parenthesized_expression_repeat1] = STATE(139),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(211),
    [anon_sym_LT_LT_DASH] = ACTIONS(211),
    [anon_sym_COLON_EQ] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(209),
    [anon_sym_DASH_GT_GT] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(209),
    [anon_sym_PIPE_PIPE] = ACTIONS(211),
    [anon_sym_AMP_AMP] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(209),
    [anon_sym_LT_EQ] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(209),
    [anon_sym_GT_EQ] = ACTIONS(211),
    [anon_sym_EQ_EQ] = ACTIONS(211),
    [anon_sym_BANG_EQ] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(209),
    [anon_sym_SLASH] = ACTIONS(211),
    [anon_sym_STAR_STAR] = ACTIONS(211),
    [anon_sym_CARET] = ACTIONS(211),
    [aux_sym_binary_operator_token1] = ACTIONS(211),
    [anon_sym_PIPE_GT] = ACTIONS(211),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [anon_sym_AT] = ACTIONS(211),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(971),
    [sym_next] = ACTIONS(971),
    [sym_break] = ACTIONS(971),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_inf] = ACTIONS(971),
    [sym_nan] = ACTIONS(971),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(971),
    [sym_dot_dot_i] = ACTIONS(973),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(975),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(1800),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(211),
    [sym__external_open_bracket2] = ACTIONS(211),
  },
  [127] = {
    [sym_function_definition] = STATE(679),
    [sym_if_statement] = STATE(679),
    [sym_for_statement] = STATE(679),
    [sym_while_statement] = STATE(679),
    [sym_repeat_statement] = STATE(679),
    [sym_braced_expression] = STATE(679),
    [sym_parenthesized_expression] = STATE(679),
    [sym_call] = STATE(679),
    [sym_subset] = STATE(679),
    [sym_subset2] = STATE(679),
    [sym_unary_operator] = STATE(679),
    [sym_binary_operator] = STATE(679),
    [sym_extract_operator] = STATE(679),
    [sym_namespace_operator] = STATE(679),
    [sym_integer] = STATE(679),
    [sym_complex] = STATE(679),
    [sym_float] = STATE(679),
    [sym__hex_literal] = STATE(2189),
    [sym__float_literal] = STATE(2189),
    [sym_string] = STATE(2192),
    [sym__single_quoted_string] = STATE(2188),
    [sym__double_quoted_string] = STATE(2187),
    [sym_na] = STATE(679),
    [sym__expression] = STATE(679),
    [sym__string_or_identifier] = STATE(5139),
    [sym__open_parenthesis] = STATE(57),
    [sym__open_brace] = STATE(59),
    [aux_sym_function_definition_repeat1] = STATE(2336),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_BSLASH] = ACTIONS(275),
    [anon_sym_function] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_repeat] = ACTIONS(285),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(295),
    [anon_sym_LT_DASH] = ACTIONS(471),
    [anon_sym_LT_LT_DASH] = ACTIONS(471),
    [anon_sym_COLON_EQ] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_GT] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(471),
    [aux_sym_binary_operator_token1] = ACTIONS(471),
    [anon_sym_PIPE_GT] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(471),
    [aux_sym__hex_literal_token1] = ACTIONS(297),
    [sym__number_literal] = ACTIONS(299),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(303),
    [sym_return] = ACTIONS(1802),
    [sym_next] = ACTIONS(1802),
    [sym_break] = ACTIONS(1802),
    [sym_true] = ACTIONS(1802),
    [sym_false] = ACTIONS(1802),
    [sym_null] = ACTIONS(1802),
    [sym_inf] = ACTIONS(1802),
    [sym_nan] = ACTIONS(1802),
    [anon_sym_NA] = ACTIONS(307),
    [anon_sym_NA_integer_] = ACTIONS(307),
    [anon_sym_NA_real_] = ACTIONS(307),
    [anon_sym_NA_complex_] = ACTIONS(307),
    [anon_sym_NA_character_] = ACTIONS(307),
    [sym_dots] = ACTIONS(1802),
    [sym_dot_dot_i] = ACTIONS(1804),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(471),
    [sym__newline] = ACTIONS(471),
    [sym__semicolon] = ACTIONS(471),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(315),
    [sym__external_close_parenthesis] = ACTIONS(471),
    [sym__external_open_brace] = ACTIONS(319),
    [sym__external_close_brace] = ACTIONS(471),
    [sym__external_open_bracket] = ACTIONS(471),
    [sym__external_close_bracket] = ACTIONS(471),
    [sym__external_open_bracket2] = ACTIONS(471),
  },
  [128] = {
    [sym_function_definition] = STATE(678),
    [sym_if_statement] = STATE(678),
    [sym_for_statement] = STATE(678),
    [sym_while_statement] = STATE(678),
    [sym_repeat_statement] = STATE(678),
    [sym_braced_expression] = STATE(678),
    [sym_parenthesized_expression] = STATE(678),
    [sym_call] = STATE(678),
    [sym_subset] = STATE(678),
    [sym_subset2] = STATE(678),
    [sym_unary_operator] = STATE(678),
    [sym_binary_operator] = STATE(678),
    [sym_extract_operator] = STATE(678),
    [sym_namespace_operator] = STATE(678),
    [sym_integer] = STATE(678),
    [sym_complex] = STATE(678),
    [sym_float] = STATE(678),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(678),
    [sym__expression] = STATE(678),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(130),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(263),
    [anon_sym_COLON_EQ] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_DASH_GT_GT] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_STAR_STAR] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(263),
    [aux_sym_binary_operator_token1] = ACTIONS(263),
    [anon_sym_PIPE_GT] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1806),
    [sym_next] = ACTIONS(1806),
    [sym_break] = ACTIONS(1806),
    [sym_true] = ACTIONS(1806),
    [sym_false] = ACTIONS(1806),
    [sym_null] = ACTIONS(1806),
    [sym_inf] = ACTIONS(1806),
    [sym_nan] = ACTIONS(1806),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1806),
    [sym_dot_dot_i] = ACTIONS(1808),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(263),
    [sym__newline] = ACTIONS(1810),
    [sym__semicolon] = ACTIONS(263),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(263),
    [sym__external_open_bracket] = ACTIONS(263),
    [sym__external_open_bracket2] = ACTIONS(263),
    [sym__external_close_bracket2] = ACTIONS(263),
  },
  [129] = {
    [sym_function_definition] = STATE(688),
    [sym_if_statement] = STATE(688),
    [sym_for_statement] = STATE(688),
    [sym_while_statement] = STATE(688),
    [sym_repeat_statement] = STATE(688),
    [sym_braced_expression] = STATE(688),
    [sym_parenthesized_expression] = STATE(688),
    [sym_call] = STATE(688),
    [sym_subset] = STATE(688),
    [sym_subset2] = STATE(688),
    [sym_unary_operator] = STATE(688),
    [sym_binary_operator] = STATE(688),
    [sym_extract_operator] = STATE(688),
    [sym_namespace_operator] = STATE(688),
    [sym_integer] = STATE(688),
    [sym_complex] = STATE(688),
    [sym_float] = STATE(688),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(688),
    [sym__expression] = STATE(688),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(131),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(545),
    [anon_sym_LT_LT_DASH] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(543),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [aux_sym_binary_operator_token1] = ACTIONS(545),
    [anon_sym_PIPE_GT] = ACTIONS(545),
    [anon_sym_COLON] = ACTIONS(543),
    [anon_sym_DOLLAR] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(545),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1812),
    [sym_next] = ACTIONS(1812),
    [sym_break] = ACTIONS(1812),
    [sym_true] = ACTIONS(1812),
    [sym_false] = ACTIONS(1812),
    [sym_null] = ACTIONS(1812),
    [sym_inf] = ACTIONS(1812),
    [sym_nan] = ACTIONS(1812),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1812),
    [sym_dot_dot_i] = ACTIONS(1814),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(1816),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(545),
    [sym__external_close_bracket2] = ACTIONS(545),
  },
  [130] = {
    [sym_function_definition] = STATE(691),
    [sym_if_statement] = STATE(691),
    [sym_for_statement] = STATE(691),
    [sym_while_statement] = STATE(691),
    [sym_repeat_statement] = STATE(691),
    [sym_braced_expression] = STATE(691),
    [sym_parenthesized_expression] = STATE(691),
    [sym_call] = STATE(691),
    [sym_subset] = STATE(691),
    [sym_subset2] = STATE(691),
    [sym_unary_operator] = STATE(691),
    [sym_binary_operator] = STATE(691),
    [sym_extract_operator] = STATE(691),
    [sym_namespace_operator] = STATE(691),
    [sym_integer] = STATE(691),
    [sym_complex] = STATE(691),
    [sym_float] = STATE(691),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(691),
    [sym__expression] = STATE(691),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_COLON_EQ] = ACTIONS(765),
    [anon_sym_DASH_GT] = ACTIONS(767),
    [anon_sym_DASH_GT_GT] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_AMP] = ACTIONS(767),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_EQ] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_EQ] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [anon_sym_STAR] = ACTIONS(767),
    [anon_sym_SLASH] = ACTIONS(765),
    [anon_sym_STAR_STAR] = ACTIONS(765),
    [anon_sym_CARET] = ACTIONS(765),
    [aux_sym_binary_operator_token1] = ACTIONS(765),
    [anon_sym_PIPE_GT] = ACTIONS(765),
    [anon_sym_COLON] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(765),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1818),
    [sym_next] = ACTIONS(1818),
    [sym_break] = ACTIONS(1818),
    [sym_true] = ACTIONS(1818),
    [sym_false] = ACTIONS(1818),
    [sym_null] = ACTIONS(1818),
    [sym_inf] = ACTIONS(1818),
    [sym_nan] = ACTIONS(1818),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1818),
    [sym_dot_dot_i] = ACTIONS(1820),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(765),
    [sym__newline] = ACTIONS(765),
    [sym__semicolon] = ACTIONS(765),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(765),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(765),
    [sym__external_open_bracket] = ACTIONS(765),
    [sym__external_open_bracket2] = ACTIONS(765),
    [sym__external_close_bracket2] = ACTIONS(765),
  },
  [131] = {
    [sym_function_definition] = STATE(729),
    [sym_if_statement] = STATE(729),
    [sym_for_statement] = STATE(729),
    [sym_while_statement] = STATE(729),
    [sym_repeat_statement] = STATE(729),
    [sym_braced_expression] = STATE(729),
    [sym_parenthesized_expression] = STATE(729),
    [sym_call] = STATE(729),
    [sym_subset] = STATE(729),
    [sym_subset2] = STATE(729),
    [sym_unary_operator] = STATE(729),
    [sym_binary_operator] = STATE(729),
    [sym_extract_operator] = STATE(729),
    [sym_namespace_operator] = STATE(729),
    [sym_integer] = STATE(729),
    [sym_complex] = STATE(729),
    [sym_float] = STATE(729),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(729),
    [sym__expression] = STATE(729),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(757),
    [anon_sym_LT_LT_DASH] = ACTIONS(757),
    [anon_sym_COLON_EQ] = ACTIONS(757),
    [anon_sym_DASH_GT] = ACTIONS(759),
    [anon_sym_DASH_GT_GT] = ACTIONS(757),
    [anon_sym_PIPE] = ACTIONS(759),
    [anon_sym_AMP] = ACTIONS(759),
    [anon_sym_PIPE_PIPE] = ACTIONS(757),
    [anon_sym_AMP_AMP] = ACTIONS(757),
    [anon_sym_LT] = ACTIONS(759),
    [anon_sym_LT_EQ] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(759),
    [anon_sym_GT_EQ] = ACTIONS(757),
    [anon_sym_EQ_EQ] = ACTIONS(757),
    [anon_sym_BANG_EQ] = ACTIONS(757),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_SLASH] = ACTIONS(757),
    [anon_sym_STAR_STAR] = ACTIONS(757),
    [anon_sym_CARET] = ACTIONS(757),
    [aux_sym_binary_operator_token1] = ACTIONS(757),
    [anon_sym_PIPE_GT] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(759),
    [anon_sym_DOLLAR] = ACTIONS(757),
    [anon_sym_AT] = ACTIONS(757),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1822),
    [sym_next] = ACTIONS(1822),
    [sym_break] = ACTIONS(1822),
    [sym_true] = ACTIONS(1822),
    [sym_false] = ACTIONS(1822),
    [sym_null] = ACTIONS(1822),
    [sym_inf] = ACTIONS(1822),
    [sym_nan] = ACTIONS(1822),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1822),
    [sym_dot_dot_i] = ACTIONS(1824),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(757),
    [sym__newline] = ACTIONS(757),
    [sym__semicolon] = ACTIONS(757),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(757),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(757),
    [sym__external_open_bracket] = ACTIONS(757),
    [sym__external_open_bracket2] = ACTIONS(757),
    [sym__external_close_bracket2] = ACTIONS(757),
  },
  [132] = {
    [sym_function_definition] = STATE(757),
    [sym_if_statement] = STATE(757),
    [sym_for_statement] = STATE(757),
    [sym_while_statement] = STATE(757),
    [sym_repeat_statement] = STATE(757),
    [sym_braced_expression] = STATE(757),
    [sym_parenthesized_expression] = STATE(757),
    [sym_call] = STATE(757),
    [sym_subset] = STATE(757),
    [sym_subset2] = STATE(757),
    [sym_unary_operator] = STATE(757),
    [sym_binary_operator] = STATE(757),
    [sym_extract_operator] = STATE(757),
    [sym_namespace_operator] = STATE(757),
    [sym_integer] = STATE(757),
    [sym_complex] = STATE(757),
    [sym_float] = STATE(757),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(757),
    [sym__expression] = STATE(757),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(134),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(531),
    [anon_sym_LT_LT_DASH] = ACTIONS(531),
    [anon_sym_COLON_EQ] = ACTIONS(531),
    [anon_sym_DASH_GT] = ACTIONS(533),
    [anon_sym_DASH_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [aux_sym_binary_operator_token1] = ACTIONS(531),
    [anon_sym_PIPE_GT] = ACTIONS(531),
    [anon_sym_COLON] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1826),
    [sym_next] = ACTIONS(1826),
    [sym_break] = ACTIONS(1826),
    [sym_true] = ACTIONS(1826),
    [sym_false] = ACTIONS(1826),
    [sym_null] = ACTIONS(1826),
    [sym_inf] = ACTIONS(1826),
    [sym_nan] = ACTIONS(1826),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1826),
    [sym_dot_dot_i] = ACTIONS(1828),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(1830),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(531),
    [sym__external_close_bracket2] = ACTIONS(531),
  },
  [133] = {
    [sym_function_definition] = STATE(1072),
    [sym_if_statement] = STATE(1072),
    [sym_for_statement] = STATE(1072),
    [sym_while_statement] = STATE(1072),
    [sym_repeat_statement] = STATE(1072),
    [sym_braced_expression] = STATE(1072),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_call] = STATE(1072),
    [sym_subset] = STATE(1072),
    [sym_subset2] = STATE(1072),
    [sym_unary_operator] = STATE(1072),
    [sym_binary_operator] = STATE(1072),
    [sym_extract_operator] = STATE(1072),
    [sym_namespace_operator] = STATE(1072),
    [sym_integer] = STATE(1072),
    [sym_complex] = STATE(1072),
    [sym_float] = STATE(1072),
    [sym__hex_literal] = STATE(2311),
    [sym__float_literal] = STATE(2311),
    [sym_string] = STATE(2312),
    [sym__single_quoted_string] = STATE(2310),
    [sym__double_quoted_string] = STATE(2309),
    [sym_na] = STATE(1072),
    [sym__expression] = STATE(1072),
    [sym__string_or_identifier] = STATE(5134),
    [sym__open_parenthesis] = STATE(64),
    [sym__open_brace] = STATE(199),
    [sym__close_brace] = STATE(2865),
    [aux_sym_braced_expression_repeat1] = STATE(105),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(1385),
    [anon_sym_BSLASH] = ACTIONS(1387),
    [anon_sym_function] = ACTIONS(1389),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(1391),
    [anon_sym_for] = ACTIONS(1393),
    [anon_sym_while] = ACTIONS(1395),
    [anon_sym_repeat] = ACTIONS(1397),
    [anon_sym_QMARK] = ACTIONS(1399),
    [anon_sym_TILDE] = ACTIONS(1401),
    [anon_sym_BANG] = ACTIONS(1403),
    [anon_sym_PLUS] = ACTIONS(1405),
    [anon_sym_DASH] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(155),
    [anon_sym_LT_LT_DASH] = ACTIONS(155),
    [anon_sym_COLON_EQ] = ACTIONS(155),
    [anon_sym_DASH_GT] = ACTIONS(157),
    [anon_sym_DASH_GT_GT] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_PIPE_PIPE] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(155),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_EQ] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_EQ_EQ] = ACTIONS(155),
    [anon_sym_BANG_EQ] = ACTIONS(155),
    [anon_sym_STAR] = ACTIONS(157),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_STAR_STAR] = ACTIONS(155),
    [anon_sym_CARET] = ACTIONS(155),
    [aux_sym_binary_operator_token1] = ACTIONS(155),
    [anon_sym_PIPE_GT] = ACTIONS(155),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(155),
    [aux_sym__hex_literal_token1] = ACTIONS(1409),
    [sym__number_literal] = ACTIONS(1411),
    [anon_sym_SQUOTE] = ACTIONS(1413),
    [anon_sym_DQUOTE] = ACTIONS(1415),
    [sym_return] = ACTIONS(1417),
    [sym_next] = ACTIONS(1417),
    [sym_break] = ACTIONS(1417),
    [sym_true] = ACTIONS(1417),
    [sym_false] = ACTIONS(1417),
    [sym_null] = ACTIONS(1417),
    [sym_inf] = ACTIONS(1417),
    [sym_nan] = ACTIONS(1417),
    [anon_sym_NA] = ACTIONS(1419),
    [anon_sym_NA_integer_] = ACTIONS(1419),
    [anon_sym_NA_real_] = ACTIONS(1419),
    [anon_sym_NA_complex_] = ACTIONS(1419),
    [anon_sym_NA_character_] = ACTIONS(1419),
    [sym_dots] = ACTIONS(1417),
    [sym_dot_dot_i] = ACTIONS(1421),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(1423),
    [sym__semicolon] = ACTIONS(1423),
    [sym__raw_string_literal] = ACTIONS(1425),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(1427),
    [sym__external_open_brace] = ACTIONS(1429),
    [sym__external_close_brace] = ACTIONS(1832),
    [sym__external_open_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(155),
  },
  [134] = {
    [sym_function_definition] = STATE(758),
    [sym_if_statement] = STATE(758),
    [sym_for_statement] = STATE(758),
    [sym_while_statement] = STATE(758),
    [sym_repeat_statement] = STATE(758),
    [sym_braced_expression] = STATE(758),
    [sym_parenthesized_expression] = STATE(758),
    [sym_call] = STATE(758),
    [sym_subset] = STATE(758),
    [sym_subset2] = STATE(758),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(758),
    [sym_extract_operator] = STATE(758),
    [sym_namespace_operator] = STATE(758),
    [sym_integer] = STATE(758),
    [sym_complex] = STATE(758),
    [sym_float] = STATE(758),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(758),
    [sym__expression] = STATE(758),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1834),
    [sym_next] = ACTIONS(1834),
    [sym_break] = ACTIONS(1834),
    [sym_true] = ACTIONS(1834),
    [sym_false] = ACTIONS(1834),
    [sym_null] = ACTIONS(1834),
    [sym_inf] = ACTIONS(1834),
    [sym_nan] = ACTIONS(1834),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1834),
    [sym_dot_dot_i] = ACTIONS(1836),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [135] = {
    [sym_function_definition] = STATE(759),
    [sym_if_statement] = STATE(759),
    [sym_for_statement] = STATE(759),
    [sym_while_statement] = STATE(759),
    [sym_repeat_statement] = STATE(759),
    [sym_braced_expression] = STATE(759),
    [sym_parenthesized_expression] = STATE(759),
    [sym_call] = STATE(759),
    [sym_subset] = STATE(759),
    [sym_subset2] = STATE(759),
    [sym_unary_operator] = STATE(759),
    [sym_binary_operator] = STATE(759),
    [sym_extract_operator] = STATE(759),
    [sym_namespace_operator] = STATE(759),
    [sym_integer] = STATE(759),
    [sym_complex] = STATE(759),
    [sym_float] = STATE(759),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(759),
    [sym__expression] = STATE(759),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(140),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(377),
    [anon_sym_LT_LT_DASH] = ACTIONS(377),
    [anon_sym_COLON_EQ] = ACTIONS(377),
    [anon_sym_DASH_GT] = ACTIONS(379),
    [anon_sym_DASH_GT_GT] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(377),
    [anon_sym_LT] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(377),
    [anon_sym_BANG_EQ] = ACTIONS(377),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_STAR_STAR] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [aux_sym_binary_operator_token1] = ACTIONS(377),
    [anon_sym_PIPE_GT] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(377),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1838),
    [sym_next] = ACTIONS(1838),
    [sym_break] = ACTIONS(1838),
    [sym_true] = ACTIONS(1838),
    [sym_false] = ACTIONS(1838),
    [sym_null] = ACTIONS(1838),
    [sym_inf] = ACTIONS(1838),
    [sym_nan] = ACTIONS(1838),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1838),
    [sym_dot_dot_i] = ACTIONS(1840),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(377),
    [sym__newline] = ACTIONS(1842),
    [sym__semicolon] = ACTIONS(377),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(377),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(377),
    [sym__external_open_bracket] = ACTIONS(377),
    [sym__external_open_bracket2] = ACTIONS(377),
    [sym__external_close_bracket2] = ACTIONS(377),
  },
  [136] = {
    [sym_function_definition] = STATE(1152),
    [sym_if_statement] = STATE(1152),
    [sym_for_statement] = STATE(1152),
    [sym_while_statement] = STATE(1152),
    [sym_repeat_statement] = STATE(1152),
    [sym_braced_expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(1152),
    [sym_call] = STATE(1152),
    [sym_subset] = STATE(1152),
    [sym_subset2] = STATE(1152),
    [sym_unary_operator] = STATE(1152),
    [sym_binary_operator] = STATE(1152),
    [sym_extract_operator] = STATE(1152),
    [sym_namespace_operator] = STATE(1152),
    [sym_integer] = STATE(1152),
    [sym_complex] = STATE(1152),
    [sym_float] = STATE(1152),
    [sym__hex_literal] = STATE(2235),
    [sym__float_literal] = STATE(2235),
    [sym_string] = STATE(2234),
    [sym__single_quoted_string] = STATE(2236),
    [sym__double_quoted_string] = STATE(2237),
    [sym_na] = STATE(1152),
    [sym__expression] = STATE(1152),
    [sym__string_or_identifier] = STATE(5150),
    [sym__open_parenthesis] = STATE(76),
    [sym__open_brace] = STATE(188),
    [sym__close_brace] = STATE(2964),
    [aux_sym_braced_expression_repeat1] = STATE(262),
    [sym_identifier] = ACTIONS(1433),
    [anon_sym_BSLASH] = ACTIONS(1435),
    [anon_sym_function] = ACTIONS(1437),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1441),
    [anon_sym_while] = ACTIONS(1443),
    [anon_sym_repeat] = ACTIONS(1445),
    [anon_sym_QMARK] = ACTIONS(1447),
    [anon_sym_TILDE] = ACTIONS(1449),
    [anon_sym_BANG] = ACTIONS(1451),
    [anon_sym_PLUS] = ACTIONS(1453),
    [anon_sym_DASH] = ACTIONS(1455),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(1457),
    [sym__number_literal] = ACTIONS(1459),
    [anon_sym_SQUOTE] = ACTIONS(1461),
    [anon_sym_DQUOTE] = ACTIONS(1463),
    [sym_return] = ACTIONS(1465),
    [sym_next] = ACTIONS(1465),
    [sym_break] = ACTIONS(1465),
    [sym_true] = ACTIONS(1465),
    [sym_false] = ACTIONS(1465),
    [sym_null] = ACTIONS(1465),
    [sym_inf] = ACTIONS(1465),
    [sym_nan] = ACTIONS(1465),
    [anon_sym_NA] = ACTIONS(1467),
    [anon_sym_NA_integer_] = ACTIONS(1467),
    [anon_sym_NA_real_] = ACTIONS(1467),
    [anon_sym_NA_complex_] = ACTIONS(1467),
    [anon_sym_NA_character_] = ACTIONS(1467),
    [sym_dots] = ACTIONS(1465),
    [sym_dot_dot_i] = ACTIONS(1469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(1471),
    [sym__semicolon] = ACTIONS(1471),
    [sym__raw_string_literal] = ACTIONS(1473),
    [sym__external_open_parenthesis] = ACTIONS(1475),
    [sym__external_open_brace] = ACTIONS(1477),
    [sym__external_close_brace] = ACTIONS(1844),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
    [sym__external_close_bracket2] = ACTIONS(51),
  },
  [137] = {
    [sym_function_definition] = STATE(761),
    [sym_if_statement] = STATE(761),
    [sym_for_statement] = STATE(761),
    [sym_while_statement] = STATE(761),
    [sym_repeat_statement] = STATE(761),
    [sym_braced_expression] = STATE(761),
    [sym_parenthesized_expression] = STATE(761),
    [sym_call] = STATE(761),
    [sym_subset] = STATE(761),
    [sym_subset2] = STATE(761),
    [sym_unary_operator] = STATE(761),
    [sym_binary_operator] = STATE(761),
    [sym_extract_operator] = STATE(761),
    [sym_namespace_operator] = STATE(761),
    [sym_integer] = STATE(761),
    [sym_complex] = STATE(761),
    [sym_float] = STATE(761),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(761),
    [sym__expression] = STATE(761),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(141),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(387),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [aux_sym_binary_operator_token1] = ACTIONS(387),
    [anon_sym_PIPE_GT] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_DOLLAR] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1846),
    [sym_next] = ACTIONS(1846),
    [sym_break] = ACTIONS(1846),
    [sym_true] = ACTIONS(1846),
    [sym_false] = ACTIONS(1846),
    [sym_null] = ACTIONS(1846),
    [sym_inf] = ACTIONS(1846),
    [sym_nan] = ACTIONS(1846),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1846),
    [sym_dot_dot_i] = ACTIONS(1848),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(1850),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(387),
    [sym__external_close_bracket2] = ACTIONS(387),
  },
  [138] = {
    [sym_function_definition] = STATE(935),
    [sym_if_statement] = STATE(935),
    [sym_for_statement] = STATE(935),
    [sym_while_statement] = STATE(935),
    [sym_repeat_statement] = STATE(935),
    [sym_braced_expression] = STATE(935),
    [sym_parenthesized_expression] = STATE(935),
    [sym_call] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_unary_operator] = STATE(935),
    [sym_binary_operator] = STATE(935),
    [sym_extract_operator] = STATE(935),
    [sym_namespace_operator] = STATE(935),
    [sym_integer] = STATE(935),
    [sym_complex] = STATE(935),
    [sym_float] = STATE(935),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_parenthesized_expression_repeat1] = STATE(138),
    [sym_identifier] = ACTIONS(1852),
    [anon_sym_BSLASH] = ACTIONS(1855),
    [anon_sym_function] = ACTIONS(1858),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(1861),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1867),
    [anon_sym_repeat] = ACTIONS(1870),
    [anon_sym_QMARK] = ACTIONS(1873),
    [anon_sym_TILDE] = ACTIONS(1876),
    [anon_sym_BANG] = ACTIONS(1879),
    [anon_sym_PLUS] = ACTIONS(1882),
    [anon_sym_DASH] = ACTIONS(1885),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(1888),
    [sym__number_literal] = ACTIONS(1891),
    [anon_sym_SQUOTE] = ACTIONS(1894),
    [anon_sym_DQUOTE] = ACTIONS(1897),
    [sym_return] = ACTIONS(1900),
    [sym_next] = ACTIONS(1900),
    [sym_break] = ACTIONS(1900),
    [sym_true] = ACTIONS(1900),
    [sym_false] = ACTIONS(1900),
    [sym_null] = ACTIONS(1900),
    [sym_inf] = ACTIONS(1900),
    [sym_nan] = ACTIONS(1900),
    [anon_sym_NA] = ACTIONS(1903),
    [anon_sym_NA_integer_] = ACTIONS(1903),
    [anon_sym_NA_real_] = ACTIONS(1903),
    [anon_sym_NA_complex_] = ACTIONS(1903),
    [anon_sym_NA_character_] = ACTIONS(1903),
    [sym_dots] = ACTIONS(1900),
    [sym_dot_dot_i] = ACTIONS(1906),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(1909),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(1912),
    [sym__external_open_parenthesis] = ACTIONS(1915),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(1918),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
    [sym__external_close_bracket2] = ACTIONS(803),
  },
  [139] = {
    [sym_function_definition] = STATE(791),
    [sym_if_statement] = STATE(791),
    [sym_for_statement] = STATE(791),
    [sym_while_statement] = STATE(791),
    [sym_repeat_statement] = STATE(791),
    [sym_braced_expression] = STATE(791),
    [sym_parenthesized_expression] = STATE(791),
    [sym_call] = STATE(791),
    [sym_subset] = STATE(791),
    [sym_subset2] = STATE(791),
    [sym_unary_operator] = STATE(791),
    [sym_binary_operator] = STATE(791),
    [sym_extract_operator] = STATE(791),
    [sym_namespace_operator] = STATE(791),
    [sym_integer] = STATE(791),
    [sym_complex] = STATE(791),
    [sym_float] = STATE(791),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(791),
    [sym__expression] = STATE(791),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [aux_sym_parenthesized_expression_repeat1] = STATE(139),
    [ts_builtin_sym_end] = ACTIONS(803),
    [sym_identifier] = ACTIONS(1921),
    [anon_sym_BSLASH] = ACTIONS(1924),
    [anon_sym_function] = ACTIONS(1927),
    [anon_sym_EQ] = ACTIONS(814),
    [anon_sym_if] = ACTIONS(1930),
    [anon_sym_for] = ACTIONS(1933),
    [anon_sym_while] = ACTIONS(1936),
    [anon_sym_repeat] = ACTIONS(1939),
    [anon_sym_QMARK] = ACTIONS(1942),
    [anon_sym_TILDE] = ACTIONS(1945),
    [anon_sym_BANG] = ACTIONS(1948),
    [anon_sym_PLUS] = ACTIONS(1951),
    [anon_sym_DASH] = ACTIONS(1954),
    [anon_sym_LT_DASH] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(803),
    [anon_sym_COLON_EQ] = ACTIONS(803),
    [anon_sym_DASH_GT] = ACTIONS(814),
    [anon_sym_DASH_GT_GT] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(814),
    [anon_sym_AMP] = ACTIONS(814),
    [anon_sym_PIPE_PIPE] = ACTIONS(803),
    [anon_sym_AMP_AMP] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_LT_EQ] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_GT_EQ] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_BANG_EQ] = ACTIONS(803),
    [anon_sym_STAR] = ACTIONS(814),
    [anon_sym_SLASH] = ACTIONS(803),
    [anon_sym_STAR_STAR] = ACTIONS(803),
    [anon_sym_CARET] = ACTIONS(803),
    [aux_sym_binary_operator_token1] = ACTIONS(803),
    [anon_sym_PIPE_GT] = ACTIONS(803),
    [anon_sym_COLON] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(803),
    [aux_sym__hex_literal_token1] = ACTIONS(1957),
    [sym__number_literal] = ACTIONS(1960),
    [anon_sym_SQUOTE] = ACTIONS(1963),
    [anon_sym_DQUOTE] = ACTIONS(1966),
    [sym_return] = ACTIONS(1969),
    [sym_next] = ACTIONS(1969),
    [sym_break] = ACTIONS(1969),
    [sym_true] = ACTIONS(1969),
    [sym_false] = ACTIONS(1969),
    [sym_null] = ACTIONS(1969),
    [sym_inf] = ACTIONS(1969),
    [sym_nan] = ACTIONS(1969),
    [anon_sym_NA] = ACTIONS(1972),
    [anon_sym_NA_integer_] = ACTIONS(1972),
    [anon_sym_NA_real_] = ACTIONS(1972),
    [anon_sym_NA_complex_] = ACTIONS(1972),
    [anon_sym_NA_character_] = ACTIONS(1972),
    [sym_dots] = ACTIONS(1969),
    [sym_dot_dot_i] = ACTIONS(1975),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(803),
    [sym__newline] = ACTIONS(1978),
    [sym__semicolon] = ACTIONS(803),
    [sym__raw_string_literal] = ACTIONS(1981),
    [sym__external_open_parenthesis] = ACTIONS(1984),
    [sym__external_close_parenthesis] = ACTIONS(803),
    [sym__external_open_brace] = ACTIONS(1987),
    [sym__external_close_brace] = ACTIONS(803),
    [sym__external_open_bracket] = ACTIONS(803),
    [sym__external_open_bracket2] = ACTIONS(803),
  },
  [140] = {
    [sym_function_definition] = STATE(762),
    [sym_if_statement] = STATE(762),
    [sym_for_statement] = STATE(762),
    [sym_while_statement] = STATE(762),
    [sym_repeat_statement] = STATE(762),
    [sym_braced_expression] = STATE(762),
    [sym_parenthesized_expression] = STATE(762),
    [sym_call] = STATE(762),
    [sym_subset] = STATE(762),
    [sym_subset2] = STATE(762),
    [sym_unary_operator] = STATE(762),
    [sym_binary_operator] = STATE(762),
    [sym_extract_operator] = STATE(762),
    [sym_namespace_operator] = STATE(762),
    [sym_integer] = STATE(762),
    [sym_complex] = STATE(762),
    [sym_float] = STATE(762),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(762),
    [sym__expression] = STATE(762),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(397),
    [anon_sym_LT_LT_DASH] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_STAR_STAR] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [aux_sym_binary_operator_token1] = ACTIONS(397),
    [anon_sym_PIPE_GT] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(397),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1990),
    [sym_next] = ACTIONS(1990),
    [sym_break] = ACTIONS(1990),
    [sym_true] = ACTIONS(1990),
    [sym_false] = ACTIONS(1990),
    [sym_null] = ACTIONS(1990),
    [sym_inf] = ACTIONS(1990),
    [sym_nan] = ACTIONS(1990),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1990),
    [sym_dot_dot_i] = ACTIONS(1992),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(397),
    [sym__newline] = ACTIONS(397),
    [sym__semicolon] = ACTIONS(397),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(397),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(397),
    [sym__external_open_bracket] = ACTIONS(397),
    [sym__external_open_bracket2] = ACTIONS(397),
    [sym__external_close_bracket2] = ACTIONS(397),
  },
  [141] = {
    [sym_function_definition] = STATE(765),
    [sym_if_statement] = STATE(765),
    [sym_for_statement] = STATE(765),
    [sym_while_statement] = STATE(765),
    [sym_repeat_statement] = STATE(765),
    [sym_braced_expression] = STATE(765),
    [sym_parenthesized_expression] = STATE(765),
    [sym_call] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_unary_operator] = STATE(765),
    [sym_binary_operator] = STATE(765),
    [sym_extract_operator] = STATE(765),
    [sym_namespace_operator] = STATE(765),
    [sym_integer] = STATE(765),
    [sym_complex] = STATE(765),
    [sym_float] = STATE(765),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [anon_sym_LT_LT_DASH] = ACTIONS(453),
    [anon_sym_COLON_EQ] = ACTIONS(453),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(453),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [aux_sym_binary_operator_token1] = ACTIONS(453),
    [anon_sym_PIPE_GT] = ACTIONS(453),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(453),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(1994),
    [sym_next] = ACTIONS(1994),
    [sym_break] = ACTIONS(1994),
    [sym_true] = ACTIONS(1994),
    [sym_false] = ACTIONS(1994),
    [sym_null] = ACTIONS(1994),
    [sym_inf] = ACTIONS(1994),
    [sym_nan] = ACTIONS(1994),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(1994),
    [sym_dot_dot_i] = ACTIONS(1996),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(453),
    [sym__external_close_bracket2] = ACTIONS(453),
  },
  [142] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [sym__close_brace] = STATE(4720),
    [aux_sym_braced_expression_repeat1] = STATE(145),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(353),
    [sym_next] = ACTIONS(353),
    [sym_break] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_null] = ACTIONS(353),
    [sym_inf] = ACTIONS(353),
    [sym_nan] = ACTIONS(353),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS(355),
    [anon_sym_NA_character_] = ACTIONS(355),
    [sym_dots] = ACTIONS(353),
    [sym_dot_dot_i] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(51),
    [sym__newline] = ACTIONS(359),
    [sym__semicolon] = ACTIONS(359),
    [sym__raw_string_literal] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(363),
    [sym__external_close_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(365),
    [sym__external_close_brace] = ACTIONS(1998),
    [sym__external_open_bracket] = ACTIONS(51),
    [sym__external_open_bracket2] = ACTIONS(51),
  },
  [143] = {
    [sym_function_definition] = STATE(766),
    [sym_if_statement] = STATE(766),
    [sym_for_statement] = STATE(766),
    [sym_while_statement] = STATE(766),
    [sym_repeat_statement] = STATE(766),
    [sym_braced_expression] = STATE(766),
    [sym_parenthesized_expression] = STATE(766),
    [sym_call] = STATE(766),
    [sym_subset] = STATE(766),
    [sym_subset2] = STATE(766),
    [sym_unary_operator] = STATE(766),
    [sym_binary_operator] = STATE(766),
    [sym_extract_operator] = STATE(766),
    [sym_namespace_operator] = STATE(766),
    [sym_integer] = STATE(766),
    [sym_complex] = STATE(766),
    [sym_float] = STATE(766),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(766),
    [sym__expression] = STATE(766),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(144),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(461),
    [anon_sym_LT_LT_DASH] = ACTIONS(461),
    [anon_sym_COLON_EQ] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_DASH_GT_GT] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [aux_sym_binary_operator_token1] = ACTIONS(461),
    [anon_sym_PIPE_GT] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_DOLLAR] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(461),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(2000),
    [sym_next] = ACTIONS(2000),
    [sym_break] = ACTIONS(2000),
    [sym_true] = ACTIONS(2000),
    [sym_false] = ACTIONS(2000),
    [sym_null] = ACTIONS(2000),
    [sym_inf] = ACTIONS(2000),
    [sym_nan] = ACTIONS(2000),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(2000),
    [sym_dot_dot_i] = ACTIONS(2002),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(2004),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(461),
    [sym__external_close_bracket2] = ACTIONS(461),
  },
  [144] = {
    [sym_function_definition] = STATE(768),
    [sym_if_statement] = STATE(768),
    [sym_for_statement] = STATE(768),
    [sym_while_statement] = STATE(768),
    [sym_repeat_statement] = STATE(768),
    [sym_braced_expression] = STATE(768),
    [sym_parenthesized_expression] = STATE(768),
    [sym_call] = STATE(768),
    [sym_subset] = STATE(768),
    [sym_subset2] = STATE(768),
    [sym_unary_operator] = STATE(768),
    [sym_binary_operator] = STATE(768),
    [sym_extract_operator] = STATE(768),
    [sym_namespace_operator] = STATE(768),
    [sym_integer] = STATE(768),
    [sym_complex] = STATE(768),
    [sym_float] = STATE(768),
    [sym__hex_literal] = STATE(2220),
    [sym__float_literal] = STATE(2220),
    [sym_string] = STATE(2219),
    [sym__single_quoted_string] = STATE(2221),
    [sym__double_quoted_string] = STATE(2222),
    [sym_na] = STATE(768),
    [sym__expression] = STATE(768),
    [sym__string_or_identifier] = STATE(5140),
    [sym__open_parenthesis] = STATE(54),
    [sym__open_brace] = STATE(56),
    [aux_sym_function_definition_repeat1] = STATE(2303),
    [sym_identifier] = ACTIONS(626),
    [anon_sym_BSLASH] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_repeat] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_LT_DASH] = ACTIONS(471),
    [anon_sym_LT_LT_DASH] = ACTIONS(471),
    [anon_sym_COLON_EQ] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_GT] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_CARET] = ACTIONS(471),
    [aux_sym_binary_operator_token1] = ACTIONS(471),
    [anon_sym_PIPE_GT] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(471),
    [aux_sym__hex_literal_token1] = ACTIONS(650),
    [sym__number_literal] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(654),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [sym_return] = ACTIONS(2006),
    [sym_next] = ACTIONS(2006),
    [sym_break] = ACTIONS(2006),
    [sym_true] = ACTIONS(2006),
    [sym_false] = ACTIONS(2006),
    [sym_null] = ACTIONS(2006),
    [sym_inf] = ACTIONS(2006),
    [sym_nan] = ACTIONS(2006),
    [anon_sym_NA] = ACTIONS(660),
    [anon_sym_NA_integer_] = ACTIONS(660),
    [anon_sym_NA_real_] = ACTIONS(660),
    [anon_sym_NA_complex_] = ACTIONS(660),
    [anon_sym_NA_character_] = ACTIONS(660),
    [sym_dots] = ACTIONS(2006),
    [sym_dot_dot_i] = ACTIONS(2008),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(471),
    [sym__newline] = ACTIONS(471),
    [sym__semicolon] = ACTIONS(471),
    [sym__raw_string_literal] = ACTIONS(666),
    [sym__external_open_parenthesis] = ACTIONS(668),
    [sym__external_close_parenthesis] = ACTIONS(471),
    [sym__external_open_brace] = ACTIONS(670),
    [sym__external_close_brace] = ACTIONS(471),
    [sym__external_open_bracket] = ACTIONS(471),
    [sym__external_open_bracket2] = ACTIONS(471),
    [sym__external_close_bracket2] = ACTIONS(471),
  },
  [145] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [aux_sym_braced_expression_repeat1] = STATE(145),
    [ts_builtin_sym_end] = ACTIONS(591),
    [sym_identifier] = ACTIONS(2010),
    [anon_sym_BSLASH] = ACTIONS(2013),
    [anon_sym_function] = ACTIONS(2016),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(2019),
    [anon_sym_for] = ACTIONS(2022),
    [anon_sym_while] = ACTIONS(2025),
    [anon_sym_repeat] = ACTIONS(2028),
    [anon_sym_QMARK] = ACTIONS(2031),
    [anon_sym_TILDE] = ACTIONS(2034),
    [anon_sym_BANG] = ACTIONS(2037),
    [anon_sym_PLUS] = ACTIONS(2040),
    [anon_sym_DASH] = ACTIONS(2043),
    [anon_sym_LT_DASH] = ACTIONS(591),
    [anon_sym_LT_LT_DASH] = ACTIONS(591),
    [anon_sym_COLON_EQ] = ACTIONS(591),
    [anon_sym_DASH_GT] = ACTIONS(562),
    [anon_sym_DASH_GT_GT] = ACTIONS(591),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(591),
    [anon_sym_AMP_AMP] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(591),
    [anon_sym_EQ_EQ] = ACTIONS(591),
    [anon_sym_BANG_EQ] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_STAR_STAR] = ACTIONS(591),
    [anon_sym_CARET] = ACTIONS(591),
    [aux_sym_binary_operator_token1] = ACTIONS(591),
    [anon_sym_PIPE_GT] = ACTIONS(591),
    [anon_sym_COLON] = ACTIONS(562),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [aux_sym__hex_literal_token1] = ACTIONS(2046),
    [sym__number_literal] = ACTIONS(2049),
    [anon_sym_SQUOTE] = ACTIONS(2052),
    [anon_sym_DQUOTE] = ACTIONS(2055),
    [sym_return] = ACTIONS(2058),
    [sym_next] = ACTIONS(2058),
    [sym_break] = ACTIONS(2058),
    [sym_true] = ACTIONS(2058),
    [sym_false] = ACTIONS(2058),
    [sym_null] = ACTIONS(2058),
    [sym_inf] = ACTIONS(2058),
    [sym_nan] = ACTIONS(2058),
    [anon_sym_NA] = ACTIONS(2061),
    [anon_sym_NA_integer_] = ACTIONS(2061),
    [anon_sym_NA_real_] = ACTIONS(2061),
    [anon_sym_NA_complex_] = ACTIONS(2061),
    [anon_sym_NA_character_] = ACTIONS(2061),
    [sym_dots] = ACTIONS(2058),
    [sym_dot_dot_i] = ACTIONS(2064),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(591),
    [sym__newline] = ACTIONS(2067),
    [sym__semicolon] = ACTIONS(2067),
    [sym__raw_string_literal] = ACTIONS(2070),
    [sym__external_open_parenthesis] = ACTIONS(2073),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(2076),
    [sym__external_close_brace] = ACTIONS(591),
    [sym__external_open_bracket] = ACTIONS(591),
    [sym__external_open_bracket2] = ACTIONS(591),
  },
  [146] = {
    [sym_function_definition] = STATE(790),
    [sym_if_statement] = STATE(790),
    [sym_for_statement] = STATE(790),
    [sym_while_statement] = STATE(790),
    [sym_repeat_statement] = STATE(790),
    [sym_braced_expression] = STATE(790),
    [sym_parenthesized_expression] = STATE(790),
    [sym_call] = STATE(790),
    [sym_subset] = STATE(790),
    [sym_subset2] = STATE(790),
    [sym_unary_operator] = STATE(790),
    [sym_binary_operator] = STATE(790),
    [sym_extract_operator] = STATE(790),
    [sym_namespace_operator] = STATE(790),
    [sym_integer] = STATE(790),
    [sym_complex] = STATE(790),
    [sym_float] = STATE(790),
    [sym__hex_literal] = STATE(2183),
    [sym__float_literal] = STATE(2183),
    [sym_string] = STATE(2169),
    [sym__single_quoted_string] = STATE(2181),
    [sym__double_quoted_string] = STATE(2180),
    [sym_na] = STATE(790),
    [sym__expression] = STATE(790),
    [sym__string_or_identifier] = STATE(5149),
    [sym__open_parenthesis] = STATE(67),
    [sym__open_brace] = STATE(24),
    [sym__close_brace] = STATE(2876),
    [aux_sym_braced_expression_repeat1] = STATE(145),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_BSLASH] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(339),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_LT_DASH] = ACTIONS(51),
    [anon_sym_LT_LT_DASH] = ACTIONS(51),
    [anon_sym_COLON_EQ] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_AMP_AMP] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_EQ_EQ] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [aux_sym_binary_operator_token1] = ACTIONS(51),
    [anon_sym_PIPE_GT] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(51),
    [aux_sym__hex_literal_token1] = ACTIONS(345),
    [sym__number_literal] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [sym_return] = ACTIONS(353),
    [sym_next] = ACTIONS(353),
    [sym_break] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_null] = ACTIONS(353),
    [sym_inf] = ACTIONS(353),
    [sym_nan] = ACTIONS(353),
    [anon_sym_NA] = ACTIONS(355),
    [anon_sym_NA_integer_] = ACTIONS(355),
    [anon_sym_NA_real_] = ACTIONS(355),
    [anon_sym_NA_complex_] = ACTIONS