% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.genpop.R
\name{read.genpop}
\alias{read.genpop}
\title{Read GENEPOP format input file}
\usage{
read.genpop(x, pop.names = NULL, pos = 1)
}
\arguments{
\item{x}{The GENEPOP file name or path to the file. The filename extension should be included.}

\item{pop.names}{A character string vector for population names. The order of the name should be the same with the order (top to down) in your GENEPOP file.}

\item{pos}{defaults to 1 which equals an assingment to global environment}
}
\value{
This function returns a list that comprises three items. [[1]] A matrix of genetic data with a population name label ($popNameVector) in the last column. [[2]] A vector of sample ID. [[3]] A vector of locus name.
}
\description{
This function allows you to import a GENEPOP format file into R. Population names can be specified in the argument. See http://genepop.curtin.edu.au/help_input.html for details about GENEPOP format.
}
\examples{
# infile <- read.genpop("Your_Genepop_File.txt", pop.names=c("pop_A", "pop_B", "pop_C"))
}
\references{
Rousset, F., 2008. Genepop'007: a complete reimplementation of the Genepop software for Windows and Linux. Mol. Ecol. Resources 8: 103-106.
}

