% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableby.stats.R
\name{tableby.stats}
\alias{tableby.stats}
\alias{arsenal_sum}
\alias{arsenal_min}
\alias{arsenal_max}
\alias{arsenal_mean}
\alias{arsenal_sd}
\alias{arsenal_var}
\alias{meansd}
\alias{meanCI}
\alias{medianrange}
\alias{medianmad}
\alias{arsenal_median}
\alias{arsenal_range}
\alias{gmean}
\alias{gsd}
\alias{gmeansd}
\alias{gmeanCI}
\alias{Nevents}
\alias{medSurv}
\alias{NeventsSurv}
\alias{NriskSurv}
\alias{Nrisk}
\alias{medTime}
\alias{q1q3}
\alias{medianq1q3}
\alias{iqr}
\alias{Nmiss}
\alias{Nmiss2}
\alias{N}
\alias{Npct}
\alias{count}
\alias{countpct}
\alias{countN}
\alias{countrowpct}
\alias{countcellpct}
\alias{binomCI}
\alias{rowbinomCI}
\title{tableby Summary Statistics Functions}
\usage{
arsenal_sum(x, na.rm = TRUE, ...)

arsenal_min(x, na.rm = TRUE, ...)

arsenal_max(x, na.rm = TRUE, ...)

arsenal_mean(x, na.rm = TRUE, weights = NULL, ...)

arsenal_sd(x, na.rm = TRUE, weights = NULL, ...)

arsenal_var(x, na.rm = TRUE, weights = NULL, ...)

meansd(x, na.rm = TRUE, weights = NULL, ...)

meanCI(x, na.rm = TRUE, weights = NULL, conf.level = 0.95, ...)

medianrange(x, na.rm = TRUE, weights = NULL, ...)

medianmad(x, na.rm = TRUE, weights = NULL, ...)

arsenal_median(x, na.rm = TRUE, weights = NULL, ...)

arsenal_range(x, na.rm = TRUE, ...)

gmean(x, na.rm = TRUE, weights = NULL, ...)

gsd(x, na.rm = TRUE, weights = NULL, ...)

gmeansd(x, na.rm = TRUE, weights = NULL, ...)

gmeanCI(x, na.rm = TRUE, weights = NULL, conf.level = 0.95, ...)

Nevents(x, na.rm = TRUE, weights = NULL, ...)

medSurv(x, na.rm = TRUE, weights = NULL, ...)

NeventsSurv(x, na.rm = TRUE, weights = NULL, times = 1:5, ...)

NriskSurv(x, na.rm = TRUE, weights = NULL, times = 1:5, ...)

Nrisk(x, na.rm = TRUE, weights = NULL, times = 1:5, ...)

medTime(x, na.rm = TRUE, weights = NULL, ...)

q1q3(x, na.rm = TRUE, weights = NULL, ...)

medianq1q3(x, na.rm = TRUE, weights = NULL, ...)

iqr(x, na.rm = TRUE, weights = NULL, ...)

Nmiss(x, na.rm = TRUE, weights = NULL, ...)

Nmiss2(x, na.rm = TRUE, weights = NULL, ...)

N(x, na.rm = TRUE, weights = NULL, ...)

Npct(
  x,
  levels = NULL,
  by,
  by.levels = sort(unique(by)),
  na.rm = TRUE,
  weights = NULL,
  ...
)

count(x, levels = NULL, na.rm = TRUE, weights = NULL, ...)

countpct(x, levels = NULL, na.rm = TRUE, weights = NULL, ...)

countN(x, levels = NULL, na.rm = TRUE, weights = NULL, ...)

countrowpct(
  x,
  levels = NULL,
  by,
  by.levels = sort(unique(by)),
  na.rm = TRUE,
  weights = NULL,
  ...
)

countcellpct(
  x,
  levels = NULL,
  by,
  by.levels = sort(unique(by)),
  na.rm = TRUE,
  weights = NULL,
  ...
)

binomCI(x, levels = NULL, na.rm = TRUE, weights = NULL, conf.level = 0.95, ...)

rowbinomCI(
  x,
  levels = NULL,
  by,
  by.levels = sort(unique(by)),
  na.rm = TRUE,
  weights = NULL,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{x}{Usually a vector.}

\item{na.rm}{Should NAs be removed?}

\item{...}{Other arguments.}

\item{weights}{A vector of weights.}

\item{conf.level}{Numeric, denoting what confidence level to use for confidence intervals.}

\item{times}{A vector of times to use for survival summaries.}

\item{levels}{A vector of levels that character \code{x}s should have.}

\item{by}{a vector of the by-values.}

\item{by.levels}{a vector of the levels of \code{by}.}
}
\value{
Usually a vector of the appropriate numbers.
}
\description{
A collection of functions that will report summary statistics. To create a custom function,
  consider using a function with all three arguments and \code{...}. See the \code{\link{tableby}} vignette
  for an example.
}
\details{
Not all these functions are exported, in order to avoid conflicting NAMESPACES.
  Note also that the functions prefixed with \code{"arsenal_"} can be referred to by their short names
  (e.g., \code{"min"} for \code{"arsenal_min"}).
}
\seealso{
\code{\link{includeNA}}, \code{\link{tableby.control}}
}
