% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{OccurrenceMatrix-class}
\alias{OccurrenceMatrix-class}
\alias{.OccurrenceMatrix}
\title{Co-Occurrence Matrix}
\description{
An S4 class to represent a co-occurrence matrix.
}
\details{
A co-occurrence matrix is a symmetric matrix with zeros on its main
diagonal, which works out how many times each pairs of taxa/types occur
together in at least one sample.
}
\section{Slots}{

\describe{
\item{\code{total}}{An \code{\link{integer}} giving the total number of observations.}
}}

\examples{
## Create an incidence (presence/absence) matrix
## Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 1/3)), nrow = 20)
## Create a count data matrix
B <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 20)

## Access
dim(B) # Get the matrix dimensions
row(B) # Get the row indexes
col(B, as.factor = TRUE) # Get the column indexes
nrow(B) # Get the number of rows
ncol(B) # Get the number of columns
dimnames(B) # Get the dimension names
rownames(B) <- LETTERS[1:20] # Set the row names
rownames(B) # Get the rownames
colnames(B) <- letters[21:25] # Set the column names
colnames(B) # Get the column names

## Subset
B[[1, 1]] # Get the first value
B[1] # Get the first value
B[, ] # Get all values
B[1, , drop = FALSE] # Get the first row
B[, 1:3] # Get the first three column
}
\seealso{
\code{\link[=as_occurrence]{as_occurrence()}}

Other matrix: 
\code{\link{CompositionMatrix-class}},
\code{\link{CountMatrix-class}},
\code{\link{DataMatrix}},
\code{\link{IncidenceMatrix-class}},
\code{\link{StratigraphicMatrix-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{matrix}
