% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonIcon.R
\name{argonIconWrapper}
\alias{argonIconWrapper}
\title{Create a Nucleo icon wrapper}
\usage{
argonIconWrapper(iconTag, circle = TRUE, size = NULL,
  status = "default", gradient_color = NULL, shadow = TRUE,
  hover_shadow = FALSE)
}
\arguments{
\item{iconTag}{Slot for \link{argonIcon}}

\item{circle}{Wrapper's shape. TRUE by default.}

\item{size}{Wrapper size. "sm", "md" or "lg".}

\item{status}{Wrapper color. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{gradient_color}{icon gradient background color.}

\item{shadow}{Whether to apply a shadow effet. TRUE by default.}

\item{hover_shadow}{Only if shadow is TRUE. Whether to enlarge the shadow on hover. FALSE by default.}
}
\description{
Build an argon Nucleo icon wrapper
}
\examples{
if (interactive()) {
 library(argonR)
 argonIconWrapper(
  iconTag = argonIcon("atom"),
  size = "lg",
  status = "danger",
  shadow = TRUE,
  hover_shadow = TRUE
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
