% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forge.R
\name{forge}
\alias{forge}
\title{Forests for Generative Modeling}
\usage{
forge(params, n_synth, parallel = TRUE)
}
\arguments{
\item{params}{Parameters learned via \code{\link{forde}}.}

\item{n_synth}{Number of synthetic samples to generate.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}
}
\value{
A dataset of \code{n_synth} synthetic samples.
}
\description{
Uses pre-trained FORDE model to simulate synthetic data.
}
\details{
\code{forge} simulates a synthetic dataset of \code{n_synth} samples. First,
leaves are sampled in proportion to their coverage. Then, each feature is
sampled independently within each leaf according to the probability mass or
density function learned by \code{\link{forde}}. This will create realistic
data so long as the adversarial RF used in the previous step satisfies the
local independence criterion. See Watson et al. (2022).
}
\examples{
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)
x_synth <- forge(psi, n_synth = 100)


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2022). Adversarial random
forests for density estimation and generative modeling. \emph{arXiv} preprint,
2205.09435.
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forde}}
}
