% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/archivistOptions.R
\name{aoptions}
\alias{aoptions}
\title{Default Options for Archivist}
\usage{
aoptions(key, value = NULL)
}
\arguments{
\item{key}{Name of the parameter.}

\item{value}{New value for the 'key' parameter.}
}
\value{
The function returns value that corresponds to a selected key.
}
\description{
The function \code{aoptions} sets and gets default options
for other \code{archivist} functions.
}
\details{
The function \code{aoptions} with two arguments sets default values
of arguments for other \code{archivist} functions (stored in an internal environment).
The function \code{aoptions} with one argument returns value of given parameter.
It is used for setting default values for parameters in archivist functions.
Currently works for arguments: silent
}
\examples{
# objects preparation
\dontrun{
# turn off warnings in saveToRepo()
aoptions("silent", FALSE)
aoptions("silent")
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

