% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive_overview.R
\name{archive_overview}
\alias{archive_overview}
\title{archive_overview: Getting a first glimpse of mementos available in the Internet Archive}
\usage{
archive_overview(homepage, startDate, endDate)
}
\arguments{
\item{homepage}{A character vector of the homepage, including the top-level-domain}

\item{startDate}{A character vector of the starting date of the overview. Accepts a large variety of date formats (see \link[anytime]{anytime})}

\item{endDate}{A character vector of the ending date of the overview. Accepts a large variety of date formats (see \link[anytime]{anytime})}
}
\value{
This function provides an overview of mementos available from the Internet Archive. It returns a calendar indicating all dates in which mementos of the homepage have been stored in the Internet Archive at least once. However, a memento being stored in the Internet Archive does not guarantee that the information from the homepage can be actually scraped.
}
\description{
\code{archive_overview} provides an overview of available mementos of the homepage from the Internet Archive
}
\examples{
\dontrun{
archive_overview(homepage = "www.spiegel.de", startDate = "20180601", endDate = "20190615")
archive_overview(homepage = "nytimes.com", startDate = "2018-06-01", endDate = "2019-05-01")
}
}
