% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx.R
\name{apsimx_options}
\alias{apsimx_options}
\title{Setting some options for the package}
\usage{
apsimx_options(
  exe.path = NA,
  examples.path = NA,
  warn.versions = TRUE,
  warn.find.apsimx = TRUE
)
}
\arguments{
\item{exe.path}{path to apsim executable. White spaces are not allowed.}

\item{examples.path}{path to apsim examples}

\item{warn.versions}{logical. warning if multiple versions of APSIM-X are detected.}

\item{warn.find.apsimx}{logical. By default a warning will be thrown if APSIM-X is not found. 
If \sQuote{exe.path} is \sQuote{NA} an error will be thrown instead.}
}
\value{
as a side effect it modifies the \sQuote{apsimx.options} environment.
}
\description{
Set the path to the APSIM-X executable, examples and warning suppression.
}
\details{
Set apsimx options
}
\note{
It is possible that APSIM-X is installed in some alternative location other than the 
      defaults ones. Guessing this can be difficult and then the auto_detect functions might
      fail. Also, if multiple versions of APSIM-X are installed apsimx will choose the newest
      one but it will issue a warning. Suppress the warning by setting warn.versions = FLASE.
}
\examples{
\donttest{
names(apsimx.options)
apsimx_options(exe.path = "some-new-path-to-executable")
apsimx.options$exe.path
}
}
