% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{transport_plan_given_C}
\alias{transport_plan_given_C}
\title{Optimal transport plans given a pre-specified cost}
\usage{
transport_plan_given_C(
  mass_x,
  mass_y,
  p = 2,
  cost = NULL,
  method = "exact",
  cost_a = NULL,
  cost_b = NULL,
  ...
)
}
\arguments{
\item{mass_x}{The empirical measure of the first sample}

\item{mass_y}{The empirical measure of the second sample.}

\item{p}{The power of the Wasserstein distance}

\item{cost}{Specify the cost matrix in advance.}

\item{method}{The transportation method to use, one of "exact", "networkflow","shortsimplex", "sinkhorn", "greenkhorn"}

\item{cost_a}{The cost matrix for the first sample with itself. Only used for unbiased Sinkhorn}

\item{cost_b}{The cost matrix for the second sample with itself. Only used for unbiased Sinkhorn}

\item{...}{Additional arguments for various methods
\itemize{
\item "niter": The number of iterations to use for the entropically penalized optimal transport distances
\item "epsilon": The multiple of the median cost to use as a penalty in the entropically penalized optimal transport distances
\item"unbiased": If using Sinkhorn distances, should the distance be de-biased? (TRUE/FALSE)
}}
}
\value{
A transportation plan as an object of class "transport.plan", which is a list with slots "from","to", and "mass".
}
\description{
Optimal transport plans given a pre-specified cost
}
\examples{
n <- 32
d <- 5
set.seed(293897)
A <- matrix(stats::rnorm(n*d),nrow=d,ncol=n)
B <- matrix(stats::rnorm(n*d),nrow=d,ncol=n)
transp.meth <- "sinkhorn"
niter <- 1e2
test <- transport_plan_given_C(rep(1/n,n), 
rep(1/n,n),  2, cost = cost_calc(A,B,2), 
"sinkhorn", niter = niter)
}
