% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{score.apd_similarity}
\alias{score.apd_similarity}
\title{Score new samples using similarity methods}
\usage{
\method{score}{apd_similarity}(object, new_data, type = "numeric", add_percentile = TRUE, ...)
}
\arguments{
\item{object}{A \code{apd_similarity} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"numeric"} for a numeric value that summarizes the similarity values for
each sample across the training set.
}}

\item{add_percentile}{A single logical; should the percentile of the
similarity score \emph{relative to the training set values} by computed?}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}. For \code{type = "numeric"},
the tibble contains a column called "similarity". If \code{add_percentile = TRUE},
an additional column called \code{similarity_pctl} will be added. These values are
in percent units so that a value of 11.5 indicates that, in the training set,
11.5 percent of the training set samples had smaller values than the sample
being scored.
}
\description{
Score new samples using similarity methods
}
\examples{
\donttest{
data(qsar_binary)

jacc_sim <- apd_similarity(binary_tr)

mean_sim <- score(jacc_sim, new_data = binary_unk)
mean_sim
}
}
