% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_num}
\alias{format_num}
\title{Format numbers (with D3)}
\usage{
format_num(format, prefix = "", suffix = "", locale = "en-US")
}
\arguments{
\item{format}{Format for numbers, currency, percentage, e.g. \code{".0\%"} for rounded percentage.
See online documentation : \url{https://github.com/d3/d3-format}.}

\item{prefix}{Character string to append before formatted value.}

\item{suffix}{Character string to append after formatted value.}

\item{locale}{Localization to use, for example \code{"fr-FR"} for french,
see possible values here: \url{https://github.com/d3/d3-format/tree/master/locale}.}
}
\value{
a \code{JS} function
}
\description{
Format numbers (with D3)
}
\examples{
# Use SI prefix
dat <- data.frame(
  labels = c("apex", "charts"),
  values = c(1e4, 2e4)
)

apex(dat, aes(labels, values), "column") \%>\% 
  ax_yaxis(labels = list(
    formatter = format_num("~s")
  ))

apex(dat, aes(labels, values * 100), "column") \%>\% 
  ax_yaxis(labels = list(
    formatter = format_num("~s")
  ))


# Percentage
dat <- data.frame(
  labels = c("apex", "charts"),
  values = c(0.45, 0.55)
)

apex(dat, aes(labels, values), "column") \%>\% 
  ax_yaxis(labels = list(
    formatter = format_num(".0\%")
  ))


# Currency
dat <- data.frame(
  labels = c("apex", "charts"),
  values = c(570, 1170)
)

apex(dat, aes(labels, values), "column") \%>\% 
  ax_yaxis(labels = list(
    formatter = format_num("$,.2f")
  ))

# Change locale
apex(dat, aes(labels, values), "column") \%>\% 
  ax_yaxis(labels = list(
    formatter = format_num("$,.2f", locale = "fr-FR")
  ))



# Customize tooltip value
# Use SI prefix
dat <- data.frame(
  labels = c("apex", "charts"),
  values = c(1e4, 2e4)
)

apex(dat, aes(labels, values), "column") \%>\% 
  ax_tooltip(y = list(
    formatter = format_num(",", suffix = " GW/h")
  ))

}
