% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/multiphyDat.class.R
\docType{class}
\name{multiphyDat-class}
\alias{multiphyDat}
\alias{multiphyDat-class}
\title{multiphyDat: class for multiple gene data}
\description{
This formal (S4) class is used to store multiple DNA alignments.
Sequences are stored as a (possibly named) list, with each element of the list being a separate DNA alignment stored as a DNAbin matrix.
The rows of the separate matrices all correspond to the same individuals, ordered identically.
}
\section{Slots}{

\describe{
\item{\code{dna}}{a list of phyDat objects; empty slot should be NULL}

\item{\code{labels}}{a vector of labels of individuals}

\item{\code{n.ind}}{the number of individuals}

\item{\code{n.seq}}{the total number of sequences (pooling all genes)}

\item{\code{ind.info}}{a data.frame containing information on the individuals, where individuals are in rows; empty slot should be NULL}

\item{\code{gene.info}}{a data.frame containing information on the genes, where genes are in rows; empty slot should be NULL}
}}
\examples{
data(Laurasiatherian)

## empty object
new("multiphyDat")

## simple conversion with nicely ordered output
\dontrun{
genes <- list(gene1=subset(Laurasiatherian,,1:1600, FALSE),
    gene2=subset(Laurasiatherian,,1601:3179, FALSE))
x <- new("multiphyDat", genes)
x
}

## trickier conversion with missing sequences / wrong order
genes <- list(gene1=subset(Laurasiatherian,1:40),
    gene2=subset(Laurasiatherian,8:47))
x <- new("multiphyDat", genes)
x
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}

Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}

