% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R
\name{cohens_d_}
\alias{cohens_d_}
\title{Cohen's d}
\usage{
cohens_d_(m1 = NULL, m2 = NULL, sd1 = NULL, sd2 = NULL,
  n1 = NULL, n2 = NULL, t = NULL, n = NULL, paired = FALSE,
  corr = c("none", "hedges_g", "glass_delta"))
}
\arguments{
\item{m1}{Numeric, mean of the first group}

\item{m2}{Numeric, mean of the second group}

\item{sd1}{Numeric, standard deviation of the first group}

\item{sd2}{Numeric, standard deviation of the second group}

\item{n1}{Numeric, size of the first group}

\item{n2}{Numeric, size of the second group}

\item{t}{Numeric, t-test statistic}

\item{n}{Numeric, total sample size}

\item{paired}{Logical indicating whether to calculate Cohen's for independent
samples or one sample (\code{FALSE}, \emph{default}) or for dependent
samples (\code{TRUE}).}

\item{corr}{Character specifying the correction applied to calculation of the
effect size: \code{"none"} \emph{(default)} returns Cohen's d,
\code{"hedges_g"} applies Hedges correction and \code{"glass_delta"}
calculates Glass' \eqn{\Delta} (uses the standard deviation of the second
group).}
}
\description{
Calculate Cohens'd from different statistics (see Details).
}
\details{
The following combinations of statistics are possible:
  \itemize{
    \item \code{m1}, \code{m2}, \code{sd1}, \code{sd2}, \code{n1} and
    \code{n2}
    \item \code{t}, \code{n1} and \code{n2}
    \item \code{t} and \code{n}
  }
}
\references{
Lakens, D. (2013). Calculating and reporting effect sizes to facilitate
  cumulative science: a practical primer for t-tests and ANOVAs.
  \emph{Frontiers in Psychology}, 4, 863. doi:10.3389/fpsyg.2013.00863
}
