% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_clusters}
\alias{plot_clusters}
\title{Visualize a cluster analysis}
\usage{
plot_clusters(
  features,
  clusters,
  within_connection = FALSE,
  between_connection = FALSE,
  illustrate_variance = FALSE,
  show_axes = FALSE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  main = "",
  cex = 1.2,
  cex.axis = 1.2,
  cex.lab = 1.2,
  lwd = 1.5,
  lty = 2,
  frame.plot = FALSE,
  cex_centroid = 2
)
}
\arguments{
\item{features}{A data.frame or matrix representing the features that
are plotted. Must have two columns.}

\item{clusters}{A vector representing the clustering}

\item{within_connection}{Boolean. Connect the elements within each
clusters through lines? Useful to illustrate a graph structure.}

\item{between_connection}{Boolean. Connect the elements between each
clusters through lines? Useful to illustrate a graph structure.
(This argument only works for two clusters).}

\item{illustrate_variance}{Boolean. Illustrate the variance criterion
in the plot?}

\item{show_axes}{Boolean, display values on the x and y-axis? Defaults
to `FALSE`.}

\item{xlab}{The label for the x-axis}

\item{ylab}{The label for the y-axis}

\item{xlim}{The limits for the x-axis}

\item{ylim}{The limits for the y-axis}

\item{main}{The title of the plot}

\item{cex}{The size of the plotting symbols, see \code{\link{par}}}

\item{cex.axis}{The size of the values on the axes}

\item{cex.lab}{The size of the labels of the axes}

\item{lwd}{The width of the lines connecting elements.}

\item{lty}{The line type of the lines connecting elements
(see \code{\link{par}}).}

\item{frame.plot}{a logical indicating whether a box should be drawn
around the plot.}

\item{cex_centroid}{The size of the cluster center symbol (has an
effect only if \code{illustrate_variance} is \code{TRUE})}
}
\description{
Visualize a cluster analysis
}
\details{
In most cases, the argument \code{clusters} is a vector
  returned by one of the functions \code{\link{anticlustering}},
  \code{\link{balanced_clustering}} or \code{\link{matching}}. 
  However, the plotting function can also be used to plot the results 
  of other cluster functions such as \code{\link{kmeans}}. This function
  is usually just used to get a fast impression of the results of an 
  (anti)clustering assignment, but limited in its functionality. 
  It is useful for depicting the intra-cluster connections using 
  argument \code{within_connection}.
}
\examples{

N <- 15
features <- matrix(runif(N * 2), ncol = 2)
K <- 3
clusters <- balanced_clustering(features, K = K)
anticlusters <- anticlustering(features, K = K)
user_par <- par("mfrow")
par(mfrow = c(1, 2))
plot_clusters(features, clusters, main = "Cluster editing", within_connection = TRUE)
plot_clusters(features, anticlusters, main = "Anticluster editing", within_connection = TRUE)
par(mfrow = user_par)

}
\author{
Martin Papenberg \email{martin.papenberg@hhu.de}
}
