% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateGeneralSettings.R
\name{updateGeneralSettings}
\alias{updateGeneralSettings}
\title{Update general parameters of an Antares study}
\usage{
updateGeneralSettings(mode = NULL, horizon = NULL, nbyears = NULL,
  simulation.start = NULL, simulation.end = NULL, january.1st = NULL,
  first.month.in.year = NULL, first.weekday = NULL, leapyear = NULL,
  year.by.year = NULL, derated = NULL, custom.ts.numbers = NULL,
  user.playlist = NULL, filtering = NULL,
  active.rules.scenario = NULL, generate = NULL,
  nbtimeseriesload = NULL, nbtimeserieshydro = NULL,
  nbtimeserieswind = NULL, nbtimeseriesthermal = NULL,
  nbtimeseriessolar = NULL, refreshtimeseries = NULL,
  intra.modal = NULL, inter.modal = NULL, refreshintervalload = NULL,
  refreshintervalhydro = NULL, refreshintervalwind = NULL,
  refreshintervalthermal = NULL, refreshintervalsolar = NULL,
  readonly = NULL, opts = antaresRead::simOptions())
}
\arguments{
\item{mode}{Economy, Adequacy, Draft.}

\item{horizon}{Reference year (static tag, not used in the calculations)}

\item{nbyears}{Number of Monte-Carlo years that should be prepared for the simulation (not always the same as the Number of MC years actually simulated, see 'selection mode' below).}

\item{simulation.start}{First day of the simulation (e.g. 8 for a simulation beginning on the second week of the first month of the year)}

\item{simulation.end}{Last day of the simulation (e.g. 28 for a simulation ending on the fourth week of the first month of the year)}

\item{january.1st}{First day of the year (Mon, Tue, etc.).}

\item{first.month.in.year}{Actual month by which the Time-series begin (Jan to Dec, Oct to Sep, etc.)}

\item{first.weekday}{In economy or adequacy simulations, indicates the frame (Mon- Sun, Sat-Fri, etc.) to use for the edition of weekly results.}

\item{leapyear}{(TRUE/FALSE) indicates whether February has 28 or 29 days.}

\item{year.by.year}{(False) No individual results will be printed out,
(True) For each simulated year, detailed results will be
printed out in an individual directory7 :
  Study_name/OUTPUT/simu_tag/Economy /mc-i-number}

\item{derated}{See Antares General Reference Guide.}

\item{custom.ts.numbers}{See Antares General Reference Guide.}

\item{user.playlist}{See Antares General Reference Guide.}

\item{filtering}{See Antares General Reference Guide.}

\item{active.rules.scenario}{See Antares General Reference Guide.}

\item{generate}{See Antares General Reference Guide.}

\item{nbtimeseriesload}{See Antares General Reference Guide.}

\item{nbtimeserieshydro}{See Antares General Reference Guide.}

\item{nbtimeserieswind}{See Antares General Reference Guide.}

\item{nbtimeseriesthermal}{See Antares General Reference Guide.}

\item{nbtimeseriessolar}{See Antares General Reference Guide.}

\item{refreshtimeseries}{See Antares General Reference Guide.}

\item{intra.modal}{See Antares General Reference Guide.}

\item{inter.modal}{See Antares General Reference Guide.}

\item{refreshintervalload}{See Antares General Reference Guide.}

\item{refreshintervalhydro}{See Antares General Reference Guide.}

\item{refreshintervalwind}{See Antares General Reference Guide.}

\item{refreshintervalthermal}{See Antares General Reference Guide.}

\item{refreshintervalsolar}{See Antares General Reference Guide.}

\item{readonly}{See Antares General Reference Guide.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Update general parameters of an Antares study
}
