% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/unsalt.R
\name{unsalt}
\alias{unsalt}
\title{Unsalt a vector.}
\usage{
unsalt(.x, .seed = NULL, .chars = letters, .n_chars = 5L)
}
\arguments{
\item{.x}{a vector.}

\item{.seed}{an integer to seed the random number generator.}

\item{.chars}{set of characters to unsalt with.}

\item{.n_chars}{an integer; number of characters to unsalt with.}
}
\value{
An unsalted version of the vector.
}
\description{
\code{salt} takes a vector \code{.x} and returns an unsalted version of it.
The algorithm for unsalting a vector is:
\enumerate{
  \item Select a random sample of characters of length \code{.n_chars} from \code{.chars}. Call this random sample \code{.y}.
  \item Substitute \code{.y} out of the vector \code{.x} wherever it occurs, in a vectorized fashion.
}
}
\details{
The user is advised to check out \href{https://en.wikipedia.org/wiki/Salt_\%28cryptography\%29}{Wikipedia} for more information.
}
\examples{
# Use various number of characters
unsalt(salt(letters, .n_chars = 0L))
unsalt(salt(letters, .n_chars = 1L))
unsalt(salt(letters, .n_chars = 5L))
unsalt(salt(letters))

# Use other sets of characters to salt with
unsalt(salt(letters, .chars = letters[1:2]), .chars = letters[1:2])
}

