% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcci.R
\name{mcci}
\alias{mcci}
\title{Compute Monte Carlo Confidence Intervals}
\usage{
mcci(
  d1 = NULL,
  se1 = NULL,
  d2 = NULL,
  se2 = NULL,
  n.mcci = 10000,
  sig.level = 0.05,
  two.tailed = TRUE,
  bound.eq = NULL,
  xlim = NULL,
  xlab = NULL,
  ylab = NULL,
  dashed.lines = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{d1}{The estimated treatment effect for group 1.}

\item{se1}{The estimated standard error of the treatment effect for group 1.}

\item{d2}{The estimated treatment effect for group 2.}

\item{se2}{The estimated standard error of the treatment effect for group 2.}

\item{n.mcci}{The number of draws for the MCCI method. Default is 10,000.}

\item{sig.level}{The significance level. Default is .05.}

\item{two.tailed}{Logical of two tailed test. Default is TRUE.}

\item{bound.eq}{The equivalence bounds for equivalence test. Default is the
MCCI for the equivalence test. It can be specified in the arguments as
bound.eq = c(lower bound #, upper bound #).}

\item{xlim}{The limits set for the x-axis in the plot.
Default is two times the MCCI for moderation. It can be
 specified in the arguments as xlim = c(lower #, higher #).}

\item{xlab}{The label for the x-axis in the plot.
Default is "Differences in Effects".}

\item{ylab}{The label for the y-axis in the plot.
Default is NULL.}

\item{dashed.lines}{Logical of whether dashed lines of equivalence
bounds and zero should be added in the plot. Default is TRUE.}

\item{verbose}{Logical; print the process if TRUE,
otherwise not; default value is TRUE.}
}
\value{
The results of moderation analysis and equivalence tests
    using the MCCI method. It will also provide a plot for
    the MCCIs.
}
\description{
Compute Monte Carlo confidence intervals (MCCI) of the
     difference in two effects from summary statistics. The MCCI can be
     used to test moderation effects (i.e., whether two effects are
     statistically different from each) and the equivalence of effects.
}
\examples{
   library(anomo)
    myci <- mcci(d1 = .1, se1 = .1, d2 = .2, se2 = .1)

}
