% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bard.R, R/capa.R, R/pass.class.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,bard.class-method}
\alias{summary,bard.sampler.class-method}
\alias{summary,capa.class-method}
\alias{summary,pass.class-method}
\title{Summary of collective and point anomalies.}
\usage{
\S4method{summary}{bard.class}(object, ...)

\S4method{summary}{bard.sampler.class}(object, ...)

\S4method{summary}{capa.class}(object, epoch = nrow(object@data))

\S4method{summary}{pass.class}(object, ...)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{capa}} or \code{\link{pass}}.}

\item{...}{Ignored.}

\item{epoch}{Positive integer. CAPA methods are sequential and as such, can generate results up to, and including, any epoch within the data series. This can be controlled by the value
of \code{epoch} and is useful for examining how the inferred anomalies are modified as the data series grows. The default value for \code{epoch} is the length of the data series.}
}
\description{
Summary methods for S4 objects returned by \code{\link{capa}}, 
\code{\link{pass}}, and \code{\link{sampler}}.  The output displayed
depends on the type of object passed to summary. For all types, the output indicates whether the data is univariate or
multivariate, the number of observations in the data, and the type of change being detected.
}
\seealso{
\code{\link{capa}}, \code{\link{pass}},\code{\link{sampler}}.
}
