% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nClust.R
\name{nClustMulti}
\alias{nClustMulti}
\title{Multiple Samples Optimal Number of Clusters Estimation}
\usage{
nClustMulti(dataDist, p = 1, maxClust = 20, clusteringFunction,
  criterion = c("slope", "silhouette"))
}
\arguments{
\item{dataDist}{An  matrix with n subjects. Each subject has the size of NxN and represents the distances between the elements of the sample.}

\item{p}{Slope adjust parameter.}

\item{maxClust}{The maximum number of clusters to be tried.}

\item{clusteringFunction}{The clustering function to be used.}

\item{criterion}{The criterion that will be used for estimating the number of clusters. The options are "slope" or "silhouette". If not defined, "slope" will be used.}
}
\value{
The optimal number of clusters.
}
\description{
Estimates the optimal number of clusters for multiple samples using either Slope or Silhouette criterion. The optimal number of clusters will be
verified in the range {2,..., maxClust}. Takes the mean of all samples in order to perform the estimation.
}
\examples{
#Install packages if necessary
#install.packages('MASS')
#install.packages('cluster')

library(anocva)
library(MASS)
library(cluster)

set.seed(5000)

#A k-means function that returns cluster labels directly.
myKmeans <- function(dist, k){
  return(kmeans(dist, k, iter.max = 50, nstart = 5)$cluster)
}

#Size of the population
npop = 25
#Number of subjects in each group of each population
nsub = 60

#Generate simulated data
data = array(NA, c(npop, nsub*2, 2))
data.dist = array(NA, c(npop, nsub*2, nsub*2))
meanx = 2
delta = 0.5
# Covariance matrix
sigma <- matrix(c(0.03, 0, 0, 0.03), 2)
for (i in seq(npop)){
  sub = rbind(mvrnorm(nsub, mu = c(0, 0), Sigma = sigma ),
              mvrnorm(nsub, mu = c(meanx,0), Sigma = sigma))
  data[i,,] = sub
  data.dist[i,,] = as.matrix(dist(data[i,,]))
}

#Estimate the optimal number of clusters
r = nClustMulti(dataDist = data.dist, p = 1, maxClust = 20,
                clusteringFunction = myKmeans, criterion = "slope")
sprintf("The optimal number of clusters found was \%d.", r)


}

