% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectMD.R
\name{detectObject}
\alias{detectObject}
\title{Run MD on a Single Image}
\usage{
detectObject(mdsession, imagefile, mdversion = 5, min_conf = 0.1)
}
\arguments{
\item{mdsession}{Should be the output from loadMDmodel(model)}

\item{imagefile}{The path for the image in question}

\item{mdversion}{MegaDetector version, defaults to 5}

\item{min_conf}{Confidence threshold for returning bounding boxes, defaults to 0.1}
}
\value{
a list of MD bounding boxes, classes, and confidence for the image
}
\description{
Returns the MD bounding boxes, classes, confidence above the min_conf
threshold for a single image. #' Requires a an mdsession is already
loaded (see loadMDModel() ) and the file path of the image in question.
}
\examples{
\dontrun{
 images <- read_exif(imagedir, 
                     tags = c("filename", "directory", "FileModifyDate"), 
                     recursive = TRUE)
 colnames(images)[1] <- "FilePath"
 mdsession <- loadMDModel(mdmodel)
 mdres <- classifyImageMD(mdsession, images$FilePath[1])
}
}
