% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{cropImageTrainGenerator}
\alias{cropImageTrainGenerator}
\title{Tensorflow data generator for training that crops images to bounding box.}
\usage{
cropImageTrainGenerator(
  files,
  boxes,
  label,
  classes,
  resize_height = 456,
  resize_width = 456,
  standardize = FALSE,
  augmentation_color = FALSE,
  augmentation_geometry = FALSE,
  shuffle = FALSE,
  cache = FALSE,
  cache_dir = NULL,
  return_iterator = FALSE,
  batch = 32
)
}
\arguments{
\item{files}{a vector of file names}

\item{boxes}{a data frame or matrix of bounding box coordinates in the format left, top, width, height.}

\item{label}{a vector of labels}

\item{classes}{a vector of all classes for the active model}

\item{resize_height}{the height the cropped image will be resized to.}

\item{resize_width}{the width the cropped image will be resized to.}

\item{standardize}{standardize the image to the range 0 to 1, TRUE or FALSE.}

\item{augmentation_color}{use data augmentation to change the color, TRUE or FALSE.}

\item{augmentation_geometry}{use data augmentation to change the geometry of the images, TRUE or FALSE.}

\item{shuffle}{return data pairas in random order, TRUE or FALSE.}

\item{cache}{use caching to reduce reading from disk, TRUE or FALSE.}

\item{cache_dir}{directory used for caching, if none provided chaching will be done in memory.}

\item{return_iterator}{Should an iterator be returned? If RALSE a tfdataset will be returned.}

\item{batch}{the batch size for the image generator.}
}
\value{
A Tensorflow image data generator.
}
\description{
Creates an image data generator that crops images based on bounding box coordinates and returnes an image/label pair.
}
\examples{
\dontrun{
dataset <- cropImageTrainGenerator(images, standardize = FALSE, batch = batch)}
}
