% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{cropImageGenerator}
\alias{cropImageGenerator}
\title{Tensorflow data generator that crops images to bounding box.}
\usage{
cropImageGenerator(
  files,
  boxes,
  resize_height = 456,
  resize_width = 456,
  standardize = FALSE,
  batch = 32
)
}
\arguments{
\item{files}{a vector of file names}

\item{boxes}{a data frame or matrix of bounding box coordinates in the format left, top, width, height.}

\item{resize_height}{the height the cropped image will be resized to.}

\item{resize_width}{the width the cropped image will be resized to.}

\item{standardize}{standardize the image to the range 0 to 1, TRUE or FALSE.}

\item{batch}{the batch size for the image generator.}
}
\value{
A Tensorflow image data generator.
}
\description{
Creates an image data generator that crops images based on bounding box coordinates.
}
\examples{
\dontrun{#' dataset <- cropImageGenerator(images, boxes, standardize = FALSE, batch = batch)}
}
