% Generated by roxygen2 (4.0.2): do not edit by hand
\name{replay}
\alias{plot.anim.frames}
\alias{replay}
\alias{replay.anim.frames}
\title{Replay an \code{anim.frames} object}
\usage{
replay(...)

\method{replay}{anim.frames}(x, frames = 1:length(x), speed = attr(x,
  "speed"), after = NULL, before = NULL, ...)

\method{plot}{anim.frames}(x, ...)
}
\arguments{
\item{...}{other arguments (not currently used)}

\item{x}{an \code{anim.frames} object}

\item{frames}{numeric vector specifying which frames to replay}

\item{speed}{a new speed}

\item{after}{an expression to evaluate after each frame is plotted}

\item{before}{an expression to evaluate before each frame is plotted}
}
\description{
Replay all or some of the frames of an object.
}
\details{
\code{before} and \code{after} will have the arguments from the
frame's call available in their environment - see the example.

The \code{plot} method simply calls \code{replay}.
}
\examples{
myplot <- anim.plot(1:10, 1:10, speed=3)
replay(myplot, speed=5)
replay(myplot, frames=c(1,5,6,10))

myplot <- anim.plot(x<-rnorm(100), x+rnorm(100,0,3), 20, window=1:t,
     show=FALSE, main="Regressions as sample size increases")
replay(myplot, after=abline(lm(y~x), col="red"))
}

