% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_interactions.R
\name{get_interactions}
\alias{get_interactions}
\title{To obtain interactions from raw GPS observations}
\usage{
get_interactions(species_raw, temporal_thresh = 7, spatial_thresh, n_cores = 1)
}
\arguments{
\item{species_raw}{A DataFrame consisting of GPS observations. 
It should have at least four columns namely "animal_id", "datetime", "latitude|_rad", and "longitude_rad". 
"latitude|_rad", and "longitude_rad" are latitude and longitude values in radians respectively. See function "get_coordinates_in_radian"
to get these values.}

\item{temporal_thresh}{Temporal threshold in minutes with default 7 minutes}

\item{spatial_thresh}{The maximum distance in meters within which two animals are considered interacting}

\item{n_cores}{Number of cores for parallel processing with default 1}
}
\value{
A dataframe consisting of five columns. The first two columns contain animal ids, third and fourth column contain timestamp of their observations and the final column contains the distance between the two individuals.
}
\description{
To obtain interactions from raw GPS observations
}
\examples{
\donttest{
data(elk_data_2010)
get_interactions(elk_data_2010, temporal_thresh = 7, spatial_thresh = 15)
}
}
