% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/router.R
\name{Router}
\alias{Router}
\title{Router}
\description{
Web server.
}
\examples{
# log
logger <- new_log()
# router
# create router
router <- Router$new("/users")

router$get("/", function(req, res){
 res$send("List of users")
})

router$get("/:id", function(req, res){
 logger$log("Return user id:", req$params$id)
 res$send(req$params$id)
})

router$get("/:id/profile", function(req, res){
 msg <- sprintf("This is the profile of user #\%s", req$params$id)
 res$send(msg)
})

# core app
app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Home!")
})

# mount the router
app$use(router)

if(interactive())
 app$start()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{error}}{500 response when the route errors, must a handler function that accepts the request and the response, by default uses \code{\link[=response_500]{response_500()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Router$new()}}
\item \href{#method-get}{\code{Router$get()}}
\item \href{#method-put}{\code{Router$put()}}
\item \href{#method-patch}{\code{Router$patch()}}
\item \href{#method-delete}{\code{Router$delete()}}
\item \href{#method-post}{\code{Router$post()}}
\item \href{#method-receive}{\code{Router$receive()}}
\item \href{#method-print}{\code{Router$print()}}
\item \href{#method-routes}{\code{Router$routes()}}
\item \href{#method-receivers}{\code{Router$receivers()}}
\item \href{#method-clone}{\code{Router$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The base path of the router.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the base route.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$get(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
GET Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$put(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PUT Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-patch"></a>}}
\if{latex}{\out{\hypertarget{method-patch}{}}}
\subsection{Method \code{patch()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$patch(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PATCH Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$delete(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
DELETE Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-post"></a>}}
\if{latex}{\out{\hypertarget{method-post}{}}}
\subsection{Method \code{post()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$post(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
POST Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$receive(name, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of message.}

\item{\code{handler}}{Function to run when message is received.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Receive Websocket Message
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-routes"></a>}}
\if{latex}{\out{\hypertarget{method-routes}{}}}
\subsection{Method \code{routes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$routes()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the routes
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receivers"></a>}}
\if{latex}{\out{\hypertarget{method-receivers}{}}}
\subsection{Method \code{receivers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$receivers()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the receivers
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
