% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_ecoregion}
\alias{calc_ecoregion}
\title{Calculate ecoregions covariates}
\usage{
calc_ecoregion(from = NULL, locs, locs_id = "site_id", geom = FALSE, ...)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{\link{process_ecoregion}}.}

\item{locs}{sf/SpatVector. Unique locs. Should include
a unique identifier field named \code{locs_id}}

\item{locs_id}{character(1). Name of unique identifier.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object object with dummy variables and
attributes of:
\itemize{
\item \code{attr(., "ecoregion2_code")}: Ecoregion lv.2 code and key
\item \code{attr(., "ecoregion3_code")}: Ecoregion lv.3 code and key
}
}
\description{
Extract ecoregions covariates (U.S. EPA Ecoregions Level 2/3) at point
locations. Returns a \code{data.frame} object containing \code{locs_id} and
binary (0 = point not in ecoregion; 1 = point in ecoregion) variables for
each ecoregion.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calc_ecoregion(
  from = ecoregion, # derived from process_ecoregion() example
  locs = loc,
  locs_id = "id",
  geom = FALSE
)
}
}
\seealso{
\code{\link{process_ecoregion}}
}
\author{
Insang Song
}
