% Generated by roxygen2 (4.0.2): do not edit by hand
\name{alm_plot}
\alias{alm_plot}
\title{Plot results of a call to the alm function.}
\usage{
alm_plot(dat, type = NULL, removezero = TRUE)
}
\arguments{
\item{dat}{Output from \code{alm_ids} (character)}

\item{type}{One of totalmetrics or history}

\item{removezero}{Remove data sources with all zeros prior to plotting.}
}
\value{
A ggplot2 bar plot for `totalmetrics` or line plot for `history`.
}
\description{
Plot results of a call to the alm function.
}
\details{
You have to specify info='detail' in your call to \code{alm_ids} so that
		you get history and summary data so that either or both can be plotted
		in this function.
}
\examples{
\dontrun{
out <- alm(doi='10.1371/journal.pone.0001543', info='detail')
alm_plot(out, type='totalmetrics') # just totalmetrics data
alm_plot(dat=out, type='history') # just historical data
alm_plot(dat=out) # leaving type as NULL prints both plots
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}
\seealso{
\code{\link{alm_ids}} which is required to use this function.
}

