% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/smooth.R
\docType{methods}
\name{smooth_rectangular}
\alias{smooth_rectangular}
\alias{smooth_rectangular-method}
\alias{smooth_rectangular,numeric,numeric-method}
\alias{smooth_rectangular,ANY,missing-method}
\title{Rectangular Smoothing}
\usage{
smooth_rectangular(x, y, ...)

\S4method{smooth_rectangular}{numeric,numeric}(x, y, m = 3)

\S4method{smooth_rectangular}{ANY,missing}(x, m)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{m}{An odd \code{\link{integer}} giving the window size (i.e. the number of
adjacent points to be used; see \code{\link[=window_sliding]{window_sliding()}}).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Unweighted sliding-average or rectangular Smoothing.
}
\details{
It replaces each point in the signal with the average of \eqn{m} adjacent
points.
}
\note{
There will be \eqn{(m - 1) / 2} points both at the beginning and at the end
of the data series for which a complete \eqn{m}-width window cannot be
obtained. To prevent data loss, progressively wider/narrower windows are
used at both ends of the data series.
}
\examples{
## Simulate data with some noise
x <- seq(-4, 4, length = 100)
y <- dnorm(x) + rnorm(100, mean = 0, sd = 0.01)

## Plot spectrum
plot(x, y, type = "l", xlab = "", ylab = "")

## Rectangular smoothing
unweighted <- smooth_rectangular(x, y, m = 3)
plot(unweighted, type = "l", xlab = "", ylab = "")

## Triangular smoothing
weighted <- smooth_triangular(x, y, m = 5)
plot(weighted, type = "l", xlab = "", ylab = "")

## Loess smoothing
loess <- smooth_loess(x, y, span = 0.75)
plot(loess, type = "l", xlab = "", ylab = "")

## Savitzky–Golay filter
savitzky <- smooth_savitzky(x, y, m = 21, p = 2)
plot(savitzky, type = "l", xlab = "", ylab = "")

## Whittaker smoothing
whittaker <- smooth_whittaker(x, y, lambda = 1600, d = 2)
plot(whittaker, type = "l", xlab = "", ylab = "")
}
\seealso{
Other smoothing methods: 
\code{\link{smooth_likelihood}()},
\code{\link{smooth_loess}()},
\code{\link{smooth_savitzky}()},
\code{\link{smooth_triangular}()},
\code{\link{smooth_whittaker}()}
}
\author{
N. Frerebeau
}
\concept{smoothing methods}
