% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bertini}
\alias{bertini}
\title{Evaluate Bertini Code}
\usage{
bertini(code, dir = tempdir(), opts = "", quiet = TRUE)
}
\arguments{
\item{code}{Bertini code as either a character string or function; see examples}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options for bertini}

\item{quiet}{show bertini output}
}
\value{
an object of class bertini
}
\description{
Write a Bertini file, evaluate it through a back-end connection to Bertini, and bring the output back into R.
}
\examples{
\dontrun{

# where does the circle intersect the line y = x?
code <- "
INPUT

variable_group x, y;
function f, g;

f = x^2 + y^2 - 1;
g = y - x;

END;
"
bertini(code)

c(sqrt(2)/2, sqrt(2)/2)




# where do the surfaces
#  x^2 - y^2 - z^2 - 1/2
#  x^2 + y^2 + z^2 - 9
#  x^2/4 + y^2/4 - z^2
# intersect?
#
code <- "
INPUT

variable_group x, y, z;
function f, g, h;

f = x^2 - y^2 - z^2 - 1/2;
g = x^2 + y^2 + z^2 - 9;
h = x^2/4 + y^2/4 - z^2;

END;
"
bertini(code)

# algebraic solution :
c(sqrt(19)/2, 7/(2*sqrt(5)), 3/sqrt(5)) # +/- each ordinate




# example from bertini manual
code <- "
INPUT

variable_group x, y;
function f, g;

f = x^2 - 1;
g = x + y - 1;

END;
"
out <- bertini(code)
summary(out)





# non zero-dimensional example
code <- "
CONFIG
  TRACKTYPE: 1;
END;

INPUT
  variable_group x, y, z;
  function f1, f2;
  f1 = x^2-y;
  f2 = x^3-z;
END;
"
out <- bertini(code)
# bertini(code, quiet = FALSE) # print broken here










































}
}

