% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spop.R
\docType{class}
\name{spop}
\alias{spop}
\title{An S4 class to represent an age-structured population}
\description{
\itemize{
\item \code{spop} implements the deterministic and stochastic age-structured population dynamics models described in Erguler et al. 2016 and 2017
\item \code{add} introduces a batch of individuals with a given age, completed development cycles, and degree of development (default: 0)
\item \code{iterate} iterates the population for one day and calculates (overwrites) the number of dead individuals and the number of individuals designated to complete their development
\item \code{devtable} reads the number, age, and development cycle of individuals designated to complete their development
\item \code{developed} reads the total number of individuals designated to complete their development
\item \code{dead} reads the number of dead individuals after each iteration
\item \code{size} reads the total number of individuals
}
}
\details{
This is an R implementation of the age-structured population dynamics models described in Erguler et al. 2016 and 2017. The \code{spop} class records the number and age of individuals and implements two processes to exit from the population: development and death. The two processes act upon the population sequentially; survival is imposed prior to development. If the population survives for one day, then, it is allowed to grow and complete its development. Survival and development are defined either with an age-independent daily probability, or an age-dependent gamma- or negative binomial-distributed probability.
\itemize{
\item \code{stochastic}: a logical value indicating a deterministic or a stochastic population dynamics
\item \code{prob}: a character string indicating the basis of age-dependent survival or development (gamma: gamma-distributed, nbinom: negative binomial-distributed)
}
}
\examples{
# Generate a population with stochastic dynamics
s <- spop(stochastic=TRUE)
# Add 1000 20-day-old individuals
add(s) <- data.frame(number=1000,age=20)

# Iterate one day without death and assume development in 20 (+-5) days (gamma-distributed)
iterate(s) <- data.frame(dev_mean=20,dev_sd=5,death=0)
print(developed(s))

# Iterate another day assuming no development but age-dependent survival
# Let each individual survive for 20 days (+-5) (gamma-distributed)
iterate(s) <- data.frame(death_mean=20,death_sd=5,dev=0)
print(dead(s))
# Note that the previous values of developed and dead will be overwritten by this command

# Generate a deterministic population and observe the difference
s <- spop(stochastic=FALSE)
add(s) <- data.frame(number=1000,age=20)

iterate(s) <- data.frame(dev_mean=20,dev_sd=5,death=0)
print(developed(s))

iterate(s) <- data.frame(death_mean=20,death_sd=5,dev=0)
print(dead(s))

}
