% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{calcDiversity}
\alias{calcDiversity}
\title{Calculate the diversity index}
\usage{
calcDiversity(p, q)
}
\arguments{
\item{p}{numeric vector of clone (species) counts or proportions.}

\item{q}{numeric vector of diversity orders.}
}
\value{
A vector of diversity scores \eqn{D} for each \eqn{q}.
}
\description{
\code{calcDiversity} calculates the clonal diversity index for a vector of diversity 
orders.
}
\details{
This method, proposed by Hill (Hill, 1973), quantifies diversity as a smooth function 
(\eqn{D}) of a single parameter \eqn{q}. Special cases of the generalized diversity 
index correspond to the most popular diversity measures in ecology: species richness 
(\eqn{q = 0}), the exponential of the Shannon-Weiner index (\eqn{q} approaches \eqn{1}), the 
inverse of the Simpson index (\eqn{q = 2}), and the reciprocal abundance of the largest 
clone (\eqn{q} approaches \eqn{+\infty}). At \eqn{q = 0} different clones weight equally, 
regardless of their size. As the parameter \eqn{q} increase from \eqn{0} to \eqn{+\infty} 
the diversity index (\eqn{D}) depends less on rare clones and more on common (abundant) 
ones, thus encompassing a range of definitions that can be visualized as a single curve. 

Values of \eqn{q < 0} are valid, but are generally not meaningful. The value of \eqn{D} 
at \eqn{q=1} is estimated by \eqn{D} at \eqn{q=0.9999}.
}
\examples{
# May define p as clonal member counts
p <- c(1, 1, 3, 10)
q <- c(0, 1, 2)
calcDiversity(p, q)

# Or proportional abundance
p <- c(1/15, 1/15, 1/5, 2/3)
calcDiversity(p, q)

}
\references{
\enumerate{
  \item  Hill M. Diversity and evenness: a unifying notation and its consequences. 
           Ecology. 1973 54(2):427-32.
}
}
\seealso{
Used by \link{rarefyDiversity} and \link{testDiversity}.
}

