% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{(Trimmed) vector.}
\usage{
trim(x, trim = 0, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector of real values.}

\item{trim}{The fraction (0 to 0.5) of observations to be trimmed from each end of \code{x}.}

\item{na.rm}{A logical value indicating whether NA values should be stripped.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{trim} is zero (the default), the values in \code{x} is returned. If \code{x} is not logical (coerced to numeric), numeric (including integer) or complex, NA_real_ is returned, with a warning.  If \code{trim} is non-zero, a symmetrically trimmed vector is returned with a fraction of \code{trim} observations deleted from each end.
}
\description{
Find a vector excluding trimmed values, on which the calculation of a statistic will result in a trimmed statistic.
}
\examples{
x <- c(rnorm(100), 100)
mean(x)
mean(x, trim=0.01)
mean(trim(x, trim=0.01))
sd(x)
sd(trim(x, trim=0.01))

}
