% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_aggjudge.R
\name{ahp.aggjudge}
\alias{ahp.aggjudge}
\title{Aggregate individual judgments}
\usage{
ahp.aggjudge(ahpmat, atts, aggmethod = "geometric", qt = 0)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{a list of attributes in the correct order}

\item{aggmethod}{The method of aggregating the judgments by all decision-makers. Five modes aggregation are available:  \code{arithmetic}: the arithmetic mean; \code{geometric}: the geometric mean (the default); \code{rootmean}: the square root of the sum of the squared value, \code{tmean}: the trimmed mean, \code{tgmean}: trimmed geometric mean. The quantiles trimmed are based on \code{qt}. It can also be set to \code{sd}, where it reports the standard deviation from the arithmetic mean.}

\item{qt}{specifies the quantile which the top \strong{and} bottom priority weights are trimmed. Used only if \code{aggmethod = 'tmean'} or \code{aggmethod = 'tgmean'}. For example, \code{qt = 0.25} specifies that the aggregation is the arithmetic mean of the values from the 25 to 75 percentile. By default \code{qt = 0}.}
}
\value{
A \code{data.frame} of the aggregated pairwise judgments of all the decision-makers.
}
\description{
Aggregate individual judgments from pairwise comparison matrices
}
\examples{

## Computes individual judgments with geometric mean and aggregates them
## with a trimmed arithmetic mean

data(city200)
atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

cityahp <- ahp.mat(df = city200, atts = atts, negconvert = TRUE)
ahp.aggjudge(cityahp, atts, aggmethod = 'tmean', qt = 0.1)


}
\author{
Frankie Cho
}
