% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMET.R
\name{stability}
\alias{stability}
\title{Stability Coefficients}
\usage{
stability(
  predictions = NULL,
  genotype = NULL,
  trial = NULL,
  response = NULL,
  best = "max"
)
}
\arguments{
\item{predictions}{A data.frame with one value per GxE combination.}

\item{genotype}{A character string indicating the column in predictions that
contains genotypes.}

\item{trial}{A character string indicating the column in predictions that
contains trials.}

\item{response}{A character string specifying the response variable.}

\item{best}{A character string specifying how to define the best genotype
by numeric value ("min", "max"). "max" by default.}
}
\value{
A data.frame with several stability measures.
"superiority" (cultivar-superiority measure), "static" (Shukla's stability
variance) and "wricke" (Wricke's ecovalence).
}
\description{
Stability Coefficients
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)

data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)

head(
  stability(
    predictions = met_results$BLUPs_GxE,
    genotype = "genotype",
    trial = "trial",
    response = "predicted.value"
  )
)
}
}
