% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme4.R
\name{h_cullis}
\alias{h_cullis}
\title{Cullis heritability for lme4 models}
\usage{
h_cullis(model, genotype, re_MME = FALSE)
}
\arguments{
\item{model}{Object of class \code{lmer}.}

\item{genotype}{A character string indicating the column in data that
contains genotypes.}

\item{re_MME}{A logical value to ask if we want to reconstruct the mixed models
equations to estimate the Cullis heritability. (\code{FALSE} by default)}
}
\value{
A numerical value of the Cullis heritability estimate. If
\code{re_MME} is \code{TRUE}, a list with matrices of the mixed models
equations is returned.
}
\description{
Cullis heritability for lme4 models
}
\examples{
\donttest{
library(lme4)
library(agridat)
library(agriutilities)
dat <- john.alpha
g.ran <- lmer(
  formula = yield ~ rep + (1 | gen) + (1 | rep:block),
  data = dat
)
h_cullis(model = g.ran, genotype = "gen")
}
}
\author{
Paul Schmidt, Johan Aparicio.
}
