% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-transitivity.R
\name{rel_is_transitive}
\alias{rel_is_transitive}
\alias{rel_closure_transitive}
\alias{rel_reduction_transitive}
\title{Transitive Binary Relations}
\usage{
rel_is_transitive(R)

rel_closure_transitive(R)

rel_reduction_transitive(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
The \code{rel_closure_transitive} and
\code{rel_reduction_transitive} functions
return a logical square matrix. \code{\link{dimnames}}
of \code{R} are preserved.

On the other hand, \code{rel_is_transitive} returns
a single logical value.
}
\description{
A binary relation \eqn{R} is \emph{transitive}, iff
for all \eqn{x}, \eqn{y}, \eqn{z} we have \eqn{xRy} and \eqn{yRz}
\eqn{\Longrightarrow}{=>} \eqn{xRz}.
}
\details{
\code{rel_is_transitive} finds out if a given binary relation
is transitive. The algorithm has \eqn{O(n^3)} time complexity,
pessimistically, where
\eqn{n} is the number of rows in \code{R}.
If \code{R} contains missing values behind the diagonal,
the result will be \code{NA}.

The \emph{transitive closure} of a binary relation \eqn{R},
determined by \code{rel_closure_transitive},
is the minimal superset of \eqn{R} such that it is transitive.
Here we use the well-known Warshall algorithm (1962),
which runs in \eqn{O(n^3)} time.

The \emph{transitive reduction},
see (Aho et al. 1972), of an acyclic binary relation \eqn{R},
determined by \code{rel_reduction_transitive},
is a minimal unique subset \eqn{R'} of \eqn{R},
such that the transitive closures of \eqn{R} and \eqn{R'} are equal.
The algorithm implemented runs in \eqn{O(n^3)} time.
Note that a transitive reduction of a reflexive relation
is also reflexive. Moreover, some kind of transitive reduction
(not necessarily minimal) is also determined in
\code{\link{rel_reduction_hasse}} -- it is useful for
drawing Hasse diagrams.
}
\references{
Aho A.V., Garey M.R., Ullman J.D.,
The Transitive Reduction of a Directed Graph,
\emph{SIAM Journal on Computing} 1(2), 1972, pp. 131-137.

Warshall S., A theorem on Boolean matrices,
\emph{Journal of the ACM} 9(1), 1962, pp. 11-12.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
