% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-examples.R
\name{pord_weakdom}
\alias{pord_weakdom}
\title{Weak Dominance Relation (Preorder) in the Producer Assessment Problem}
\usage{
pord_weakdom(x, y)
}
\arguments{
\item{x}{numeric vector with nonnegative elements}

\item{y}{numeric vector with nonnegative elements}
}
\value{
Returns a single logical value
indicating whether \code{x} is weakly
dominated by \code{y}.
}
\description{
Checks whether a given numeric vector
of arbitrary length is (weakly) dominated
by another vector, possibly of different length,
in terms of (sorted) elements' values and their number.
}
\details{
We say that a numeric vector \bold{x}
of length \eqn{n_x}
is \emph{weakly dominated} by \bold{y}
of length \eqn{n_y}
iff
\enumerate{
\item \eqn{n_x\le n_y} and
\item for all \eqn{i=1,\dots,n} it holds
   \eqn{x_{(n_x-i+1)}\le y_{(n_y-i+1)}}.
}

This relation is a preorder: it is reflexive (see \code{\link{rel_is_reflexive}})
and transitive (see \code{\link{rel_is_transitive}}),
but not necessarily total  (see \code{\link{rel_is_total}}).
See \code{\link{rel_graph}} for a convenient function
to calculate the relationship between all pairs of elements
of a given set.

Note that this dominance relation gives the same value
for all permutations of input vectors' element.
Such a preorder is tightly related to symmetric impact functions:
each impact function is a morphism between
weak-dominance-preordered set of vectors
and the set of reals equipped with standard linear ordering
(see Gagolewski, Grzegorzewski, 2011
and Gagolewski, 2013).
}
\references{
Gagolewski M., Grzegorzewski P., Possibilistic Analysis of Arity-Monotonic
Aggregation Operators and Its Relation to Bibliometric Impact Assessment of Individuals,
\emph{International Journal of Approximate Reasoning} 52(9), 2011, pp. 1312-1324.

Gagolewski M., Scientific Impact Assessment Cannot be Fair,
\emph{Journal of Informetrics} 7(4), 2013, pp. 792-802.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}

Other impact_functions: \code{\link{index_g}},
  \code{\link{index_h}}, \code{\link{index_lp}},
  \code{\link{index_maxprod}}, \code{\link{index_rp}},
  \code{\link{index_w}}
}
\concept{binary_relations}
\concept{impact_functions}
