% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib-pareto2-estimators.R
\name{pareto2_estimate_mmse}
\alias{pareto2_estimate_mmse}
\title{Parameter Estimation in the Pareto Type-II Distribution Family (MMSE)}
\usage{
pareto2_estimate_mmse(x)
}
\arguments{
\item{x}{a non-negative numeric vector}
}
\value{
Returns a numeric vector  with the following named components:
\itemize{
\item \code{k} - estimated parameter of shape,
\item \code{s} - estimated parameter of scale.
}
}
\description{
Finds the MMS estimator of the Pareto Type-II distribution parameters
using the Bayesian method (and the R code) developed by
Zhang and Stevens (2009).
}
\references{
Zhang J., Stevens M.A., A New and Efficient Estimation Method
for the Generalized Pareto Distribution, \emph{Technometrics} 51(3), 2009, pp. 316-325.
}
\seealso{
Other Pareto2: \code{\link{pareto2_estimate_mle}},
  \code{\link{pareto2_test_ad}},
  \code{\link{pareto2_test_f}}, \code{\link{rpareto2}}
}
\concept{Pareto2}
